/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupConfig;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.MessageQueue;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.AsyncQueue;
import oracle.ias.cache.group.CoordinatorBroadcast;
import oracle.ias.cache.group.CoordinatorResolver;
import oracle.ias.cache.group.ElectionNotification;
import oracle.ias.cache.group.EndPoint;
import oracle.ias.cache.group.FailureDetector;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.GroupSocketOpener;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.GrpConfig;
import oracle.ias.cache.group.GrpReplyInfo;
import oracle.ias.cache.group.Job;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.Monitor;
import oracle.ias.cache.group.NodeListener;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.Receiver;
import oracle.ias.cache.group.SSLManager;
import oracle.ias.cache.group.Sender;
import oracle.ias.cache.group.ServerSocketEndPoint;
import oracle.ias.cache.group.ServerSocketReceiver;
import oracle.ias.cache.group.StreamHandler;
import oracle.ias.cache.group.Unicaster;
import oracle.ias.cache.group.View;
import oracle.ias.cache.group.ViewInfo;

class Transport {
    static final int DEFAULT_JOINGROUP_TIMEOUT = 600000;
    static final int DEFAULT_JOINGROUP_ATTEMPTS = 3;
    static final int CLEAN_INTERVAL = 0x100000;
    static final int DEFAULT_SOCK_CONNECT_TIMEOUT = 60000;
    static final int BACKLOG = 50;
    static final long NODE_LISTENER_STARTUP_TIMEOUT = 120000L;
    static final long COORD_TERM_DELAY = 30000L;
    static final String CONNECT_TIMEOUT_PROPERTY = "oracle.ias.cache.group.connect-timeout";
    static final String OPMNID = "oracle.ons.indexid";
    static final String OPNNORACLE_HOME = "oracle.ons.oraclehome";
    static final String LOGGER_NAME = "oracle.ias.cache.group.Transport";
    private static final int FOUND = 0;
    private static final int NOT_FOUND = -1;
    private static final int COORD_TERM = -2;
    int clean_interval_ = 0x100000;
    int s_timeout;
    Vector addrList = new Vector();
    Hashtable endPointList = new Hashtable();
    ServerSocketEndPoint ssep;
    ServerSocketEndPoint nlistener = null;
    Hashtable receivingQList = new Hashtable();
    InetAddress localHost = null;
    final String TGNAME = new String("ReceiverThreadGroup");
    ThreadGroup tg = new ThreadGroup(this.TGNAME);
    boolean initializing = true;
    boolean terminated = false;
    AsyncQueue asQ = null;
    Sender sender = null;
    GroupConfig s_config;
    CoordinatorBroadcast broadcaster = null;
    CoordinatorResolver resolver = null;
    Vector electionVotes = null;
    boolean enableColletingVotes = false;
    Address localNLAddress = null;
    Object nodeListernerLock = new Object();
    Object ctx = null;
    GrpCommunication gcomm_;
    GroupManager gmgr_;
    FailureDetector failDect_;
    Monitor mon_;
    SSLManager sslMgr_;
    private long g_uid = 0L;
    private byte[] guid_lock = new byte[0];
    private byte[] seq_lock = new byte[0];
    private long sequencer = -1L;
    private byte[] c_lock = new byte[0];
    private long counter = 0L;
    private byte[] to_lock = new byte[0];
    private long to_counter = 0L;
    private boolean discardIncomingConnection_;
    private byte[] ton_lock = new byte[0];
    private long receivedTONumber = -1L;
    private byte[] coordinator_lock = new byte[0];
    private byte[] member_lock = new byte[0];
    private byte[] total_lock = new byte[0];
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.Transport");
    private int numOfClosingReceivers_;
    private byte[] registrationLock_ = new byte[0];
    private boolean registrationCompleted_ = false;
    private boolean registrationStatus_ = false;
    private long coordStartTime_;
    long[][] counters = new long[2][25];

    Transport(GrpCommunication grpCommunication) throws GroupException {
        this.gcomm_ = grpCommunication;
        this.failDect_ = new FailureDetector(grpCommunication, this);
        this.mon_ = new Monitor(this.gcomm_, this);
        this.gmgr_ = new GroupManager(this.gcomm_, this);
        if (this.gcomm_.getGroupConfig().isSSLEnabled()) {
            try {
                this.sslMgr_ = new SSLManager(this.gcomm_);
            }
            catch (Exception exception) {
                throw new GroupException(GrpCommunication.EXP_GRP_SSL_CONFIG);
            }
        }
    }

    FailureDetector getFailureDetector() {
        return this.failDect_;
    }

    GroupManager getGroupManager() {
        return this.gmgr_;
    }

    Monitor getMonitor() {
        return this.mon_;
    }

    SSLManager getSSLManager() {
        return this.sslMgr_;
    }

    void dump() {
        this.logger_.log(Level.SEVERE, "--- Start dumping Transport Layer---");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nCurrent Coordinator at: ");
        stringBuffer.append(this.failDect_.getCoordinator());
        stringBuffer.append("\nNodeListener: " + this.nlistener);
        stringBuffer.append("\nServerSocketEndpoint: " + this.ssep);
        Vector vector = this.s_config.getListenerList();
        stringBuffer.append("\nDiscovery List: ");
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            stringBuffer.append(vector.elementAt(i));
            stringBuffer.append(", ");
        }
        this.logger_.log(Level.SEVERE, stringBuffer.toString());
        if (this.asQ != null) {
            this.asQ.dump();
        }
        if (this.endPointList != null) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("--- Start dumping EndPoint ---");
            Enumeration enumeration = this.endPointList.elements();
            int n = 1;
            while (enumeration.hasMoreElements()) {
                EndPoint endPoint = (EndPoint)enumeration.nextElement();
                stringBuffer.append("\n#");
                stringBuffer.append(n++);
                stringBuffer.append(".\t");
                stringBuffer.append(endPoint);
            }
            stringBuffer.append("\n--- End dumping EndPoint ---");
            this.logger_.log(Level.SEVERE, stringBuffer.toString());
        }
        this.logger_.log(Level.SEVERE, "--- End dumping Transport Layer---");
        this.gmgr_.dump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init(boolean bl) throws GroupException, InterruptedException {
        this.initializing = true;
        this.discardIncomingConnection_ = true;
        this.terminated = false;
        this.electionVotes = new Vector();
        this.s_config = this.gcomm_.getGroupConfig();
        this.numOfClosingReceivers_ = 0;
        String string = System.getProperty(CONNECT_TIMEOUT_PROPERTY);
        if (string == null) {
            this.s_timeout = 60000;
        } else {
            try {
                this.s_timeout = Integer.parseInt(string);
            }
            catch (Exception exception) {
                if (this.logger_.isLoggable(Level.WARNING)) {
                    this.logger_.log(Level.WARNING, "invalid connect timeout value", exception);
                }
                this.s_timeout = 60000;
            }
        }
        try {
            this.localHost = this.s_config.getLocalAddress() != null ? InetAddress.getByName(this.s_config.getLocalAddress()) : InetAddress.getLocalHost();
        }
        catch (Exception exception) {
            throw new GroupException(GrpCommunication.EXP_GRP_NOLOCALHOST + exception.toString());
        }
        if (this.sender == null) {
            this.asQ = new AsyncQueue(this.gcomm_);
            this.sender = new Sender(this.gcomm_, this, this.asQ);
            this.sender.start();
        }
        this.ssinit(this.s_config.getLowerPortBoundry(), this.s_config.getUpperPortBoundry(), this.s_config.getTag(), this.localHost, this.s_config.getListenerList());
        this.ssep.handler = new ServerSocketReceiver(this.gcomm_, this, this.ssep);
        this.ssep.handler.start();
        this.localNLAddress = this.getLocalNodeListenerAddress(this.s_config.getListenerList());
        try {
            if (bl) {
                this.bootstrapGroup();
            } else {
                this.joinGroup(this.s_config.isMulticast(), this.s_config.getListenerList(), this.s_config.getMulticastInterval(), this.s_config.getResolutionTimeout());
            }
        }
        finally {
            this.initializing = false;
        }
        this.mon_.start();
    }

    void bootstrapGroup() throws GroupException {
        this.nlinit();
        this.failDect_.setCoordinator(this.ssep.addr);
        this.ssep.addr.setPosition(0);
        this.ssep.addr.setUid(0L);
        this.ssep.addr.setTimeStamp(System.currentTimeMillis());
        this.gmgr_.initView(null);
    }

    void joinGroup(boolean bl, Vector vector, int n, long l) throws GroupException {
        boolean bl2 = false;
        int n2 = 0;
        Vector<Address> vector2 = null;
        Address[] addressArray = this.getASortedAddressList(vector);
        long l2 = System.currentTimeMillis();
        while (!bl2 && System.currentTimeMillis() - l2 <= 600000L) {
            int n3;
            if (n2 > 0 && this.ssep.isClosed()) {
                this.ssinit(this.s_config.getLowerPortBoundry(), this.s_config.getUpperPortBoundry(), this.s_config.getTag(), this.localHost, this.s_config.getListenerList());
                this.ssep.handler = new ServerSocketReceiver(this.gcomm_, this, this.ssep);
                this.ssep.handler.start();
            }
            if (!this.isNLStarted()) {
                if (this.startNodeListener()) {
                    vector2 = (Vector<Address>)vector.clone();
                    vector2.removeElement(this.localNLAddress);
                } else {
                    vector2 = new Vector<Address>();
                    vector2.addElement(this.localNLAddress);
                }
            }
            if ((n3 = this.discoverCoordinator(vector2)) == 0) {
                bl2 = true;
            } else if (!this.isNLStarted() || n3 == -2) {
                this.stopNodeListener();
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                if (this.ssep.isClosed()) {
                    this.ssinit(this.s_config.getLowerPortBoundry(), this.s_config.getUpperPortBoundry(), this.s_config.getTag(), this.localHost, this.s_config.getListenerList());
                    this.ssep.handler = new ServerSocketReceiver(this.gcomm_, this, this.ssep);
                    this.ssep.handler.start();
                }
                if (this.beACoordinator(bl, addressArray, n, l)) {
                    try {
                        this.ssep.addr.setPosition(0);
                        this.ssep.addr.setUid(0L);
                        this.ssep.addr.setTimeStamp(System.currentTimeMillis());
                        this.gmgr_.initView(null);
                        this.failDect_.setCoordinator(this.ssep.addr);
                        this.failDect_.setNodeListenerHostname(this.ssep.addr.getHostName());
                        this.resolver.shutdown();
                        this.broadcaster.shutdown(l * 2L);
                        this.registrationStatus_ = true;
                        bl2 = true;
                    }
                    catch (Exception exception) {
                        if (this.logger_.isLoggable(Level.INFO)) {
                            this.logger_.log(Level.INFO, "Unable to initialize coordinator.", exception);
                        }
                        this.resolver.shutdown();
                        this.broadcaster.shutdown();
                    }
                } else {
                    this.resolver.shutdown();
                    this.broadcaster.shutdown();
                    if (this.resolver.isLocalConflict()) {
                        this.stopNodeListener();
                    }
                    try {
                        Thread.sleep(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (bl2) continue;
            ++n2;
        }
        if (!bl2) {
            this.cleanupConnections(false);
            throw new GroupException("Unable to find or become the coordinator after " + n2 + " attempts.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int discoverCoordinator(Vector vector) throws GroupException {
        int n = -1;
        int n2 = 0;
        int n3 = vector.size();
        Vector vector2 = new Vector();
        for (int i = 0; i < n3; ++i) {
            Unicaster unicaster = new Unicaster(this.gcomm_, this, (Address)vector.elementAt(i), vector2);
            unicaster.start();
        }
        while (n2 < n3) {
            while (vector2.size() > 0) {
                Unicaster unicaster;
                if (this.ssep.isClosed()) {
                    this.ssinit(this.s_config.getLowerPortBoundry(), this.s_config.getUpperPortBoundry(), this.s_config.getTag(), this.localHost, this.s_config.getListenerList());
                    this.ssep.handler = new ServerSocketReceiver(this.gcomm_, this, this.ssep);
                    this.ssep.handler.start();
                }
                if ((unicaster = (Unicaster)vector2.firstElement()).getCoordinator() != null) {
                    n = -2;
                    if (this.connect(unicaster.getNodeListener(), unicaster.getCoordinator())) {
                        return 0;
                    }
                }
                vector2.removeElement(unicaster);
                ++n2;
            }
            Vector vector3 = vector2;
            synchronized (vector3) {
                try {
                    vector2.wait(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return n;
    }

    Vector removeANodeFromList(String string, Vector vector) {
        Vector<Address> vector2 = new Vector<Address>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Address address = (Address)vector.elementAt(i);
            if (address.getIPString().equals(string)) continue;
            vector2.addElement(address);
        }
        return vector2;
    }

    boolean beACoordinator(boolean bl, Address[] addressArray, int n, long l) throws GroupException {
        boolean bl2 = false;
        if (bl) {
            this.broadcaster = new CoordinatorBroadcast(this.gcomm_, this, this.s_config.getMulticastAddress(), this.s_config.getMulticastPort(), this.ssep.addr, this.s_config.getMulticastInterval(), false);
            this.resolver = new CoordinatorResolver(this.gcomm_, this, addressArray, this.ssep.addr, this.broadcaster.getMulticastSocket());
        } else {
            this.broadcaster = new CoordinatorBroadcast(this.gcomm_, this, addressArray, this.ssep.addr, this.s_config.getMulticastInterval(), false);
            this.resolver = new CoordinatorResolver(this.gcomm_, this, addressArray, this.ssep.addr);
        }
        this.broadcaster.start();
        this.resolver.start();
        long l2 = System.currentTimeMillis();
        try {
            this.resolver.join(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        long l3 = System.currentTimeMillis() - l2;
        if (this.resolver.canBeCoordinator() && l3 >= l && this.isNLStarted()) {
            this.broadcaster.confirmNominee();
            this.discardIncomingConnection_ = false;
            bl2 = true;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void broadcastConfirmation(Address address) throws GroupException {
        if (this.broadcaster != null) {
            this.broadcaster.shutdown();
        }
        if (this.s_config.isMulticast()) {
            this.broadcaster = new CoordinatorBroadcast(this.gcomm_, this, this.s_config.getMulticastAddress(), this.s_config.getMulticastPort(), address, this.s_config.getMulticastInterval(), true);
        } else {
            Vector vector;
            Address[] addressArray = null;
            GroupConfig groupConfig = this.s_config;
            synchronized (groupConfig) {
                vector = (Vector)this.s_config.getListenerList().clone();
            }
            if (vector != null && vector.size() > 0) {
                addressArray = new Address[vector.size()];
                vector.toArray(addressArray);
            }
            this.broadcaster = new CoordinatorBroadcast(this.gcomm_, this, addressArray, address, this.s_config.getMulticastInterval(), true);
        }
        this.broadcaster.start();
        this.broadcaster.shutdown(this.s_config.getResolutionTimeout() * 2L);
        this.coordStartTime_ = System.currentTimeMillis();
    }

    Address getLocalNodeListenerAddress() throws GroupException {
        Vector vector = this.s_config.getListenerList();
        return this.getLocalNodeListenerAddress(vector);
    }

    Address getLocalNodeListenerAddress(Vector vector) throws GroupException {
        int n = vector.size();
        Address address = null;
        for (int i = 0; i < n; ++i) {
            Address address2 = (Address)vector.elementAt(i);
            if (address2.isOriginal()) {
                address = address2;
                break;
            }
            if (address != null || !address2.getIPString().equals(this.getLocalAddress().getIPString())) continue;
            address = address2;
        }
        if (address == null) {
            throw new GroupException("Unable to find a local Address from the discoverer list");
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ssinit(int n, int n2, Serializable serializable, InetAddress inetAddress, Vector vector) throws GroupException {
        try {
            ServerSocket serverSocket = this.createServerSocket(n, n2, inetAddress, this.s_config.isSSLEnabled(), this.getAllPortsFrom(vector, inetAddress));
            Address address = null;
            address = inetAddress != null ? new Address(inetAddress, serverSocket.getLocalPort(), serializable) : new Address(InetAddress.getLocalHost(), serverSocket.getLocalPort(), serializable);
            address.setCacheName(this.s_config.getCacheName());
            String string = System.getProperty(OPMNID);
            String string2 = System.getProperty(OPNNORACLE_HOME);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("prop:");
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            if (string != null) {
                stringBuffer.append(' ');
                stringBuffer.append(string);
            } else {
                stringBuffer.append("NA");
            }
            if (stringBuffer.toString() != null) {
                address.setUserDefinedId(stringBuffer.toString());
            }
            this.ssep = new ServerSocketEndPoint(this.gcomm_, address, serverSocket);
            Vector vector2 = this.addrList;
            synchronized (vector2) {
                this.addrList.addElement(address);
            }
        }
        catch (BindException bindException) {
            throw new GroupException(GrpCommunication.EXP_GRP_PORTINUSE);
        }
        catch (Exception exception) {
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Transport initialization failed.", exception);
            }
            throw new GroupException(GrpCommunication.EXP_GRP_SOCKETINITFAIL, exception);
        }
    }

    boolean nlinit() {
        boolean bl;
        block5: {
            bl = false;
            ServerSocket serverSocket = null;
            try {
                serverSocket = this.createServerSocket(this.localNLAddress.port, this.localNLAddress.getIPString());
                this.nlistener = new ServerSocketEndPoint(this.gcomm_, this.localNLAddress, serverSocket);
                this.nlistener.handler = new NodeListener(this.gcomm_, this, this.nlistener);
                this.nlistener.handler.start();
                this.waitUtilNodeListenIsUp(this.localNLAddress, 120000L);
                this.failDect_.setNodeListenerHostname(this.localNLAddress.getHostName());
                bl = true;
            }
            catch (Exception exception) {
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                this.nlistener = null;
                if (!this.logger_.isLoggable(Level.INFO)) break block5;
                this.logger_.log(Level.INFO, "Unable to start Node Listener at port:" + this.localNLAddress.getPort() + ". " + exception.getMessage());
            }
        }
        return bl;
    }

    void waitUtilNodeListenIsUp(Address address, long l) throws GroupException {
        boolean bl = false;
        long l2 = System.currentTimeMillis();
        while (!bl) {
            try {
                this.getCoordinatorFromANodeListener(address);
                bl = true;
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (System.currentTimeMillis() - l2 <= l) continue;
            throw new GroupException("Timeout while waiting for Node Listener to be available.");
        }
    }

    int findEmptySlot(Vector vector) throws GroupException {
        int n;
        if (vector == null) {
            throw new GroupException(GrpCommunication.EXP_GRP_INTERNAL + GrpCommunication.EXP_GRP_INVALIDPAR);
        }
        BitSet bitSet = new BitSet();
        for (n = 0; n < vector.size(); ++n) {
            Address address = (Address)vector.elementAt(n);
            bitSet.set(address.getPosition());
        }
        for (n = 0; n < vector.size(); ++n) {
            if (bitSet.get(n)) continue;
            return n;
        }
        return vector.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNLStarted() {
        Object object = this.nodeListernerLock;
        synchronized (object) {
            return this.nlistener != null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopNodeListener() {
        Object object = this.nodeListernerLock;
        synchronized (object) {
            if (this.nlistener != null) {
                block6: {
                    try {
                        this.nlistener.close();
                    }
                    catch (Exception exception) {
                        if (!this.logger_.isLoggable(Level.SEVERE)) break block6;
                        this.logger_.log(Level.SEVERE, "Node Listener termination error. " + exception);
                    }
                }
                this.nlistener = null;
            }
            this.clearElectionVoteBuffer();
        }
    }

    Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        return this.createSocket(inetAddress, n, this.s_timeout);
    }

    Socket createSocket(InetAddress inetAddress, int n, int n2) throws IOException {
        GroupSocketOpener groupSocketOpener = this.s_config.isSSLEnabled() ? new GroupSocketOpener(this, inetAddress, n, n2, true) : new GroupSocketOpener(this, inetAddress, n, n2, false);
        Socket socket = groupSocketOpener.createSocket();
        return socket;
    }

    ServerSocket createServerSocket(int n, String string) throws IOException {
        InetAddress inetAddress = null;
        inetAddress = string != null ? InetAddress.getByName(string) : InetAddress.getLocalHost();
        ServerSocket serverSocket = this.s_config.isSSLEnabled() ? this.sslMgr_.createSSLServerSocket(n, 50, inetAddress) : new ServerSocket(n, 50, inetAddress);
        return serverSocket;
    }

    ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress, boolean bl, int[] nArray) throws IOException, GroupException {
        int n3;
        InetAddress inetAddress2 = null;
        ServerSocket serverSocket = null;
        int n4 = n2 - n + 1;
        BitSet bitSet = null;
        int n5 = 0;
        Random random = new Random(System.currentTimeMillis());
        if (n4 <= 0) {
            throw new GroupException("Invalid port range: " + n + "-" + n2);
        }
        bitSet = new BitSet(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            bitSet.set(n3);
        }
        if (nArray != null) {
            for (n3 = 0; n3 < nArray.length; ++n3) {
                int n6 = nArray[n3];
                if (n > n6 || n6 > n2) continue;
                bitSet.clear(n6 - n);
            }
        }
        inetAddress2 = inetAddress != null ? inetAddress : InetAddress.getLocalHost();
        n3 = random.nextInt(n4);
        while (!this.isBitSetEmpty(bitSet)) {
            while (!bitSet.get(n3)) {
                n3 = random.nextInt(n4);
            }
            n5 = n + n3;
            try {
                serverSocket = bl ? this.sslMgr_.createSSLServerSocket(n5, 50, inetAddress2) : new ServerSocket(n5, 50, inetAddress2);
                if (n5 == 0 && this.arrayContains(nArray, serverSocket.getLocalPort())) continue;
                break;
            }
            catch (IOException iOException) {
                bitSet.clear(n3);
            }
        }
        if (serverSocket == null) {
            throw new GroupException("Unable to create server socket within port range:" + n + "-" + n2);
        }
        return serverSocket;
    }

    private boolean isBitSetEmpty(BitSet bitSet) {
        boolean bl = true;
        for (int i = 0; i < bitSet.length(); ++i) {
            if (!bitSet.get(i)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean arrayContains(int[] nArray, int n) {
        boolean bl = false;
        if (nArray == null) {
            return bl;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private int[] getAllPortsFrom(Vector vector, InetAddress inetAddress) {
        int[] nArray = null;
        if (vector != null) {
            int n;
            Vector<Integer> vector2 = new Vector<Integer>();
            for (n = 0; n < vector.size(); ++n) {
                Address address;
                Object e = vector.elementAt(n);
                if (e == null || !(e instanceof Address) || (address = (Address)e).getIPString() != null && !address.getIPString().equals(inetAddress.getHostAddress())) continue;
                vector2.addElement(new Integer(address.getPort()));
            }
            n = vector2.size();
            if (n > 0) {
                nArray = new int[n];
                for (int i = 0; i < n; ++i) {
                    nArray[i] = (Integer)vector2.elementAt(i);
                }
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean connect(Address address, Address address2) {
        EndPoint endPoint = null;
        EndPoint endPoint2 = null;
        boolean bl = false;
        try {
            View view;
            this.failDect_.setCoordinator(address2);
            this.failDect_.setNodeListenerHostname(address.getHostName());
            Socket socket = this.createSocket(address2.ip, address2.port);
            int n = socket.getSoTimeout();
            endPoint = new EndPoint(this.gcomm_, address2, socket);
            this.endPointList.put(address2, endPoint);
            this.discardIncomingConnection_ = false;
            Packet packet = new Packet(8, 0, this.ssep.addr, null, null, 0L);
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, "Register myself to the coordinator at " + address2);
            }
            socket.setSoTimeout(0);
            endPoint.write(packet);
            Packet packet2 = endPoint.read();
            if (packet2 == null || packet2.type == 21) {
                throw new ConnectException("Coordinator has been moved");
            }
            Address address3 = null;
            Serializable serializable = this.addrList;
            synchronized (serializable) {
                this.addrList.clear();
                this.addrList.addAll(((View)packet2.message).getMembers());
                address3 = (Address)this.addrList.lastElement();
            }
            if (address3.equals(this.ssep.addr)) {
                this.ssep.addr.setPosition(address3.getPosition());
                this.ssep.addr.setUid(address3.getUid());
                this.ssep.addr.setTimeStamp(address3.getTimeStamp());
                if (address3.getUid() > this.getGUid()) {
                    this.setGUid(address3.getUid());
                }
            } else {
                if (this.logger_.isLoggable(Level.WARNING)) {
                    this.logger_.log(Level.WARNING, "Unable to register " + address3 + " in view: " + (View)packet2.message);
                }
                throw new GroupException(GrpCommunication.EXP_GRP_INTERNAL + GrpCommunication.EXP_GRP_INVALIDPAR);
            }
            if (this.logger_.isLoggable(Level.INFO)) {
                this.logger_.log(Level.INFO, "Registered successfully. Member address: " + this.ssep.addr + ", view ID: " + ((View)packet2.message).getVid());
            }
            if (this.addrList == null) {
                throw new GroupException(GrpCommunication.EXP_GRP_INTERNAL + GrpCommunication.EXP_GRP_INVALIDPAR);
            }
            packet = new Packet(3, 0, this.ssep.addr, (Serializable)((Object)GroupManager.SYSTEM_GROUP), null, 0L);
            Enumeration enumeration = this.addrList.elements();
            serializable = null;
            Hashtable hashtable = new Hashtable();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                serializable = (Address)enumeration.nextElement();
                if (this.isMyself((Address)serializable) || ((Address)serializable).equals(this.failDect_.getCoordinator())) continue;
                ++n2;
                Receiver receiver = new Receiver(this.gcomm_, this, (Address)serializable, packet, hashtable);
                receiver.start();
            }
            long l = System.currentTimeMillis();
            long l2 = this.s_timeout * 10;
            while (true) {
                Hashtable hashtable2 = hashtable;
                synchronized (hashtable2) {
                    if (hashtable.size() == n2 || System.currentTimeMillis() - l > l2) {
                        if (this.logger_.isLoggable(Level.FINEST)) {
                            this.logger_.log(Level.FINEST, "Finished registering for all members");
                        }
                        if (hashtable.containsValue(false) && this.logger_.isLoggable(Level.FINE)) {
                            this.logger_.log(Level.FINE, "Some members have left");
                        }
                        break;
                    }
                    hashtable.wait(100L);
                }
            }
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "ready and expect a view");
            }
            packet = new Packet(5, 0, this.ssep.addr, address, null, 0L);
            endPoint2 = (EndPoint)this.endPointList.get(this.failDect_.getCoordinator());
            int n3 = endPoint2.s.getSoTimeout();
            endPoint2.write(packet);
            packet2 = endPoint2.read();
            if (packet2 == null) {
                throw new GroupException(GrpCommunication.EXP_GRP_INTERNAL + GrpCommunication.EXP_GRP_REPLYISNULL);
            }
            boolean bl2 = false;
            block17: while (!bl2) {
                switch (packet2.type) {
                    case 4: {
                        view = (View)packet2.message;
                        bl2 = view.getMembers().contains(this.ssep.addr);
                        if (bl2) continue block17;
                    }
                    case 21: {
                        throw new GroupException(GrpCommunication.EXP_GRP_VIEWNULL);
                    }
                }
                if (this.logger_.isLoggable(Level.FINEST)) {
                    this.logger_.log(Level.FINEST, "Expected a view object from " + this.failDect_.getCoordinator().toString(true) + ". Ignores packet: " + packet2);
                }
                packet2 = endPoint2.read();
            }
            view = (View)packet2.message;
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got new view: " + view);
            }
            endPoint2.s.setSoTimeout(n3);
            Vector vector = this.addrList;
            synchronized (vector) {
                this.addrList.clear();
                this.addrList.addAll(view.getMembers());
                this.gmgr_.initView(view);
            }
            endPoint2.handler = new Receiver(this.gcomm_, this, endPoint2);
            endPoint2.handler.start();
            this.gmgr_.flush(packet2);
            bl = true;
            this.registrationStatus_ = true;
            this.notifyRegistrationIsCompleted();
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, "Registration completed successfully at " + this.failDect_.getCoordinator());
            }
        }
        catch (Exception exception) {
            this.registrationStatus_ = false;
            this.notifyRegistrationIsCompleted();
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, "Failed to connect to coordinator at " + this.failDect_.getCoordinator().toString(false) + ", " + exception);
            }
            this.cleanupConnections(false);
            this.failDect_.setCoordinator(null);
            this.failDect_.setNodeListenerHostname(null);
            this.resetRegistrationStatus();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Address getCoordinatorFromANodeListener(Address address) throws GroupException {
        Address address2 = null;
        Socket socket = null;
        Packet packet = null;
        Packet packet2 = null;
        try {
            try {
                socket = this.createSocket(address.ip, address.port);
                socket.setSoTimeout(this.s_timeout);
                StreamHandler streamHandler = new StreamHandler(this.gcomm_, socket);
                Address address3 = null;
                if (this.isNLStarted()) {
                    address3 = this.getCachedLocalNLAddress();
                }
                packet = new Packet(1, 0, this.ssep.addr, null, address3, 0L);
                streamHandler.write(packet);
                packet2 = streamHandler.read();
                Serializable serializable = packet2.message;
                if (serializable != null && serializable instanceof Address) {
                    address2 = (Address)serializable;
                }
            }
            catch (Exception exception) {
                throw new GroupException(GrpCommunication.EXP_GRP_INTERNAL + GrpCommunication.EXP_GRP_REPLYISNULL);
            }
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            try {
                if (socket == null) throw throwable;
                socket.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (socket == null) return address2;
        socket.close();
        return address2;
    }

    void sendElectionVoteTo(Address address, ElectionNotification electionNotification) {
        Socket socket = null;
        Packet packet = null;
        StreamHandler streamHandler = null;
        if (this.terminated) {
            return;
        }
        try {
            socket = this.createSocket(address.ip, address.port);
            socket.setSoLinger(true, 1);
            socket.setSoTimeout(this.s_timeout);
            streamHandler = new StreamHandler(this.gcomm_, socket);
            packet = new Packet(18, 0, this.getLocalAddress(), null, electionNotification, 0L);
            streamHandler.write(packet);
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Sent vote: " + electionNotification + " to " + address.toString(true));
            }
            Packet packet2 = streamHandler.read();
        }
        catch (Exception exception) {
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Unable to send vote: " + electionNotification + " to " + address.toString(true));
            }
            try {
                if (streamHandler != null) {
                    streamHandler.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    Address[] getASortedAddressList(Vector vector) {
        Address[] addressArray = null;
        if (vector == null || vector.size() <= 0) {
            return null;
        }
        TreeSet treeSet = new TreeSet(vector);
        addressArray = new Address[treeSet.size()];
        treeSet.toArray(addressArray);
        return addressArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void terminateNodeListenerAt(Address address) throws GroupException {
        block11: {
            Socket socket = null;
            Packet packet = null;
            Packet packet2 = null;
            socket = this.createSocket(address.ip, address.port);
            socket.setSoLinger(true, 1);
            socket.setSoTimeout(this.s_timeout);
            StreamHandler streamHandler = new StreamHandler(this.gcomm_, socket);
            packet = new Packet(23, 0, this.ssep.addr, null, null, 0L);
            streamHandler.write(packet);
            packet2 = streamHandler.read();
            Object var8_6 = null;
            try {
                if (socket != null) {
                    socket.close();
                }
                break block11;
            }
            catch (Exception exception) {}
            break block11;
            {
                catch (Exception exception) {
                    Object var8_7 = null;
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        break block11;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    void term() {
        this.mon_.stopit();
        try {
            if (this.isMyself(this.getFailureDetector().getCoordinator())) {
                while (this.numOfClosingReceivers_ != 0) {
                    Thread.sleep(500L);
                }
                long l = 30000L - (System.currentTimeMillis() - this.coordStartTime_);
                if (l > 0L) {
                    Thread.sleep(l);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.discardIncomingConnection_ = true;
        this.terminated = true;
        this.stopNodeListener();
        if (this.sender != null) {
            this.sender.stopit();
            try {
                this.sender.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sender = null;
            this.asQ = null;
        }
        this.receivingQList.clear();
        try {
            Packet packet = new Packet(20, 0, this.ssep.addr, (Serializable)((Object)GroupManager.SYSTEM_GROUP), null, 0L);
            this.multicast(packet, true);
            Thread.sleep(600L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.cleanupConnections();
        if (this.broadcaster != null) {
            this.broadcaster.shutdown();
            try {
                this.broadcaster.join(this.s_timeout);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.receivingQList.clear();
        this.gmgr_.term();
    }

    private void cleanupConnections() {
        this.cleanupConnections(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupConnections(boolean bl) {
        Vector vector;
        block12: {
            vector = null;
            try {
                if (!bl && this.ssep != null) {
                    this.ssep.close();
                }
            }
            catch (Exception exception) {
                if (!this.logger_.isLoggable(Level.FINEST)) break block12;
                this.logger_.log(Level.FINEST, "Ignore ssep close error", exception);
            }
        }
        Hashtable hashtable = this.endPointList;
        synchronized (hashtable) {
            vector = new Vector(this.endPointList.values());
        }
        for (int i = 0; vector != null && i < vector.size(); ++i) {
            try {
                EndPoint endPoint = (EndPoint)vector.elementAt(i);
                endPoint.close();
                continue;
            }
            catch (Exception exception) {
                if (!this.logger_.isLoggable(Level.FINEST)) continue;
                this.logger_.log(Level.FINEST, "Ignore ep close error", exception);
            }
        }
        this.endPointList.clear();
        Vector vector2 = this.addrList;
        synchronized (vector2) {
            this.addrList.clear();
        }
    }

    void send(Packet packet) throws GroupException, IOException, InterruptedException {
        if (this.terminated) {
            throw new GroupException(GrpCommunication.EXP_GRP_NOTINITIALIZED);
        }
        if (this.tg.equals(Thread.currentThread().getThreadGroup())) {
            Job job = new Job(0, packet);
            this.asQ.enqueue(job);
        } else {
            this.syncSend(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void syncSend(Packet packet) throws GroupException, IOException, InterruptedException {
        boolean bl = false;
        EndPoint endPoint = (EndPoint)this.endPointList.get((Address)packet.destination);
        if (endPoint == null) {
            throw new GroupException(GrpCommunication.EXP_GRP_NOCONNECTION + packet.destination);
        }
        this.gmgr_.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        MessageBuffer messageBuffer = this.gmgr_.getCurrentViewInfo(GroupManager.SYSTEM_GROUP).getMessageBuffer();
        this.gmgr_.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        try {
            try {
                Object[] objectArray;
                this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                bl = true;
                View view = this.gmgr_.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
                packet.vid = view.getVid();
                packet.receiverIndex = view.getMembers().indexOf((Address)packet.destination);
                packet.receiverPosition = ((Address)packet.destination).getPosition();
                packet.senderIndex = view.getMembers().indexOf(this.getLocalAddress());
                if (messageBuffer.updated()) {
                    objectArray = messageBuffer.getReceiveVector();
                    packet.setReceiveArray((long[])objectArray);
                    packet.setReceivedTONumber(this.getReceivedTONumber());
                }
                objectArray = endPoint.lock;
                synchronized (endPoint.lock) {
                    endPoint.write(packet);
                    endPoint.counter += packet.getSize();
                    if (endPoint.counter >= 0x100000L) {
                        endPoint.reset();
                        endPoint.counter = 0L;
                    }
                    // ** MonitorExit[var6_7 /* !! */ ] (shouldn't be in output)
                    if (this.logger_.isLoggable(Level.FINEST)) {
                        this.logger_.log(Level.FINEST, "syncSend: " + packet);
                        break block10;
                    }
                    if (!this.logger_.isLoggable(Level.FINE) || packet == null) break block10;
                    this.logger_.log(Level.FINE, "syncSend: " + packet.getType() + " to " + endPoint.addr.toString(true));
                }
            }
            catch (IOException iOException) {
                if (!this.logger_.isLoggable(Level.FINE)) throw iOException;
                this.logger_.log(Level.FINE, "syncSend warning: " + iOException.getMessage() + ". ep:" + endPoint);
                throw iOException;
            }
            {
                block10: {
                }
                Object var9_8 = null;
                if (!bl) return;
                this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!bl) throw throwable;
            this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
            throw throwable;
        }
    }

    GrpReplyInfo sendTotalOrderedMsg(Packet packet) throws GroupException, IOException, InterruptedException {
        if (this.terminated) {
            throw new GroupException(GrpCommunication.EXP_GRP_NOTINITIALIZED);
        }
        if (!this.tg.equals(Thread.currentThread().getThreadGroup())) {
            return this.syncSendTotalOrderedMsg(packet);
        }
        Job job = new Job(1, packet);
        this.asQ.enqueue(job);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    GrpReplyInfo syncSendTotalOrderedMsg(Packet packet) throws GroupException, IOException, InterruptedException {
        boolean bl = false;
        EndPoint endPoint = (EndPoint)this.endPointList.get(this.failDect_.getCoordinator());
        if (endPoint == null) {
            if (!this.isMyself(this.failDect_.getCoordinator())) throw new GroupException(GrpCommunication.EXP_GRP_NOCONNECTION + this.failDect_.getCoordinator());
            this.multicastTotalOrderedMsg(packet);
        }
        this.gmgr_.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        MessageBuffer messageBuffer = this.gmgr_.getCurrentViewInfo(GroupManager.SYSTEM_GROUP).getMessageBuffer();
        this.gmgr_.getCurrentViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        try {
            GrpReplyInfo grpReplyInfo;
            try {
                Object object;
                this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                bl = true;
                View view = this.gmgr_.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
                packet.vid = view.getVid();
                packet.receiverIndex = view.getMembers().indexOf(this.failDect_.getCoordinator());
                packet.receiverPosition = this.failDect_.getCoordinator().getPosition();
                packet.senderIndex = view.getMembers().indexOf(this.getLocalAddress());
                messageBuffer.save(packet);
                if (messageBuffer.updated()) {
                    object = messageBuffer.getReceiveVector();
                    packet.setReceiveArray((long[])object);
                    packet.setReceivedTONumber(this.getReceivedTONumber());
                }
                object = endPoint.lock;
                synchronized (endPoint.lock) {
                    endPoint.write(packet);
                    endPoint.counter += packet.getSize();
                    if (endPoint.counter >= 0x100000L) {
                        endPoint.reset();
                        endPoint.counter = 0L;
                    }
                    // ** MonitorExit[var7_7 /* !! */ ] (shouldn't be in output)
                    if (this.logger_.isLoggable(Level.FINEST)) {
                        this.logger_.log(Level.FINEST, "syncSendTotalOrderedMsg packet: " + packet);
                    }
                    object = view.getMembers();
                    grpReplyInfo = new GrpReplyInfo(this, view);
                    if (this.logger_.isLoggable(Level.FINEST)) {
                        this.logger_.log(Level.FINEST, "syncSendTotalOrderedMsg: " + packet);
                        break block11;
                    }
                    if (!this.logger_.isLoggable(Level.FINE) || packet == null) break block11;
                    this.logger_.log(Level.FINE, "syncSendTotalOrderedMsg: " + packet.getType() + " to " + endPoint.addr.toString(true));
                }
            }
            catch (IOException iOException) {
                if (!this.logger_.isLoggable(Level.WARNING)) throw iOException;
                this.logger_.log(Level.WARNING, "syncSendTotalOrderedMsg Warning: " + iOException.getMessage() + ". ep:" + endPoint + ", msg:" + packet);
                throw iOException;
            }
            {
                block11: {
                }
                Object var10_9 = null;
                if (!bl) return grpReplyInfo;
                this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                return grpReplyInfo;
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (!bl) throw throwable;
            this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
            throw throwable;
        }
    }

    public GrpReplyInfo multicast(Packet packet) throws GroupException, IOException, InterruptedException {
        return this.multicast(packet, false, false);
    }

    private GrpReplyInfo multicast(Packet packet, boolean bl) throws GroupException, IOException, InterruptedException {
        return this.multicast(packet, bl, false);
    }

    GrpReplyInfo multicast(Packet packet, boolean bl, boolean bl2) throws GroupException, IOException, InterruptedException {
        if (this.terminated && !bl) {
            throw new GroupException(GrpCommunication.EXP_GRP_NOTINITIALIZED);
        }
        if (bl2 && !this.tg.equals(Thread.currentThread().getThreadGroup()) || !this.asQ.isEnable()) {
            return this.syncMulticast(packet);
        }
        Job job = new Job(2, packet);
        this.asQ.enqueue(job);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    GrpReplyInfo syncMulticast(Packet packet) throws GroupException, IOException, InterruptedException {
        Object var2_2 = null;
        int n = 0;
        GrpReplyInfo grpReplyInfo = null;
        boolean bl = false;
        try {
            Object object;
            this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
            bl = true;
            ViewInfo viewInfo = this.gmgr_.getLatestViewInfo((String)((Object)packet.destination));
            View view = viewInfo.getView();
            packet.vid = view.getVid();
            packet.senderIndex = view.getMembers().indexOf(this.getLocalAddress());
            MessageBuffer messageBuffer = viewInfo.getMessageBuffer();
            if (messageBuffer.updated()) {
                object = messageBuffer.getReceiveVector();
                packet.setReceiveArray((long[])object);
                packet.setReceivedTONumber(this.getReceivedTONumber());
                messageBuffer.setUpdated(false);
            }
            object = view.getMembers();
            Vector vector = viewInfo.getEPList();
            Hashtable hashtable = this.getEndPointList();
            if (object == null) throw new GroupException(GrpCommunication.EXP_GRP_NOGROUPINFO);
            if (vector == null) {
                throw new GroupException(GrpCommunication.EXP_GRP_NOGROUPINFO);
            }
            for (n = 0; n < ((Vector)object).size(); ++n) {
                packet.receiverIndex = n;
                Address address = (Address)((Vector)object).elementAt(n);
                packet.receiverPosition = address.getPosition();
                if (!this.isMyself(address)) {
                    EndPoint endPoint = (EndPoint)hashtable.get(address);
                    if (endPoint != null) {
                        block16: {
                            byte[] byArray = endPoint.lock;
                            // MONITORENTER : endPoint.lock
                            try {
                                endPoint.write(packet);
                                endPoint.counter += packet.getSize();
                                if (endPoint.counter >= 0x100000L) {
                                    endPoint.reset();
                                    endPoint.counter = 0L;
                                }
                            }
                            catch (Exception exception) {
                                if (!this.logger_.isLoggable(Level.INFO)) break block16;
                                this.logger_.log(Level.INFO, "Can't send msg from " + this.ssep.addr + " to " + endPoint.addr + " :" + exception);
                            }
                        }
                        // MONITOREXIT : byArray
                        continue;
                    }
                    if (this.logger_.isLoggable(Level.FINE)) {
                        this.logger_.log(Level.FINE, "No connection to " + address);
                    }
                    if (!this.logger_.isLoggable(Level.FINEST)) continue;
                    this.logger_.log(Level.FINEST, "Unable to send [" + packet + "] to [" + address + "]");
                    continue;
                }
                grpReplyInfo = new GrpReplyInfo(this, view);
            }
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "syncMulticast: " + packet + " in view:" + view.getVid());
            } else if (this.logger_.isLoggable(Level.FINE) && packet != null) {
                this.logger_.log(Level.FINE, "syncMulticast: " + packet.getType() + " in view: " + view.getVid());
            }
            Object var18_16 = null;
            if (!bl) return grpReplyInfo;
            this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
            return grpReplyInfo;
        }
        catch (Throwable throwable) {
            Object var18_17 = null;
            if (!bl) throw throwable;
            this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
            throw throwable;
        }
    }

    synchronized GrpReplyInfo multicastTotalOrderedMsg(Packet packet) throws GroupException, IOException, InterruptedException {
        if (this.terminated) {
            throw new GroupException(GrpCommunication.EXP_GRP_NOTINITIALIZED);
        }
        packet.setSequenceNumber(this.incSequencer());
        if (!this.tg.equals(Thread.currentThread().getThreadGroup())) {
            return this.syncMulticastTotalOrderedMsg(packet);
        }
        Job job = new Job(3, packet);
        this.asQ.enqueue(job);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    synchronized GrpReplyInfo syncMulticastTotalOrderedMsg(Packet packet) throws GroupException, IOException, InterruptedException {
        Object var2_2 = null;
        int n = 0;
        int n2 = 0;
        GrpReplyInfo grpReplyInfo = null;
        boolean bl = false;
        try {
            Vector vector;
            Vector vector2;
            Object[] objectArray;
            MessageBuffer messageBuffer;
            View view;
            ViewInfo viewInfo;
            if (packet.getVid() == -1) {
                this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                bl = true;
                viewInfo = this.gmgr_.getLatestViewInfo((String)((Object)packet.destination));
                view = viewInfo.getView();
                packet.vid = view.getVid();
                packet.senderIndex = view.getMembers().indexOf(this.getLocalAddress());
                packet.fromMyself = true;
                messageBuffer = viewInfo.getMessageBuffer();
                messageBuffer.save(packet);
                Receiver.deliver(this.gcomm_, this, packet, messageBuffer);
                if (messageBuffer.updated()) {
                    objectArray = messageBuffer.getReceiveVector();
                    packet.setReceiveArray((long[])objectArray);
                    packet.setReceivedTONumber(this.getReceivedTONumber());
                    messageBuffer.setUpdated(false);
                }
                vector2 = view.getMembers();
                vector = viewInfo.getEPList();
                if (vector2 == null) throw new GroupException(GrpCommunication.EXP_GRP_NOGROUPINFO);
                if (vector == null) {
                    throw new GroupException(GrpCommunication.EXP_GRP_NOGROUPINFO);
                }
            } else {
                this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                bl = true;
                viewInfo = this.gmgr_.getLatestViewInfo(GroupManager.SYSTEM_GROUP);
                view = viewInfo.getView();
                messageBuffer = viewInfo.getMessageBuffer();
                vector2 = view.getMembers();
                vector = viewInfo.getEPList();
                viewInfo = this.gmgr_.getViewInfo(GroupManager.SYSTEM_GROUP, packet.getVid());
                if (viewInfo != null) {
                    messageBuffer = viewInfo.getMessageBuffer();
                    messageBuffer.save(packet);
                }
                if (vector2 == null) throw new GroupException(GrpCommunication.EXP_GRP_NOGROUPINFO);
                if (vector == null) {
                    throw new GroupException(GrpCommunication.EXP_GRP_NOGROUPINFO);
                }
            }
            for (n = 0; n < vector2.size(); ++n) {
                packet.receiverIndex = n;
                packet.receiverPosition = ((Address)vector2.elementAt(n)).getPosition();
                if (!this.isMyself((Address)vector2.elementAt(n))) {
                    if (n2 < vector.size()) {
                        EndPoint endPoint = (EndPoint)vector.elementAt(n2);
                        if (endPoint != null) {
                            block20: {
                                objectArray = endPoint.lock;
                                // MONITORENTER : endPoint.lock
                                try {
                                    endPoint.write(packet);
                                    endPoint.counter += packet.getSize();
                                    if (endPoint.counter >= 0x100000L) {
                                        endPoint.reset();
                                        endPoint.counter = 0L;
                                    }
                                }
                                catch (Exception exception) {
                                    if (!this.logger_.isLoggable(Level.INFO)) break block20;
                                    this.logger_.log(Level.INFO, "Can't send msg from " + this.ssep.addr + " to " + var2_2 + " :" + exception);
                                }
                            }
                            // MONITOREXIT : objectArray
                        }
                        ++n2;
                        continue;
                    }
                    if (!this.logger_.isLoggable(Level.FINEST)) continue;
                    this.logger_.log(Level.FINEST, "Warning, no connection to " + vector2.elementAt(n));
                    continue;
                }
                grpReplyInfo = new GrpReplyInfo(this, view);
            }
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "syncMulticastTotalOrderedMsg: " + packet + " in view:" + view.getVid());
            } else if (this.logger_.isLoggable(Level.FINE) && packet != null) {
                this.logger_.log(Level.FINE, "syncMulticastTotalOrderedMsg: " + packet.getType() + " to view: " + view.getVid());
            }
            Object var17_15 = null;
            if (!bl) return grpReplyInfo;
            this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
            return grpReplyInfo;
        }
        catch (Throwable throwable) {
            Object var17_16 = null;
            if (!bl) throw throwable;
            this.gmgr_.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
            throw throwable;
        }
    }

    void registerReceivingQueue(String string, MessageQueue messageQueue, Object object) {
        this.receivingQList.put(string, messageQueue);
        this.ctx = object;
    }

    void deregisterReceivingQueue(String string, MessageQueue messageQueue) {
        this.receivingQList.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAddress(Address address) {
        if (address != null) {
            Vector vector = this.addrList;
            synchronized (vector) {
                this.addrList.removeElement(address);
            }
            this.endPointList.remove(address);
        }
    }

    void removeEndPoint(Address address) {
        if (address != null) {
            this.endPointList.remove(address);
        }
    }

    boolean isMyself(Address address) {
        return this.ssep.addr.equals(address);
    }

    synchronized void setAddrList(Vector vector) {
        this.addrList = new Vector(vector);
    }

    synchronized Vector getAddrList() {
        return new Vector(this.addrList);
    }

    Hashtable getEndPointList() {
        return this.endPointList;
    }

    Address getLocalAddress() {
        return this.ssep.addr;
    }

    Address getCachedLocalNLAddress() {
        return this.localNLAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean startNodeListener() {
        boolean bl = false;
        Object object = this.nodeListernerLock;
        synchronized (object) {
            if (this.nlistener == null) {
                if (!this.terminated) {
                    bl = this.nlinit();
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    boolean isReady() {
        return !this.initializing;
    }

    boolean isDiscardIncomingConnection() {
        return this.discardIncomingConnection_;
    }

    boolean isNLDeathDetectable() {
        return this.s_config.isNLDeathDetected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addElectionVote(ElectionNotification electionNotification) {
        Vector vector = this.electionVotes;
        synchronized (vector) {
            if (this.enableColletingVotes) {
                this.electionVotes.addElement(electionNotification);
                this.electionVotes.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearElectionVoteBuffer() {
        Vector vector = this.electionVotes;
        synchronized (vector) {
            this.electionVotes.clear();
        }
    }

    void toEnableCollectingVotes(boolean bl) {
        this.enableColletingVotes = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ElectionNotification getACoordinatorVote() {
        ElectionNotification electionNotification = null;
        Vector vector = this.electionVotes;
        synchronized (vector) {
            try {
                this.electionVotes.wait(this.s_config.getMulticastInterval());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.electionVotes.size() > 0) {
                Object e = this.electionVotes.firstElement();
                if (e != null && e instanceof ElectionNotification) {
                    electionNotification = (ElectionNotification)e;
                }
                this.electionVotes.removeElementAt(0);
            }
        }
        return electionNotification;
    }

    ThreadGroup getRTG() {
        return this.tg;
    }

    void resetCleanInterval(int n) {
        if (n <= 1) {
            return;
        }
        this.clean_interval_ = Math.round(4096 / (n - 1)) * 1024;
    }

    boolean getTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setGUid(long l) {
        byte[] byArray = this.guid_lock;
        synchronized (this.guid_lock) {
            this.g_uid = l;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getGUid() {
        byte[] byArray = this.guid_lock;
        synchronized (this.guid_lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.g_uid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incGUid() {
        byte[] byArray = this.guid_lock;
        synchronized (this.guid_lock) {
            ++this.g_uid;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getSequencer() {
        byte[] byArray = this.seq_lock;
        synchronized (this.seq_lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.sequencer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSequencer(long l) {
        byte[] byArray = this.seq_lock;
        synchronized (this.seq_lock) {
            this.sequencer = l;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long incSequencer() {
        byte[] byArray = this.seq_lock;
        synchronized (this.seq_lock) {
            ++this.sequencer;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.sequencer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    long getPacketSerial(int n) {
        long l = 0L;
        if ((n & 1) != 0) {
            byte[] byArray = this.c_lock;
            synchronized (this.c_lock) {
                ++this.counter;
                return this.counter;
            }
        }
        if ((n & 2) == 0) return 0L;
        byte[] byArray = this.to_lock;
        synchronized (this.to_lock) {
            --this.to_counter;
            return this.to_counter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getReceivedTONumber() {
        byte[] byArray = this.ton_lock;
        synchronized (this.ton_lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.receivedTONumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setReceivedTONumber(long l) {
        byte[] byArray = this.ton_lock;
        synchronized (this.ton_lock) {
            this.receivedTONumber = l;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    Object getCoordinatorLock() {
        return this.coordinator_lock;
    }

    Object getMemberLock() {
        return this.member_lock;
    }

    Object getTotalLock() {
        return this.total_lock;
    }

    long getRecentReadOf(Address address) {
        EndPoint endPoint;
        long l = 0L;
        if (this.endPointList != null && (endPoint = (EndPoint)this.endPointList.get(address)) != null && endPoint.handler != null) {
            l = endPoint.handler.getRecentReadCounter();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetRecentCounter() {
        if (this.endPointList == null) {
            return;
        }
        Hashtable hashtable = this.endPointList;
        synchronized (hashtable) {
            Vector vector = new Vector(this.endPointList.values());
            for (int i = 0; i < vector.size(); ++i) {
                EndPoint endPoint = (EndPoint)vector.elementAt(i);
                if (endPoint == null || endPoint.handler == null) continue;
                endPoint.handler.resetRecentReadCounter();
            }
        }
    }

    void resetRecentCounter(Address address) {
        EndPoint endPoint;
        if (this.endPointList != null && (endPoint = (EndPoint)this.endPointList.get(address)) != null && endPoint.handler != null) {
            endPoint.handler.resetRecentReadCounter();
        }
    }

    long getJoinGroupAllowance() {
        GrpConfig grpConfig = (GrpConfig)this.gcomm_.getGroupConfig();
        long l = grpConfig.getResolutionTimeout() + (long)(this.s_timeout * 4);
        return l;
    }

    long getViewUpdateAllowance() {
        GrpConfig grpConfig = (GrpConfig)this.gcomm_.getGroupConfig();
        long l = grpConfig.getResolutionTimeout() + (long)(this.s_timeout * 2);
        return l;
    }

    synchronized void decNumberOfClosingReceiver() {
        --this.numOfClosingReceivers_;
    }

    synchronized void incNumberOfClosingReceiver() {
        ++this.numOfClosingReceivers_;
    }

    int getNumberOfClosingReceivers() {
        return this.numOfClosingReceivers_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateDiscoveryList(Address address) {
        GroupConfig groupConfig = this.s_config;
        synchronized (groupConfig) {
            Vector vector = this.s_config.getListenerList();
            if (!vector.contains(address)) {
                vector.addElement(address);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void waitForSender() {
        try {
            while (this.isReady() && this.sender != null && this.sender.isBusy() && this.sender.isAlive()) {
                Sender sender = this.sender;
                synchronized (sender) {
                    this.sender.wait(50L);
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetRegistrationStatus() {
        byte[] byArray = this.registrationLock_;
        synchronized (this.registrationLock_) {
            this.registrationCompleted_ = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyRegistrationIsCompleted() {
        byte[] byArray = this.registrationLock_;
        synchronized (this.registrationLock_) {
            this.registrationCompleted_ = true;
            this.registrationLock_.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForRegister() {
        try {
            byte[] byArray = this.registrationLock_;
            synchronized (this.registrationLock_) {
                while (!this.registrationCompleted_ && !this.isReady()) {
                    this.registrationLock_.wait(100L);
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        {
            return;
        }
    }

    boolean getRegistrationStatus() {
        return this.registrationStatus_;
    }

    void setCoordinatorBeginTime(long l) {
        this.coordStartTime_ = l;
    }

    long[][] getIOCounters(boolean bl) {
        return this.counters;
    }
}

