/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.HttpHandler;
import oracle.ias.cache.group.HttpPacket;
import oracle.ias.cache.group.Packet;

class StreamHandler {
    private Socket m_s;
    private int m_mode;
    private ObjectInputStream m_ois;
    private ObjectOutputStream m_oos;
    private BufferedOutputStream m_bos;
    private BufferedInputStream m_bis;
    private HttpHandler m_http_handler;
    private transient GrpCommunication gcomm_;

    StreamHandler(GrpCommunication grpCommunication, Socket socket) throws GroupException, IOException {
        this.gcomm_ = grpCommunication;
        this.m_mode = this.gcomm_.getGroupConfig().getMode();
        if (socket == null) {
            throw new GroupException(GrpCommunication.EXP_GRP_SOCKETINITFAIL);
        }
        this.m_s = socket;
        if (this.m_mode == 0) {
            this.m_oos = new ObjectOutputStream(this.m_s.getOutputStream());
            this.m_ois = new ObjectInputStream(this.m_s.getInputStream());
        } else if (this.m_mode == 1) {
            int n = socket.getReceiveBufferSize();
            int n2 = socket.getSendBufferSize();
            this.m_http_handler = new HttpHandler(this.gcomm_, this.m_s.getInputStream(), this.m_s.getOutputStream(), n, n2);
        }
    }

    void write(Packet packet) throws IOException, GroupException {
        if (this.m_mode == 0) {
            this.m_oos.writeObject(packet);
            this.m_oos.flush();
        } else if (this.m_mode == 1) {
            HttpPacket httpPacket = new HttpPacket(this.gcomm_, packet);
            this.m_http_handler.write(httpPacket);
        }
    }

    Packet read() throws IOException, GroupException {
        Packet packet = null;
        try {
            if (this.m_mode == 0) {
                packet = (Packet)this.m_ois.readObject();
            } else if (this.m_mode == 1) {
                packet = this.m_http_handler.read();
            }
        }
        catch (Exception exception) {
            throw new GroupException(exception.getMessage(), exception);
        }
        return packet;
    }

    void reset() throws IOException {
        if (this.m_mode == 0) {
            this.m_oos.reset();
        } else if (this.m_mode == 1) {
            // empty if block
        }
    }

    void close() throws IOException {
        if (this.m_mode == 0) {
            this.m_oos.close();
            this.m_ois.close();
        } else {
            this.m_bos.close();
            this.m_bis.close();
        }
    }
}

