/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.Serializable;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.ElectionNotification;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.StreamHandler;
import oracle.ias.cache.group.Transport;

class NodeListenerHandler
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.group.NodeListenerHandler";
    private Socket s_;
    private GrpCommunication gcomm_;
    private Transport trans_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.NodeListenerHandler");

    NodeListenerHandler(GrpCommunication grpCommunication, Transport transport, Socket socket) {
        this.s_ = socket;
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.setDaemon(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        block15: {
            Packet packet = null;
            Packet packet2 = null;
            this.setName("Node Listener Handler for socket: " + this.s_);
            this.s_.setSoLinger(true, 1);
            StreamHandler streamHandler = new StreamHandler(this.gcomm_, this.s_);
            packet = streamHandler.read();
            if (packet.type == 1) {
                packet2 = new Packet(2, 0, this.trans_.getLocalAddress(), packet.source, this.trans_.getFailureDetector().getCoordinator(), 0L);
                streamHandler.write(packet2);
                Serializable serializable = packet.getMessage();
                if (serializable != null && serializable instanceof Address) {
                    Address address = (Address)packet.getMessage();
                    this.trans_.updateDiscoveryList(address);
                }
                break block15;
            }
            if (packet.type == 18) {
                Serializable serializable = packet.getMessage();
                ElectionNotification electionNotification = null;
                if (serializable != null && serializable instanceof ElectionNotification) {
                    this.trans_.addElectionVote((ElectionNotification)serializable);
                }
                if (this.trans_.isMyself(this.trans_.getFailureDetector().getCoordinator())) {
                    ElectionNotification electionNotification2;
                    electionNotification = electionNotification2 = new ElectionNotification(this.trans_.getFailureDetector().getCoordinator(), true);
                }
                packet2 = new Packet(18, 0, this.trans_.getLocalAddress(), packet.source, electionNotification, 0L);
                streamHandler.write(packet2);
                break block15;
            }
            if (packet.type == 23) {
                packet2 = new Packet(23, 0, this.trans_.getLocalAddress(), packet.source, this.trans_.getLocalAddress(), 0L);
                streamHandler.write(packet2);
                this.trans_.stopNodeListener();
                break block15;
            }
            if (!this.logger_.isLoggable(Level.WARNING)) break block15;
            this.logger_.log(Level.WARNING, "Invalid Packet Type: " + packet.type);
        }
        Object var8_10 = null;
        if (this.s_ == null) return;
        try {
            this.s_.close();
            return;
        }
        catch (Exception exception) {}
        return;
        {
            catch (Exception exception) {
                if (this.logger_.isLoggable(Level.FINE)) {
                    this.logger_.log(Level.FINE, "NodeListenerHandler exception.", exception);
                }
                Object var8_11 = null;
                if (this.s_ == null) return;
                try {
                    this.s_.close();
                    return;
                }
                catch (Exception exception2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            if (this.s_ == null) throw throwable;
            try {
                this.s_.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

