/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.MessageQueue;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.EndPoint;
import oracle.ias.cache.group.FlushInfo;
import oracle.ias.cache.group.GroupMessage;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.MsgInfo;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.RWLock;
import oracle.ias.cache.group.Receiver;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;
import oracle.ias.cache.group.ViewChange;
import oracle.ias.cache.group.ViewInfo;

class GroupManager {
    static final String LOGGER_NAME = "oracle.ias.cache.group.GroupManager";
    static final String SYSTEM_GROUP = new String("SYSTEM_GROUP");
    private byte[] flush_lock;
    private RWLock curview_lock;
    private RWLock latestview_lock;
    private RWLock deliver_lock;
    private BitSet flushedFlags;
    private Vector flushInfoVector;
    private int flushcounter = 0;
    private int viewCounter = 0;
    private Hashtable unDeliverableViewInfo;
    private final int RETRY = 3;
    private boolean initializing = true;
    private GrpCommunication gcomm_;
    private Transport trans_;
    private ViewInfo latestViewInfo;
    private ViewInfo curViewInfo;
    private Logger logger_;
    private Hashtable sysMsgList_;

    GroupManager(GrpCommunication grpCommunication, Transport transport) {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.latestViewInfo = new ViewInfo(this.gcomm_, this.trans_, -1);
        this.curViewInfo = new ViewInfo(this.gcomm_, this.trans_, -1);
        this.flush_lock = new byte[0];
        this.curview_lock = new RWLock();
        this.latestview_lock = new RWLock();
        this.deliver_lock = new RWLock();
        this.unDeliverableViewInfo = new Hashtable();
        this.logger_ = Logger.getLogger(LOGGER_NAME);
        this.sysMsgList_ = new Hashtable();
    }

    void term() {
        this.viewCounter = 0;
        this.latestViewInfo = new ViewInfo(this.gcomm_, this.trans_, -1);
        this.curViewInfo = new ViewInfo(this.gcomm_, this.trans_, -1);
        this.initializing = true;
        this.flushcounter = 0;
        this.sysMsgList_ = new Hashtable();
    }

    void dump() {
        this.logger_.log(Level.SEVERE, "------Begin Dumping GroupManager ------");
        this.logger_.log(Level.SEVERE, "Current View Info:" + this.curViewInfo);
        this.logger_.log(Level.SEVERE, "Latest View Info:" + this.latestViewInfo);
        this.logger_.log(Level.SEVERE, "current view lock: " + this.curview_lock);
        this.logger_.log(Level.SEVERE, "latest view lock: " + this.latestview_lock);
        this.logger_.log(Level.SEVERE, "deliver lock: " + this.deliver_lock);
        this.logger_.log(Level.SEVERE, "viewCounter=" + this.viewCounter);
        this.logger_.log(Level.SEVERE, "------End Dumping GroupManager ------");
    }

    void createGroup(String string) {
    }

    void joinGroup(String string, Packet packet) throws GroupException, IOException, InterruptedException {
        Packet packet2 = null;
        View view = this.newView(SYSTEM_GROUP, (Address)packet.getSourceAddress(), true);
        if (view != null) {
            packet2 = new Packet(4, 0, this.trans_.getLocalAddress(), (Serializable)((Object)SYSTEM_GROUP), view, 0L);
            this.curview_lock.acquireReadLock();
            MessageBuffer messageBuffer = this.curViewInfo.getMessageBuffer();
            this.curview_lock.releaseReadLock();
            packet2.setReceiveArray(messageBuffer.getReceiveVector());
            packet2.setUnDeliverableMsgList(this.getUnDeliverableMsgInfo());
            packet2.setReceivedTONumber(this.trans_.getReceivedTONumber());
            messageBuffer.setUpdated(false);
            this.trans_.multicast(packet2);
        } else {
            packet2 = new Packet(21, 0, this.trans_.ssep.addr, packet.source, null, 0L);
            this.trans_.send(packet2);
        }
    }

    synchronized void leaveGroup(String string, Address address) throws GroupException, IOException, InterruptedException {
        Packet packet = null;
        View view = null;
        View view2 = null;
        boolean bl = false;
        boolean bl2 = false;
        this.latestview_lock.acquireReadLock();
        view = this.latestViewInfo.getView();
        this.latestview_lock.releaseReadLock();
        Vector vector = view.getMembers();
        if (!vector.contains(address)) {
            return;
        }
        if (this.trans_.isMyself(this.trans_.getFailureDetector().getCoordinator())) {
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, "Removing member:" + address + ", from view:" + view.getVid());
            }
            this.trans_.removeAddress(address);
            view2 = this.newView(SYSTEM_GROUP, address, false);
            Hashtable hashtable = this.trans_.getEndPointList();
            if (view2.size() == 1 || hashtable != null && hashtable.size() == 0) {
                this.updateView(SYSTEM_GROUP);
            } else {
                packet = new Packet(4, 0, this.trans_.getLocalAddress(), (Serializable)((Object)SYSTEM_GROUP), view2, 0L);
                this.curview_lock.acquireReadLock();
                MessageBuffer messageBuffer = this.curViewInfo.getMessageBuffer();
                this.curview_lock.releaseReadLock();
                packet.setReceiveArray(messageBuffer.getReceiveVector());
                packet.setUnDeliverableMsgList(this.trans_.getGroupManager().getUnDeliverableMsgInfo());
                packet.setReceivedTONumber(this.trans_.getReceivedTONumber());
                messageBuffer.setUpdated(false);
            }
        }
        if (packet != null) {
            this.trans_.multicast(packet);
        }
    }

    void destroyGroup(String string) {
    }

    RWLock getCurrentViewInfoRWLock(String string) {
        return this.curview_lock;
    }

    RWLock getLatestViewInfoRWLock(String string) {
        return this.latestview_lock;
    }

    RWLock getDeliverRWLock(String string) {
        return this.deliver_lock;
    }

    ViewInfo getCurrentViewInfo(String string) {
        return this.curViewInfo;
    }

    ViewInfo getLatestViewInfo(String string) {
        return this.latestViewInfo;
    }

    void initView(View view) {
        Vector vector = null;
        if (view == null) {
            ++this.viewCounter;
            View view2 = new View(this.viewCounter, 0, this.trans_.getAddrList());
            this.latestViewInfo = this.curViewInfo = new ViewInfo(this.gcomm_, this.trans_, view2);
            vector = view2.getMembers();
        } else {
            this.latestViewInfo = this.curViewInfo = new ViewInfo(this.gcomm_, this.trans_, view);
            this.viewCounter = view.getVid();
            vector = view.getMembers();
        }
        if (vector != null) {
            this.trans_.resetCleanInterval(vector.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setView(View view) throws InterruptedException {
        Vector vector;
        block10: {
            this.latestview_lock.acquireWriteLock();
            try {
                this.latestViewInfo = new ViewInfo(this.gcomm_, this.trans_, view);
                this.unDeliverableViewInfo.put(new Integer(view.getVid()), this.latestViewInfo);
            }
            catch (Exception exception) {
                if (this.logger_.isLoggable(Level.SEVERE)) {
                    this.logger_.log(Level.SEVERE, "Unable to set view: ", exception);
                }
            }
            finally {
                this.latestview_lock.releaseWriteLock();
            }
            try {
                this.updateView(SYSTEM_GROUP);
            }
            catch (GroupException groupException) {
                if (!this.logger_.isLoggable(Level.FINEST)) break block10;
                this.logger_.log(Level.FINEST, "Ignore updateView error", groupException);
            }
        }
        this.viewCounter = view.getVid();
        if (view != null && (vector = view.getMembers()) != null) {
            this.trans_.resetCleanInterval(vector.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateView(String string) throws GroupException, InterruptedException {
        Object object;
        Vector vector = new Vector();
        boolean bl = false;
        if (this.unDeliverableViewInfo.size() == 0) {
            this.curViewInfo = this.latestViewInfo;
        } else {
            while (this.unDeliverableViewInfo.size() > 0) {
                block25: {
                    int n = this.curViewInfo.getView().getVid();
                    ViewInfo viewInfo = this.curViewInfo;
                    object = this.trans_.getGroupManager().getOldestViewIdFrom(this.unDeliverableViewInfo);
                    if (object == null) break;
                    if (n + 1 > (Integer)object) {
                        this.unDeliverableViewInfo.remove(object);
                        continue;
                    }
                    ViewInfo viewInfo2 = (ViewInfo)this.unDeliverableViewInfo.remove(object);
                    if (viewInfo2 == null || viewInfo2.getView() == null) {
                        if (!this.logger_.isLoggable(Level.FINEST)) break;
                        this.logger_.log(Level.FINEST, "Got an empty newViewInfo from unDeliverableViewInfo for vid:" + n);
                        this.logger_.log(Level.FINEST, "unDeliverableViewInfo size: " + this.unDeliverableViewInfo.size() + ", keys: " + this.unDeliverableViewInfo.keys());
                        break;
                    }
                    this.curview_lock.acquireWriteLock();
                    try {
                        this.curViewInfo = viewInfo2;
                        MessageBuffer messageBuffer = this.curViewInfo.getMessageBuffer();
                        MessageBuffer messageBuffer2 = viewInfo.getMessageBuffer();
                        messageBuffer.initDeliveredVector(messageBuffer2.getDeliveredVector());
                    }
                    finally {
                        this.curview_lock.releaseWriteLock();
                    }
                    if (this.unDeliverableViewInfo.size() == 0) {
                        bl = true;
                    }
                    if (this.curViewInfo == null) {
                        throw new GroupException(GrpCommunication.EXP_GRP_INTERNAL + GrpCommunication.EXP_GRP_VIEWINFOEMPTY);
                    }
                    try {
                        if (viewInfo == null) {
                            this.viewChanged(null, this.curViewInfo.getView());
                        } else {
                            this.viewChanged(viewInfo.getView(), this.curViewInfo.getView());
                        }
                    }
                    catch (Exception exception) {
                        if (this.logger_.isLoggable(Level.SEVERE)) {
                            this.logger_.log(Level.SEVERE, "viewChanged callback exception: ", exception);
                        }
                    }
                    catch (Error error) {
                        if (!this.logger_.isLoggable(Level.SEVERE)) break block25;
                        this.logger_.log(Level.SEVERE, "viewChanged callback error: ", error);
                    }
                }
                this.deliver_lock.acquireWriteLock();
                try {
                    MessageBuffer messageBuffer = this.curViewInfo.getMessageBuffer();
                    Vector vector2 = messageBuffer.getUnDeliverableMsgs();
                    if (vector2 == null) continue;
                    ListIterator listIterator = vector2.listIterator();
                    while (listIterator.hasNext()) {
                        Packet packet = (Packet)listIterator.next();
                        listIterator.remove();
                        if (bl && packet.isAtomic()) {
                            messageBuffer.save(packet);
                        }
                        Receiver.deliver(this.gcomm_, this.trans_, packet, messageBuffer);
                    }
                }
                finally {
                    this.deliver_lock.releaseWriteLock();
                }
            }
        }
        object = this.flush_lock;
        synchronized (this.flush_lock) {
            View view = this.curViewInfo.getView();
            this.flushedFlags = new BitSet(view.size());
            this.flushInfoVector = new Vector(view.size());
            // ** MonitorExit[var13_13] (shouldn't be in output)
            return;
        }
    }

    View currentAddrList(String string) {
        int n = this.viewCounter + 1;
        View view = new View(n, 0, this.trans_.getAddrList());
        if (this.trans_.getTerminated()) {
            return null;
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    View newView(String string, Address address, boolean bl) throws InterruptedException, GroupException {
        ++this.viewCounter;
        this.latestview_lock.acquireReadLock();
        View view = this.latestViewInfo.getView();
        this.latestview_lock.releaseReadLock();
        if (view == null) {
            return null;
        }
        Vector<Address> vector = new Vector<Address>(view.getMembers());
        if (bl) {
            vector.add(address);
        } else {
            vector.remove(address);
        }
        int n = this.trans_.getLocalAddress().getPosition();
        if (n < 0) {
            n = 0;
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Forcing coordinator ID to 0");
            }
        }
        view = new View(this.viewCounter, n, vector);
        ViewInfo viewInfo = (ViewInfo)this.unDeliverableViewInfo.get(new Integer(this.viewCounter));
        if (viewInfo != null) {
            viewInfo.init(view);
        } else {
            viewInfo = new ViewInfo(this.gcomm_, this.trans_, view);
            this.unDeliverableViewInfo.put(new Integer(this.viewCounter), viewInfo);
        }
        this.latestview_lock.acquireWriteLock();
        this.latestViewInfo = viewInfo;
        this.latestview_lock.releaseWriteLock();
        this.updateView(SYSTEM_GROUP);
        byte[] byArray = this.flush_lock;
        synchronized (this.flush_lock) {
            this.flushedFlags.set(0);
            // ** MonitorExit[var9_8] (shouldn't be in output)
            return viewInfo.getView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ViewInfo getViewInfo(String string, int n) throws GroupException, InterruptedException {
        ViewInfo viewInfo = null;
        int n2 = -1;
        this.curview_lock.acquireReadLock();
        View view = this.curViewInfo.getView();
        if (view != null && n == view.getVid()) {
            viewInfo = this.curViewInfo;
        }
        this.curview_lock.releaseReadLock();
        if (viewInfo == null) {
            ViewInfo viewInfo2 = (ViewInfo)this.unDeliverableViewInfo.get(new Integer(n));
            if (viewInfo2 != null) {
                viewInfo = viewInfo2;
            } else {
                this.latestview_lock.acquireReadLock();
                try {
                    View view2 = this.latestViewInfo.getView();
                    if (view2 == null) {
                        ViewInfo viewInfo3 = viewInfo;
                        return viewInfo3;
                    }
                    n2 = view2.getVid();
                }
                finally {
                    this.latestview_lock.releaseReadLock();
                }
                if (n > n2) {
                    viewInfo2 = new ViewInfo(this.gcomm_, this.trans_, n);
                    this.unDeliverableViewInfo.put(new Integer(n), viewInfo2);
                    viewInfo = viewInfo2;
                }
            }
        }
        return viewInfo;
    }

    void viewChanged(View view, View view2) {
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Deliver view change. oldView:" + view + ", newView:" + view2);
        }
        if (this.logger_.isLoggable(Level.INFO) && view != null && view2 != null) {
            this.logger_.log(Level.INFO, "Deliver view change. old:" + view.getVid() + ", new:" + view2.getVid());
        }
        Enumeration enumeration = this.trans_.receivingQList.elements();
        while (enumeration.hasMoreElements()) {
            MessageQueue messageQueue = (MessageQueue)enumeration.nextElement();
            messageQueue.enqueue(new GroupMessage(1, new ViewChange(view, view2)), this.trans_.ctx);
        }
    }

    Vector getUnDeliverableMsgInfo() throws InterruptedException {
        Packet packet;
        this.curview_lock.acquireReadLock();
        MessageBuffer messageBuffer = this.curViewInfo.getMessageBuffer();
        this.curview_lock.releaseReadLock();
        Vector<MsgInfo> vector = new Vector<MsgInfo>();
        Vector vector2 = messageBuffer.getUnDeliverableMsgs();
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            packet = (Packet)enumeration.nextElement();
            if (!packet.isAtomic()) continue;
            vector.add(new MsgInfo(packet.getVid(), packet.getSenderIndex(), packet.getSerialNumber()));
        }
        Enumeration enumeration2 = this.unDeliverableViewInfo.elements();
        while (enumeration2.hasMoreElements()) {
            ViewInfo viewInfo = (ViewInfo)enumeration2.nextElement();
            vector2 = viewInfo.getMessageBuffer().getUnDeliverableMsgs();
            enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                packet = (Packet)enumeration.nextElement();
                if (!packet.isAtomic()) continue;
                vector.add(new MsgInfo(packet.getVid(), packet.getSenderIndex(), packet.getSerialNumber()));
            }
        }
        return vector;
    }

    Vector getUnDeliverableMsgList() throws InterruptedException {
        this.curview_lock.acquireReadLock();
        MessageBuffer messageBuffer = this.curViewInfo.getMessageBuffer();
        this.curview_lock.releaseReadLock();
        Vector vector = new Vector();
        vector.addAll(messageBuffer.getUnDeliverableMsgs());
        Enumeration enumeration = this.unDeliverableViewInfo.elements();
        while (enumeration.hasMoreElements()) {
            ViewInfo viewInfo = (ViewInfo)enumeration.nextElement();
            Vector vector2 = viewInfo.getMessageBuffer().getUnDeliverableMsgs();
            vector.addAll(vector2);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitSet getFlushedFlags() {
        byte[] byArray = this.flush_lock;
        synchronized (this.flush_lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.flushedFlags;
        }
    }

    void flush(Packet packet) throws GroupException, IOException, InterruptedException {
        block7: {
            Packet packet2;
            Packet packet3;
            long[] lArray = (long[])packet.getReceiptTracker();
            long l = packet.getReceivedTONumber();
            if (this.initializing) {
                this.initializing = false;
                Packet packet4 = new Packet(15, 0, this.trans_.getLocalAddress(), this.trans_.getFailureDetector().getCoordinator(), null, 0L);
                this.trans_.send(packet4);
                return;
            }
            this.curview_lock.acquireReadLock();
            MessageBuffer messageBuffer = this.curViewInfo.getMessageBuffer();
            View view = this.curViewInfo.getView();
            this.curview_lock.releaseReadLock();
            Address address = this.trans_.getFailureDetector().getCoordinator();
            ListIterator listIterator = messageBuffer.getUnstableMsgs();
            while (listIterator.hasNext()) {
                packet3 = (Packet)listIterator.next();
                if (lArray != null && lArray.length > packet3.getSenderIndex() && packet3.getSerialNumber() <= lArray[packet3.getSenderIndex()] || address.equals((Address)packet3.getSourceAddress())) continue;
                packet2 = new Packet(13, 0, this.trans_.getLocalAddress(), address, packet3, 0L);
                this.trans_.send(packet2);
            }
            listIterator = messageBuffer.getTotalOrderedMsgList().listIterator();
            while (listIterator.hasNext()) {
                packet3 = (Packet)listIterator.next();
                if (packet3.getSequenceNumber() <= l || address.equals((Address)packet3.getSourceAddress())) continue;
                packet2 = new Packet(13, 0, this.trans_.getLocalAddress(), address, packet3, 0L);
                this.trans_.send(packet2);
            }
            Vector vector = packet.getUnDeliverableMsgList();
            Enumeration enumeration = this.unDeliverableViewInfo.elements();
            while (enumeration.hasMoreElements()) {
                ViewInfo viewInfo = (ViewInfo)enumeration.nextElement();
                Vector vector2 = viewInfo.getMessageBuffer().getUnDeliverableMsgs();
                Enumeration enumeration2 = vector2.elements();
                while (enumeration2.hasMoreElements()) {
                    MsgInfo msgInfo;
                    packet3 = (Packet)enumeration2.nextElement();
                    if (!packet3.isAtomic() || vector.contains(msgInfo = new MsgInfo(packet.getVid(), packet.getSenderIndex(), packet.getSerialNumber())) || address.equals((Address)packet3.getSourceAddress())) continue;
                    packet2 = new Packet(13, 0, this.trans_.getLocalAddress(), this.trans_.getFailureDetector().getCoordinator(), packet3, 0L);
                    this.trans_.send(packet2);
                }
            }
            packet2 = new Packet(15, 0, this.trans_.getLocalAddress(), this.trans_.getFailureDetector().getCoordinator(), null, 0L);
            packet2.setReceiveArray(messageBuffer.getReceiveVector());
            packet2.setUnDeliverableMsgList(this.getUnDeliverableMsgInfo());
            packet2.setReceivedTONumber(this.trans_.getReceivedTONumber());
            try {
                this.trans_.send(packet2);
            }
            catch (Exception exception) {
                if (!this.logger_.isLoggable(Level.WARNING) || !this.gcomm_.isReady()) break block7;
                this.logger_.log(Level.WARNING, "Warning: Can't send a FLUSH message.", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endFlush(Receiver receiver, Packet packet) throws GroupException, IOException, InterruptedException {
        Vector vector = null;
        Vector vector2 = null;
        Vector vector3 = new Vector();
        long l = -1L;
        Vector<Packet> vector4 = new Vector<Packet>();
        BitSet bitSet = null;
        Object object = this.flush_lock;
        synchronized (this.flush_lock) {
            Serializable serializable;
            bitSet = this.flushedFlags;
            if (this.flushedFlags != null) {
                this.flushedFlags.set(packet.getSenderIndex());
                serializable = new FlushInfo((Address)packet.getSourceAddress(), packet.getReceiveVector(), packet.getUnDeliverableMsgList(), packet.getReceivedTONumber());
                this.flushInfoVector.add(serializable);
            } else if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Internal Error: flushedFlags is null.");
            }
            // ** MonitorExit[var16_9] (shouldn't be in output)
            this.latestview_lock.acquireReadLock();
            try {
                object = this.latestViewInfo.getView();
                if (object == null) {
                    return;
                }
                serializable = ((View)object).getMembers();
                for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                    if (bitSet != null && bitSet.get(i)) continue;
                    return;
                }
            }
            finally {
                this.latestview_lock.releaseReadLock();
            }
            this.curview_lock.acquireReadLock();
            View view = this.curViewInfo.getView();
            MessageBuffer messageBuffer = this.curViewInfo.getMessageBuffer();
            this.curview_lock.releaseReadLock();
            object = this.flushInfoVector.listIterator();
            serializable = messageBuffer.getUnStableMsgMatrix();
            Vector vector5 = this.getUnDeliverableMsgList();
            Vector vector6 = messageBuffer.getTotalOrderedMsgList();
            while (object.hasNext()) {
                Enumeration enumeration;
                Packet packet2;
                FlushInfo flushInfo = (FlushInfo)object.next();
                if (flushInfo != null) {
                    vector = flushInfo.receiveVector;
                    vector2 = flushInfo.unDeliverableVector;
                    l = flushInfo.totalOrderedMsgNumber;
                }
                int n = view.getMembers().indexOf(flushInfo.source);
                if (vector != null && serializable != null) {
                    for (int i = 0; i < vector.size() && i < ((Serializable)serializable).length; ++i) {
                        Serializable serializable2 = serializable[i];
                        synchronized (serializable2) {
                            ListIterator listIterator = serializable[i].listIterator();
                            while (listIterator.hasNext() && i != n) {
                                Packet packet3 = (Packet)listIterator.next();
                                if ((Long)vector.elementAt(i) >= packet3.getSerialNumber()) continue;
                                packet2 = new Packet(14, 0, this.trans_.getLocalAddress(), flushInfo.source, packet3, 0L);
                                try {
                                    this.trans_.send(packet2);
                                }
                                catch (Exception exception) {}
                            }
                            continue;
                        }
                    }
                    enumeration = vector6.elements();
                    while (enumeration.hasMoreElements()) {
                        packet2 = (Packet)enumeration.nextElement();
                        if (packet2.getSequenceNumber() <= l) continue;
                        packet2 = new Packet(14, 0, this.trans_.getLocalAddress(), flushInfo.source, packet2, 0L);
                        try {
                            this.trans_.send(packet2);
                        }
                        catch (Exception exception) {}
                    }
                }
                enumeration = vector5.elements();
                while (enumeration.hasMoreElements()) {
                    packet2 = (Packet)enumeration.nextElement();
                    if (!packet2.isAtomic()) continue;
                    MsgInfo msgInfo = new MsgInfo(packet2.getVid(), packet2.getSenderIndex(), packet2.getSerialNumber());
                    if (vector2 == null || packet2 == null || vector2.contains(msgInfo) || packet2.getSenderIndex() == n) continue;
                    packet2 = new Packet(14, 0, this.trans_.getLocalAddress(), flushInfo.source, packet2, 0L);
                    try {
                        this.trans_.send(packet2);
                    }
                    catch (Exception exception) {}
                }
                if (n == 0) continue;
                packet2 = new Packet(16, 0, this.trans_.getLocalAddress(), flushInfo.source, null, 0L);
                packet2.setReceiveArray(messageBuffer.getReceiveVector());
                packet2.setReceivedTONumber(this.trans_.getReceivedTONumber());
                vector4.addElement(packet2);
            }
            this.updateView(SYSTEM_GROUP);
            for (int i = 0; i < vector4.size(); ++i) {
                Packet packet4 = null;
                try {
                    packet4 = (Packet)vector4.elementAt(i);
                    this.trans_.send(packet4);
                    continue;
                }
                catch (Exception exception) {
                    if (!this.logger_.isLoggable(Level.FINE)) continue;
                    this.logger_.log(Level.FINE, "Unable to send " + packet4 + ". " + exception.getMessage());
                }
            }
            return;
        }
    }

    void releaseCurrentViewLock(String string, boolean bl) {
        block4: {
            try {
                if (bl) {
                    this.getCurrentViewInfoRWLock(string).releaseReadLock();
                } else {
                    this.getCurrentViewInfoRWLock(string).releaseWriteLock();
                }
            }
            catch (Exception exception) {
                if (!this.logger_.isLoggable(Level.FINE)) break block4;
                this.logger_.log(Level.FINE, "Unable to release view lock: ", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Integer getOldestViewIdFrom(Hashtable hashtable) {
        Integer n = null;
        if (hashtable != null) {
            Hashtable hashtable2 = hashtable;
            synchronized (hashtable2) {
                if (hashtable.size() > 0) {
                    Set set = hashtable.keySet();
                    TreeSet treeSet = new TreeSet(set);
                    n = (Integer)treeSet.first();
                }
            }
        }
        return n;
    }

    void addToSysMsgList(EndPoint endPoint) {
        this.sysMsgList_.put(endPoint, endPoint);
    }

    void removeFromSysMsgList(EndPoint endPoint) {
        this.sysMsgList_.remove(endPoint);
    }

    boolean shouldProcess(EndPoint endPoint) {
        return this.sysMsgList_.isEmpty() || this.sysMsgList_.containsKey(endPoint);
    }
}

