/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.Packet;
import oracle.ias.cache.group.Receiver;
import oracle.ias.cache.group.StreamHandler;

class EndPoint {
    static final String LOGGER_NAME = "oracle.ias.cache.group.EndPoint";
    static final int SEND_COUNTER_TYPE = 0;
    static final int RECV_COUNTER_TYPE = 1;
    static final int TOTAL_COUNTER_TYPES = 2;
    Address addr;
    Socket s;
    Receiver handler;
    byte[] lock;
    long counter;
    StreamHandler m_sh;
    private GrpCommunication gcomm_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.EndPoint");
    private boolean closed_;
    long[][] ioStat_ = new long[2][25];

    EndPoint(GrpCommunication grpCommunication, Address address, Socket socket) throws GroupException, IOException {
        this.gcomm_ = grpCommunication;
        this.addr = address;
        this.s = socket;
        this.m_sh = new StreamHandler(this.gcomm_, this.s);
        this.lock = new byte[0];
        this.counter = 0L;
        this.closed_ = false;
    }

    StreamHandler getStreamHandler() {
        return this.m_sh;
    }

    synchronized void write(Packet packet) throws IOException, GroupException {
        this.m_sh.write(packet);
        this.updateIOCounters(0, packet);
    }

    Packet read() throws IOException, GroupException {
        Packet packet = this.m_sh.read();
        this.updateIOCounters(1, packet);
        return packet;
    }

    void reset() throws IOException {
        this.m_sh.reset();
    }

    String getShortName() {
        return new String(this.addr.getIPString() + ":" + this.addr.getPort());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.addr);
        stringBuffer.append(", Socket= ");
        stringBuffer.append(this.s);
        if (this.closed_) {
            stringBuffer.append(", closed");
        }
        return stringBuffer.toString();
    }

    boolean isClosed() {
        return this.closed_;
    }

    void close() {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean bl) {
        try {
            if (!bl && this.handler != null) {
                this.handler.stopit();
            }
            this.s.close();
            this.m_sh.close();
            this.handler.join();
        }
        catch (Exception exception) {
        }
        finally {
            this.closed_ = true;
        }
    }

    public void finalize() {
        this.close();
    }

    void dump() {
        this.logger_.log(Level.SEVERE, "--- EndPoint Dump ---");
        this.logger_.log(Level.SEVERE, this.toString());
    }

    void updateIOCounters(int n, Packet packet) {
        if (packet != null) {
            long[] lArray = this.ioStat_[n];
            int n2 = packet.type;
            lArray[n2] = lArray[n2] + 1L;
            long[] lArray2 = this.gcomm_.getTransport().counters[n];
            int n3 = packet.type;
            lArray2[n3] = lArray2[n3] + 1L;
        }
    }

    void resetIOCounters() {
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 25; ++j) {
                this.ioStat_[i][j] = 0L;
            }
        }
    }

    long[][] getIOCounters() {
        return this.ioStat_;
    }
}

