/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.ias.cache.commx.NetworkAddress;

public class Address
implements Serializable,
Comparable,
NetworkAddress {
    static final long serialVersionUID = 7259713205257648185L;
    InetAddress ip;
    int port;
    private int position;
    private long uid;
    private long timeStamp = 0L;
    private Serializable tag = null;
    private boolean isOriginal_;
    private String cacheName = "";
    private transient int code = 0;
    private String fullyQualifiedHostname;
    private String userDefinedID = null;
    private int priorityOrder = 0;

    public Address(InetAddress inetAddress, int n, boolean bl, int n2, Serializable serializable) {
        this.ip = inetAddress;
        this.port = n;
        this.position = n2;
        this.isOriginal_ = bl;
        this.tag = serializable;
        if (inetAddress != null) {
            this.fullyQualifiedHostname = Address.getFullyQualifiedHostName(inetAddress.getHostAddress());
        }
    }

    public Address(InetAddress inetAddress, int n, boolean bl, int n2, int n3) {
        this.ip = inetAddress;
        this.port = n;
        this.position = n2;
        this.isOriginal_ = bl;
        this.fullyQualifiedHostname = Address.getFullyQualifiedHostName(inetAddress.getHostAddress());
        this.priorityOrder = n3;
    }

    public Address(InetAddress inetAddress, int n, int n2) {
        this.ip = inetAddress;
        this.port = n;
        this.position = n2;
        this.fullyQualifiedHostname = Address.getFullyQualifiedHostName(inetAddress.getHostAddress());
    }

    public Address(InetAddress inetAddress, int n) {
        this.ip = inetAddress;
        this.port = n;
        this.position = -1;
        this.fullyQualifiedHostname = Address.getFullyQualifiedHostName(inetAddress.getHostAddress());
    }

    public Address(InetAddress inetAddress, int n, Serializable serializable) {
        this.ip = inetAddress;
        this.port = n;
        this.tag = serializable;
        this.position = -1;
        this.fullyQualifiedHostname = Address.getFullyQualifiedHostName(inetAddress.getHostAddress());
    }

    public Address(int n) {
        try {
            this.port = n;
            this.ip = InetAddress.getLocalHost();
            this.fullyQualifiedHostname = Address.getFullyQualifiedHostName(this.ip.getHostAddress());
            this.position = -1;
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    void setUid(long l) {
        this.uid = l;
    }

    public long getUid() {
        return this.uid;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long l) {
        this.timeStamp = l;
    }

    public Serializable getTag() {
        return this.tag;
    }

    public boolean isOriginal() {
        return this.isOriginal_;
    }

    public int getPort() {
        return this.port;
    }

    public void setCacheName(String string) {
        this.cacheName = string;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        if (this.ip != null) {
            stringBuffer.append(this.ip.getHostAddress());
        }
        stringBuffer.append(":");
        stringBuffer.append(this.port);
        stringBuffer.append(", pos=");
        stringBuffer.append(this.position);
        if (!bl) {
            stringBuffer.append(", uid=");
            stringBuffer.append(this.uid);
            if (this.tag != null) {
                stringBuffer.append(", tag=");
                stringBuffer.append(this.tag.hashCode());
            }
            if (this.isOriginal_) {
                stringBuffer.append(", orig");
            }
            if (this.cacheName != null) {
                stringBuffer.append(", name=");
                stringBuffer.append(this.cacheName);
            }
            stringBuffer.append(", pri=");
            stringBuffer.append(this.priorityOrder);
        }
        if (this.userDefinedID != null && !this.userDefinedID.equals("")) {
            stringBuffer.append(", def=");
            stringBuffer.append(this.userDefinedID);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getString() {
        return new String(this.getFullyQualifiedHostName() + ":" + this.port);
    }

    public String getIPString() {
        String string = null;
        if (this.ip != null) {
            string = new String(this.ip.getHostAddress());
        }
        return string;
    }

    public String getHostName() {
        return new String(this.ip.getHostName());
    }

    public String getFullyQualifiedHostName() {
        return this.fullyQualifiedHostname;
    }

    private static String getFullyQualifiedHostName(String string) {
        String string2 = null;
        try {
            string2 = InetAddress.getByName(string).getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string2;
    }

    public void setUserDefinedId(String string) {
        this.userDefinedID = string;
    }

    public String getUserDefinedId() {
        return this.userDefinedID;
    }

    public int getPriorityOrder() {
        return this.priorityOrder;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Address address = (Address)object;
        return this.ip.equals(address.ip) && address.port == this.port;
    }

    public boolean equals(InetAddress inetAddress, int n) {
        return this.ip.equals(inetAddress) && n == this.port;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (!this.equals(object)) {
            Address address = (Address)object;
            String string = address.getIPString();
            int n2 = address.port;
            n = this.getIPString().compareTo(string);
            if (n == 0) {
                n = this.port - n2;
            }
        }
        return n;
    }

    public int hashCode() {
        if (this.code == 0) {
            this.code = this.ip.hashCode() + this.port;
        }
        return this.code;
    }

    public Object getMemberID() {
        return this.tag;
    }
}

