/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.IOException;
import java.io.OutputStreamWriter;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.Element;
import oracle.ias.cache.Mdslot;

class SlotTree {
    Element[] tree;
    int[] freeSlots;
    int tstack;
    int treesize;
    int root;
    int prev;
    int allocsize;

    public SlotTree(int n) {
        this.tree = new Element[n];
        this.allocsize = n;
        this.tstack = -1;
        this.treesize = 0;
        this.root = 0;
        this.prev = 0;
    }

    Element findElement(int n, Object object, String string, int n2, boolean bl) {
        Mdslot mdslot = null;
        Object object2 = null;
        String string2 = null;
        int n3 = this.root;
        boolean bl2 = false;
        if (this.root == 0) {
            this.prev = 0;
            return null;
        }
        Element element = this.tree[n3];
        while (n3 != 0) {
            while (n3 != 0 && element.key != n) {
                this.prev = n3;
                n3 = n < element.key ? element.lt : element.gte;
                element = this.tree[n3];
            }
            while (n3 != 0 && element.key == n) {
                mdslot = element.slot;
                object2 = mdslot.name;
                string2 = mdslot.qualifier;
                if (bl == ((mdslot.state & 0x1000000L) != 0L)) {
                    if (n2 == 0 || mdslot.regionNumber == 0) {
                        if (string2.equals(string) && object2.equals(object)) {
                            this.prev = 0;
                            return element;
                        }
                    } else if (mdslot.regionNumber == n2 && object2.equals(object)) {
                        this.prev = 0;
                        return element;
                    }
                }
                this.prev = n3;
                n3 = element.gte;
                element = this.tree[n3];
            }
        }
        return null;
    }

    void insertElement(Element element) {
        int n = element.elid;
        int n2 = element.key;
        if (this.prev != 0) {
            Element element2 = this.tree[this.prev];
            if (element2.key <= n2) {
                element.gte = element2.gte;
                this.tree[element.gte].parent = n;
                element2.gte = n;
            } else {
                element.lt = element2.lt;
                this.tree[element.lt].parent = n;
                element2.lt = n;
            }
        } else {
            this.root = n;
        }
        element.parent = this.prev;
        this.prev = 0;
    }

    void removeElement(int n) {
        Element element = this.tree[n];
        Element element2 = this.tree[element.parent];
        if (element.parent == 0) {
            if (element.lt == 0) {
                this.root = element.gte;
                element2.gte = n;
            } else {
                this.root = element.lt;
                element2.lt = n;
            }
        }
        if (element2.lt == n) {
            if (element.lt != 0) {
                element2.lt = element.lt;
                Element element3 = this.tree[element.lt];
                element3.parent = element.parent;
                if (element.gte != 0) {
                    int n2 = element.gte;
                    int n3 = this.tree[element.gte].lt;
                    while (n3 != 0) {
                        n2 = n3;
                        n3 = this.tree[n3].lt;
                    }
                    Element element4 = this.tree[n2];
                    element4.lt = element3.gte;
                    this.tree[element4.lt].parent = n2;
                    element3.gte = element.gte;
                    this.tree[element.gte].parent = element.lt;
                }
            } else {
                element2.lt = element.gte;
                this.tree[element.gte].parent = element.parent;
            }
        } else if (element2.gte == n) {
            Element element5 = this.tree[element.gte];
            if (element.gte != 0) {
                element2.gte = element.gte;
                element5.parent = element.parent;
                if (element.lt != 0) {
                    int n4 = element.lt;
                    int n5 = this.tree[element.lt].gte;
                    while (n5 != 0) {
                        n4 = n5;
                        n5 = this.tree[n5].gte;
                    }
                    Element element6 = this.tree[n4];
                    element6.gte = this.tree[element.gte].lt;
                    this.tree[element6.gte].parent = n4;
                    this.tree[element.gte].lt = element.lt;
                    this.tree[element.lt].parent = element.gte;
                }
            } else {
                element2.gte = element.lt;
                this.tree[element.lt].parent = element.parent;
            }
        }
        element2 = this.tree[0];
        element2.parent = 0;
        element2.lt = 0;
        element2.gte = 0;
        element.parent = 0;
        element.lt = 0;
        element.gte = 0;
    }

    void freeElement(int n) {
        if (this.tree[n].slot != null) {
            this.tree[n].slot.free();
        }
        this.freeSlots[++this.tstack] = n;
    }

    Element getElement(int n) {
        return this.tree[n];
    }

    Element getFreeElement() {
        int n;
        if (this.tstack < 0) {
            n = this.treesize;
            this.treesize += this.allocsize;
            this.freeSlots = new int[this.treesize];
            Element[] elementArray = new Element[this.treesize];
            System.arraycopy(this.tree, 0, elementArray, 0, n);
            this.tree = elementArray;
            for (int i = this.tstack = this.allocsize - 1; i >= 0; --i) {
                this.tree[n] = new Element();
                this.tree[n].elid = n;
                this.freeSlots[i] = n++;
            }
        }
        if (this.freeSlots[this.tstack] == 0) {
            --this.tstack;
        }
        n = this.freeSlots[this.tstack];
        --this.tstack;
        return this.tree[n];
    }

    public void dumpSlots() {
        System.out.println(" root = " + this.root + " prev = " + this.prev);
        for (int i = 0; i < this.treesize; ++i) {
            Element element = this.tree[i];
            if (element.slot == null) continue;
            System.out.print(" id " + i + " ");
            element.printElement();
            element.slot.printSlot();
            System.out.println();
        }
    }

    Element getElement(Object object, String string, int n, int n2, String string2) {
        for (int i = 0; i < this.treesize; ++i) {
            Element element = this.tree[i];
            Mdslot mdslot = element.slot;
            if (mdslot == null || mdslot.qualifier == null || !mdslot.qualifier.equals(string) || mdslot.name == null || !mdslot.name.equals(object) || mdslot.disk == null || mdslot.disk.instNum != n || mdslot.disk.mdRecNum != n2 || mdslot.disk.fileName == null || !mdslot.disk.fileName.equals(string2)) continue;
            return element;
        }
        return null;
    }

    void dump(int n, CacheCtx cacheCtx, OutputStreamWriter outputStreamWriter) throws IOException {
        boolean bl = true;
        for (int i = 0; i < this.treesize; ++i) {
            Element element = this.tree[i];
            if (element.slot == null || element.slot.name == null || cacheCtx != null && cacheCtx != element.slot.cacheCtx) continue;
            if (bl) {
                outputStreamWriter.write("<<< Bucket " + n + " >>>\n");
                bl = false;
            }
            outputStreamWriter.write(" ElementId " + i + "\n");
            element.dump(outputStreamWriter);
            element.slot.dump(outputStreamWriter);
        }
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("tstack=");
        stringBuffer.append(this.tstack);
        stringBuffer.append(", treesize=");
        stringBuffer.append(this.treesize);
        stringBuffer.append(", root=");
        stringBuffer.append(this.root);
        stringBuffer.append(", prev=");
        stringBuffer.append(this.prev);
        stringBuffer.append(", allocsize=");
        stringBuffer.append(this.allocsize);
        stringBuffer.append(", =");
        stringBuffer.append("");
        stringBuffer.append(", tree=[");
        if (this.tree != null) {
            for (n = 0; n < this.tree.length; ++n) {
                stringBuffer.append("#");
                stringBuffer.append(n);
                stringBuffer.append(". ");
                stringBuffer.append(this.tree[n]);
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("], freeSlots=[");
        if (this.freeSlots != null) {
            for (n = 0; n < this.freeSlots.length; ++n) {
                stringBuffer.append(this.freeSlots[n]);
                stringBuffer.append(", ");
            }
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

