/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

class RegionCount {
    long objid;
    int count;
    int max;
    long maxSize;
    long size;
    int diskCount;
    int diskMax;
    long diskMaxSize;
    long diskSize;

    RegionCount(long l, int n, long l2, int n2, long l3) {
        this.objid = l;
        this.count = 0;
        this.size = 0L;
        this.max = n;
        this.maxSize = l2;
        this.diskCount = 0;
        this.diskSize = 0L;
        this.diskMax = n2;
        this.diskMaxSize = l3;
    }

    synchronized boolean incNcheck(long l) {
        ++this.count;
        this.size += l;
        return this.max > 0 && this.count > this.max || this.maxSize > 0L && this.size > this.maxSize;
    }

    synchronized boolean check(boolean bl) {
        if (bl) {
            return this.diskCheck();
        }
        return this.check();
    }

    private boolean check() {
        return this.max > 0 && this.count > this.max || this.maxSize > 0L && this.size > this.maxSize;
    }

    synchronized void dec(long l) {
        --this.count;
        this.size -= l;
    }

    long getId() {
        return this.objid;
    }

    int getCount() {
        return this.count;
    }

    int getMax() {
        return this.max;
    }

    long getMaxSize() {
        return this.maxSize;
    }

    long getsize() {
        return this.size;
    }

    synchronized void resetMax(int n) {
        this.max = n;
    }

    synchronized void resetSize(long l) {
        this.maxSize = l;
    }

    synchronized boolean incDiskNcheck(long l) {
        ++this.diskCount;
        this.diskSize += l;
        return this.diskMax > 0 && this.diskCount > this.diskMax || this.diskMaxSize > 0L && this.diskSize > this.diskMaxSize;
    }

    private boolean diskCheck() {
        return this.diskMax > 0 && this.diskCount > this.diskMax || this.diskMaxSize > 0L && this.diskSize > this.diskMaxSize;
    }

    synchronized void diskDec(long l) {
        --this.diskCount;
        this.diskSize -= l;
    }

    int getDiskCount() {
        return this.diskCount;
    }

    int getDiskMax() {
        return this.diskMax;
    }

    long getDiskMaxSize() {
        return this.diskMaxSize;
    }

    long getDiskSize() {
        return this.diskSize;
    }

    synchronized void resetDiskMax(int n) {
        this.diskMax = n;
    }

    synchronized void resetDiskSize(long l) {
        this.diskMaxSize = l;
    }
}

