/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import oracle.ias.cache.AffinityObject;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.PoolAffinityFactory;
import oracle.ias.cache.PoolInstanceFactory;

class PoolMgr {
    PoolInstanceFactory factory;
    int max;
    int min;
    int step;
    int boundary;
    Attributes attr;
    private int[] indexStack;
    private int hot;
    private int top;
    private AffinityObject[] affinityList;
    private boolean affinityOn = false;
    private PoolAffinityFactory affinity = null;
    private int nextAffinity = -1;
    private CacheCtx cacheCtx;

    PoolMgr(PoolInstanceFactory poolInstanceFactory, Attributes attributes, int n, int n2, CacheCtx cacheCtx) {
        int n3;
        this.min = n;
        this.max = n2;
        this.factory = poolInstanceFactory;
        this.attr = attributes;
        this.indexStack = new int[n];
        this.affinityList = new AffinityObject[n];
        this.cacheCtx = cacheCtx;
        this.boundary = n;
        this.step = (n2 - n) / 10;
        if (this.step < 10) {
            this.step = 10;
        }
        if (n2 <= 0) {
            this.max = Integer.MAX_VALUE;
            this.step = 100;
        }
        for (n3 = 0; n3 < this.boundary; ++n3) {
            this.indexStack[n3] = n3;
        }
        this.hot = 0;
        this.top = this.min;
        if (poolInstanceFactory instanceof PoolAffinityFactory) {
            this.affinityOn = true;
            this.affinity = (PoolAffinityFactory)poolInstanceFactory;
            for (n3 = 0; n3 < this.boundary; ++n3) {
                this.affinityList[n3] = new AffinityObject();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getIndex() throws CacheException {
        int n = -1;
        AffinityObject[] affinityObjectArray = this.affinityList;
        synchronized (this.affinityList) {
            n = this._getIndex();
            if (n == -1 && this.boundary < this.max && this.growTable()) {
                n = this._getIndex();
            }
            if (n == -1) {
                n = this._getAffinityObject();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _getIndex() throws CacheException {
        int n = -1;
        AffinityObject[] affinityObjectArray = this.affinityList;
        synchronized (this.affinityList) {
            if (this.hot < this.min) {
                n = this.indexStack[this.hot++];
            } else if (this.top != this.boundary) {
                n = this.indexStack[this.top++];
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _getAffinityObject() throws CacheException {
        int n = -1;
        AffinityObject[] affinityObjectArray = this.affinityList;
        synchronized (this.affinityList) {
            if (this.affinityOn) {
                for (int i = 0; i < this.boundary; ++i) {
                    CacheHandle cacheHandle;
                    ++this.nextAffinity;
                    this.nextAffinity %= this.boundary;
                    AffinityObject affinityObject = this.affinityList[this.nextAffinity];
                    if (affinityObject.isInUse() || (cacheHandle = affinityObject.handle) == null || !this.affinity.affinityRelease(cacheHandle.getObject())) continue;
                    this.cacheCtx.releaseHandle(cacheHandle);
                    affinityObject.reset();
                    // ** MonitorExit[var3_2] (shouldn't be in output)
                    return this.nextAffinity;
                }
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseIndex(int n) {
        AffinityObject[] affinityObjectArray = this.affinityList;
        synchronized (this.affinityList) {
            if (n < this.min && this.hot > 0) {
                this.indexStack[--this.hot] = n;
            } else if (this.top > 0) {
                this.indexStack[--this.top] = n;
            }
            if (this.affinityOn && n < this.boundary) {
                this.affinityList[n].reset();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    boolean hasAffinity() {
        return this.affinityOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheHandle getAffinity(int n, int n2) {
        CacheHandle cacheHandle = null;
        boolean bl = true;
        if (n > this.max) {
            return null;
        }
        AffinityObject[] affinityObjectArray = this.affinityList;
        synchronized (this.affinityList) {
            while (n > this.boundary) {
                if (this.growTable()) continue;
                // ** MonitorExit[var6_5] (shouldn't be in output)
                return null;
            }
            AffinityObject affinityObject = this.affinityList[n];
            if (affinityObject.version == n2 && (cacheHandle = affinityObject.getHandle()) != null) {
                affinityObject.setInUse(true);
            }
            // ** MonitorExit[var6_5] (shouldn't be in output)
            return cacheHandle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int releaseAffinity(int n, CacheHandle cacheHandle) {
        int n2 = 0;
        AffinityObject[] affinityObjectArray = this.affinityList;
        synchronized (this.affinityList) {
            if (n < this.boundary && n >= 0) {
                this.affinityList[n].handle = cacheHandle;
                this.affinityList[n].setInUse(false);
                n2 = this.affinityList[n].version;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return n2;
        }
    }

    public String toString() {
        String string = "stack:{";
        for (int i = 0; i < this.indexStack.length; ++i) {
            string = i == this.indexStack.length - 1 ? string + this.indexStack[i] + "}" : string + this.indexStack[i] + ",";
        }
        string = string + "::hot:" + this.hot;
        string = string + "::top:" + this.top;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean growTable() {
        boolean bl = false;
        AffinityObject[] affinityObjectArray = this.affinityList;
        synchronized (this.affinityList) {
            if (this.max > this.boundary) {
                int n = this.boundary + this.step;
                if (this.max < n) {
                    n = this.max;
                }
                int[] nArray = new int[n];
                AffinityObject[] affinityObjectArray2 = new AffinityObject[n];
                System.arraycopy(this.indexStack, 0, nArray, 0, this.boundary);
                System.arraycopy(this.affinityList, 0, affinityObjectArray2, 0, this.boundary);
                for (int i = this.boundary; i < n; ++i) {
                    nArray[i] = i;
                    affinityObjectArray2[i] = new AffinityObject();
                }
                this.affinityList = affinityObjectArray2;
                this.indexStack = nArray;
                this.boundary = n;
                bl = true;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return bl;
        }
    }
}

