/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheLogger;
import oracle.ias.cache.commx.GroupCommunication;
import oracle.ias.cache.commx.GroupConfig;
import oracle.ias.cache.commx.NetworkAddress;

public class NamedCacheAttributes
implements Cloneable {
    public static final int TCP = 0;
    public static final String REGIONSEPARATOR = "/";
    public static final int HTTP = 1;
    static final String DEFAULT_CONFIG = "CacheDefaultConfig.properties";
    static final String CACHE_CONFIG = "javacache.properties";
    static final String DEFAULT_COMM_PROVIDER = "oracle.ias.cache.group.GrpCommunication";
    public boolean isSSLEnabled;
    public String sslConfigFilePath;
    public boolean distribute;
    public boolean dms;
    public int maxObjects;
    public int maxSize;
    public int diskSize;
    public int diskCount;
    public String diskPath;
    public String logger;
    public String logFileName;
    public int logSeverity;
    public Level logLevel;
    public String dumpFileName;
    boolean overrideLogConfig = true;
    GroupConfig gconfig;
    boolean diskSizeSet;
    boolean diskCountSet;
    boolean logSeveritySet;
    boolean maxObjectsSet;
    boolean maxSizeSet;
    Hashtable configTable;
    NetworkAddress defaultDiscovery;
    String comm_provider_name = "oracle.ias.cache.group.GrpCommunication";
    String loggerConfigFileName;
    static /* synthetic */ Class class$oracle$ias$cache$CacheAttributes;

    public NamedCacheAttributes(String string) throws CacheException {
        try {
            Class<?> clazz = Class.forName(string);
            GroupCommunication groupCommunication = (GroupCommunication)clazz.newInstance();
            this.gconfig = groupCommunication.getDefaultConfiguration();
            this.diskSizeSet = false;
            this.diskCountSet = false;
            this.logSeveritySet = false;
            this.maxObjectsSet = false;
            this.maxSizeSet = false;
            this.logLevel = Level.OFF;
            this.readConfig(DEFAULT_CONFIG, true);
            this.defaultDiscovery = (NetworkAddress)this.gconfig.getListenerList().get(0);
            this.gconfig.getListenerList().remove(0);
        }
        catch (CacheException cacheException) {
            throw cacheException;
        }
        catch (Exception exception) {
            throw new CacheException(null, exception);
        }
    }

    public NamedCacheAttributes() throws CacheException {
        this(DEFAULT_COMM_PROVIDER);
    }

    void readConfig(String string, boolean bl) throws Exception {
        this.getConfigInfo(string);
        String string2 = this.getConfigItem("logFileName");
        if (string2 != null) {
            this.logFileName = string2;
        }
        if ((string2 = this.getConfigItem("logSeverity")) != null) {
            this.logSeverity = CacheLogger.parseLogSeverity(string2);
        }
        if ((string2 = this.getConfigItem("logLevel")) != null) {
            this.logLevel = Level.parse(string2);
        }
        if ((string2 = this.getConfigItem("logger")) != null) {
            this.logger = string2;
        }
        if ((string2 = this.getConfigItem("dumpFileName")) != null) {
            this.dumpFileName = string2;
        }
        if ((string2 = this.getConfigItem("maxSize")) != null) {
            this.maxSize = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("maxObjects")) != null) {
            this.maxObjects = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("diskPath")) != null && !string2.equalsIgnoreCase("null")) {
            this.diskPath = string2.replace('/', File.separatorChar);
        }
        if ((string2 = this.getConfigItem("diskSize")) != null) {
            this.diskSize = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("diskCount")) != null) {
            this.diskCount = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("distribute")) != null) {
            this.distribute = string2.equalsIgnoreCase("true");
        }
        if ((string2 = this.getConfigItem("dms")) != null) {
            this.dms = string2.equalsIgnoreCase("true");
        }
        if ((string2 = this.getConfigItem("communicationProvider")) != null && !string2.equals(this.comm_provider_name)) {
            try {
                Class<?> clazz = Class.forName(string2);
                GroupCommunication groupCommunication = (GroupCommunication)clazz.newInstance();
                this.gconfig = groupCommunication.getDefaultConfiguration();
            }
            catch (Exception exception) {
                throw new CacheException(null, exception);
            }
        }
        if ((string2 = this.getConfigItem("discoveryAddress")) != null) {
            this.buildAddrList(string2);
        }
    }

    void getConfigInfo(String string) throws Exception {
        String string2;
        InputStream inputStream;
        block6: {
            this.configTable = new Hashtable();
            String string3 = REGIONSEPARATOR + string;
            inputStream = null;
            try {
                inputStream = new FileInputStream(string);
            }
            catch (IOException iOException) {
                inputStream = (class$oracle$ias$cache$CacheAttributes == null ? (class$oracle$ias$cache$CacheAttributes = NamedCacheAttributes.class$("oracle.ias.cache.CacheAttributes")) : class$oracle$ias$cache$CacheAttributes).getResourceAsStream(string3);
                if (inputStream != null) break block6;
                File file = new File(string);
                if (CACHE_CONFIG.equals(string) && !file.exists()) {
                    return;
                }
                throw iOException;
            }
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            int n;
            int n2;
            char[] cArray = string2.toCharArray();
            if (cArray.length == 0 || cArray[0] == '#') continue;
            for (n2 = 0; n2 < cArray.length && cArray[n2] != '='; ++n2) {
            }
            if (n2 == cArray.length) continue;
            for (n = n2; n < cArray.length && cArray[n] != '#'; ++n) {
            }
            String string4 = new String(cArray, 0, n2).trim();
            String string5 = new String(cArray, n2 + 1, n - n2 - 1).trim();
            if (string5.equals("")) continue;
            this.configTable.put(string4.toLowerCase(), string5);
        }
        bufferedReader.close();
    }

    String getConfigItem(String string) {
        return (String)this.configTable.get(string.toLowerCase());
    }

    void buildAddrList(String string) throws UnknownHostException {
        InetAddress inetAddress = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":,", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals(",")) continue;
            if (string2.equals(":")) {
                if (inetAddress != null) continue;
                inetAddress = InetAddress.getLocalHost();
                continue;
            }
            if (inetAddress != null) {
                int n = Integer.parseInt(string2);
                this.addCacheAddr(inetAddress, n, true);
                inetAddress = null;
                continue;
            }
            inetAddress = InetAddress.getByName(string2);
        }
    }

    public void setDistribute(boolean bl) {
        this.distribute = bl;
    }

    public void setDms(boolean bl) {
        this.dms = bl;
    }

    public void setMaxObjects(int n) {
        this.maxObjects = n;
        this.maxObjectsSet = true;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
        this.maxSizeSet = true;
    }

    public void setDiskSize(int n) {
        this.diskSize = n;
        this.diskSizeSet = true;
    }

    public void setDiskCount(int n) {
        this.diskCount = n;
        this.diskCountSet = true;
    }

    public void setDiskPath(String string) {
        this.diskPath = string;
    }

    public void setLogger(String string) {
        this.logger = string;
    }

    public void setLogSeverity(int n) {
        this.logSeverity = n;
        this.logLevel = CacheLogger.getMappedLogLevel(n);
        this.logSeveritySet = true;
    }

    public void setLogLevel(Level level) {
        this.logLevel = level;
        this.logSeveritySet = true;
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    boolean isLogLevelSet() {
        return this.logSeveritySet;
    }

    public void setLogFileName(String string) {
        this.logFileName = string;
    }

    public void setLoggerConfigurationFileName(String string) {
        this.loggerConfigFileName = string;
    }

    public String getLoggerConfigurationFileName() {
        return this.loggerConfigFileName;
    }

    public boolean isOverrideLogconfiguration() {
        return this.overrideLogConfig;
    }

    public void setOverrideLogconfiguration(boolean bl) {
        this.overrideLogConfig = bl;
    }

    public void setCacheDumpFileName(String string) {
        this.dumpFileName = string;
    }

    public String getCacheDumpFilePath() {
        return this.dumpFileName;
    }

    public void setKeyStore(String string) {
        this.gconfig.setKeyStore(string);
    }

    public void setSSLConfigFile(String string) {
        this.gconfig.setSSLConfigFile(string);
    }

    public void setEnableSSL(boolean bl) {
        this.gconfig.setSSLEnabled(bl);
    }

    public void setTransport(int n) {
        this.gconfig.setMode(n);
    }

    public void setLocalAddress(String string) {
        this.gconfig.setLocalAddress(string);
    }

    public void addCacheAddr(InetAddress inetAddress, int n) {
        this.addCacheAddr(inetAddress, n, false);
    }

    public void addCacheAddr(InetAddress inetAddress, int n, boolean bl) {
        this.addCacheAddr(inetAddress, n, false, false, 0);
    }

    public void addCacheAddr(InetAddress inetAddress, int n, boolean bl, boolean bl2) {
        this.addCacheAddr(inetAddress, n, bl, bl2, 0);
    }

    public void addCacheAddr(InetAddress inetAddress, int n, boolean bl, boolean bl2, int n2) {
        this.gconfig.addCacheAddr(inetAddress, n, bl, bl2, n2);
    }

    public synchronized void addPrimaryCacheAddr(InetAddress inetAddress, int n) {
        this.gconfig.addPrimaryCacheAddr(inetAddress, n);
    }

    public boolean addressIsOriginal(InetAddress inetAddress, int n) {
        return this.gconfig.addressIsOriginal(inetAddress, n);
    }

    public boolean removeCacheAddr(InetAddress inetAddress, int n) {
        return this.gconfig.removeCacheAddr(inetAddress, n);
    }

    public Enumeration getCacheAddrs() {
        return new AddrEnumerator();
    }

    public CacheAddress[] getCoordinatorList() {
        int n = this.gconfig.getListenerList().size();
        if (n == 0) {
            CacheAddress[] cacheAddressArray = new CacheAddress[]{new CacheAddress(this.defaultDiscovery)};
            return cacheAddressArray;
        }
        CacheAddress[] cacheAddressArray = new CacheAddress[n];
        for (int i = 0; i < cacheAddressArray.length; ++i) {
            cacheAddressArray[i] = new CacheAddress((NetworkAddress)this.gconfig.getListenerList().get(i));
        }
        return cacheAddressArray;
    }

    public Vector getAddrList() {
        if (this.gconfig.getListenerList() == null || this.gconfig.getListenerList().size() == 0) {
            Vector<NetworkAddress> vector = new Vector<NetworkAddress>();
            vector.add(this.defaultDiscovery);
            return vector;
        }
        return this.gconfig.getListenerList();
    }

    public String getAddrListString() {
        String string = "none";
        if (this.gconfig.getListenerList() == null || this.gconfig.getListenerList().isEmpty()) {
            string = this.defaultDiscovery.toString();
        } else {
            NetworkAddress networkAddress = (NetworkAddress)this.gconfig.getListenerList().elementAt(0);
            string = networkAddress.toString();
            for (int i = 1; i < this.gconfig.getListenerList().size(); ++i) {
                networkAddress = (NetworkAddress)this.gconfig.getListenerList().elementAt(i);
                string = string + "," + networkAddress.toString();
            }
        }
        return string;
    }

    public String getAddrString() {
        String string = "none";
        if (this.gconfig.getListenerList() == null || this.gconfig.getListenerList().isEmpty()) {
            string = this.defaultDiscovery.getString();
        } else {
            NetworkAddress networkAddress = (NetworkAddress)this.gconfig.getListenerList().elementAt(0);
            string = networkAddress.getString();
            for (int i = 1; i < this.gconfig.getListenerList().size(); ++i) {
                networkAddress = (NetworkAddress)this.gconfig.getListenerList().elementAt(i);
                string = string + "," + networkAddress.getString();
            }
        }
        return string;
    }

    public String getLocalAddress() {
        return this.gconfig.getLocalAddress();
    }

    public GroupConfig getGroupConfig() {
        return this.gconfig;
    }

    public boolean isNodeListenerDeathDetectable() {
        return this.gconfig.isNLDeathDetected();
    }

    public void setNodeListenerDeathDetectable(boolean bl) {
        this.gconfig.setNLDeathDetected(bl);
    }

    public void setOverrideNodeListenerPort(int n) {
        this.gconfig.setOverrideNLPort(n);
    }

    public int getOverrideNodeListenerPort() {
        return this.gconfig.getOverrideNLPort();
    }

    public String getMulticastAddress() {
        return this.gconfig.getMulticastAddress();
    }

    public int getMulticastPort() {
        return this.gconfig.getMulticastPort();
    }

    public int getMulticastInterval() {
        return this.gconfig.getMulticastInterval();
    }

    public int getMulticastTTL() {
        return this.gconfig.getMulticastTTL();
    }

    public boolean isMulticast() {
        return this.gconfig.isMulticast();
    }

    public long getResolutionInterval() {
        return this.gconfig.getResolutionInterval();
    }

    public boolean isPriorityOrderEnabled() {
        return this.gconfig.isPriorityOrderEnabled();
    }

    public int getLowerPortBoundry() {
        return this.gconfig.getLowerPortBoundry();
    }

    public int getUpperPortBoundry() {
        return this.gconfig.getUpperPortBoundry();
    }

    public void setLowerPortBoundry(int n) {
        this.gconfig.setLowerPortBoundry(n);
    }

    public void setUpperPortBoundry(int n) {
        this.gconfig.setUpperPortBoundry(n);
    }

    public Object clone() {
        NamedCacheAttributes namedCacheAttributes;
        try {
            namedCacheAttributes = (NamedCacheAttributes)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        return namedCacheAttributes;
    }

    public String toString() {
        String string = CacheLogger.severityToString(this.logSeverity);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("distribute = ");
        stringBuffer.append(this.distribute);
        stringBuffer.append(",\nmaxSize = ");
        stringBuffer.append(this.maxSize);
        stringBuffer.append(" mb");
        stringBuffer.append(",\nmaxObjects = ");
        stringBuffer.append(this.maxObjects);
        stringBuffer.append(",\ndiskSize = ");
        stringBuffer.append(this.diskSize);
        stringBuffer.append(" mb");
        stringBuffer.append(", \ndiskCount = ");
        stringBuffer.append(this.diskCount);
        stringBuffer.append(",\ndiskCount = ");
        stringBuffer.append(this.diskCount);
        stringBuffer.append(",\ndiskPath = ");
        stringBuffer.append(this.diskPath);
        stringBuffer.append(",\noverrideLogConfiguration = ");
        stringBuffer.append(this.overrideLogConfig);
        stringBuffer.append(",\nLogFileName = ");
        stringBuffer.append(this.logFileName);
        stringBuffer.append(",\nloggerConfigFileName = ");
        stringBuffer.append(this.loggerConfigFileName);
        stringBuffer.append(",\nLog severity = ");
        stringBuffer.append(string);
        stringBuffer.append(",\nLog Level = ");
        stringBuffer.append(this.logLevel);
        stringBuffer.append(",\nLogger = ");
        stringBuffer.append(this.logger);
        stringBuffer.append(",\ncache address list = ");
        stringBuffer.append(this.getAddrListString());
        if (this.gconfig != null) {
            stringBuffer.append(",\nCommunication Provider = ");
            stringBuffer.append(this.gconfig.getClass().getName());
        }
        stringBuffer.append(",\nGroupConfig = ");
        stringBuffer.append(this.gconfig);
        stringBuffer.append(",\nisSSLEnabled = ");
        stringBuffer.append(this.isSSLEnabled);
        stringBuffer.append(",\nsslConfigFilePath = ");
        stringBuffer.append(this.sslConfigFilePath);
        stringBuffer.append(",\ndms = ");
        stringBuffer.append(this.dms);
        return stringBuffer.toString();
    }

    static int parseTransportInt(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string.equals("TCP")) {
            n = 0;
        } else if (string.equals("HTTP")) {
            n = 1;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AddrEnumerator
    implements Enumeration {
        int next = 0;

        private AddrEnumerator() {
        }

        public boolean hasMoreElements() {
            return !(NamedCacheAttributes.this.gconfig.getListenerList() == null ? this.next > 0 : this.next >= NamedCacheAttributes.this.gconfig.getListenerList().size());
        }

        public Object nextElement() {
            if (NamedCacheAttributes.this.gconfig.getListenerList() == null) {
                throw new NoSuchElementException();
            }
            NetworkAddress networkAddress = (NetworkAddress)NamedCacheAttributes.this.gconfig.getListenerList().elementAt(this.next);
            ++this.next;
            return networkAddress.getString();
        }
    }
}

