/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Hashtable;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheEvent;
import oracle.ias.cache.CacheEventListener;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheLoader;
import oracle.ias.cache.CapacityPolicy;
import oracle.ias.cache.MdDisk;
import oracle.ias.cache.MdGroup;
import oracle.ias.cache.ObjectStatus;
import oracle.ias.cache.OwnerInfo;
import oracle.ias.cache.RegionCount;

class Mdslot {
    boolean wasCounted = false;
    int refcount = 0;
    long state = 0L;
    long objid = 0L;
    Object name;
    String qualifier;
    String group = null;
    int mygId = -1;
    long groupId = 0L;
    MdGroup groupInfo = null;
    Object object = null;
    long timeToLive = 0L;
    long idleTime = 0L;
    long ttlInterval = 0L;
    long version = 0L;
    OwnerInfo ownerInfo = null;
    int regionNumber = 0;
    CacheEventListener[] eventHandlers = null;
    CacheLoader loader;
    ClassLoader userClassLoader;
    boolean[] eventDefault;
    MdDisk disk = null;
    ObjectStatus objStatus = new ObjectStatus();
    RegionCount[] regionCount = null;
    CapacityPolicy capacityPolicy = null;
    Hashtable userAttrs = null;
    CacheCtx cacheCtx = null;

    synchronized void free() {
        this.wasCounted = false;
        this.name = null;
        this.qualifier = null;
        this.object = null;
        this.group = null;
        this.groupInfo = null;
        this.ownerInfo = null;
        this.state = 1L;
        this.objid = CacheHandle.updateid(this.objid);
        this.groupId = 0L;
        this.mygId = -1;
        this.version = 0L;
        this.timeToLive = 0L;
        this.ttlInterval = 0L;
        this.idleTime = 0L;
        this.regionNumber = 0;
        this.disk = null;
        this.eventHandlers = null;
        this.regionCount = null;
        this.capacityPolicy = null;
        this.userAttrs = null;
        this.cacheCtx = null;
        this.objStatus.reset();
    }

    public void printSlot() {
        if (this.name != null) {
            System.out.println(" Qualifier=" + this.qualifier + " Name=" + this.name + " ObjId=" + this.objid + " Group=" + this.group + " GroupInfo=(" + this.groupInfo + ")" + " Version=" + this.version + " TimeToLive=" + this.timeToLive + " IdleTime=" + this.idleTime + " TtlInterval=" + this.ttlInterval + " CacheLoader=" + this.loader + " CacheEventHandlers=" + this.getEventHandlers() + " State=" + Mdslot.getStateString(this.state) + " Region id=" + this.regionNumber + " Object =" + this.object + " Disk =(" + this.disk + ")" + " status=[" + this.objStatus.toString() + "]" + " ownerinfo=" + this.ownerInfo + " cacheCtx=" + this.cacheCtx + " userAttributes=" + this.userAttrs);
        }
    }

    void dump(OutputStreamWriter outputStreamWriter) throws IOException {
        outputStreamWriter.write(" Qualifier=" + this.qualifier + " Name=" + this.name + " ObjId=" + this.objid + " Group=" + this.group + " GroupInfo=(" + this.groupInfo + ")" + " RefCount=" + this.refcount + " Version=" + this.version + " TimeToLive=" + this.timeToLive + " IdleTime=" + this.idleTime + " TtlInterval=" + this.ttlInterval + " CacheLoader=" + this.loader + " CapacityPolicy=" + this.capacityPolicy + " CacheEventHandlers=" + this.getEventHandlers() + " State=" + Mdslot.getStateString(this.state) + " Region id=" + this.regionNumber + " Object =(" + this.object + ")" + " Disk =(" + this.disk + ")" + " status=" + this.objStatus + " ownerinfo=" + this.ownerInfo + " cacheCtx=" + this.cacheCtx + " userAttributes=" + this.userAttrs + "\n");
    }

    static String getStateString(long l) {
        String[] stringArray = new String[]{"FREE", "LOADED", "LOADING", "NEEDLOAD", "VALID", "UPDATEALL", "INMEMORY", "GROUP", "ONDISK", "DISTRIBUTE", "NEEDVERIFY", "REPLY", "DISKONLY", "DISKABLE", "MEMORY", "REPLACED", "ORIGINAL", "SYNCUP", "FINDONLY", "ATTRSET", "SYNCDEF", "NOWAIT", "TTLDESTROY", "WRITEONLY", "LOADER", "STREAM", "REMOTELOAD", "NOTDEFINED", "REGION", "DISABLED", "ALLOWNULL", "MEASURESIZE", "LISTLOAD", "INV_TIMEOUT", "NO_LOCK", "LOADERSET", "ISFILE", "SPOOLING", "TIMEINV_LOCALONLY"};
        long l2 = l;
        StringBuffer stringBuffer = new StringBuffer(Long.toHexString(l) + " ");
        for (int i = 0; i < 64; ++i) {
            if ((l2 & 1L) == 1L) {
                stringBuffer.append(stringArray[i] + ",");
            }
            l2 >>= 1;
        }
        return stringBuffer.toString();
    }

    private String getEventHandlers() {
        String string = "";
        if (this.eventHandlers == null) {
            return "None";
        }
        for (int i = 0; i < 6; ++i) {
            string = string + CacheEvent.getEventName(i) + ":" + this.eventHandlers[i];
        }
        return string;
    }

    public String toString() {
        return " Qualifier=" + this.qualifier + " Name=" + this.name + " ObjId=" + this.objid + " Group=" + this.group + " GroupInfo=(" + this.groupInfo + ")" + " RefCount=" + this.refcount + " Version=" + this.version + " TimeToLive=" + this.timeToLive + " IdleTime=" + this.idleTime + " TtlInterval=" + this.ttlInterval + " CacheLoader=" + this.loader + " CapacityPolicy=" + this.capacityPolicy + " CacheEventHandlers=" + this.getEventHandlers() + " State=" + Mdslot.getStateString(this.state) + " Region id=" + this.regionNumber + " Object =(" + this.object + ")" + " Disk =(" + this.disk + ")" + " status=" + this.objStatus + " ownerinfo=" + this.ownerInfo + " userAttributes=" + this.userAttrs;
    }
}

