/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.Bucket;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheObjectInputStream;
import oracle.ias.cache.CacheObjectOutputStream;
import oracle.ias.cache.DiskCache;
import oracle.ias.cache.DiskCacheException;
import oracle.ias.cache.DiskFileLock;
import oracle.ias.cache.MdDisk;
import oracle.ias.cache.Mdslot;

class DiskCacheV1013
extends DiskCache {
    private static final String LOGGER_NAME = "oracle.ias.cache.DiskCache";
    private static final String METADATA = "1";
    private static final String DATA = "2";
    private static final String OVERFLOW = "4";
    private static final String TMP = ".tmp";
    private static final char MD_DISKONLY = 'D';
    private static final char MD_MEMORY = 'M';
    private static final char MD_STREAM = 'S';
    private static final char MD_INVALID = 'I';
    private static final char MD_FREE = 'F';
    private static final char MD_USEOV = 'O';
    private static final char MD_LOCALNAME = 'N';
    private static final char SP = '\u007f';
    private static final int BASE = 6;
    private static final int MASK = 63;
    private static final int RECORDSIZE = 256;
    private static final int LOCK_RETRY = 1000;
    private static final int GROW_IDX = 100;
    private static final String SEP = "_";
    private static final int buckCnt = 50;
    private DiskFileLock lock;
    private String mdFile;
    private RandomAccessFile mdFileHdl;
    private String ovFile;
    private RandomAccessFile ovFileHdl;
    private IdxEntry[] idx;
    private String bucketPath;
    private File objectDir;
    private byte[] buffer;
    private byte[] ovBuf;
    private int bufPtr;
    private long seekPtr;
    private int currRec;
    private int ovPtr;
    private char status;
    private int buckNum;
    private Bucket bucket;
    private CacheCtx cacheCtx;
    private Logger logger_;
    private boolean isLocal;
    private int gInst;
    private boolean gInstSet;
    private char useov;
    private long fileTag;
    private int localTag;
    private int tag = 0;
    static final long[] l2bMask = new long[]{63L, 4032L, 258048L, 0xFC0000L, 0x3F000000L, 0xFC0000000L, 0x3F000000000L, 0xFC0000000000L, 0x3F000000000000L, 0xFC0000000000000L, -1152921504606846976L};

    DiskCacheV1013(String string, int n, boolean bl, CacheCtx cacheCtx) {
        this(string, n, bl, false, cacheCtx);
    }

    DiskCacheV1013(String string, int n, boolean bl, boolean bl2, CacheCtx cacheCtx) {
        this.isLocal = bl;
        this.buckNum = n;
        if (!bl2) {
            this.bucket = CacheInternal.hashtab[n];
        }
        int n2 = n % 50;
        this.bucketPath = string + File.separator + n2;
        this.path = this.bucketPath + File.separator + DATA;
        this.mdFile = this.bucketPath + File.separator + n + SEP + METADATA;
        this.ovFile = this.bucketPath + File.separator + n + SEP + OVERFLOW;
        this.gInstSet = false;
        this.fileTag = -1L;
        this.objectDir = new File(this.path);
        this.lock = new DiskFileLock(this.isLocal);
        this.cacheCtx = cacheCtx;
        this.logger_ = cacheCtx != null ? cacheCtx.getLogger(LOGGER_NAME) : Logger.getLogger(LOGGER_NAME);
    }

    long checkDisk(Mdslot mdslot) throws DiskCacheException {
        File file = null;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        long l = 8L;
        if (!this.objectDir.exists()) {
            this.objectDir.mkdirs();
        }
        try {
            this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
            this.lock.getLock(this.mdFileHdl);
            if ((mdslot.state & 0x100L) != 0L && this.getRecord(mdslot.disk.mdRecNum)) {
                file = new File(mdslot.disk.path, mdslot.disk.fileName + TMP);
                l = file.exists() ? 4L : 2L;
                if (this.logger_.isLoggable(Level.INFO)) {
                    this.logger_.log(Level.INFO, "[Dsk] checkDisk: slot on disk, ret=" + l);
                }
                long l2 = l;
                return l2;
            }
            if (this.updateNeeded()) {
                n = 0;
                this.startScan();
                while ((n = this.findNextUpdate()) >= 0) {
                    if (!bl && this.qualifier.equals(mdslot.qualifier) && this.name.equals(mdslot.name)) {
                        file = new File(this.path, this.fileName + TMP);
                        l = file.exists() ? 4L : 2L;
                        bl = true;
                        mdslot.timeToLive = this.timeToLive;
                        mdslot.ttlInterval = this.ttlInterval;
                        mdslot.idleTime = this.idleTime;
                        mdslot.version = this.version;
                        mdslot.state = 0L;
                        mdslot.objStatus.size = this.oSize;
                        mdslot.objStatus.fileSize = this.fileSize;
                        if (mdslot.disk == null) {
                            mdslot.disk = new MdDisk();
                        }
                        mdslot.disk.fileName = new String(this.fileName);
                        mdslot.disk.path = this.path;
                        mdslot.disk.instNum = this.instNum;
                        mdslot.disk.mdRecNum = this.mdRecNum;
                        mdslot.disk.overFlow = this.overFlow;
                        if (this.flags != 0L) {
                            mdslot.state |= this.flags | 0x80000L;
                        }
                        mdslot.state |= 0x110L | this.storType;
                        if ((mdslot.state & 0x1000L) != 0L) {
                            mdslot.object = this.path + File.separator + this.fileName;
                            mdslot.state |= 2L;
                        }
                    } else {
                        this.bucket.updateDisk(this);
                        if (this.idx == null || this.idx.length <= n) {
                            this.growIdx();
                        }
                        this.idx[n].instNum = this.instNum;
                        this.idx[n].status = (mdslot.state & 0x1000L) != 0L ? (char)68 : ((mdslot.state & 0x2000000L) != 0L ? (char)83 : (char)77);
                    }
                    ++n;
                }
            }
            if (!bl) {
                file = null;
                this.generateName();
                n = this.findFree(0);
                while (this.getStatus(n) != 'F') {
                    n = this.findFree(n + 1);
                }
                if (!this.isLocal) {
                    this.bucket.growDiskMaps(this.idx.length);
                }
                ++this.instNum;
                if (mdslot.disk == null) {
                    mdslot.disk = new MdDisk();
                }
                mdslot.disk.mdRecNum = n;
                mdslot.disk.instNum = this.instNum;
                mdslot.disk.fileName = new String(this.fileName);
                mdslot.disk.path = this.path;
                file = new File(mdslot.disk.path, mdslot.disk.fileName + TMP);
                file.createNewFile();
                if ((mdslot.state & 0x1000L) != 0L) {
                    this.writeHeader(n, 'D');
                    this.writeMetadata(n, 'D', mdslot);
                } else if ((mdslot.state & 0x2000000L) != 0L) {
                    this.writeHeader(n, 'S');
                    this.writeMetadata(n, 'S', mdslot);
                } else {
                    this.writeHeader(n, 'M');
                    this.writeMetadata(n, 'M', mdslot);
                }
                l = 8L;
            }
        }
        catch (Exception exception) {
            if (!bl && file != null) {
                file.delete();
            }
            throw DiskCacheV1013.diskExceptionHandler(exception);
        }
        finally {
            this.lock.releaseLock();
            this.mdClose();
        }
        return l;
    }

    void updateSlot(Mdslot mdslot) throws DiskCacheException {
        if (!this.objectDir.exists()) {
            this.objectDir.mkdirs();
        }
        mdslot.objStatus.fileSize = new File(mdslot.disk.path, mdslot.disk.fileName).length();
        File file = new File(mdslot.disk.path, mdslot.disk.fileName + TMP);
        if (file.exists()) {
            file.delete();
        }
    }

    void invalidate(Mdslot mdslot) throws DiskCacheException {
        if (!this.objectDir.exists()) {
            this.objectDir.mkdirs();
        }
        try {
            this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
            this.lock.getLock(this.mdFileHdl);
            this.checkForUpdates(false, mdslot.name, mdslot.qualifier);
            this.getStatus(mdslot.disk.mdRecNum);
            if (mdslot.disk.instNum == this.instNum) {
                ++this.instNum;
                mdslot.disk.instNum = this.instNum;
                this.writeStatus(mdslot.disk.mdRecNum, 'F');
                this.writeHeader(mdslot.disk.mdRecNum, 'F');
            }
        }
        catch (Exception exception) {
            throw DiskCacheV1013.diskExceptionHandler(exception);
        }
        finally {
            this.lock.releaseLock();
            this.mdClose();
        }
    }

    long freeSlot(Object object, String string, int n, int n2) throws DiskCacheException {
        long l = 0L;
        if (!this.objectDir.exists()) {
            this.objectDir.mkdirs();
        }
        try {
            File file = new File(this.path + File.separator + string);
            l = file.length();
            if (!file.delete()) {
                this.logger_.log(Level.INFO, "[Dsk] freeSlot failed to delete " + file);
            }
            file = new File(this.path + File.separator + string + TMP);
            file.delete();
            return l;
        }
        catch (Exception exception) {
            throw DiskCacheV1013.diskExceptionHandler(exception);
        }
    }

    void checkForUpdates() throws DiskCacheException {
        this.checkForUpdates(true, null, null);
    }

    private void checkForUpdates(boolean bl, Object object, String string) throws DiskCacheException {
        if (bl && !this.objectDir.exists()) {
            this.objectDir.mkdirs();
        }
        int n = 0;
        try {
            if (bl) {
                this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
                this.lock.getLock(this.mdFileHdl);
            }
            if (this.updateNeeded()) {
                if (this.idx == null) {
                    this.growIdx();
                }
                this.startScan();
                while ((n = this.findNextUpdate()) >= 0) {
                    if (object != null && object.equals(this.name) && string.equals(this.qualifier)) continue;
                    this.bucket.updateDisk(this);
                    if (this.idx.length <= n) {
                        this.growIdx();
                    }
                    this.idx[n].instNum = this.instNum;
                    this.idx[n].status = this.status;
                }
                this.setGinst();
            }
        }
        catch (Exception exception) {
            throw DiskCacheV1013.diskExceptionHandler(exception);
        }
        finally {
            if (bl) {
                this.lock.releaseLock();
                this.mdClose();
            }
        }
    }

    void loadFromDisk(String string, boolean bl) throws DiskCacheException {
        if (!this.objectDir.exists() || this.objectDir.list().length == 0) {
            return;
        }
        try {
            if (this.idx == null) {
                this.growIdx();
            }
            this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
            if (bl) {
                this.lock.getLock(this.mdFileHdl);
            }
            this.setGinst();
            this.startScan();
            while (this.getNextRec()) {
                if (!this.readRecord() || string != null && !string.equals(this.qualifier)) continue;
                this.bucket.updateDisk(this);
                if (this.idx.length <= this.currRec) {
                    this.growIdx();
                }
                this.idx[this.currRec].instNum = this.instNum;
                this.idx[this.currRec].status = this.status;
            }
        }
        catch (Exception exception) {
            throw DiskCacheV1013.diskExceptionHandler(exception);
        }
        finally {
            this.mdClose();
            if (bl) {
                this.lock.releaseLock();
            }
        }
    }

    boolean getNextFile(String string) throws DiskCacheException {
        if (!this.objectDir.exists() || this.objectDir.list().length == 0) {
            return false;
        }
        try {
            if (this.mdFileHdl == null) {
                this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
                this.seekPtr = 0L;
            }
            while (this.getNextRec()) {
                File file;
                if (!this.readRecord() || string != null && !string.equals(this.qualifier) || (file = new File(this.path, this.fileName + TMP)).exists()) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw DiskCacheV1013.diskExceptionHandler(exception);
        }
    }

    void close() {
        this.mdClose();
    }

    /*
     * Loose catch block
     */
    void migrateFile(DiskCache diskCache) throws DiskCacheException {
        block17: {
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            block16: {
                int n;
                fileInputStream = null;
                fileOutputStream = null;
                byte[] byArray = new byte[8192];
                Mdslot mdslot = new Mdslot();
                mdslot.qualifier = diskCache.qualifier;
                mdslot.name = diskCache.name;
                mdslot.timeToLive = diskCache.timeToLive;
                mdslot.ttlInterval = diskCache.ttlInterval;
                mdslot.idleTime = diskCache.idleTime;
                mdslot.version = diskCache.version;
                mdslot.state = diskCache.flags | diskCache.storType;
                mdslot.cacheCtx = this.cacheCtx;
                mdslot.objStatus.fileSize = diskCache.fileSize;
                if (!this.objectDir.exists()) {
                    this.objectDir.mkdirs();
                }
                this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
                this.generateName();
                int n2 = this.findFree(0);
                while (this.getStatus(n2) != 'F') {
                    n2 = this.findFree(n2 + 1);
                }
                ++this.instNum;
                mdslot.disk = new MdDisk();
                mdslot.disk.mdRecNum = n2;
                mdslot.disk.instNum = this.instNum;
                mdslot.disk.fileName = new String(this.fileName);
                mdslot.disk.path = this.path;
                File file = new File(diskCache.path, diskCache.fileName);
                File file2 = new File(this.path, this.fileName);
                fileInputStream = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                while ((n = fileInputStream.read(byArray)) > 0) {
                    fileOutputStream.write(byArray, 0, n);
                }
                if ((mdslot.state & 0x1000L) != 0L) {
                    this.writeHeader(n2, 'D');
                    this.writeMetadata(n2, 'D', mdslot);
                    break block16;
                }
                if ((mdslot.state & 0x2000000L) != 0L) {
                    this.writeHeader(n2, 'S');
                    this.writeMetadata(n2, 'S', mdslot);
                    break block16;
                }
                this.writeHeader(n2, 'M');
                this.writeMetadata(n2, 'M', mdslot);
            }
            Object var12_10 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                break block17;
            }
            catch (Exception exception) {
                // empty catch block
            }
            {
                break block17;
                catch (Exception exception) {
                    throw DiskCacheV1013.diskExceptionHandler(exception);
                }
            }
            catch (Throwable throwable) {
                Object var12_11 = null;
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mdClose();
                throw throwable;
            }
        }
        this.mdClose();
    }

    CacheCtx getCacheCtx() {
        return this.cacheCtx;
    }

    private boolean getRecord(int n) throws DiskCacheException {
        try {
            this.getRec(n);
            return this.readRecord();
        }
        catch (Exception exception) {
            throw DiskCacheV1013.diskExceptionHandler(exception);
        }
    }

    private boolean getHeader() throws IOException {
        this.getRec(0);
        return this.readStatus();
    }

    private boolean readRecord() throws IOException, ClassNotFoundException {
        if (this.readStatus()) {
            this.readBase();
            if (this.isLoading()) {
                this.storType = 0x4000000L;
            }
            return true;
        }
        return false;
    }

    private boolean readStatus() throws IOException {
        this.status = this.getNextChar();
        this.useov = this.getNextChar();
        this.instNum = (int)this.getNextNum();
        this.version = this.getNextNum();
        switch (this.status) {
            case 'F': 
            case 'I': {
                return false;
            }
            case 'D': {
                this.storType = 4096L;
                break;
            }
            case 'M': {
                this.storType = 16384L;
                break;
            }
            case 'S': {
                this.storType = 0x2000000L;
            }
        }
        return true;
    }

    private void readBase() throws IOException, ClassNotFoundException {
        int n = (int)this.getNextNum();
        int n2 = (int)this.getNextNum();
        int n3 = (int)this.getNextNum();
        this.timeToLive = this.getNextNum();
        this.ttlInterval = this.getNextNum();
        this.idleTime = (int)this.getNextNum();
        this.flags = this.getNextNum();
        this.oSize = this.getNextNum();
        this.mdRecNum = (int)this.getNextNum();
        this.fileName = this.getNextString(n3);
        this.fileSize = new File(this.path, this.fileName).length();
        if (this.useov == 'O') {
            long l;
            int n4 = n + n2;
            this.overFlow = l = this.getNextNum();
            this.ovBuf = new byte[n4];
            this.ovPtr = 0;
            if (this.ovFileHdl == null) {
                this.ovFileHdl = new RandomAccessFile(this.ovFile, "rw");
            }
            this.ovFileHdl.seek(l);
            this.ovFileHdl.read(this.ovBuf, 0, n4);
            this.qualifier = this.getNextOString(n);
            this.name = this.getNextOObject(n2, this.qualifier);
        } else {
            this.qualifier = this.getNextString(n);
            this.name = this.getNextObject(n2, this.qualifier);
            this.overFlow = -1L;
        }
    }

    private String getNextOString(int n) {
        String string = new String(this.ovBuf, this.ovPtr, n);
        this.ovPtr += n;
        return string;
    }

    private String getNextString(int n) {
        String string = new String(this.buffer, this.bufPtr, n);
        this.bufPtr += n;
        return string;
    }

    private Object getNextOObject(int n, String string) throws IOException {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.ovBuf, this.ovPtr, n);
            CacheObjectInputStream cacheObjectInputStream = new CacheObjectInputStream(byteArrayInputStream, this.cacheCtx, string);
            object = cacheObjectInputStream.readObject();
            this.ovPtr += n;
        }
        catch (ClassNotFoundException classNotFoundException) {
            CacheInternal.exceptionLog("[Dsk] ", classNotFoundException);
        }
        return object;
    }

    private Object getNextObject(int n, String string) throws IOException {
        Object object = null;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buffer, this.bufPtr, n);
            CacheObjectInputStream cacheObjectInputStream = new CacheObjectInputStream(byteArrayInputStream, this.cacheCtx, string);
            object = cacheObjectInputStream.readObject();
            this.bufPtr += n;
        }
        catch (ClassNotFoundException classNotFoundException) {
            CacheInternal.exceptionLog("[Dsk] ", classNotFoundException);
        }
        return object;
    }

    private char getNextChar() {
        char c = (char)this.buffer[this.bufPtr];
        ++this.bufPtr;
        return c;
    }

    private long getNextNum() {
        long l;
        long l2 = this.buffer[this.bufPtr++];
        while ((l = (long)this.buffer[this.bufPtr++]) != 127L) {
            l2 = (l2 << 6) + l;
        }
        return l2;
    }

    private void mdClose() {
        try {
            if (this.mdFileHdl != null) {
                this.mdFileHdl.close();
                this.mdFileHdl = null;
                this.bufPtr = 0;
            }
            if (this.ovFileHdl != null) {
                this.ovFileHdl.close();
                this.ovFileHdl = null;
                this.ovPtr = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean getNextRec() throws IOException {
        int n;
        if (this.buffer == null) {
            this.buffer = new byte[256];
        }
        if ((n = this.mdFileHdl.read(this.buffer, 0, 256)) < 0) {
            return false;
        }
        this.seekPtr += 256L;
        this.bufPtr = 0;
        ++this.currRec;
        return true;
    }

    private void getRec(int n) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[256];
        }
        this.mdFileHdl.seek(n * 256);
        int n2 = this.mdFileHdl.read(this.buffer, 0, 256);
        if (n2 == -1) {
            this.initRec(this.buffer);
        }
        this.bufPtr = 0;
    }

    private void initRec(byte[] byArray) {
        int n = 0;
        n = this.charToByte(byArray, n, 'F');
        n = this.charToByte(byArray, n, 'N');
        n = this.longToByte(byArray, n, 0L);
        n = this.longToByte(byArray, n, 0L);
    }

    private void writeMetadata(int n, char c, Mdslot mdslot) throws IOException {
        int n2 = 0;
        byte[] byArray = new byte[256];
        byte[] byArray2 = mdslot.qualifier.getBytes();
        int n3 = byArray2.length;
        byte[] byArray3 = mdslot.disk.fileName.getBytes();
        int n4 = byArray3.length;
        byte[] byArray4 = this.objectToByte(mdslot.name);
        int n5 = byArray4.length;
        if (!this.gInstSet) {
            this.setGinst();
        }
        long l = n * 256;
        int n6 = n2 = this.charToByte(byArray, n2, c);
        n2 = this.charToByte(byArray, n2, 'N');
        n2 = this.longToByte(byArray, n2, mdslot.disk.instNum);
        n2 = this.longToByte(byArray, n2, mdslot.version);
        n2 = this.longToByte(byArray, n2, n3);
        n2 = this.longToByte(byArray, n2, n5);
        n2 = this.longToByte(byArray, n2, n4);
        n2 = this.longToByte(byArray, n2, mdslot.timeToLive);
        n2 = this.longToByte(byArray, n2, mdslot.ttlInterval);
        n2 = this.longToByte(byArray, n2, mdslot.idleTime);
        n2 = this.longToByte(byArray, n2, mdslot.state & 0x40C2532A00L);
        n2 = this.longToByte(byArray, n2, mdslot.objStatus.size);
        n2 = this.longToByte(byArray, n2, n);
        n2 = this.byteToByte(byArray, n2, byArray3);
        this.mdFileHdl.seek(l);
        int n7 = n3 + n5;
        if (n7 > 256 - n2) {
            this.charToByte(byArray, n6, 'O');
            byte[] byArray5 = new byte[n7];
            n6 = 0;
            n6 = this.byteToByte(byArray5, n6, byArray2);
            n6 = this.byteToByte(byArray5, n6, byArray4);
            this.ovFileHdl = new RandomAccessFile(this.ovFile, "rw");
            mdslot.disk.overFlow = this.ovFileHdl.length();
            this.ovFileHdl.seek(mdslot.disk.overFlow);
            this.ovFileHdl.write(byArray5);
            n2 = this.longToByte(byArray, n2, mdslot.disk.overFlow);
        } else {
            n2 = this.byteToByte(byArray, n2, byArray2);
            n2 = this.byteToByte(byArray, n2, byArray4);
            mdslot.disk.overFlow = -1L;
        }
        this.mdFileHdl.write(byArray);
    }

    private void generateName() throws IOException {
        if (this.fileTag < 0L) {
            this.getTag();
        }
        this.fileName = this.buckNum + SEP + this.fileTag + SEP + this.localTag;
        ++this.localTag;
    }

    static int longToByte(byte[] byArray, int n, long l, int n2) {
        int n3 = n + n2;
        int n4 = n3 - 1;
        for (int i = n2; i > 0; --i) {
            if (l > 0L) {
                byArray[n4] = (byte)(l & 0x3FL);
                l >>= 6;
            } else {
                byArray[n4] = 0;
            }
            --n4;
        }
        byArray[n3++] = 127;
        return n3;
    }

    private int longToByte(byte[] byArray, int n, long l) {
        int n2 = l2bMask.length;
        while (n2 > 0 && (l & l2bMask[--n2]) == 0L) {
        }
        n += n2 + 1;
        n2 = n + 1;
        byArray[n--] = 127;
        do {
            byArray[n--] = (byte)(l & 0x3FL);
        } while ((l >>= 6) > 0L);
        return n2;
    }

    private byte[] objectToByte(Object object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0);
        CacheObjectOutputStream cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
        cacheObjectOutputStream.writeObject(object);
        return byteArrayOutputStream.toByteArray();
    }

    private int charToByte(byte[] byArray, int n, char c) {
        byArray[n++] = (byte)c;
        return n;
    }

    private int byteToByte(byte[] byArray, int n, byte[] byArray2) {
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return n + byArray2.length;
    }

    private char getStatus(int n) throws IOException {
        this.getRec(n);
        this.readStatus();
        return this.status;
    }

    boolean isValid() {
        return this.status != 'I' && this.status != 'F';
    }

    boolean isLoading() {
        File file = new File(this.path, this.fileName + TMP);
        return file.exists();
    }

    boolean isLoaded(Mdslot mdslot) {
        File file = new File(mdslot.disk.path, mdslot.disk.fileName + TMP);
        return !file.exists();
    }

    boolean isLocal() {
        return this.isLocal;
    }

    void dump(int n, OutputStreamWriter outputStreamWriter) throws IOException {
        String string = this.dump();
        if (!string.equals("")) {
            outputStreamWriter.write("<<< Bucket " + n + " Disk metadata >>>" + string);
        }
    }

    boolean haveFiles() {
        File file = new File(this.mdFile);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String dump() {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            if (!this.objectDir.exists()) {
                String string = "";
                return string;
            }
            this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
            this.startScan();
            while (this.getNextRec()) {
                if (!this.readRecord()) continue;
                stringBuffer.append(this.toString());
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.mdClose();
            this.currRec = 0;
            this.seekPtr = 0L;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "\n Qualifier=" + this.qualifier + " Name=" + this.name + " FileName=" + this.fileName + " Path=" + this.path + " Record Number=" + this.mdRecNum + " Instance Number=" + this.instNum + " TimeToLive=" + this.timeToLive + " FileSize=" + this.fileSize + " Size=" + this.oSize + " Status=" + this.status + " Storage Type=" + this.storType;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[1]);
        DiskCacheV1013 diskCacheV1013 = new DiskCacheV1013(stringArray[0], n, true, null);
        System.err.println("dumping diskcache: " + ((DiskCache)diskCacheV1013).dump());
    }

    private void setGinst() throws IOException {
        if (this.mdFileHdl.length() < 256L) {
            this.initHeader();
        } else {
            this.getHeader();
        }
        this.gInst = this.instNum;
        this.gInstSet = true;
    }

    private void getTag() throws IOException {
        if (this.mdFileHdl.length() < 256L) {
            this.initHeader();
        }
        this.getHeader();
        this.fileTag = this.version++;
        this.writeStatus(0, 'I');
        this.gInst = this.instNum;
        this.gInstSet = true;
    }

    private boolean updateNeeded() throws IOException {
        if (this.mdFileHdl == null) {
            this.mdFileHdl = new RandomAccessFile(this.mdFile, "rw");
        }
        this.getHeader();
        return this.gInst != this.instNum;
    }

    private int findNextUpdate() throws IOException, ClassNotFoundException {
        if (this.buffer == null) {
            this.buffer = new byte[256];
        }
        while (this.getNextRec()) {
            if (!this.readStatus() || this.idx != null && this.currRec < this.idx.length && this.instNum == this.idx[this.currRec].instNum) continue;
            this.readBase();
            return this.currRec;
        }
        return -1;
    }

    private void writeHeader(int n, char c) throws IOException {
        this.idx[n].instNum = this.instNum++;
        this.idx[n].status = c;
        this.getHeader();
        this.gInst = this.instNum;
        this.writeStatus(0, 'I');
    }

    private void initHeader() throws IOException {
        this.instNum = 0;
        this.version = 0L;
        this.writeStatus(0, 'I');
        if (this.idx == null) {
            this.growIdx();
        }
    }

    private void writeStatus(int n, char c) throws IOException {
        byte[] byArray = new byte[18];
        int n2 = this.charToByte(byArray, 0, c);
        n2 = this.charToByte(byArray, n2, 'N');
        n2 = this.longToByte(byArray, n2, this.instNum);
        n2 = this.longToByte(byArray, n2, this.version);
        this.mdFileHdl.seek(n * 256);
        this.mdFileHdl.write(byArray, 0, n2);
    }

    private int findFree(int n) {
        int n2 = 0;
        if (this.idx != null) {
            n2 = this.idx.length;
        }
        for (int i = n; i < n2; ++i) {
            if (i == 0 || this.idx[i].status != 'F') continue;
            return i;
        }
        this.growIdx();
        if (n2 == 0) {
            return 1;
        }
        return n2;
    }

    private void growIdx() {
        int n = 0;
        if (this.idx != null) {
            n = this.idx.length;
        }
        int n2 = n + 100;
        IdxEntry[] idxEntryArray = new IdxEntry[n2];
        if (this.idx != null) {
            System.arraycopy(this.idx, 0, idxEntryArray, 0, n);
        }
        this.idx = idxEntryArray;
        for (int i = n; i < n2; ++i) {
            this.idx[i] = new IdxEntry();
            this.idx[i].instNum = -1;
            this.idx[i].status = (char)70;
        }
    }

    private void startScan() {
        this.currRec = 0;
        this.seekPtr = 256L;
    }

    private class IdxEntry {
        int instNum;
        char status;

        private IdxEntry() {
        }
    }
}

