/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.IOException;
import java.io.OutputStreamWriter;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.DiskCacheException;
import oracle.ias.cache.Mdslot;

abstract class DiskCache {
    String qualifier = null;
    Object name = null;
    long timeToLive = 0L;
    long ttlInterval = 0L;
    int idleTime = 0;
    long version = 0L;
    long flags = 0L;
    String fileName = null;
    String path = null;
    int mdRecNum = 0;
    int instNum = 0;
    long fileSize = 0L;
    long oSize = 0L;
    long overFlow = 0L;
    long storType = 0L;

    DiskCache() {
    }

    abstract long checkDisk(Mdslot var1) throws DiskCacheException;

    abstract void updateSlot(Mdslot var1) throws DiskCacheException;

    abstract void invalidate(Mdslot var1) throws DiskCacheException;

    abstract long freeSlot(Object var1, String var2, int var3, int var4) throws DiskCacheException;

    abstract void checkForUpdates() throws DiskCacheException;

    abstract void loadFromDisk(String var1, boolean var2) throws DiskCacheException;

    abstract boolean getNextFile(String var1) throws DiskCacheException;

    abstract void migrateFile(DiskCache var1) throws DiskCacheException;

    abstract CacheCtx getCacheCtx();

    abstract boolean isValid();

    abstract boolean isLoading();

    abstract boolean isLoaded(Mdslot var1);

    abstract boolean isLocal();

    abstract void dump(int var1, OutputStreamWriter var2) throws IOException;

    abstract String dump();

    abstract void close();

    abstract boolean haveFiles();

    static DiskCacheException diskExceptionHandler(Exception exception) {
        CacheInternal.exceptionLog("[Dsk] ", exception);
        if (exception instanceof DiskCacheException) {
            return (DiskCacheException)exception;
        }
        DiskCacheException diskCacheException = new DiskCacheException(exception.toString(), exception);
        diskCacheException.setLogged();
        return diskCacheException;
    }
}

