/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.CacheException;

public abstract class CacheLogger
extends Logger {
    public static final int OFF = -1;
    public static final int FATAL = 0;
    public static final int ERROR = 3;
    public static final int DEFAULT = 4;
    public static final int WARNING = 6;
    public static final int TRACE = 7;
    public static final int INFO = 10;
    public static final int DEBUG = 15;
    static final String[] SEVERITYNAMES = new String[]{"OFF", "FATAL", "ERROR", "DEFAULT", "WARNING", "TRACE", "INFO", "DEBUG"};
    static final int[] SEVERITYLEVELS = new int[]{-1, 0, 3, 4, 6, 7, 10, 15};
    protected int severity = 4;
    protected String logFileName = null;

    public abstract void log(String var1);

    public abstract void log(String var1, Throwable var2);

    public abstract void flush();

    public abstract void init(String var1, int var2) throws CacheException;

    public int getSeverity() {
        return this.severity;
    }

    public String getLogFileName() {
        return new File(this.logFileName).getAbsolutePath();
    }

    public boolean shouldLog(int n) {
        return n <= this.severity;
    }

    public void setSeverity(int n) {
        this.severity = n > 15 ? 15 : (n < -1 ? -1 : n);
    }

    public static int parseLogSeverity(String string) {
        int n = 4;
        if (string == null) {
            return n;
        }
        for (int i = 0; i < SEVERITYLEVELS.length; ++i) {
            if (!string.equalsIgnoreCase(SEVERITYNAMES[i])) continue;
            n = SEVERITYLEVELS[i];
            break;
        }
        return n;
    }

    public static String severityToString(int n) {
        String string = null;
        for (int i = 0; i < SEVERITYLEVELS.length; ++i) {
            if (n != SEVERITYLEVELS[i]) continue;
            string = SEVERITYNAMES[i];
            break;
        }
        return string;
    }

    public CacheLogger() {
        super("oracle.ias.cache.CacheLogger", null);
    }

    public CacheLogger(String string, String string2) {
        super(string, string2);
    }

    static Level getMappedLogLevel(int n) {
        Level level = Level.SEVERE;
        switch (n) {
            case -1: {
                level = Level.OFF;
                break;
            }
            case 0: 
            case 3: 
            case 4: {
                level = Level.SEVERE;
                break;
            }
            case 6: {
                level = Level.WARNING;
                break;
            }
            case 7: {
                level = Level.INFO;
                break;
            }
            case 10: {
                level = Level.FINE;
                break;
            }
            case 15: {
                level = Level.FINEST;
            }
        }
        return level;
    }
}

