/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheEventListener;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.DiskCacheException;
import oracle.ias.cache.InvalidObjectException;
import oracle.ias.cache.Mdslot;
import oracle.ias.cache.ObjectExistsException;

public abstract class CacheLoader {
    private static final String LOGGER_NAME = "oracle.ias.cache.CacheLoader";
    protected CacheCtx m_ctx = null;
    protected Logger logger_;

    protected Object callLoad(CacheHandle cacheHandle, Object object) throws CacheException {
        this.m_ctx = cacheHandle.cacheCtx;
        return this.load(cacheHandle, object);
    }

    public abstract Object load(Object var1, Object var2) throws CacheException;

    protected final Object netSearch(Object object, int n) throws CacheException {
        return ((CacheHandle)object).netSearch(n);
    }

    protected final Object netSearch(Object object, int n, boolean bl) throws CacheException {
        return ((CacheHandle)object).netSearch(n, bl);
    }

    protected final boolean isRemoteRequest(Object object) {
        return ((CacheHandle)object).isRemoteRequest();
    }

    protected final Object getFromRemote(Object object, CacheAddress cacheAddress, int n, boolean bl) throws CacheException {
        return ((CacheHandle)object).getFromRemote(cacheAddress, n, bl);
    }

    protected final void setAttributes(Object object, Attributes attributes) throws CacheException {
        CacheHandle cacheHandle = (CacheHandle)object;
        Mdslot mdslot = cacheHandle.slot;
        try {
            cacheHandle.setAttributes(attributes);
        }
        catch (InvalidObjectException invalidObjectException) {
            if (attributes.handlers != null) {
                if (mdslot.eventHandlers == null) {
                    mdslot.eventHandlers = new CacheEventListener[6];
                    mdslot.eventDefault = new boolean[6];
                }
                if (attributes.handlerSet[0]) {
                    mdslot.eventHandlers[0] = attributes.handlers[0];
                }
            }
        }
        catch (IOException iOException) {
            throw new CacheException(CacheInternal.EXP_INTERNAL, iOException);
        }
    }

    protected final Object getName(Object object) {
        return ((CacheHandle)object).slot.name;
    }

    protected final String getRegion(Object object) {
        return ((CacheHandle)object).slot.qualifier;
    }

    protected final OutputStream createStream(Object object, Attributes attributes) throws ObjectExistsException, DiskCacheException, CacheException {
        CacheHandle cacheHandle = (CacheHandle)object;
        if (attributes != null) {
            this.setAttributes(object, attributes);
        }
        return cacheHandle.createStream();
    }

    protected final OutputStream createStream(Object object) throws ObjectExistsException, DiskCacheException, CacheException, IOException {
        return this.createStream(object, null);
    }

    protected final File createDiskObject(Object object, Attributes attributes) throws ObjectExistsException, DiskCacheException, CacheException, IOException {
        CacheHandle cacheHandle = (CacheHandle)object;
        if (attributes != null) {
            this.setAttributes(object, attributes);
        }
        cacheHandle.slot.state |= 0x1000L;
        File file = cacheHandle.getDiskFile();
        cacheHandle.slot.object = file.getAbsolutePath();
        return file;
    }

    protected final File createDiskObject(Object object) throws ObjectExistsException, DiskCacheException, CacheException, IOException {
        return this.createDiskObject(object, null);
    }

    protected final CacheException exceptionHandler(String string, Exception exception) {
        return CacheInternal.exceptionHandler(CacheInternal.EXP_LOAD + " " + string, exception);
    }

    protected final void log(String string) {
        if (this.logger_ == null) {
            this.logger_ = this.m_ctx != null ? this.m_ctx.getLogger(LOGGER_NAME) : Logger.getLogger(LOGGER_NAME);
        }
        this.logger_.log(Level.INFO, "[Ldr] " + string);
    }
}

