/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheNotAvailableException;
import oracle.ias.cache.Mdslot;
import oracle.ias.cache.RegionCount;
import oracle.ias.cache.ThreadPool;

class CacheDmsRefresh
implements GroupRefresh {
    private Noun m_noun;
    private Mdslot m_slot;
    private boolean m_root;
    private boolean m_hasDisk;
    int cnt = 0;

    CacheDmsRefresh(Noun noun) {
        this.m_root = true;
        this.m_noun = noun;
        this.m_slot = null;
        this.m_hasDisk = true;
    }

    CacheDmsRefresh(Noun noun, Mdslot mdslot, boolean bl) {
        this.m_noun = noun;
        this.m_slot = mdslot;
        this.m_root = false;
        this.m_hasDisk = bl;
    }

    public void refresh() {
        State state = null;
        State state2 = null;
        State state3 = null;
        State state4 = null;
        State state5 = null;
        State state6 = null;
        State state7 = null;
        State state8 = null;
        State state9 = (State)this.m_noun.getSensor("memory_size");
        State state10 = (State)this.m_noun.getSensor("memory_object_count");
        state4 = (State)this.m_noun.getSensor("worker_thread_count");
        state5 = (State)this.m_noun.getSensor("task_count");
        state6 = (State)this.m_noun.getSensor("response_q_size");
        state7 = (State)this.m_noun.getSensor("time_q_size");
        if (this.m_hasDisk) {
            state2 = (State)this.m_noun.getSensor("disk_Size");
        }
        if (this.m_root) {
            state9.update(CacheInternal.curCacheSize);
            state10.update(CacheInternal.curObjCnt);
            state4.update(ThreadPool.runThreads);
            state5.update(CacheInternal.asyncTaskQ.count);
            state6.update(CacheInternal.respQ.getSize());
            state7.update(CacheInternal.ttlQ.count);
            if (CacheInternal.diskManager != null) {
                try {
                    state2.update(CacheInternal.diskManager.getLocalDiskCacheSize());
                }
                catch (CacheNotAvailableException cacheNotAvailableException) {
                    state2.update(0);
                }
            }
        } else {
            if (this.m_hasDisk) {
                state3 = (State)this.m_noun.getSensor("disk_Count");
                state = (State)this.m_noun.getSensor("disk_average_load_time");
            }
            State state11 = (State)this.m_noun.getSensor("memory_average_load_time");
            state8 = (State)this.m_noun.getSensor("memory_object_access_count");
            RegionCount regionCount = this.m_slot.regionCount[0];
            state9.update(regionCount.getsize());
            state10.update(regionCount.getCount());
            if (this.m_hasDisk) {
                state2.update(regionCount.getDiskSize());
                state3.update(regionCount.getDiskCount());
                state.update(this.m_slot.groupInfo.aggDiskStatus.getLoadTime(1));
            }
            state11.update(this.m_slot.groupInfo.aggStatus.getLoadTime(1));
            state8.update(this.m_slot.groupInfo.aggStatus.getAccessCount(1));
        }
    }
}

