/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.AggregateStatus;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheNotAvailableException;
import oracle.ias.cache.InvalidArgumentException;
import oracle.ias.cache.InvalidHandleException;
import oracle.ias.cache.NotAPoolException;
import oracle.ias.cache.NullObj;
import oracle.ias.cache.NullObjectException;
import oracle.ias.cache.NullObjectNameException;
import oracle.ias.cache.ObjectExistsException;
import oracle.ias.cache.ObjectNotFoundException;
import oracle.ias.cache.ObjectStatus;
import oracle.ias.cache.PoolAccess;
import oracle.ias.cache.PoolInstanceFactory;
import oracle.ias.cache.RegionNotFoundException;
import oracle.ias.cache.TimeoutException;

public class CacheAccess {
    static final String DEF_QUAL_ = "oracle_java_cache_service";
    static final String DEF_GROUP_NAME_ = "oracle_java_cache_service";
    static final String SUBREGION_DELIM = "/";
    static final String LOGGER_NAME = "oracle.ias.cache.CacheAccess";
    static CacheAttributes defcacheattr_;
    static Logger s_logger;
    private String region_ = null;
    private String owned_ = null;
    private CacheHandle grphandle_ = null;
    private CacheCtx ctx_ = null;

    private CacheHandle getHandle() throws InvalidHandleException, RegionNotFoundException {
        return this.getHandle(false);
    }

    private CacheHandle getHandle(boolean bl) throws InvalidHandleException, RegionNotFoundException {
        if (this.ctx_ == null) {
            this.ctx_ = CacheInternal.getCacheCtx(this.region_);
            if (this.ctx_ == null) {
                CacheCtx cacheCtx;
                if (bl && (cacheCtx = CacheInternal.defaultCtx) != null) {
                    return cacheCtx.getHandle();
                }
                throw new RegionNotFoundException(CacheInternal.EXP_NOREGION + ": \"" + this.region_ + "\"");
            }
            this.grphandle_ = this.ctx_.getHandle();
        }
        if (this.grphandle_ == null) {
            throw new InvalidHandleException(CacheInternal.EXP_INVALHDL);
        }
        return this.grphandle_;
    }

    private void releaseHandle() {
        try {
            if (this.grphandle_ != null) {
                this.ctx_.releaseHandle(this.grphandle_);
                this.grphandle_ = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean initCacheService() {
        boolean bl = true;
        try {
            if (!CacheInternal.isReady()) {
                if (!CacheInternal.autoInit()) {
                    return false;
                }
                CacheInternal.open("javacache.properties");
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    private static boolean isRegionExist(String string) {
        boolean bl = false;
        try {
            bl = CacheHandle.regionExists(string, string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private String getDefGrpName() {
        return this.getRegionName();
    }

    private static CacheException exceptionHandler(String string, Exception exception) {
        return CacheInternal.exceptionHandler(CacheInternal.EXP_EXCEPTIONIN + " " + string, exception);
    }

    private static void createSubRegions(String string, String string2, Attributes attributes) throws CacheException {
        CacheAccess cacheAccess = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, SUBREGION_DELIM);
        try {
            if (string == null && !CacheAccess.isRegionExist(string = stringTokenizer.nextToken())) {
                try {
                    CacheAccess.defineRegion(string, attributes);
                }
                catch (ObjectExistsException objectExistsException) {
                    // empty catch block
                }
            }
            cacheAccess = new CacheAccess(string);
            CacheCtx cacheCtx = CacheInternal.getCacheCtx(string);
            CacheHandle cacheHandle = cacheAccess.getHandle();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = string + SUBREGION_DELIM + string3;
                if (!CacheAccess.isRegionExist(string4)) {
                    try {
                        cacheHandle.createRegion(string4, string, attributes, cacheCtx);
                    }
                    catch (ObjectExistsException objectExistsException) {
                        // empty catch block
                    }
                }
                string = string + SUBREGION_DELIM + string3;
            }
        }
        catch (CacheException cacheException) {
            throw cacheException;
        }
        catch (Exception exception) {
            throw CacheAccess.exceptionHandler("CacheAccess.defineRegion", exception);
        }
        finally {
            if (cacheAccess != null) {
                cacheAccess.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void defineRegion(String string, Attributes attributes) throws CacheNotAvailableException, NullObjectNameException, ObjectExistsException, CacheException {
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        CacheCtx cacheCtx = CacheInternal.getCacheCtx("000DEFAULT_CONTEXT$$");
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "defineRegion(\"" + string + "\", " + attributes + ")");
        }
        try {
            try {
                if (string == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = cacheCtx.getHandle();
                cacheHandle.createRegion(string, null, attributes, null);
                cacheHandle.setRegionNumber();
                cacheCtx.releaseHandle(cacheHandle);
                cacheHandle = null;
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.defineRegion", exception);
            }
            Object var7_6 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public static void defineRegion(String string) throws CacheNotAvailableException, NullObjectNameException, ObjectExistsException, CacheException {
        CacheAccess.defineRegion(string, null);
    }

    public static CacheAccess getAccess() throws CacheException {
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (CacheInternal.logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(null, "getAccess()");
        }
        CacheAccess cacheAccess = new CacheAccess(CacheAccess.getDefRegionName());
        if (CacheInternal.logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(null, "return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public static CacheAccess getAccess(String string) throws CacheNotAvailableException {
        CacheAccess cacheAccess = null;
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (CacheInternal.logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(null, "getAccess(\"" + string + "\")");
        }
        cacheAccess = new CacheAccess(string);
        if (CacheInternal.logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(null, "return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public static CacheAccess getAccess(String string, boolean bl) throws CacheNotAvailableException, RegionNotFoundException, CacheException {
        CacheAccess cacheAccess = null;
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (CacheInternal.logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(null, "getAccess(\"" + string + "\", " + bl + ")");
        }
        if (bl && !CacheAccess.isRegionExist(string)) {
            throw CacheAccess.exceptionHandler("CacheAccess.getAccess", new RegionNotFoundException(CacheInternal.EXP_NOREGION + ": \"" + string + "\""));
        }
        cacheAccess = new CacheAccess(string);
        if (CacheInternal.logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(null, "return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public static CacheAccess getAccess(String string, Attributes attributes, boolean bl) throws CacheNotAvailableException, RegionNotFoundException, CacheException {
        CacheAccess cacheAccess = null;
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (CacheInternal.logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(null, "getAccess(\"" + string + "\", " + attributes + ")");
        }
        if (!CacheAccess.isRegionExist(string)) {
            if (bl) {
                CacheAccess.createSubRegions(null, string, attributes);
            } else {
                try {
                    CacheAccess.defineRegion(string, attributes);
                }
                catch (ObjectExistsException objectExistsException) {
                    // empty catch block
                }
            }
        }
        cacheAccess = new CacheAccess(string);
        if (CacheInternal.logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(null, "return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public void defineObject(Object object, Attributes attributes) throws CacheException {
        this.defineObject(object, this.getDefGrpName(), attributes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defineObject(Object object, String string, Attributes attributes) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "defineObject(" + object + ", \"" + string + "\", " + attributes + ")");
        }
        try {
            try {
                if (string == null || object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.register(object, this.getRegionName(), string, attributes);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.defineObject", exception);
            }
            Object var8_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public void resetAttributes(Attributes attributes) throws CacheException, InvalidHandleException {
        this.resetAttributes(this.getDefGrpName(), attributes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void resetAttributes(Object object, Attributes attributes) throws CacheException, InvalidHandleException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "resetAttributes(" + object + ", " + attributes + ")");
        }
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.resetAttributes(object, this.getRegionName(), attributes);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.resetAttributes", exception);
            }
            Object var7_6 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(Object object) throws ObjectNotFoundException, RegionNotFoundException, InvalidHandleException, CacheException {
        Object object2;
        block12: {
            long l;
            block10: {
                block11: {
                    l = 0L;
                    if (s_logger.isLoggable(Level.INFO)) {
                        l = CacheAccess.TRACE(s_logger, "get(" + object + ")");
                    }
                    object2 = null;
                    try {
                        try {
                            if (object == null) {
                                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            }
                            CacheHandle cacheHandle = this.getHandle();
                            object2 = cacheHandle.locateObject(object, this.getRegionName(), this.getDefGrpName(), null);
                        }
                        catch (NullObjectException nullObjectException) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + "\"" + object + "\""));
                        }
                        catch (Exception exception) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", exception);
                        }
                        Object var7_7 = null;
                        if (!s_logger.isLoggable(Level.INFO)) break block10;
                        if (object2 == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var7_8 = null;
                        if (!s_logger.isLoggable(Level.INFO)) {
                            if (!s_logger.isLoggable(Level.FINEST)) throw throwable;
                            CacheAccess.TRACE(s_logger, "return:" + object2, l);
                            throw throwable;
                        }
                        if (object2 != null) {
                            CacheAccess.TRACE(s_logger, "return: " + object2.hashCode() + " " + object2.getClass().getName(), l);
                            throw throwable;
                        }
                        CacheAccess.TRACE(s_logger, "return null", l);
                        throw throwable;
                    }
                    CacheAccess.TRACE(s_logger, "return: " + object2.hashCode() + " " + object2.getClass().getName(), l);
                    break block12;
                }
                CacheAccess.TRACE(s_logger, "return null", l);
                break block12;
            }
            if (s_logger.isLoggable(Level.FINEST)) {
                CacheAccess.TRACE(s_logger, "return:" + object2, l);
            }
        }
        if (!(object2 instanceof NullObj)) return object2;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(Object object, Object object2) throws ObjectNotFoundException, RegionNotFoundException, InvalidHandleException, CacheException {
        Object object3;
        block12: {
            long l;
            block10: {
                block11: {
                    l = 0L;
                    if (s_logger.isLoggable(Level.INFO)) {
                        l = CacheAccess.TRACE(s_logger, "get(" + object + ", " + object2 + ")");
                    }
                    object3 = null;
                    try {
                        try {
                            if (object == null) {
                                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            }
                            CacheHandle cacheHandle = this.getHandle();
                            object3 = cacheHandle.locateObject(object, this.getRegionName(), this.getDefGrpName(), object2);
                        }
                        catch (NullObjectException nullObjectException) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + "\"" + object + "\""));
                        }
                        catch (Exception exception) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", exception);
                        }
                        Object var8_8 = null;
                        if (!s_logger.isLoggable(Level.INFO)) break block10;
                        if (object3 == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (!s_logger.isLoggable(Level.INFO)) {
                            if (!s_logger.isLoggable(Level.FINEST)) throw throwable;
                            CacheAccess.TRACE(s_logger, "return:" + object3, l);
                            throw throwable;
                        }
                        if (object3 != null) {
                            CacheAccess.TRACE(s_logger, "return: " + object3.hashCode() + " " + object3.getClass().getName(), l);
                            throw throwable;
                        }
                        CacheAccess.TRACE(s_logger, "return null", l);
                        throw throwable;
                    }
                    CacheAccess.TRACE(s_logger, "return: " + object3.hashCode() + " " + object3.getClass().getName(), l);
                    break block12;
                }
                CacheAccess.TRACE(s_logger, "return null", l);
                break block12;
            }
            if (s_logger.isLoggable(Level.FINEST)) {
                CacheAccess.TRACE(s_logger, "return:" + object3, l);
            }
        }
        if (!(object3 instanceof NullObj)) return object3;
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(Object object, String string, Object object2) throws ObjectNotFoundException, RegionNotFoundException, InvalidHandleException, CacheException {
        Object object3;
        block12: {
            long l;
            block10: {
                block11: {
                    l = 0L;
                    if (s_logger.isLoggable(Level.INFO)) {
                        l = CacheAccess.TRACE(s_logger, "get(" + object + ", \"" + string + "\", " + object2 + ")");
                    }
                    object3 = null;
                    try {
                        try {
                            if (object == null) throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            if (string == null) {
                                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            }
                            CacheHandle cacheHandle = this.getHandle();
                            object3 = cacheHandle.locateObject(object, this.getRegionName(), string, object2);
                        }
                        catch (NullObjectException nullObjectException) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", new ObjectNotFoundException(CacheInternal.EXP_OBJNFOUND + "\"" + object + "\"", nullObjectException));
                        }
                        catch (Exception exception) {
                            throw CacheAccess.exceptionHandler("CacheAccess.get", exception);
                        }
                        Object var9_9 = null;
                        if (!s_logger.isLoggable(Level.INFO)) break block10;
                        if (object3 == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var9_10 = null;
                        if (!s_logger.isLoggable(Level.INFO)) {
                            if (!s_logger.isLoggable(Level.FINEST)) throw throwable;
                            CacheAccess.TRACE(s_logger, "return:" + object3, l);
                            throw throwable;
                        }
                        if (object3 != null) {
                            CacheAccess.TRACE(s_logger, "return: " + object3.hashCode() + " " + object3.getClass().getName(), l);
                            throw throwable;
                        }
                        CacheAccess.TRACE(s_logger, "return null", l);
                        throw throwable;
                    }
                    CacheAccess.TRACE(s_logger, "return: " + object3.hashCode() + " " + object3.getClass().getName(), l);
                    break block12;
                }
                CacheAccess.TRACE(s_logger, "return null", l);
                break block12;
            }
            if (s_logger.isLoggable(Level.FINEST)) {
                CacheAccess.TRACE(s_logger, "return:" + object3, l);
            }
        }
        if (!(object3 instanceof NullObj)) return object3;
        return null;
    }

    public void loadList(Object[] objectArray) throws RegionNotFoundException, InvalidHandleException, CacheException {
        this.loadList(objectArray, this.getDefGrpName(), null);
    }

    public void loadList(Object[] objectArray, Object object) throws RegionNotFoundException, InvalidHandleException, CacheException {
        this.loadList(objectArray, this.getDefGrpName(), object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadList(Object[] objectArray, String string, Object object) throws RegionNotFoundException, InvalidHandleException, CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "loadList(" + objectArray + ", \"" + string + "\", " + object + ")");
        }
        try {
            try {
                if (objectArray == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.loadList(objectArray, this.getRegionName(), string, object);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.loadList", exception);
            }
            Object var8_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public void preLoad(Object object) throws ObjectNotFoundException, InvalidHandleException, CacheException {
        this.preLoad(object, this.getDefGrpName(), null);
    }

    public void preLoad(Object object, Object object2) throws ObjectNotFoundException, InvalidHandleException, CacheException {
        this.preLoad(object, this.getDefGrpName(), object2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preLoad(Object object, String string, Object object2) throws ObjectNotFoundException, InvalidHandleException, CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "preLoad(" + object + ", \"" + string + "\", " + object2 + ")");
        }
        try {
            try {
                if (object == null || string == null) {
                    throw new ObjectNotFoundException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.preLoadObject(object, this.getRegionName(), string, object2);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.preLoad", exception);
            }
            Object var8_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public void put(Object object, Object object2) throws CacheException {
        this.put(object, this.getDefGrpName(), object2, null);
    }

    public void put(Object object, String string, Object object2) throws CacheException {
        this.put(object, string, object2, null);
    }

    public void put(Object object, Attributes attributes, Object object2) throws CacheException {
        this.put(object, this.getDefGrpName(), object2, attributes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void put(Object object, String string, Object object2, Attributes attributes) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "put(" + object + ", \"" + string + "\", " + object2 + ", " + attributes + ")");
        }
        try {
            try {
                if (object == null || string == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.putObject(object, this.getRegionName(), string, object2, attributes);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.put", exception);
            }
            Object var9_8 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public Object replace(Object object, Object object2) throws CacheException {
        return this.replace(object, this.getDefGrpName(), object2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object replace(Object object, String string, Object object2) throws CacheException, NullObjectException {
        Object object3;
        block11: {
            long l;
            block9: {
                block10: {
                    l = 0L;
                    if (s_logger.isLoggable(Level.INFO)) {
                        l = CacheAccess.TRACE(s_logger, "replace(" + object + ", \"" + string + "\", " + object2 + ")");
                    }
                    object3 = null;
                    try {
                        try {
                            if (object == null) throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            if (string == null) {
                                throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                            }
                            CacheHandle cacheHandle = this.getHandle();
                            object3 = cacheHandle.replaceObject(object, this.getRegionName(), string, object2);
                        }
                        catch (Exception exception) {
                            throw CacheAccess.exceptionHandler("CacheAccess.replace", exception);
                        }
                        Object var9_8 = null;
                        if (!s_logger.isLoggable(Level.INFO)) break block9;
                        if (object3 == null) break block10;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (!s_logger.isLoggable(Level.INFO)) {
                            if (!s_logger.isLoggable(Level.FINEST)) throw throwable;
                            CacheAccess.TRACE(s_logger, "return:" + object3, l);
                            throw throwable;
                        }
                        if (object3 != null) {
                            CacheAccess.TRACE(s_logger, "return: " + object3.hashCode() + ", " + object3.getClass().getName(), l);
                            throw throwable;
                        }
                        CacheAccess.TRACE(s_logger, "return:null", l);
                        throw throwable;
                    }
                    CacheAccess.TRACE(s_logger, "return: " + object3.hashCode() + ", " + object3.getClass().getName(), l);
                    break block11;
                }
                CacheAccess.TRACE(s_logger, "return:null", l);
                break block11;
            }
            if (s_logger.isLoggable(Level.FINEST)) {
                CacheAccess.TRACE(s_logger, "return:" + object3, l);
            }
        }
        if (!(object3 instanceof NullObj)) return object3;
        return null;
    }

    public void replaceRemote(Object object, Object object2, CacheAddress cacheAddress) throws CacheException {
        this.replaceRemote(object, this.getDefGrpName(), object2, cacheAddress);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void replaceRemote(Object object, String string, Object object2, CacheAddress cacheAddress) throws CacheException, NullObjectException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "replaceRemote(" + object + ", \"" + string + "\", " + object2 + ", " + cacheAddress + ")");
        }
        try {
            try {
                if (object == null || string == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.replaceRemoteObject(object, this.getRegionName(), string, object2, cacheAddress);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.replaceRemote", exception);
            }
            Object var9_8 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public void invalidate() throws CacheException {
        this.invalidate(this.getDefGrpName(), false);
    }

    public void invalidate(boolean bl) throws CacheException {
        this.invalidate(this.getDefGrpName(), bl);
    }

    public void invalidate(Object object) throws CacheException {
        this.invalidate(object, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invalidate(Object object, boolean bl) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "invalidate(" + object + ")");
        }
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle(!bl);
                cacheHandle.invalidate(object, this.getRegionName(), bl);
            }
            catch (RegionNotFoundException regionNotFoundException) {
                Object var7_8 = null;
                if (!s_logger.isLoggable(Level.INFO)) return;
                CacheAccess.TRACE(s_logger, "return", l);
                return;
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.invalidate", exception);
            }
            Object var7_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public void invalidate(Object[] objectArray) throws CacheException {
        this.invalidate(objectArray, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void invalidate(Object[] objectArray, boolean bl) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "invalidate(" + objectArray + ")");
        }
        try {
            try {
                if (objectArray == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle(!bl);
                cacheHandle.invalidate(objectArray, this.getRegionName(), bl);
            }
            catch (RegionNotFoundException regionNotFoundException) {
                Object var7_8 = null;
                if (!s_logger.isLoggable(Level.INFO)) return;
                CacheAccess.TRACE(s_logger, "return", l);
                return;
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.invalidate", exception);
            }
            Object var7_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public void disable() throws CacheException {
        this.disable(this.getDefGrpName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void disable(Object object) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "disable(" + object + ")");
        }
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.disable(object, this.getRegionName());
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.disable", exception);
            }
            Object var6_5 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public void enable() throws CacheException {
        this.enable(this.getDefGrpName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enable(Object object) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "enable(" + object + ")");
        }
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.enable(object, this.getRegionName());
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.enable", exception);
            }
            Object var6_5 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public boolean isDisabled() throws CacheException {
        return this.isDisabled(this.getDefGrpName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDisabled(Object object) throws CacheException {
        long l = 0L;
        boolean bl = false;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "isDisabled(" + object + ")");
        }
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                bl = cacheHandle.isDisabled(object, this.getRegionName());
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.isDisabled", exception);
            }
            Object var7_6 = null;
            if (!s_logger.isLoggable(Level.INFO)) return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return:" + bl, l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return:" + bl, l);
        return bl;
    }

    public void save() throws CacheException, NullObjectNameException {
        this.save(this.getDefGrpName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void save(Object object) throws CacheException, NullObjectNameException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "save(" + object + ")");
        }
        CacheHandle cacheHandle = this.getHandle();
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                cacheHandle.saveObject(object, this.getRegionName());
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.save", exception);
            }
            Object var7_4 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void spool(Object object) throws CacheException, NullObjectNameException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "spool(" + object + ")");
        }
        CacheHandle cacheHandle = this.getHandle();
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                cacheHandle.spool(object, this.getRegionName());
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.spool", exception);
            }
            Object var7_4 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public void close() {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "close " + this.region_);
        }
        try {
            this.releaseHandle();
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Mem] ", exception);
        }
    }

    public void defineGroup(String string) throws CacheException {
        this.defineGroup(string, this.getDefGrpName(), null);
    }

    public void defineGroup(String string, String string2) throws CacheException {
        this.defineGroup(string, string2, null);
    }

    public void defineGroup(String string, Attributes attributes) throws CacheException {
        this.defineGroup(string, this.getDefGrpName(), attributes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defineGroup(String string, String string2, Attributes attributes) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "defineGroup(\"" + string + "\", \"" + string2 + "\", " + attributes + ")");
        }
        try {
            try {
                if (string == null || string2 == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.createGroup(string, this.getRegionName(), null, string2, attributes);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.defineGroup", exception);
            }
            Object var8_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public void defineSubRegion(String string) throws CacheException {
        this.defineSubRegion(string, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void defineSubRegion(String string, Attributes attributes) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "defineSubRegion(\"" + string + "\", \"" + attributes + ")");
        }
        try {
            try {
                if (string == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                String string2 = this.getRegionName() + SUBREGION_DELIM + string;
                cacheHandle.createRegion(string2, this.getRegionName(), attributes, this.ctx_);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.defineGroup", exception);
            }
            Object var8_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public CacheAccess getSubRegion(String string) throws CacheException {
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "getSubRegion(" + string + ")");
        }
        String string2 = this.getRegionName() + SUBREGION_DELIM + string;
        CacheAccess cacheAccess = new CacheAccess(string2, this.ctx_);
        if (s_logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(s_logger, "return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public CacheAccess getSubRegion(String string, Attributes attributes) throws CacheException {
        String string2;
        if (!CacheAccess.initCacheService()) {
            throw new CacheNotAvailableException(CacheInternal.EXP_NA);
        }
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "getSubRegion(" + string + ")");
        }
        if (!CacheAccess.isRegionExist(string2 = this.getRegionName() + SUBREGION_DELIM + string)) {
            CacheAccess.createSubRegions(this.getRegionName(), string, attributes);
        }
        CacheAccess cacheAccess = new CacheAccess(string2, this.ctx_);
        if (s_logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(s_logger, "return:" + cacheAccess, l);
        }
        return cacheAccess;
    }

    public String getParent() throws CacheException {
        String string = null;
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "getParent()");
        }
        try {
            CacheHandle cacheHandle = this.getHandle();
            string = cacheHandle.getParent(this.getDefGrpName());
        }
        catch (RegionNotFoundException regionNotFoundException) {
            throw CacheAccess.exceptionHandler("CacheAccess.getAccess", regionNotFoundException);
        }
        if (s_logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(s_logger, "return:" + string, l);
        }
        return string;
    }

    public void createPool(String string, PoolInstanceFactory poolInstanceFactory, Attributes attributes, int n, int n2) throws InvalidArgumentException, CacheException {
        this.createPool(string, this.getDefGrpName(), poolInstanceFactory, attributes, n, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createPool(String string, String string2, PoolInstanceFactory poolInstanceFactory, Attributes attributes, int n, int n2) throws InvalidArgumentException, CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "createPool(\"" + string + "\", " + "\"" + string2 + "\", " + attributes + ", " + n + ", " + n2 + ")");
        }
        try {
            try {
                if (string == null || string2 == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                PoolAccess.createPool(this.getRegionName(), string2, string, poolInstanceFactory, attributes, n, n2, this.ctx_);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.createPool", exception);
            }
            Object var11_8 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public void destroy() throws CacheException {
        this.destroy(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy(boolean bl) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "destroy() localOnly=" + bl);
        }
        try {
            block6: {
                try {
                    if (this.getRegionName().equals(CacheAccess.getDefRegionName())) break block6;
                    CacheHandle cacheHandle = this.getHandle(!bl);
                    cacheHandle.destroy(this.getDefGrpName(), this.getRegionName(), bl);
                    this.releaseHandle();
                }
                catch (RegionNotFoundException regionNotFoundException) {
                    Object var6_7 = null;
                    if (!s_logger.isLoggable(Level.INFO)) return;
                    CacheAccess.TRACE(s_logger, "return", l);
                    return;
                }
                catch (Exception exception) {
                    throw CacheAccess.exceptionHandler("CacheAccess.destroy", exception);
                }
            }
            Object var6_6 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
            CacheAccess.TRACE(s_logger, "return", l);
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
    }

    public void destroy(Object object) throws CacheException {
        this.destroy(object, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy(Object object, boolean bl) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "destroy(" + object + ", localOnly=)" + bl);
        }
        try {
            block7: {
                try {
                    if (object == null) {
                        throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                    }
                    if (object.equals(CacheAccess.getDefRegionName())) break block7;
                    CacheHandle cacheHandle = this.getHandle(!bl);
                    cacheHandle.destroy(object, this.getRegionName(), bl);
                    if (!object.equals(this.getDefGrpName())) break block7;
                    this.releaseHandle();
                }
                catch (RegionNotFoundException regionNotFoundException) {
                    Object var7_8 = null;
                    if (!s_logger.isLoggable(Level.INFO)) return;
                    CacheAccess.TRACE(s_logger, "return", l);
                    return;
                }
                catch (Exception exception) {
                    throw CacheAccess.exceptionHandler("CacheAccess.destroy", exception);
                }
            }
            Object var7_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
            CacheAccess.TRACE(s_logger, "return", l);
            return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
    }

    public void destroy(Object[] objectArray) throws CacheException {
        this.destroy(objectArray, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void destroy(Object[] objectArray, boolean bl) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "destroy(" + objectArray + ", localOnly=)" + bl);
        }
        try {
            try {
                if (objectArray == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                for (int i = 0; i < objectArray.length; ++i) {
                    if (objectArray[i] == null || !objectArray[i].equals(CacheAccess.getDefRegionName())) continue;
                    objectArray[i] = null;
                }
                CacheHandle cacheHandle = this.getHandle(!bl);
                cacheHandle.destroy(objectArray, this.getRegionName(), bl);
            }
            catch (RegionNotFoundException regionNotFoundException) {
                Object var7_9 = null;
                if (!s_logger.isLoggable(Level.INFO)) return;
                CacheAccess.TRACE(s_logger, "return", l);
                return;
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.destroy", exception);
            }
            Object var7_8 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void waitForResponse(int n) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "waitForResponse(" + n + ")");
        }
        CacheHandle cacheHandle = this.getHandle();
        try {
            try {
                cacheHandle.waitForAllResponse(n);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.waitForResponse", exception);
            }
            Object var7_4 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cancelResponse() throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "cancelResponse()");
        }
        CacheHandle cacheHandle = this.getHandle();
        try {
            try {
                cacheHandle.cancelAllResponse();
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.cancelResponse", exception);
            }
            Object var6_3 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public Object getOwnership(int n) throws CacheException {
        return this.getOwnership(this.getDefGrpName(), this.getDefGrpName(), n);
    }

    public Object getOwnership(Object object, int n) throws CacheException {
        return this.getOwnership(object, this.getDefGrpName(), n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getOwnership(Object object, String string, int n) throws CacheException {
        Object object2;
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "getOwnership(" + object + ", " + string + ", " + n + ")");
        }
        try {
            try {
                if (object == null) throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                if (string == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                object2 = cacheHandle.getOwnership(object, this.getRegionName(), string, n);
                Object var9_9 = null;
                if (!s_logger.isLoggable(Level.INFO)) return object2;
            }
            catch (TimeoutException timeoutException) {
                throw timeoutException;
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.getOwnership", exception);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isPresent(Object object) {
        long l = 0L;
        boolean bl = false;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "isPresent(" + object + ")");
        }
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                bl = cacheHandle.isPresent(object, this.getRegionName());
            }
            catch (Exception exception) {
                CacheAccess.exceptionHandler("CacheAccess.isPresent", exception);
                Object var8_6 = null;
                if (!s_logger.isLoggable(Level.INFO)) return bl;
                CacheAccess.TRACE(s_logger, "return:" + bl, l);
                return bl;
            }
            Object var8_5 = null;
            if (!s_logger.isLoggable(Level.INFO)) return bl;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return:" + bl, l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return:" + bl, l);
        return bl;
    }

    public void releaseOwnership(int n) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "releaseOwnership(" + n + ")");
        }
        this.releaseOwnership(this.getDefGrpName(), n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void releaseOwnership(Object object, int n) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "releaseOwnership(" + object + ", " + n + ")");
        }
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                cacheHandle.releaseOwnership(object, this.getRegionName(), n);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.releaseOwnership", exception);
            }
            Object var7_6 = null;
            if (!s_logger.isLoggable(Level.INFO)) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return", l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return", l);
    }

    public Attributes getAttributes() throws CacheException {
        Attributes attributes = null;
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "getAttributes()");
        }
        try {
            attributes = this.getAttributes(this.getDefGrpName());
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new RegionNotFoundException(CacheInternal.EXP_NOREGION + ": \"" + this.getDefGrpName() + "\"", objectNotFoundException);
        }
        if (s_logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(s_logger, "return:" + attributes, l);
        }
        return attributes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Attributes getAttributes(Object object) throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "getAttributes(" + object + ")");
        }
        Attributes attributes = null;
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                attributes = cacheHandle.getAttributes(object, this.getRegionName());
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.getAttributes", exception);
            }
            Object var7_6 = null;
            if (!s_logger.isLoggable(Level.INFO)) return attributes;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return:" + attributes, l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return:" + attributes, l);
        return attributes;
    }

    public ObjectStatus getStatus() throws CacheException {
        long l = 0L;
        ObjectStatus objectStatus = null;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "getStatus()");
        }
        objectStatus = this.getStatus(this.getDefGrpName());
        if (s_logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(s_logger, "return:" + objectStatus, l);
        }
        return objectStatus;
    }

    public AggregateStatus getAggregateStatus() throws CacheException {
        long l = 0L;
        AggregateStatus aggregateStatus = null;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "getAggregateStatus()");
        }
        aggregateStatus = this.getAggregateStatus(this.getDefGrpName());
        if (s_logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(s_logger, "return:", l);
        } else if (s_logger.isLoggable(Level.FINEST)) {
            CacheAccess.TRACE(s_logger, "return:" + aggregateStatus, l);
        }
        return aggregateStatus;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectStatus getStatus(Object object) throws CacheException {
        long l = 0L;
        ObjectStatus objectStatus = null;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "getStatus(" + object + ")");
        }
        try {
            try {
                if (object == null) {
                    throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                }
                CacheHandle cacheHandle = this.getHandle();
                objectStatus = cacheHandle.getStatus(object, this.getRegionName());
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.getStatus", exception);
            }
            Object var7_6 = null;
            if (!s_logger.isLoggable(Level.INFO)) return objectStatus;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return:" + objectStatus, l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return:" + objectStatus, l);
        return objectStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public AggregateStatus getAggregateStatus(Object object) throws CacheException {
        AggregateStatus aggregateStatus;
        long l;
        block8: {
            l = 0L;
            aggregateStatus = null;
            if (s_logger.isLoggable(Level.INFO)) {
                l = CacheAccess.TRACE(s_logger, "getAggregateStatus(" + object + ")");
            }
            try {
                try {
                    if (object == null) {
                        throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                    }
                    CacheHandle cacheHandle = this.getHandle();
                    aggregateStatus = cacheHandle.getAggregateStatus(object, this.getRegionName());
                }
                catch (Exception exception) {
                    throw CacheAccess.exceptionHandler("CacheAccess.getStatus", exception);
                }
                Object var7_6 = null;
                if (!s_logger.isLoggable(Level.INFO)) break block8;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (s_logger.isLoggable(Level.INFO)) {
                    CacheAccess.TRACE(s_logger, "return", l);
                    throw throwable;
                }
                if (!s_logger.isLoggable(Level.FINEST)) throw throwable;
                CacheAccess.TRACE(s_logger, "return:" + aggregateStatus, l);
                throw throwable;
            }
            CacheAccess.TRACE(s_logger, "return", l);
            return aggregateStatus;
        }
        if (!s_logger.isLoggable(Level.FINEST)) return aggregateStatus;
        CacheAccess.TRACE(s_logger, "return:" + aggregateStatus, l);
        return aggregateStatus;
    }

    public int getCount() throws CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "getCount()");
        }
        CacheHandle cacheHandle = this.getHandle();
        int n = cacheHandle.getRegionCount(this.getRegionName());
        if (s_logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(s_logger, "return:" + n, l);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PoolAccess getPool(String string) throws NotAPoolException, ObjectNotFoundException, CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "getPool(\"" + string + "\")");
        }
        PoolAccess poolAccess = null;
        try {
            try {
                poolAccess = PoolAccess.getPool(this.getRegionName(), string, this.ctx_);
            }
            catch (Exception exception) {
                throw CacheAccess.exceptionHandler("CacheAccess.getPool", exception);
            }
            Object var7_4 = null;
            if (!s_logger.isLoggable(Level.INFO)) return poolAccess;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            if (!s_logger.isLoggable(Level.INFO)) throw throwable;
            CacheAccess.TRACE(s_logger, "return:" + poolAccess, l);
            throw throwable;
        }
        CacheAccess.TRACE(s_logger, "return:" + poolAccess, l);
        return poolAccess;
    }

    public String getRegionName() {
        return this.region_;
    }

    public Object[] listNames() throws RegionNotFoundException, InvalidHandleException, CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "listNames()");
        }
        CacheHandle cacheHandle = this.getHandle();
        Object[] objectArray = cacheHandle.listNames(this.getRegionName());
        if (s_logger.isLoggable(Level.INFO)) {
            if (objectArray != null) {
                CacheAccess.TRACE(s_logger, "return: list of " + objectArray.length + " objects", l);
            } else {
                CacheAccess.TRACE(s_logger, "return:null", l);
            }
        } else if (s_logger.isLoggable(Level.FINEST)) {
            CacheAccess.TRACE(s_logger, "return:" + objectArray, l);
        }
        return objectArray;
    }

    public String[] listRegions() throws RegionNotFoundException, InvalidHandleException, CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "listRegions()");
        }
        CacheHandle cacheHandle = this.getHandle();
        String[] stringArray = cacheHandle.listRegions(this.getRegionName());
        if (s_logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(s_logger, "return:", l);
        }
        return stringArray;
    }

    public Enumeration listObjects() throws RegionNotFoundException, InvalidHandleException, CacheException {
        long l = 0L;
        if (s_logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(s_logger, "listObjects()");
        }
        CacheHandle cacheHandle = this.getHandle();
        Enumeration enumeration = cacheHandle.createList(this.getRegionName());
        if (s_logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(s_logger, "return", l);
        } else if (s_logger.isLoggable(Level.FINEST)) {
            CacheAccess.TRACE(s_logger, "return:" + enumeration, l);
        }
        return enumeration;
    }

    public Vector getAllCached(Object object, int n) throws ObjectNotFoundException, RegionNotFoundException, InvalidHandleException, CacheException {
        return this.getAllCached(object, n, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getAllCached(Object object, int n, boolean bl) throws ObjectNotFoundException, RegionNotFoundException, InvalidHandleException, CacheException {
        Vector vector;
        long l;
        block10: {
            block11: {
                l = 0L;
                if (s_logger.isLoggable(Level.INFO)) {
                    l = CacheAccess.TRACE(s_logger, "getAllCached(" + object + ", " + n + ", " + bl + ")");
                }
                vector = null;
                CacheHandle cacheHandle = null;
                try {
                    try {
                        if (object == null) {
                            throw new NullObjectNameException(CacheInternal.EXP_NULLOBJNAM);
                        }
                        if (this.grphandle_ == null) {
                            throw new InvalidHandleException(CacheInternal.EXP_INVALHDL);
                        }
                        cacheHandle = this.ctx_.getHandle();
                        vector = cacheHandle.netSearchList(object, this.getRegionName(), n, bl);
                    }
                    catch (Exception exception) {
                        throw CacheAccess.exceptionHandler("CacheAccess.getAllCached", exception);
                    }
                    Object var10_7 = null;
                    if (!s_logger.isLoggable(Level.INFO)) break block10;
                    if (vector == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var10_8 = null;
                    if (!s_logger.isLoggable(Level.INFO)) {
                        if (!s_logger.isLoggable(Level.FINEST)) throw throwable;
                        CacheAccess.TRACE(s_logger, "return:" + vector, l);
                        throw throwable;
                    }
                    if (vector != null) {
                        CacheAccess.TRACE(s_logger, "return: list of " + vector.size() + " objects", l);
                        throw throwable;
                    }
                    CacheAccess.TRACE(s_logger, "return:null", l);
                    throw throwable;
                }
                CacheAccess.TRACE(s_logger, "return: list of " + vector.size() + " objects", l);
                return vector;
            }
            CacheAccess.TRACE(s_logger, "return:null", l);
            return vector;
        }
        if (!s_logger.isLoggable(Level.FINEST)) return vector;
        CacheAccess.TRACE(s_logger, "return:" + vector, l);
        return vector;
    }

    public String toString() {
        return this.region_;
    }

    CacheAccess(String string) {
        this.region_ = string;
        this.ctx_ = string == null ? CacheInternal.getCacheCtx("000DEFAULT_CONTEXT$$") : CacheInternal.getCacheCtx(string);
        if (this.ctx_ != null) {
            this.grphandle_ = this.ctx_.getHandle();
        }
    }

    CacheAccess(String string, CacheCtx cacheCtx) {
        this.region_ = string;
        this.ctx_ = cacheCtx;
        this.grphandle_ = this.ctx_.getHandle();
    }

    public static String getDefRegionName() {
        long l = 0L;
        if (CacheInternal.logger.isLoggable(Level.INFO)) {
            l = CacheAccess.TRACE(null, "getDefRegionName()");
        }
        String string = "oracle_java_cache_service";
        if (CacheInternal.logger.isLoggable(Level.INFO)) {
            CacheAccess.TRACE(null, "return:" + string, l);
        }
        return string;
    }

    private static final long TRACE(Logger logger, String string) {
        return CacheAccess.TRACE(logger, string, 0L);
    }

    private static final long TRACE(Logger logger, String string, long l) {
        long l2 = l;
        if (l2 == 0L) {
            l2 = CacheInternal.getSeqId();
        }
        if (logger == null) {
            logger = CacheInternal.logger;
        }
        logger.log(Level.INFO, "[Acc] (" + l2 + ") " + string);
        return l2;
    }

    static {
        s_logger = Logger.getLogger(LOGGER_NAME);
    }
}

