/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardAdapter;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardListener;

public class WizardFrame
extends JFrame {
    private BaseWizard _wizard;
    private boolean _cancelled;
    private WizardListener _listener;
    private static final int _BORDER_INSET = 13;
    private static final Border _sBorder = new EmptyBorder(13, 13, 13, 13);

    public WizardFrame() {
        this(null, "");
    }

    public WizardFrame(BaseWizard baseWizard) {
        this(baseWizard, "");
    }

    public WizardFrame(BaseWizard baseWizard, String string) {
        super(string);
        this._wizard = baseWizard;
        this._listener = new WizListener();
        JComponent jComponent = (JComponent)this.getContentPane();
        jComponent.setLayout(new BorderLayout());
        jComponent.setBorder(_sBorder);
        this.enableEvents(64L);
        this.setDefaultCloseOperation(0);
    }

    public BaseWizard getWizard() {
        return this._wizard;
    }

    public void setWizard(BaseWizard baseWizard) {
        if (this.isVisible()) {
            throw new IllegalStateException();
        }
        this._wizard = baseWizard;
    }

    public boolean isCancelled() {
        return this._cancelled;
    }

    public void show() {
        if (this.isVisible()) {
            return;
        }
        BaseWizard baseWizard = this._wizard;
        if (baseWizard == null || baseWizard.getParent() != null) {
            throw new IllegalStateException();
        }
        this.getContentPane().add((Component)baseWizard, "Center");
        baseWizard.addWizardListener(this._listener);
        this.pack();
        ((Component)this).setBackground(baseWizard.getBackground());
        this.getContentPane().setBackground(baseWizard.getBackground());
        WindowUtils.centerWindow(this);
        this._cancelled = false;
        super.show();
    }

    protected void dismissFrame(boolean bl) {
        this._cancelled = bl;
        if (this.isVisible()) {
            ((Component)this).setVisible(false);
            this._wizard.removeWizardListener(this._listener);
            this.getContentPane().remove(this._wizard);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        JButton jButton;
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201 && (jButton = this._wizard._cancel).isEnabled()) {
            jButton.doClick();
        }
    }

    private class WizListener
    extends WizardAdapter {
        private WizListener() {
        }

        public void wizardFinished(WizardEvent wizardEvent) {
            WizardFrame.this.dismissFrame(false);
        }

        public void wizardCanceled(WizardEvent wizardEvent) {
            WizardFrame.this.dismissFrame(true);
        }
    }
}

