/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.shuttle;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import javax.swing.FocusManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.util.FocusUtils;

class ShuttleLayout
implements LayoutManager {
    public static final String FROM_LIST = "FromList";
    public static final String TO_LIST = "ToList";
    public static final String FROM_HEADER = "FromHeader";
    public static final String TO_HEADER = "ToHeader";
    public static final String FROM_FOOTER = "FromFooter";
    public static final String TO_FOOTER = "ToFooter";
    public static final String COMMON_FOOTER = "CommonFooter";
    public static final String SHUTTLE_CONTROL = "ShuttleControl";
    public static final String FROM_REORDER_CONTROL = "FromReorderControl";
    public static final String TO_REORDER_CONTROL = "ToReorderControl";
    private static final String _BOTTOM_RIGHT_CONTROL = "BottomRightControl";
    private static final String _TOP_LEFT_CONTROL = "TopLeftControl";
    private static final int _FOCUS_ROOT = 0;
    private static final int _FROM_HEADER = 1;
    private static final int _TO_HEADER = 2;
    private static final int _FROM_REORDER = 3;
    private static final int _FROM_PICKER = 4;
    private static final int _SHUTTLE = 5;
    private static final int _TO_PICKER = 6;
    private static final int _TO_REORDER = 7;
    private static final int _FROM_FOOTER = 8;
    private static final int _TO_FOOTER = 9;
    private static final int _HEADER_GAP = 0;
    private static final int _FOOTER_GAP = 5;
    private static final int _SHUTTLE_GAP = 5;
    private static final int _INSET = 5;
    private static final int _REORDER_GAP = 5;
    private static final Dimension _ZERO_SIZE = new Dimension(0, 0);
    private Component _fromListComponent;
    private Component _toListComponent;
    private Component _fromListHeader;
    private Component _toListHeader;
    private Component _fromListFooter;
    private Component _toListFooter;
    private Component _commonFooter;
    private Component _shuttleControl;
    private Component _fromReorderControl;
    private Component _toReorderControl;
    private JButton _bottomRightButton;
    private JButton _topLeftButton;
    private Shuttle _shuttle;
    private boolean _reversed = false;
    private boolean _horizontal = true;
    private int _lastDirection = 1;

    public ShuttleLayout(Shuttle shuttle) {
        this._shuttle = shuttle;
    }

    public void addLayoutComponent(String string, Component component) {
        if (string == FROM_LIST) {
            this._fromListComponent = component;
        } else if (string == TO_LIST) {
            this._toListComponent = component;
        } else if (string == FROM_HEADER) {
            this._fromListHeader = component;
        } else if (string == TO_HEADER) {
            this._toListHeader = component;
        } else if (string == SHUTTLE_CONTROL) {
            this._shuttleControl = component;
        } else if (string == FROM_REORDER_CONTROL) {
            this._fromReorderControl = component;
        } else if (string == TO_REORDER_CONTROL) {
            this._toReorderControl = component;
        } else if (string == FROM_FOOTER) {
            this._fromListFooter = component;
        } else if (string == TO_FOOTER) {
            this._toListFooter = component;
        } else if (string == _BOTTOM_RIGHT_CONTROL) {
            this._bottomRightButton = (JButton)component;
        } else if (string == _TOP_LEFT_CONTROL) {
            this._topLeftButton = (JButton)component;
        } else if (string == COMMON_FOOTER) {
            this._commonFooter = component;
        } else {
            throw new IllegalArgumentException();
        }
        this.updateFocusCycle();
    }

    public void removeLayoutComponent(Component component) {
        boolean bl = false;
        if (component == this._fromListComponent) {
            this._fromListComponent = null;
        } else if (component == this._toListComponent) {
            this._toListComponent = null;
        } else if (component == this._fromListHeader) {
            this._fromListHeader = null;
        } else if (component == this._toListHeader) {
            this._toListHeader = null;
        } else if (component == this._shuttleControl) {
            this._shuttleControl = null;
        } else if (component == this._fromReorderControl) {
            this._fromReorderControl = null;
        } else if (component == this._toReorderControl) {
            this._toReorderControl = null;
        } else if (component == this._fromListFooter) {
            this._fromListFooter = null;
        } else if (component == this._toListFooter) {
            this._toListFooter = null;
        } else if (component == this._commonFooter) {
            this._commonFooter = null;
        }
        this.updateFocusCycle();
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = this._horizontal ? this._calculateHorizontalSize(this._getPreferredSize(this._fromListComponent), this._getPreferredSize(this._toListComponent), this._getPreferredSize(this._fromListHeader), this._getPreferredSize(this._toListHeader), this._getPreferredSize(this._shuttleControl), this._getPreferredSize(this._fromReorderControl), this._getPreferredSize(this._toReorderControl), this._getPreferredSize(this._fromListFooter), this._getPreferredSize(this._toListFooter), this._getPreferredSize(this._commonFooter)) : this._calculateVerticalSize(this._getPreferredSize(this._fromListComponent), this._getPreferredSize(this._toListComponent), this._getPreferredSize(this._fromListHeader), this._getPreferredSize(this._toListHeader), this._getPreferredSize(this._shuttleControl), this._getPreferredSize(this._fromReorderControl), this._getPreferredSize(this._toReorderControl), this._getPreferredSize(this._fromListFooter), this._getPreferredSize(this._toListFooter), this._getPreferredSize(this._commonFooter));
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension minimumLayoutSize(Container container) {
        Dimension dimension = this._horizontal ? this._calculateHorizontalSize(this._getMinimumSize(this._fromListComponent), this._getMinimumSize(this._toListComponent), this._getMinimumSize(this._fromListHeader), this._getMinimumSize(this._toListHeader), this._getMinimumSize(this._shuttleControl), this._getMinimumSize(this._fromReorderControl), this._getMinimumSize(this._toReorderControl), this._getMinimumSize(this._fromListFooter), this._getMinimumSize(this._toListFooter), this._getMinimumSize(this._commonFooter)) : this._calculateVerticalSize(this._getMinimumSize(this._fromListComponent), this._getMinimumSize(this._toListComponent), this._getMinimumSize(this._fromListHeader), this._getMinimumSize(this._toListHeader), this._getMinimumSize(this._shuttleControl), this._getMinimumSize(this._fromReorderControl), this._getMinimumSize(this._toReorderControl), this._getMinimumSize(this._fromListFooter), this._getMinimumSize(this._toListFooter), this._getMinimumSize(this._commonFooter));
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public void layoutContainer(Container container) {
        JButton jButton;
        Shuttle shuttle = (Shuttle)container;
        int n = shuttle.getActualReadingDirection();
        if (n != this._lastDirection) {
            if (n == 2) {
                shuttle._setActualLayoutReversed(!shuttle.isLayoutReversed());
            } else if (n == 1) {
                shuttle._setActualLayoutReversed(shuttle.isLayoutReversed());
            }
            this._lastDirection = n;
        }
        if (this._bottomRightButton == null) {
            jButton = ShuttleLayout._createBottomRightButton();
            this._shuttle.add((Component)jButton, _BOTTOM_RIGHT_CONTROL);
        }
        if (this._topLeftButton == null) {
            jButton = ShuttleLayout._createTopLeftButton();
            this._shuttle.add((Component)jButton, _TOP_LEFT_CONTROL);
            jButton.setBounds(-1, 0, 0, 0);
        }
        if (this._horizontal) {
            this._layoutHorizontal(container);
        } else {
            this._layoutVertical(container);
        }
    }

    public Component getComponent(Object object) {
        if (object == FROM_HEADER) {
            return this._fromListHeader;
        }
        if (object == FROM_FOOTER) {
            return this._fromListFooter;
        }
        if (object == TO_HEADER) {
            return this._toListHeader;
        }
        if (object == TO_FOOTER) {
            return this._toListFooter;
        }
        if (object == COMMON_FOOTER) {
            return this._commonFooter;
        }
        return null;
    }

    public Component getShuttleControl() {
        return this._shuttleControl;
    }

    public void setHorizontalLayout(boolean bl) {
        this._horizontal = bl;
    }

    public void setReverseLayout(boolean bl) {
        this._reversed = bl;
    }

    private void _layoutHorizontal(Container container) {
        int n;
        int n2 = this._getShuttleGap();
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        Dimension dimension2 = this._getPreferredSize(this._fromListHeader);
        Dimension dimension3 = this._getPreferredSize(this._toListHeader);
        int n3 = Math.max(dimension2.height, dimension3.height);
        Dimension dimension4 = this._getPreferredSize(this._commonFooter);
        Dimension dimension5 = this._getPreferredSize(this._fromListFooter);
        Dimension dimension6 = this._getPreferredSize(this._toListFooter);
        Dimension dimension7 = this._getPreferredSize(this._shuttleControl);
        Dimension dimension8 = this._getPreferredSize(this._fromReorderControl);
        Dimension dimension9 = this._getPreferredSize(this._toReorderControl);
        int n4 = dimension8.width;
        int n5 = dimension9.width;
        if (n4 != 0) {
            n4 += 5;
        }
        if (n5 != 0) {
            n5 += 5;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (this._fromListComponent != null) {
            ++n8;
        }
        if (this._toListComponent != null) {
            ++n8;
        }
        if (n8 == 1) {
            n7 = dimension.width - insets.left - insets.right - dimension7.width - n2 * 2 - n4 - n5;
            if (this._toListComponent == null) {
                n6 = n7;
                n7 = 0;
            }
        } else if (n8 == 2) {
            n7 = n6 = (dimension.width - insets.left - insets.right - dimension7.width - n2 * 2 - n4 - n5) / 2;
        }
        int n9 = insets.left;
        if (!this._reversed) {
            if (dimension8 != _ZERO_SIZE) {
                n9 += n4;
            }
        } else if (dimension9 != _ZERO_SIZE) {
            n9 += n5;
        }
        int n10 = n9 + n2;
        int n11 = (n10 += !this._reversed ? n6 : n7) + dimension7.width + n2;
        int n12 = !this._reversed ? n11 + n7 + 5 : insets.left;
        int n13 = !this._reversed ? insets.left : n11 + n6 + 5;
        int n14 = !this._reversed ? n9 : n11;
        int n15 = !this._reversed ? n11 : n9;
        int n16 = n = insets.top + 5;
        if (n3 > 0) {
            n16 += n3 + 0;
            if (dimension2 != _ZERO_SIZE) {
                this._fromListHeader.setBounds(n14, n, n6, n3);
            }
            if (dimension3 != _ZERO_SIZE) {
                this._toListHeader.setBounds(n15, n, n7, n3);
            }
        }
        int n17 = dimension.height - n16 - dimension5.height - dimension4.height - this._getFooterGap() - 5 - insets.bottom;
        int n18 = dimension.height - n16 - dimension6.height - dimension4.height - this._getFooterGap() - 5 - insets.bottom;
        if (this._fromListComponent != null && this._fromListComponent.isVisible()) {
            this._fromListComponent.setBounds(n14, n16, n6, n17);
        }
        if (this._toListComponent != null && this._toListComponent.isVisible()) {
            this._toListComponent.setBounds(n15, n16, n7, n18);
        }
        if (dimension5 != _ZERO_SIZE) {
            this._fromListFooter.setBounds(n14, n16 + n17 + this._getFooterGap(), n6, dimension5.height);
        }
        if (dimension6 != _ZERO_SIZE) {
            this._toListFooter.setBounds(n15, n16 + n18 + this._getFooterGap(), n7, dimension6.height);
        }
        int n19 = Math.min(n17, n18);
        if (dimension7 != _ZERO_SIZE) {
            this._shuttleControl.setBounds(n10, n16 + (n19 - dimension7.height) / 2, dimension7.width, dimension7.height);
        }
        if (dimension9 != _ZERO_SIZE) {
            this._toReorderControl.setBounds(n12, n16 + (n18 - dimension9.height) / 2, dimension9.width, dimension9.height);
        }
        if (dimension8 != _ZERO_SIZE) {
            this._fromReorderControl.setBounds(n13, n16 + (n17 - dimension8.height) / 2, dimension8.width, dimension8.height);
        }
        int n20 = Math.max(n16 + n17, n16 + n18) + this._getFooterGap();
        if (dimension4 != _ZERO_SIZE) {
            this._commonFooter.setBounds((dimension.width - (insets.left + insets.right) - dimension4.width) / 2, n20, dimension4.width, dimension4.height);
        }
        this._bottomRightButton.setBounds(n11 + (this._reversed ? n6 : n7), n20, 0, 0);
    }

    private void _layoutVertical(Container container) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = this._getShuttleGap();
        Dimension dimension = container.getSize();
        Insets insets = container.getInsets();
        Dimension dimension2 = this._getPreferredSize(this._fromListHeader);
        Dimension dimension3 = this._getPreferredSize(this._toListHeader);
        int n11 = dimension2.height > 0 ? dimension2.height + 0 : 0;
        int n12 = dimension3.height > 0 ? dimension3.height + 0 : 0;
        Dimension dimension4 = this._getPreferredSize(this._fromListFooter);
        Dimension dimension5 = this._getPreferredSize(this._toListFooter);
        Dimension dimension6 = this._getPreferredSize(this._commonFooter);
        int n13 = dimension4.height > 0 ? dimension4.height + this._getFooterGap() : 0;
        int n14 = dimension5.height > 0 ? dimension5.height + this._getFooterGap() : 0;
        int n15 = dimension6.height > 0 ? dimension6.height + this._getFooterGap() : 0;
        Dimension dimension7 = this._getPreferredSize(this._shuttleControl);
        Dimension dimension8 = this._getPreferredSize(this._toReorderControl);
        Dimension dimension9 = this._getPreferredSize(this._fromReorderControl);
        int n16 = dimension8.width;
        int n17 = dimension9.width;
        if (n16 != 0) {
            n16 += 5;
        }
        if (n17 != 0) {
            n17 += 5;
        }
        int n18 = dimension.width - insets.left - insets.right - Math.max(n16, n17);
        int n19 = insets.left;
        int n20 = n19 + (n18 - dimension7.width) / 2;
        int n21 = n19 + n18 + 5;
        int n22 = dimension.height - insets.top - n11 - n12 - n13 - n14 - n15 - 2 * n10 - dimension7.height - insets.bottom;
        if (this._fromListComponent != null && this._toListComponent != null) {
            n22 /= 2;
        }
        int n23 = this._fromListComponent != null ? n22 : 0;
        int n24 = this._toListComponent != null ? n22 : 0;
        int n25 = insets.top;
        int n26 = n25 + (this._reversed ? n12 : n11);
        int n27 = 0;
        if (this._reversed) {
            if (n14 > 0) {
                n27 = 5;
            }
        } else if (n13 > 0) {
            n27 = 5;
        }
        int n28 = n26 + (this._reversed ? n24 : n23) + n27;
        int n29 = n28 - n27 + n10 + (this._reversed ? n14 : n13);
        int n30 = n29 + dimension7.height + n10;
        int n31 = n30 + (this._reversed ? n11 : n12);
        int n32 = n9 = n31 + (this._reversed ? n23 : n24) + this._getFooterGap();
        if (!this._reversed) {
            n8 = n26;
            n7 = n25;
            n6 = n28;
            n5 = n31;
            n4 = n30;
            n3 = n9;
            n2 = n31;
            n = n26;
        } else {
            n8 = n31;
            n7 = n30;
            n6 = n9;
            n5 = n26;
            n4 = n25;
            n3 = n28;
            n2 = n26;
            n = n31;
        }
        n2 += (n24 - dimension8.height) / 2;
        n += (n23 - dimension9.height) / 2;
        if (n11 > 0 && dimension2 != _ZERO_SIZE) {
            this._fromListHeader.setBounds(n19, n7, n18, dimension2.height);
        }
        if (n12 > 0 && dimension3 != _ZERO_SIZE) {
            this._toListHeader.setBounds(n19, n4, n18, dimension3.height);
        }
        if (this._fromListComponent != null && this._fromListComponent.isVisible()) {
            this._fromListComponent.setBounds(n19, n8, n18, n23);
        }
        if (this._toListComponent != null && this._toListComponent.isVisible()) {
            this._toListComponent.setBounds(n19, n5, n18, n24);
        }
        if (dimension4 != _ZERO_SIZE) {
            this._fromListFooter.setBounds(n19, n6, n18, dimension4.height);
        }
        if (dimension5 != _ZERO_SIZE) {
            this._toListFooter.setBounds(n19, n3, n18, dimension5.height);
        }
        if (dimension7 != _ZERO_SIZE) {
            this._shuttleControl.setBounds(n20, n29, dimension7.width, dimension7.height);
        }
        if (dimension8 != _ZERO_SIZE) {
            this._toReorderControl.setBounds(n21, n2, dimension8.width, dimension8.height);
        }
        if (dimension9 != _ZERO_SIZE) {
            this._fromReorderControl.setBounds(n21, n, dimension9.width, dimension9.height);
        }
        if (dimension6 != _ZERO_SIZE) {
            this._commonFooter.setBounds(n19 + (n18 - dimension6.width) / 2, n32, dimension6.width, dimension6.height);
        }
        this._bottomRightButton.setBounds(n19 + n18, n32, 0, 0);
    }

    private Dimension _calculateHorizontalSize(Dimension dimension, Dimension dimension2, Dimension dimension3, Dimension dimension4, Dimension dimension5, Dimension dimension6, Dimension dimension7, Dimension dimension8, Dimension dimension9, Dimension dimension10) {
        int n;
        int n2 = this._getShuttleGap();
        int n3 = Math.max(Math.max(Math.max(Math.max(dimension.height, dimension6.height), dimension2.height), dimension5.height), dimension7.height);
        int n4 = Math.max(Math.max(dimension.width, dimension2.width), Math.max(Math.max(dimension3.width, dimension4.width), Math.max(dimension8.width, dimension9.width)));
        int n5 = Math.max(dimension3.height, dimension4.height);
        if (n5 > 0) {
            n5 += 0;
        }
        if ((n = Math.max(Math.max(dimension8.height, dimension9.height), dimension10.height)) > 0) {
            n += this._getFooterGap();
        }
        int n6 = 2 * n4 + 2 * n2 + dimension5.width;
        if (dimension6 != _ZERO_SIZE) {
            n6 += 5 + dimension6.width;
        }
        if (dimension7 != _ZERO_SIZE) {
            n6 += 5 + dimension7.width;
        }
        return new Dimension(Math.max(n6, dimension10.width), n5 + n3 + n + 10);
    }

    private Dimension _calculateVerticalSize(Dimension dimension, Dimension dimension2, Dimension dimension3, Dimension dimension4, Dimension dimension5, Dimension dimension6, Dimension dimension7, Dimension dimension8, Dimension dimension9, Dimension dimension10) {
        int n = this._getShuttleGap();
        int n2 = Math.max(Math.max(Math.max(dimension.height, dimension6.height), dimension2.height), dimension7.height);
        int n3 = Math.max(Math.max(dimension5.width, Math.max(Math.max(dimension.width, dimension2.width), Math.max(Math.max(dimension3.width, dimension4.width), Math.max(dimension8.width, dimension9.width)))), dimension10.width);
        if (dimension3.height > 0) {
            dimension3.height += 0;
        }
        if (dimension4.height > 0) {
            dimension4.height += 0;
        }
        if (dimension8.height > 0) {
            dimension8.height += this._getFooterGap();
        }
        if (dimension9.height > 0) {
            dimension9.height += this._getFooterGap();
        }
        if (dimension10.height > 0) {
            dimension10.height += this._getFooterGap();
        }
        int n4 = dimension3.height + dimension4.height + dimension8.height + dimension9.height + dimension10.height + n2 * 2 + n * 2 + dimension5.height;
        int n5 = n3;
        if (dimension6 != _ZERO_SIZE) {
            n5 += 5 + dimension6.width;
        } else if (dimension7 != _ZERO_SIZE) {
            n5 += 5 + dimension7.width;
        }
        return new Dimension(n5, n4);
    }

    private Dimension _getPreferredSize(Component component) {
        return component != null && component.isVisible() ? component.getPreferredSize() : _ZERO_SIZE;
    }

    private Dimension _getMinimumSize(Component component) {
        return component != null && component.isVisible() ? component.getMinimumSize() : _ZERO_SIZE;
    }

    private int _getShuttleGap() {
        return this._shuttleControl != null && this._shuttleControl.getPreferredSize().width > 0 ? 5 : 0;
    }

    private int _getFooterGap() {
        if (this._commonFooter != null && this._commonFooter.isVisible()) {
            return 10;
        }
        if (this._fromListFooter != null && this._fromListFooter.isVisible() || this._toListFooter != null && this._toListFooter.isVisible()) {
            return 5;
        }
        return 0;
    }

    private static void _sGetFocusableComps(Container container, ArrayList arrayList) {
        if (container instanceof JComponent && FocusUtils.getAcceptsFocus(container)) {
            arrayList.add(container);
        } else if (!container.isVisible()) {
            return;
        }
        int n = container.getComponentCount();
        Component component = null;
        int n2 = 0;
        while (n2 < n) {
            component = container.getComponent(n2);
            if (component instanceof Container) {
                ShuttleLayout._sGetFocusableComps((Container)component, arrayList);
            }
            ++n2;
        }
    }

    private void _linkComponents() {
        Component[] componentArray = new Component[]{this._topLeftButton, this._fromListHeader, this._fromListComponent, this._fromListFooter, this._shuttleControl, this._toListHeader, this._toListComponent, this._toListFooter, this._toReorderControl, this._fromReorderControl, this._commonFooter};
        ArrayList<Component> arrayList = new ArrayList<Component>(8);
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (componentArray[n2] instanceof Container) {
                ShuttleLayout._sGetFocusableComps((Container)componentArray[n2], arrayList);
            }
            ++n2;
        }
        if (this._shuttle.getNextFocusableComponent() != null) {
            arrayList.add(this._shuttle.getNextFocusableComponent());
        } else if (this._bottomRightButton != null) {
            arrayList.add(this._bottomRightButton);
        }
        n = arrayList.size();
        int n3 = 0;
        while (n3 < n - 1) {
            ((JComponent)arrayList.get(n3)).setNextFocusableComponent((Component)arrayList.get(n3 + 1));
            ++n3;
        }
    }

    public void updateFocusCycle() {
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            this._linkComponents();
        } else {
            Component[] componentArray = new Component[]{this._topLeftButton, this._fromListHeader, this._fromListComponent, this._fromListFooter, this._shuttleControl, this._toListHeader, this._toListComponent, this._toListFooter, this._toReorderControl, this._fromReorderControl, this._commonFooter};
            int n = 0;
            int n2 = -1;
            while (n < componentArray.length - 1) {
                if (componentArray[n] instanceof JComponent) {
                    n2 = n;
                    int n3 = n + 1;
                    while (n3 < componentArray.length) {
                        if (componentArray[n3] instanceof JComponent) {
                            n2 = n3;
                            ((JComponent)componentArray[n]).setNextFocusableComponent(componentArray[n3]);
                            n = n3 - 1;
                            break;
                        }
                        ++n3;
                    }
                }
                ++n;
            }
            if (n2 != -1) {
                ((JComponent)componentArray[n2]).setNextFocusableComponent(this._bottomRightButton);
            }
            if (this._bottomRightButton != null) {
                this._bottomRightButton.setNextFocusableComponent(this._shuttle.getNextFocusableComponent());
            }
        }
    }

    private static boolean _isFocusable(Component component) {
        return component.isFocusTraversable() && component.isVisible() && component.isEnabled() && FocusUtils.isFocusable(component);
    }

    static Component __getFocusableComponent(Component component) {
        if (FocusUtils.getAcceptsFocus(component)) {
            return component;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component2 = container.getComponent(n2);
                if (ShuttleLayout._isFocusTraversable(component2)) {
                    return component2;
                }
                ++n2;
            }
        }
        return null;
    }

    private static boolean _isFocusTraversable(Component component) {
        if (FocusUtils.getAcceptsFocus(component)) {
            return true;
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            int n2 = 0;
            while (n2 < n) {
                Component component2 = container.getComponent(n2);
                if (ShuttleLayout._isFocusTraversable(component2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static JButton _createBottomRightButton() {
        JButton jButton = new JButton("");
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            FocusAdapter focusAdapter = new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Component component = FocusUtils.getOppositeComponent(focusEvent);
                    if (component instanceof JComponent && ((JComponent)component).getNextFocusableComponent() == focusEvent.getSource()) {
                        FocusManager.getCurrentManager().focusNextComponent((Component)focusEvent.getSource());
                    } else {
                        FocusManager.getCurrentManager().focusPreviousComponent((Component)focusEvent.getSource());
                    }
                }
            };
            jButton.addFocusListener(focusAdapter);
        } else {
            jButton.setEnabled(false);
        }
        return jButton;
    }

    private static JButton _createTopLeftButton() {
        JButton jButton = new JButton("");
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            FocusAdapter focusAdapter = new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    Component component = FocusUtils.getOppositeComponent(focusEvent);
                    JButton jButton = (JButton)focusEvent.getSource();
                    if (jButton.getNextFocusableComponent() == component) {
                        FocusManager.getCurrentManager().focusPreviousComponent(jButton);
                    } else {
                        FocusManager.getCurrentManager().focusNextComponent(jButton);
                    }
                }
            };
            jButton.addFocusListener(focusAdapter);
        } else {
            jButton.setEnabled(false);
        }
        return jButton;
    }
}

