/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.pivot.AbstractPivotHeaderHeaderItem;
import oracle.bali.ewt.pivot.AbstractPivotPopup;
import oracle.bali.ewt.pivot.PageItem;
import oracle.bali.ewt.pivot.PagingComponent;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.pivot.PivotTable;
import oracle.bali.share.nls.LocaleUtils;

public class PivotPopup
extends AbstractPivotPopup {
    private static final String _KEY_COLUMN_HEADER = "PIVOT.MENU_COLUMN";
    private static final String _KEY_ROW_HEADER = "PIVOT.MENU_ROW";
    private static final String _KEY_PAGING = "PIVOT.MENU_PAGING";
    private static final String _KEY_LEVEL = "PIVOT.MENU_LEVEL";
    private static final String _BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private PivotTable _pivot;
    private PagingComponent _pagingComponent;

    public PivotPopup(PivotTable pivotTable) {
        this(pivotTable, null);
    }

    public PivotPopup(PivotTable pivotTable, PagingComponent pagingComponent) {
        if (pivotTable == null) {
            throw new NullPointerException("table must be non null");
        }
        this._pivot = pivotTable;
        this._pagingComponent = pagingComponent;
        this.initialize();
    }

    public boolean isSwapAllowed() {
        boolean bl = this._pivot.isSwapAllowed();
        if (this._pagingComponent != null) {
            bl &= this._pagingComponent.isSwapAllowed();
        }
        return bl;
    }

    public Locale getLocale() {
        return LocaleUtils.getDefaultableLocale((Component)this._pivot);
    }

    public Object[] getSources() {
        ArrayList<LWComponent> arrayList = new ArrayList<LWComponent>(3);
        if (this._pivot.getColumnPivotHeader() != null) {
            arrayList.add(this._pivot.getColumnPivotHeader());
        }
        if (this._pivot.getRowPivotHeader() != null) {
            arrayList.add(this._pivot.getRowPivotHeader());
        }
        if (this._pagingComponent != null) {
            arrayList.add(this._pagingComponent);
        }
        return arrayList.toArray();
    }

    public Component getSourceComponent(Object object) {
        if (object == this._pivot.getColumnPivotHeader()) {
            return this._pivot.getColumnPivotHeader().getRowHeader();
        }
        if (object == this._pivot.getRowPivotHeader()) {
            return this._pivot.getRowPivotHeader().getColumnHeader();
        }
        if (object == this._pagingComponent) {
            return this._pagingComponent;
        }
        return null;
    }

    public Object getSource(Component component) {
        if (this._pivot.getColumnPivotHeader() != null && component == this._pivot.getColumnPivotHeader().getRowHeader()) {
            return this._pivot.getColumnPivotHeader();
        }
        if (this._pivot.getRowPivotHeader() != null && component == this._pivot.getRowPivotHeader().getColumnHeader()) {
            return this._pivot.getRowPivotHeader();
        }
        if (this._pagingComponent != null && this._pagingComponent.isAncestorOf(component)) {
            return this._pagingComponent;
        }
        return null;
    }

    public int getSourceIndex(Component component, int n, int n2, boolean bl) {
        if (this._pivot.getColumnPivotHeader() != null && component == this._pivot.getColumnPivotHeader().getRowHeader()) {
            if (bl) {
                return this._pivot.getColumnPivotHeader().getRowHeader().getFocusItem();
            }
            return this._pivot.getColumnPivotHeader().getRowHeader().getItemAt(n, n2);
        }
        if (this._pivot.getRowPivotHeader() != null && component == this._pivot.getRowPivotHeader().getColumnHeader()) {
            if (bl) {
                return this._pivot.getRowPivotHeader().getColumnHeader().getFocusItem();
            }
            return this._pivot.getRowPivotHeader().getColumnHeader().getItemAt(n, n2);
        }
        if (this._pagingComponent != null && this._pagingComponent.isAncestorOf(component)) {
            PageItem pageItem = null;
            while (component != null) {
                if (component instanceof PageItem) {
                    pageItem = (PageItem)component;
                    break;
                }
                component = component.getParent();
            }
            if (pageItem != null) {
                return this._pagingComponent.getIndex(pageItem);
            }
        }
        return -1;
    }

    public Object[] getTargets() {
        return this.getSources();
    }

    public String getTargetLabel(Object object) {
        if (object == this._pivot.getColumnPivotHeader()) {
            return this._getTranslatedString(_KEY_COLUMN_HEADER);
        }
        if (object == this._pivot.getRowPivotHeader()) {
            return this._getTranslatedString(_KEY_ROW_HEADER);
        }
        if (object == this._pagingComponent) {
            return this._getTranslatedString(_KEY_PAGING);
        }
        return null;
    }

    public int getTargetDropCount(Object object) {
        if (object == this._pivot.getColumnPivotHeader()) {
            return this._pivot.getColumnPivotHeader().getRowHeader().getItemCount();
        }
        if (object == this._pivot.getRowPivotHeader()) {
            return this._pivot.getRowPivotHeader().getColumnHeader().getItemCount();
        }
        if (object == this._pagingComponent) {
            return this._pagingComponent.getComponentCount();
        }
        return 0;
    }

    public String getTargetDropLabel(Object object, int n) {
        PageItem pageItem;
        if (object == this._pivot.getColumnPivotHeader() || object == this._pivot.getRowPivotHeader()) {
            String string;
            Object object2;
            PivotHeader pivotHeader = this._pivot.getColumnPivotHeader();
            PivotHeader pivotHeader2 = this._pivot.getRowPivotHeader();
            Object object3 = object2 = object == pivotHeader ? pivotHeader.getRowHeader().getModel().getData(n) : pivotHeader2.getColumnHeader().getModel().getData(n);
            if (object2 instanceof AbstractPivotHeaderHeaderItem) {
                object2 = ((AbstractPivotHeaderHeaderItem)object2).getData();
            }
            if ((string = this.getAxisLabelString(object2)) == null) {
                MessageFormat messageFormat = new MessageFormat(this._getTranslatedString(_KEY_LEVEL));
                Object[] objectArray = new Object[]{String.valueOf(n + 1)};
                string = messageFormat.format(objectArray);
            }
            return string;
        }
        if (object == this._pagingComponent && (pageItem = this._pagingComponent.getItem(n)) != null) {
            return pageItem.getText();
        }
        return null;
    }

    public void firePivotEvent(Object object, int n, Object object2, int n2) {
        if (object == this._pivot.getColumnPivotHeader() || object == this._pivot.getRowPivotHeader()) {
            this._pivot.firePivotEvent(object, n, object2, n2);
        } else if (object == this._pagingComponent) {
            this._pagingComponent.firePivotEvent(object, n, object2, n2);
        }
    }

    public void fireSwapEvent(Object object, int n, Object object2, int n2) {
        if (object == this._pivot.getColumnPivotHeader() || object == this._pivot.getRowPivotHeader()) {
            this._pivot.fireSwapEvent(object, n, object2, n2);
        } else if (object == this._pagingComponent) {
            this._pagingComponent.fireSwapEvent(object, n, object2, n2);
        }
    }

    public void dispose() {
        super.dispose();
        this._pivot = null;
        this._pagingComponent = null;
    }

    protected String getAxisLabelString(Object object) {
        return object == null ? null : object.toString();
    }

    private String _getTranslatedString(String string) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(_BUNDLE, this.getLocale());
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            return "Key not found";
        }
    }
}

