/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.pivot.AbstractPivotHeaderHeaderItem;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.selection.OneDSelection;

class PivotHeaderHeaderInputHandler
extends StandardHeaderKeyHandler
implements HeaderItemInputHandler {
    private PivotHeader _pivotHeader;
    private int _lastItem = -1;

    public PivotHeaderHeaderInputHandler(PivotHeader pivotHeader) {
        this._pivotHeader = pivotHeader;
    }

    public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        header.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        AbstractPivotHeaderHeaderItem abstractPivotHeaderHeaderItem = this._pivotHeader.getPivotHeaderHeaderItem(n);
        if (abstractPivotHeaderHeaderItem != null && this._pivotHeader.isAxisLabelsVisible()) {
            Cursor cursor = header.getCursor();
            Point point = this._convertPointToImageSpace(header, n, mouseEvent.getX(), mouseEvent.getY());
            Cursor cursor2 = this._pivotHeader.isAxisLabelDrill(n, point.x, point.y) ? this._pivotHeader.getAxisLabelDrillCursor(n) : Cursor.getDefaultCursor();
            if (cursor != cursor2) {
                header.setCursor(cursor2);
                mouseEvent.consume();
            }
        } else {
            header.setCursor(this._pivotHeader.getPivotCursor(n));
        }
    }

    public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
        if (mouseEvent.isConsumed()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        if (this._pivotHeader.isAxisLabelsVisible()) {
            boolean bl = this._pivotHeader.isAxisLabelDrillable(n);
            boolean bl2 = bl ? false : this._pivotHeader.isAxisLabelCollapsable(n);
            Point point = this._convertPointToImageSpace(header, n, mouseEvent.getX(), mouseEvent.getY());
            if ((bl || bl2) && this._pivotHeader.isAxisLabelDrill(n, point.x, point.y)) {
                int n2 = -2;
                int n3 = -2;
                if (this._pivotHeader.getOrientation() == 0) {
                    n3 = n;
                } else {
                    n2 = n;
                }
                if (bl) {
                    this._pivotHeader.fireHeaderCellDrillRequest(n2, n3);
                } else {
                    this._pivotHeader.fireCollapse(n2, n3);
                }
                mouseEvent.consume();
            }
        }
        if (!mouseEvent.isConsumed()) {
            this._selectGrid(mouseEvent, header, n);
        }
    }

    public void handleKeyEvent(Header header, KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        if (this._pivotHeader.isAxisLabelsVisible() && keyEvent.getID() == 401) {
            int n = header.getFocusItem();
            boolean bl = this._pivotHeader.isAxisLabelDrillable(n);
            boolean bl2 = bl ? false : this._pivotHeader.isAxisLabelCollapsable(n);
            boolean bl3 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? keyEvent.isControlDown() : keyEvent.isAltDown();
            int n2 = -2;
            int n3 = -2;
            if (this._pivotHeader.getOrientation() == 0) {
                n3 = n;
            } else {
                n2 = n;
            }
            if (bl && bl3 && keyEvent.getKeyCode() == 40) {
                this._pivotHeader.fireHeaderCellDrillRequest(n2, n3);
                keyEvent.consume();
            } else if (bl2 & bl3 & keyEvent.getKeyCode() == 38) {
                this._pivotHeader.fireCollapse(n2, n3);
                keyEvent.consume();
            }
        }
        if (!keyEvent.isConsumed()) {
            super.handleKeyEvent(header, keyEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        this._pivotHeader.__selectGrid(true);
    }

    private Point _convertPointToImageSpace(Header header, int n, int n2, int n3) {
        Image image = this._pivotHeader.getAxisLabelDrillImage(n);
        int n4 = 0;
        if (image != null) {
            FontMetrics fontMetrics;
            int n5 = 0;
            int n6 = image.getHeight(this._pivotHeader);
            if (this._pivotHeader.getOrientation() == 0) {
                n5 = header.getItemSize(n);
                n4 = this._pivotHeader.__getPivotGrippyPainter().getSize((PaintContext)this._pivotHeader.getPaintContext(), (int)header.getSize().width, (int)n5).width;
            } else {
                n5 = header.getSize().height;
                n4 = this._pivotHeader.__getPivotGrippyPainter().getSize((PaintContext)this._pivotHeader.getPaintContext(), (int)header.getItemSize((int)n), (int)header.getSize().height).width;
            }
            PaintContext paintContext = header.getItemPaintContext(n);
            float f = paintContext.getInteriorAlignmentY();
            Font font = paintContext.getPaintFont();
            int n7 = 0;
            if (font == null) {
                font = this._pivotHeader.getFont();
            }
            if (font != null && (fontMetrics = paintContext.getFontMetrics(font)) != null) {
                n7 = fontMetrics.getHeight();
            }
            if (n5 < n7) {
                n5 = n7;
            }
            n3 = (int)((float)n3 - (float)(n5 - n7) * f - (float)((n7 - n6) / 2));
        }
        return new Point(n2 - n4, n3);
    }

    private void _selectGrid(MouseEvent mouseEvent, Header header, int n) {
        if (this._pivotHeader.isAxisLabelsVisible()) {
            int n2 = 0;
            int n3 = 0;
            if (header.getOrientation() == 0) {
                n2 = header.getItemSize(n);
                n3 = header.getSize().height;
            } else {
                n2 = header.getSize().width;
                n3 = header.getItemSize(n);
            }
            int n4 = this._pivotHeader.__getPivotGrippyPainter().getSize((PaintContext)header.getItemPaintContext((int)n), (int)n2, (int)n3).width;
            int n5 = mouseEvent.getX();
            if (n5 >= 0 && n5 < n4) {
                this._pivotHeader.__selectGrid(true);
                if (n == this._lastItem) {
                    OneDSelection oneDSelection = header.getSelection();
                    try {
                        header.setSelection(OneDSelection.getEmptySelection());
                        header.setSelection(oneDSelection);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            } else {
                Grid grid = this._pivotHeader.getGrid();
                try {
                    grid.deselectAll();
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                this._pivotHeader.__selectGrid(false);
                this._lastItem = n;
            }
        }
    }
}

