/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.util.MenuUtils;

public abstract class AbstractPivotPopup {
    private static final String _KEY_SWAP_MENU = "PIVOT.MENU_SWAP";
    private static final String _KEY_PIVOT_MENU = "PIVOT.MENU_PIVOT";
    private static final String _KEY_BEFORE = "PIVOT.MENU_BEFORE";
    private static final String _KEY_AFTER = "PIVOT.MENU_AFTER";
    private static final String _BUNDLE = "oracle.bali.ewt.resource.JEWTBundle";
    private Listener _listener;
    private JPopupMenu _menu;
    private Object _source;
    private int _sourceIndex;

    public abstract boolean isSwapAllowed();

    public abstract Locale getLocale();

    public abstract Object[] getSources();

    public abstract Component getSourceComponent(Object var1);

    public abstract Object getSource(Component var1);

    public abstract int getSourceIndex(Component var1, int var2, int var3, boolean var4);

    public abstract Object[] getTargets();

    public abstract String getTargetLabel(Object var1);

    public abstract int getTargetDropCount(Object var1);

    public abstract String getTargetDropLabel(Object var1, int var2);

    public abstract void firePivotEvent(Object var1, int var2, Object var3, int var4);

    public abstract void fireSwapEvent(Object var1, int var2, Object var3, int var4);

    protected void initialize() {
        if (this._listener != null) {
            return;
        }
        this._listener = new Listener();
        Object[] objectArray = this.getSources();
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getSourceComponent(objectArray[n2]);
            this._addListeners(component);
            ++n2;
        }
    }

    public void dispose() {
        if (this._listener == null) {
            return;
        }
        Object[] objectArray = this.getSources();
        int n = objectArray == null ? 0 : objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = this.getSourceComponent(objectArray[n2]);
            this._removeListeners(component);
            ++n2;
        }
        if (this._menu != null) {
            this._menu.setInvoker(null);
            this._removeActionListeners(this._menu, this._listener);
            this._menu.removeAll();
        }
        this._menu = null;
        this._listener = null;
    }

    private void _showMenu(Component component, int n, int n2, boolean bl) {
        int n3;
        if (this._menu == null) {
            this._menu = new JPopupMenu();
        }
        this._removeActionListeners(this._menu, this._listener);
        this._menu.removeAll();
        int n4 = this.getSourceIndex(component, n, n2, bl);
        Object object = this.getSource(component);
        if (n4 == -1 || object == null) {
            return;
        }
        Object[] objectArray = this.getTargets();
        int n5 = n3 = objectArray == null ? 0 : objectArray.length;
        if (n3 == 0) {
            return;
        }
        boolean bl2 = this.isSwapAllowed();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(_BUNDLE, this.getLocale());
        JMenu jMenu = new JMenu(this._getTranslatedString(resourceBundle, _KEY_PIVOT_MENU));
        this._menu.add(jMenu);
        JMenu jMenu2 = null;
        if (bl2) {
            jMenu2 = new JMenu(this._getTranslatedString(resourceBundle, _KEY_SWAP_MENU));
            this._menu.add(jMenu2);
        }
        MessageFormat messageFormat = new MessageFormat(this._getTranslatedString(resourceBundle, _KEY_BEFORE));
        MessageFormat messageFormat2 = new MessageFormat(this._getTranslatedString(resourceBundle, _KEY_AFTER));
        Object[] objectArray2 = new Object[1];
        int n6 = 0;
        while (n6 < n3) {
            JMenuItem jMenuItem;
            int n7;
            Object object2 = objectArray[n6];
            String string = this.getTargetLabel(object2);
            JMenu jMenu3 = new JMenu(string);
            jMenu.add(jMenu3);
            JMenu jMenu4 = null;
            if (bl2) {
                jMenu4 = new JMenu(string);
                jMenu2.add(jMenu4);
            }
            if ((n7 = this.getTargetDropCount(object2)) == 0) {
                jMenuItem = new JMenuItem(string);
                jMenuItem.addActionListener(this._listener);
                jMenuItem.setActionCommand("PIVOT." + n6 + ".0");
                jMenu3.add(jMenuItem);
            } else {
                int n8 = 0;
                while (n8 < n7 + 1) {
                    String string2;
                    String string3 = string2 = n8 == n7 ? this.getTargetDropLabel(object2, n8 - 1) : this.getTargetDropLabel(object2, n8);
                    if (object != object2 || n8 != n4 && n8 != n4 + 1) {
                        MessageFormat messageFormat3 = n8 == n7 ? messageFormat2 : messageFormat;
                        objectArray2[0] = string2;
                        String string4 = messageFormat3.format(objectArray2);
                        jMenuItem = new JMenuItem(string4);
                        jMenuItem.addActionListener(this._listener);
                        jMenuItem.setActionCommand("PIVOT." + n6 + "." + n8);
                        jMenu3.add(jMenuItem);
                    }
                    if (bl2 && n8 != n7 && (object != object2 || n8 != n4)) {
                        jMenuItem = new JMenuItem(string2);
                        jMenuItem.addActionListener(this._listener);
                        jMenuItem.setActionCommand("SWAP." + n6 + "." + n8);
                        jMenu4.add(jMenuItem);
                    }
                    ++n8;
                }
            }
            if (jMenu3.getMenuComponentCount() == 0) {
                jMenu.remove(jMenu3);
            }
            if (bl2 && jMenu4.getMenuComponentCount() == 0) {
                jMenu2.remove(jMenu4);
            }
            ++n6;
        }
        if (jMenu.getMenuComponentCount() == 0) {
            this._menu.remove(jMenu);
        }
        if (bl2 && jMenu2.getMenuComponentCount() == 0) {
            this._menu.remove(jMenu2);
        }
        if (this._menu.getComponentCount() == 0) {
            return;
        }
        this._source = object;
        this._sourceIndex = n4;
        MenuUtils.showPopupMenu(this._menu, component, n, n2);
    }

    private void _removeActionListeners(JPopupMenu jPopupMenu, ActionListener actionListener) {
        int n = 0;
        while (n < jPopupMenu.getComponentCount()) {
            Component component = jPopupMenu.getComponent(n);
            if (component instanceof JMenuItem) {
                ((JMenuItem)component).removeActionListener(actionListener);
            }
            ++n;
        }
    }

    private void _addListeners(Component component) {
        component.addKeyListener(this._listener);
        component.addMouseListener(this._listener);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this._listener);
            int n = 0;
            while (n < container.getComponentCount()) {
                this._addListeners(container.getComponent(n));
                ++n;
            }
        }
    }

    private void _removeListeners(Component component) {
        component.removeKeyListener(this._listener);
        component.removeMouseListener(this._listener);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this._listener);
            int n = 0;
            while (n < container.getComponentCount()) {
                this._removeListeners(container.getComponent(n));
                ++n;
            }
        }
    }

    private String _getTranslatedString(ResourceBundle resourceBundle, String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (Exception exception) {
            return "Key not found";
        }
    }

    private class Listener
    extends MouseAdapter
    implements ActionListener,
    KeyListener,
    ContainerListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            String string = actionEvent.getActionCommand();
            boolean bl2 = string.startsWith("PIVOT");
            int n = string.indexOf(".");
            int n2 = string.lastIndexOf(".");
            String string2 = string.substring(n + 1, n2);
            int n3 = -1;
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Object object = null;
            if (n3 != -1) {
                object = AbstractPivotPopup.this.getTargets()[n3];
            }
            String string3 = string.substring(n2 + 1);
            int n4 = -1;
            try {
                n4 = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (object == null || n4 == -1) {
                return;
            }
            boolean bl3 = bl = AbstractPivotPopup.this._source == object;
            if (bl2 && bl && AbstractPivotPopup.this._sourceIndex < n4) {
                --n4;
            }
            if (bl2) {
                AbstractPivotPopup.this.firePivotEvent(AbstractPivotPopup.this._source, AbstractPivotPopup.this._sourceIndex, object, n4);
            } else {
                AbstractPivotPopup.this.fireSwapEvent(AbstractPivotPopup.this._source, AbstractPivotPopup.this._sourceIndex, object, n4);
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getComponent().isEnabled() && keyEvent.getKeyCode() == 121 && keyEvent.isShiftDown()) {
                int n = keyEvent.getComponent().getWidth() / 3;
                int n2 = 2 * keyEvent.getComponent().getHeight() / 3;
                AbstractPivotPopup.this._showMenu(keyEvent.getComponent(), n, n2, true);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getComponent().isEnabled() && SwingUtilities.isRightMouseButton(mouseEvent)) {
                AbstractPivotPopup.this._showMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), false);
            }
        }

        public void componentAdded(ContainerEvent containerEvent) {
            AbstractPivotPopup.this._addListeners(containerEvent.getChild());
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            AbstractPivotPopup.this._removeListeners(containerEvent.getChild());
        }
    }
}

