/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.olaf.OracleTreeCellRenderer;

public class OracleTreeUI
extends BasicTreeUI {
    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleTreeUI();
    }

    public TreeCellRenderer createDefaultCellRenderer() {
        return new OracleTreeCellRenderer();
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if (object.equals("Tree.expandedIcon")) {
            return new EraseBG(uIDefaults.getIcon("Tree.expandedImage"), new Insets(2, 0, 0, 1));
        }
        if (object.equals("Tree.collapsedIcon")) {
            return new EraseBG(uIDefaults.getIcon("Tree.collapsedImage"), new Insets(1, 0, 1, 0));
        }
        return null;
    }

    protected void installDefaults() {
        FontMetrics fontMetrics;
        super.installDefaults();
        Font font = this.tree.getFont();
        if (font != null && (fontMetrics = ((Component)this.tree).getFontMetrics(font)) != null) {
            this.tree.setRowHeight(fontMetrics.getHeight() + 2);
        }
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    JTree __getTree() {
        return this.tree;
    }

    void __checkForClickInExpandControl(TreePath treePath, int n, int n2) {
        super.checkForClickInExpandControl(treePath, n, n2);
    }

    boolean __startEditing(TreePath treePath, MouseEvent mouseEvent) {
        return super.startEditing(treePath, mouseEvent);
    }

    void __selectPathForEvent(TreePath treePath, MouseEvent mouseEvent) {
        super.selectPathForEvent(treePath, mouseEvent);
    }

    private static class EraseBG
    implements Icon {
        private Icon _icon;
        private Insets _insets;

        public EraseBG(Icon icon, Insets insets) {
            this._icon = icon;
            insets.right += insets.left;
            insets.bottom += insets.top;
            this._insets = insets;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(component.getBackground());
            Insets insets = this._insets;
            graphics.fillRect(n + insets.left, n2 + insets.top, this.getIconWidth() - insets.right, this.getIconHeight() - insets.bottom);
            graphics.setColor(color);
            this._icon.paintIcon(component, graphics, n, n2);
        }

        public int getIconWidth() {
            return this._icon.getIconWidth();
        }

        public int getIconHeight() {
            return this._icon.getIconHeight();
        }
    }

    private final class MouseHandler
    extends MouseAdapter {
        private TreePath lastSelectedPath = null;

        private MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            JTree jTree = OracleTreeUI.this.__getTree();
            if (jTree != null && jTree.isEnabled()) {
                jTree.requestFocus();
                TreePath treePath = OracleTreeUI.this.getClosestPathForLocation(jTree, mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    int n;
                    Rectangle rectangle = OracleTreeUI.this.getPathBounds(jTree, treePath);
                    if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        OracleTreeUI.this.__checkForClickInExpandControl(treePath, mouseEvent.getX(), mouseEvent.getY());
                    }
                    if ((n = mouseEvent.getX()) > rectangle.x && n <= rectangle.x + rectangle.width && !OracleTreeUI.this.__startEditing(treePath, mouseEvent)) {
                        if (jTree.isPathSelected(treePath)) {
                            this.lastSelectedPath = treePath;
                        } else {
                            this.lastSelectedPath = null;
                            OracleTreeUI.this.__selectPathForEvent(treePath, mouseEvent);
                        }
                    }
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            TreePath treePath;
            JTree jTree = OracleTreeUI.this.__getTree();
            if (jTree != null && jTree.isEnabled() && (treePath = OracleTreeUI.this.getClosestPathForLocation(jTree, mouseEvent.getX(), mouseEvent.getY())) != null) {
                Rectangle rectangle = OracleTreeUI.this.getPathBounds(jTree, treePath);
                if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                    return;
                }
                int n = mouseEvent.getX();
                if (n > rectangle.x && n <= rectangle.x + rectangle.width && treePath.equals(this.lastSelectedPath)) {
                    OracleTreeUI.this.__selectPathForEvent(treePath, mouseEvent);
                }
            }
            this.lastSelectedPath = null;
        }
    }
}

