/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.PainterUI;
import oracle.bali.ewt.olaf.ProgressBarPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class OracleProgressBarUI
extends ProgressBarUI
implements PainterUI,
ChangeListener {
    private static final OracleProgressBarUI _sInstance = new OracleProgressBarUI();

    public static ComponentUI createUI(JComponent jComponent) {
        return _sInstance;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
        LookAndFeel.installBorder(jComponent, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(jComponent, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        JProgressBar jProgressBar = (JProgressBar)jComponent;
        jProgressBar.addChangeListener(this);
        jProgressBar.setStringPainted(true);
        OracleUIUtils.putPaintContext(jComponent, this.getPaintContext(jComponent));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        LookAndFeel.uninstallBorder(jComponent);
        ((JProgressBar)jComponent).removeChangeListener(this);
        OracleUIUtils.removePaintContext(jComponent);
    }

    public PaintContext getPaintContext(JComponent jComponent) {
        return new PaintCtxt((JProgressBar)jComponent);
    }

    public Painter getPainter(JComponent jComponent) {
        return ProgressBarPainter.getPainter();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return OracleUIUtils.getPreferredSize(this, jComponent);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return OracleUIUtils.getMinimumSize(this, jComponent);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return OracleUIUtils.getMaximumSize(this, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        OracleUIUtils.fillBackground(graphics, jComponent);
        this.paint(graphics, jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        OracleUIUtils.paint(this, graphics, jComponent);
    }

    public boolean contains(JComponent jComponent, int n, int n2) {
        return OracleUIUtils.contains(this, jComponent, n, n2);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        ((JComponent)changeEvent.getSource()).repaint();
    }

    private OracleProgressBarUI() {
    }

    private static class PaintCtxt
    extends JPaintContext {
        private JProgressBar _bar;

        public PaintCtxt(JProgressBar jProgressBar) {
            super(jProgressBar);
            this._bar = jProgressBar;
        }

        public Object getPaintData(Object object) {
            if (PaintContext.LABEL_KEY.equals(object)) {
                if (this._bar.isStringPainted()) {
                    return this._bar.getString();
                }
                return null;
            }
            return super.getPaintData(object);
        }
    }
}

