/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.UIDefaults;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.painter.PaintContext;

public class OracleListUI
extends BasicListUI
implements PropertyChangeListener,
ListSelectionListener {
    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleListUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        OracleUIUtils.putPaintContext(jComponent);
        ((JList)jComponent).addListSelectionListener(this);
        jComponent.addPropertyChangeListener(this);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OracleUIUtils.removePaintContext(jComponent);
        ((JList)jComponent).removeListSelectionListener(this);
        jComponent.removePropertyChangeListener(this);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = super.getMinimumSize(jComponent);
        int n = ((JList)jComponent).getModel().getSize();
        if (n != 0) {
            Insets insets = jComponent.getInsets();
            dimension.height = insets.top + this.getRowHeight(0) + insets.bottom;
        }
        return dimension;
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object;
        Object e = listModel.getElementAt(n);
        boolean bl = this.list.hasFocus() && n == n2;
        boolean bl2 = listSelectionModel.isSelectedIndex(n);
        boolean bl3 = false;
        boolean bl4 = false;
        Color color = null;
        PaintContext paintContext = null;
        Component component = listCellRenderer.getListCellRendererComponent(this.list, e, n, bl2, false);
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = n3 + n5 - 1;
        int n7 = rectangle.height;
        int n8 = n4 + n7 - 1;
        if (bl2) {
            if (paintContext == null) {
                paintContext = OracleUIUtils.getPaintContext(this.list);
            }
            object = paintContext.getPaintUIDefaults();
            bl3 = (paintContext.getPaintState() & 4) != 0;
            boolean bl5 = bl4 = (paintContext.getPaintState() & 1) != 0;
            if (bl3 || bl4) {
                Color color2 = ((UIDefaults)object).getColor(ColorScheme.CONTROL_INACTIVE_TEXT);
                color = component.getBackground();
                component.setBackground(color2);
            }
        }
        this.rendererPane.paintComponent(graphics, component, this.list, n3, n4, n5, n7, true);
        if (bl3) {
            component.setBackground(color);
        }
        if (bl2) {
            color = graphics.getColor();
            int n9 = n == 0 ? n : n - 1;
            int n10 = n == listModel.getSize() - 1 ? n : n + 1;
            graphics.setColor(paintContext.getPaintBackground());
            if (!listSelectionModel.isSelectedIndex(n9)) {
                graphics.drawLine(n3, n4, n3, n4);
                graphics.drawLine(n6, n4, n6, n4);
            }
            if (!listSelectionModel.isSelectedIndex(n10)) {
                graphics.drawLine(n3, n8, n3, n8);
                graphics.drawLine(n6, n8, n6, n8);
            }
            graphics.setColor(color);
        }
        if (bl) {
            color = graphics.getColor();
            if (paintContext == null) {
                paintContext = OracleUIUtils.getPaintContext(this.list);
            }
            object = OracleUIUtils.getFocusPainter();
            graphics.setColor(bl2 ? paintContext.getPaintUIDefaults().getColor("selectedFocus") : Color.black);
            object.paint(paintContext, graphics, n3 + 2, n4 + 1, n5 - 4, n7 - 2);
            graphics.setColor(color);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("enabled")) {
            UIDefaults uIDefaults = OracleUIUtils.getUIDefaults(this.list);
            this.list.setBackground(this.list.isEnabled() ? uIDefaults.getColor("List.background") : uIDefaults.getColor("control"));
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.list.ensureIndexIsVisible(this.list.getLeadSelectionIndex());
    }
}

