/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;
import oracle.bali.ewt.graphics.ImageSet;
import oracle.bali.ewt.graphics.ImageSetIcon;
import oracle.bali.ewt.graphics.ImageStrip;
import oracle.bali.ewt.olaf.OracleUIUtils;
import oracle.bali.ewt.olaf.OracleWindowBorder;
import oracle.bali.ewt.olaf.TitleBar;
import oracle.bali.ewt.plaf.BorderAdapter;

public class OracleInternalFrameUI
extends BasicInternalFrameUI {
    private static final boolean _sJDK1_3;

    public static ComponentUI createUI(JComponent jComponent) {
        return new OracleInternalFrameUI((JInternalFrame)jComponent);
    }

    public void installUI(JComponent jComponent) {
        Border border;
        super.installUI(jComponent);
        jComponent.setOpaque(false);
        Color color = jComponent.getBackground();
        if (color == null || color instanceof UIResource) {
            jComponent.setBackground(UIManager.getColor("InternalFrame.background"));
        }
        if ((border = jComponent.getBorder()) == null || border instanceof UIResource) {
            jComponent.setBorder(new BorderAdapter(new OracleWindowBorder(this.getNorthPane())));
        }
        OracleUIUtils.putPaintContext(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        OracleUIUtils.removePaintContext(jComponent);
    }

    public static Object instantiate(UIDefaults uIDefaults, Object object, String string) {
        if (object.equals("InternalFrame.maximizeIcon")) {
            return new ImageSetIcon(OracleInternalFrameUI._getImageSet(uIDefaults, "Window.maximizeStrip"));
        }
        if (object.equals("InternalFrame.minimizeIcon")) {
            return new ImageSetIcon(OracleInternalFrameUI._getImageSet(uIDefaults, "Window.minimizeStrip"));
        }
        if (object.equals("InternalFrame.closeIcon")) {
            return new ImageSetIcon(OracleInternalFrameUI._getImageSet(uIDefaults, "Window.closeStrip"));
        }
        if (object.equals("InternalFrame.iconifyIcon")) {
            return new ImageSetIcon(OracleInternalFrameUI._getImageSet(uIDefaults, "Window.iconifyStrip"));
        }
        return null;
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        return new TitleBar(jInternalFrame);
    }

    protected MouseInputListener createGlassPaneDispatcher() {
        if (_sJDK1_3) {
            return new GlassPaneDragDispatcher();
        }
        return super.createGlassPaneDispatcher();
    }

    private static ImageSet _getImageSet(UIDefaults uIDefaults, Object object) {
        Object object2 = uIDefaults.get(object);
        if (object2 instanceof Image) {
            return new ImageStrip((Image)object2, 5);
        }
        return null;
    }

    private OracleInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    static {
        String string = System.getProperty("java.version");
        _sJDK1_3 = string == null ? false : string.startsWith("1.3");
    }

    private class GlassPaneDragDispatcher
    extends BasicInternalFrameUI.GlassPaneDispatcher {
        private Component _dragSource;
        private boolean _isDragging;

        private GlassPaneDragDispatcher() {
            super(OracleInternalFrameUI.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            this._dragSource = this._findComponentAt(OracleInternalFrameUI.this.frame.getLayeredPane(), mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this._isDragging) {
                this._dragSource.dispatchEvent(SwingUtilities.convertMouseEvent(OracleInternalFrameUI.this.frame.getLayeredPane(), mouseEvent, this._dragSource));
                this._isDragging = false;
            } else {
                super.mouseReleased(mouseEvent);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this._isDragging = true;
            this._dragSource.dispatchEvent(SwingUtilities.convertMouseEvent(OracleInternalFrameUI.this.frame.getLayeredPane(), mouseEvent, this._dragSource));
        }

        private Component _findComponentAt(Container container, int n, int n2) {
            if (!container.contains(n, n2)) {
                return container;
            }
            int n3 = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            int n4 = 0;
            while (n4 < n3) {
                Component component = componentArray[n4];
                Point point = component.getLocation();
                if (component != null && component.contains(n - point.x, n2 - point.y) && component.isLightweight() && component.isVisible()) {
                    if (component instanceof Container) {
                        Container container2 = (Container)component;
                        Point point2 = container2.getLocation();
                        Component component2 = this._findComponentAt(container2, n - point2.x, n2 - point2.y);
                        if (component2 != null) {
                            return component2;
                        }
                    } else {
                        return component;
                    }
                }
                ++n4;
            }
            return container;
        }
    }
}

