/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.bigCell;

import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.CellRange;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.share.collection.Range;

public class BigCellSelectionManager
extends GeneralGridSelectionManager {
    private Grid _grid;

    public BigCellSelectionManager(Grid grid) {
        this._grid = grid;
    }

    public Grid getGrid() {
        return this._grid;
    }

    protected TwoDSelection constrain(TwoDSelection twoDSelection) {
        if (twoDSelection.isEmpty()) {
            return twoDSelection;
        }
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        if (!oneDSelection.isEmpty()) {
            return new TwoDSelection(null, this._constrainSelection(oneDSelection));
        }
        OneDSelection oneDSelection2 = twoDSelection.getColumnSelection();
        if (!oneDSelection2.isEmpty()) {
            return new TwoDSelection(this._constrainSelection(oneDSelection2), null);
        }
        AbstractBigCell abstractBigCell = null;
        Cell cell = twoDSelection.getSingleCell();
        if (cell == null) {
            return new TwoDSelection();
        }
        Grid grid = this.getGrid();
        abstractBigCell = AbstractBigCell.getBigCell(grid, cell.column, cell.row);
        if (abstractBigCell != null) {
            int n = abstractBigCell.getColumn();
            int n2 = abstractBigCell.getRow();
            twoDSelection = new TwoDSelection(null, null, n, n2, n + abstractBigCell.getColumnCount() - 1, n2 + abstractBigCell.getRowCount() - 1);
        } else {
            twoDSelection = new TwoDSelection(null, null, cell.column, cell.row);
        }
        return twoDSelection;
    }

    private boolean _meetsConstraints(OneDSelection oneDSelection) {
        Range[] rangeArray = oneDSelection.getRanges();
        return rangeArray == null || rangeArray.length == 0 || rangeArray.length > 0 && rangeArray[0].getLowerLimit() == rangeArray[0].getUpperLimit();
    }

    private boolean _meetsConstraints(CellRange[] cellRangeArray) {
        if (cellRangeArray == null) {
            return true;
        }
        Cell cell = null;
        AbstractBigCell abstractBigCell = null;
        Grid grid = this.getGrid();
        int n = 0;
        while (n < cellRangeArray.length) {
            Cell cell2 = cellRangeArray[n].getLowerLimit();
            Cell cell3 = cellRangeArray[n].getUpperLimit();
            int n2 = cell2.row;
            while (n2 <= cell3.row) {
                int n3 = cell2.column;
                while (n3 <= cell3.column) {
                    AbstractBigCell abstractBigCell2 = AbstractBigCell.getBigCell(grid, n3, n2);
                    if (abstractBigCell2 != null) {
                        if (cell != null) {
                            return false;
                        }
                        if (abstractBigCell == null) {
                            abstractBigCell = abstractBigCell2;
                        } else if (abstractBigCell2 != abstractBigCell) {
                            return false;
                        }
                    } else {
                        if (cell != null || abstractBigCell != null) {
                            return false;
                        }
                        cell = new Cell(n3, n2);
                    }
                    ++n3;
                }
                ++n2;
            }
            ++n;
        }
        return true;
    }

    protected boolean meetsConstraints(TwoDSelection twoDSelection) {
        return this._meetsConstraints(twoDSelection.getColumnSelection()) && this._meetsConstraints(twoDSelection.getRowSelection()) && this._meetsConstraints(twoDSelection.getCellRanges());
    }

    public TwoDSelection getRepaintSelection(TwoDSelection twoDSelection, TwoDSelection twoDSelection2) {
        TwoDSelection twoDSelection3 = super.getRepaintSelection(twoDSelection, twoDSelection2);
        if (!twoDSelection3.getRowSelection().isEmpty() || !twoDSelection3.getColumnSelection().isEmpty()) {
            Grid grid = this.getGrid();
            int n = grid.getNextVisibleColumn(-1);
            int n2 = grid.getPreviousVisibleColumn(grid.getColumnCount());
            int n3 = grid.getNextVisibleRow(-1);
            int n4 = grid.getPreviousVisibleRow(grid.getRowCount());
            twoDSelection3 = new TwoDSelection(null, null, n, n3, n2, n4);
        }
        return twoDSelection3;
    }

    private OneDSelection _constrainSelection(OneDSelection oneDSelection) {
        Range[] rangeArray = oneDSelection.getRanges();
        if (rangeArray == null || rangeArray.length == 0 || rangeArray.length > 0 && rangeArray[0].getLowerLimit() == rangeArray[0].getUpperLimit()) {
            return oneDSelection;
        }
        return new OneDSelection(rangeArray[0].getLowerLimit());
    }
}

