/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Icon;
import oracle.bali.ewt.graphics.ImageUtils;

public final class IconStrip {
    private Image _image;
    private transient Image _disabledImage;
    private transient boolean _loaded;
    private int _width;
    private int _height;
    int _tileWidth;
    int _tileHeight;
    private boolean _synthesizeDisabled;
    private Icon[] _icons;

    public IconStrip(Image image, int n) {
        this(image, n, 1, true);
    }

    public IconStrip(Image image, int n, boolean bl) {
        this(image, n, 1, bl);
    }

    public IconStrip(Image image, int n, int n2) {
        this(image, n, n2, true);
    }

    public IconStrip(Image image, int n, int n2, boolean bl) {
        if (image == null || image == ImageUtils.getNotLoadedImage()) {
            throw new IllegalArgumentException("Image not loaded");
        }
        this._image = image;
        this._width = n;
        this._height = n2;
        this._icons = new Icon[n * n2];
        ImageUtils.loadImage(image);
        this._tileWidth = image.getWidth(null) / n;
        this._tileHeight = image.getHeight(null) / n2;
        this._synthesizeDisabled = bl;
    }

    public Icon getIcon(int n) {
        return this.getIcon(n % this._width, n / this._width);
    }

    public Icon getIcon(int n, int n2) {
        if (n < 0 || n >= this._width || n2 < 0 || n2 >= this._height) {
            throw new IllegalArgumentException();
        }
        int n3 = n + n2 * this._width;
        IconStrip iconStrip = this;
        synchronized (iconStrip) {
            Icon icon = this._icons[n3];
            if (icon == null) {
                this._icons[n3] = icon = new OneIcon(n, n2);
            }
            Icon icon2 = icon;
            return icon2;
        }
    }

    Image __getImage(Component component) {
        Image image = this._image;
        if (!component.isEnabled() && this._synthesizeDisabled) {
            IconStrip iconStrip = this;
            synchronized (iconStrip) {
                if (this._disabledImage == null) {
                    this._disabledImage = ImageUtils.createDisabledImage(image);
                    ImageUtils.loadImage(this._disabledImage);
                }
                image = this._disabledImage;
            }
        }
        return image;
    }

    private class OneIcon
    implements Icon {
        private int _x;
        private int _y;

        public OneIcon(int n, int n2) {
            this._x = n * IconStrip.this._tileWidth;
            this._y = n2 * IconStrip.this._tileHeight;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            int n5 = this._x;
            int n6 = this._y;
            Image image = IconStrip.this.__getImage(component);
            graphics.drawImage(image, n, n2, n + n3, n2 + n4, n5, n6, n5 + n3, n6 + n4, null);
        }

        public int getIconWidth() {
            return IconStrip.this._tileWidth;
        }

        public int getIconHeight() {
            return IconStrip.this._tileHeight;
        }
    }
}

