/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;

public class GraphicUtils {
    private static final String SWING_AATEXT_PROPERTY = "swing.aatext";
    private static final boolean useAAText;

    public static void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        int n8;
        int n9;
        if (n != n3 && n2 != n4) {
            return;
        }
        if (n5 == 0 || n5 == 1) {
            graphics.drawLine(n, n2, n3, n4);
            return;
        }
        if (n == n3) {
            n9 = n - n5 / 2;
            n8 = n5;
            if (n2 < n4) {
                n7 = n2;
                n6 = n4 - n2 + 1;
            } else {
                n7 = n4;
                n6 = n2 - n4 + 1;
            }
        } else {
            n7 = n2 - n5 / 2;
            n6 = n5;
            if (n < n3) {
                n9 = n;
                n8 = n3 - n + 1;
            } else {
                n9 = n3;
                n8 = n - n3 + 1;
            }
        }
        graphics.fillRect(n9, n7, n8, n6);
    }

    public static void drawRect(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (n5 == 0 || n5 == 1) {
            graphics.drawRect(n, n2, n3, n4);
            return;
        }
        int n7 = n5 / 2;
        int n8 = n - n7;
        int n9 = n8 + n3 + n5 - 1;
        int n10 = n6 = n2;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
        n10 = n6 = n2 + n4;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
        n10 = n2 + n7;
        n6 = n2 + n4 - n7 - 1;
        n8 = n9 = n;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
        n8 = n9 = n + n3;
        GraphicUtils.drawLine(graphics, n8, n10, n9, n6, n5);
    }

    public static void drawDottedLine(Graphics graphics, int n, int n2, int n3, int n4) {
        if (n == n3) {
            if (n2 > n4) {
                int n5 = n4;
                n4 = n2;
                n2 = n5;
            }
            if ((n & 1 ^ n2 & 1) != 0) {
                ++n2;
            }
            while (n2 <= n4) {
                graphics.drawLine(n, n2, n, n2);
                n2 += 2;
            }
        } else {
            if (n2 != n4) {
                throw new IllegalArgumentException("Only horizontal and vertical lines");
            }
            if (n > n3) {
                int n6 = n3;
                n3 = n;
                n = n6;
            }
            if ((n & 1 ^ n2 & 1) != 0) {
                ++n;
            }
            while (n <= n3) {
                graphics.drawLine(n, n2, n, n2);
                n += 2;
            }
        }
    }

    public static boolean useTextAntialiasing() {
        return useAAText;
    }

    private static boolean drawTextAntialiased(Graphics graphics) {
        return GraphicUtils.useTextAntialiasing() && graphics != null && graphics instanceof Graphics2D;
    }

    public static void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        if (n2 <= 0) {
            return;
        }
        if (GraphicUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawChars(cArray, n, n2, n3, n4);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            graphics.drawChars(cArray, n, n2, n3, n4);
        }
    }

    public static void drawString(Graphics graphics, AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        if (attributedCharacterIterator == null) {
            return;
        }
        if (GraphicUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            FontRenderContext fontRenderContext = new FontRenderContext(null, true, false);
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, fontRenderContext);
            textLayout.draw(graphics2D, n, n2);
        } else {
            graphics.drawString(attributedCharacterIterator, n, n2);
        }
    }

    public static void drawString(Graphics graphics, String string, int n, int n2) {
        if (string == null || string.length() <= 0) {
            return;
        }
        if (GraphicUtils.drawTextAntialiased(graphics)) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.drawString(string, n, n2);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            graphics.drawString(string, n, n2);
        }
    }

    public static void drawString(Graphics2D graphics2D, String string, float f, float f2) {
        if (string == null || string.length() <= 0) {
            return;
        }
        if (GraphicUtils.useTextAntialiasing()) {
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics2D.drawString(string, f, f2);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, object);
        } else {
            graphics2D.drawString(string, f, f2);
        }
    }

    private GraphicUtils() {
    }

    static {
        String string = null;
        try {
            string = System.getProperty("java.version");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            string = "1.0";
        }
        if (!(string == null || string.startsWith("1.0") || string.startsWith("1.1") || string.startsWith("1.2") || string.startsWith("1.3") || string.startsWith("1.4"))) {
            String string2 = null;
            try {
                string = System.getProperty(SWING_AATEXT_PROPERTY, "false");
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                string2 = "false";
            }
            useAAText = Boolean.valueOf(string2);
        } else {
            useAAText = false;
        }
    }
}

