/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dialog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import oracle.bali.ewt.graphics.ImageUtils;

public class DialogHeader
extends JPanel {
    private static final Dimension _EMPTY = new Dimension();
    private static final Border _BORDER = new HeaderBorder();
    private static Border _sHeaderImageBorder;
    private static Border _sHeaderTitleBorder;
    private static Border _sHeaderDescriptionBorder;
    private JLabel _headerTitle;
    private JLabel _headerImageLabel;
    private JLabel _headerDescription;

    public DialogHeader() {
        this.setLayout(new HeaderLayout());
        this.setBorder(_BORDER);
    }

    public void setHeaderImage(Image image) {
        if (this._headerImageLabel == null) {
            if (image == null) {
                return;
            }
            this._headerImageLabel = new JLabel();
            this._headerImageLabel.setBorder(DialogHeader._getHeaderImageBorder());
            this.add(this._headerImageLabel);
        }
        ImageIcon imageIcon = null;
        if (image != null) {
            ImageUtils.loadImage(image);
            imageIcon = new ImageIcon(image);
        }
        this._headerImageLabel.setIcon(imageIcon);
        this._checkHeader();
    }

    public Image getHeaderImage() {
        if (this._headerImageLabel == null) {
            return null;
        }
        Icon icon = this._headerImageLabel.getIcon();
        return icon == null ? null : ((ImageIcon)icon).getImage();
    }

    public void setHeaderTitle(String string) {
        if (this._headerTitle == null) {
            if (string == null || "".equals(string)) {
                return;
            }
            this._headerTitle = new JLabel(){

                public void addNotify() {
                    super.addNotify();
                    Font font = this.getFont();
                    if (!font.isBold()) {
                        font = font.deriveFont(1);
                        this.setFont(font);
                    }
                }
            };
            this._headerTitle.setBorder(DialogHeader._getHeaderTitleBorder());
            this.add(this._headerTitle);
        }
        this._headerTitle.setText(string);
        this._checkHeader();
    }

    public String getHeaderTitle() {
        return this._headerTitle == null ? null : this._headerTitle.getText();
    }

    public void setHeaderDescription(String string) {
        if (this._headerDescription == null) {
            if (string == null || "".equals(string)) {
                return;
            }
            this._headerDescription = new JLabel();
            this._headerDescription.setBorder(DialogHeader._getHeaderDescriptionBorder());
            this.add(this._headerDescription);
        }
        this._headerDescription.setText(string);
        this._checkHeader();
    }

    public String getHeaderDescription() {
        return this._headerDescription == null ? null : this._headerDescription.getText();
    }

    boolean __isEmpty() {
        return this._headerTitle == null && this._headerImageLabel == null && this._headerDescription == null;
    }

    public void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - (insets.left + insets.right);
        int n4 = this.getHeight() - (insets.top + insets.bottom);
        if (graphics instanceof Graphics2D) {
            Color color = this.getBackground();
            if (color == null) {
                color = UIManager.getColor("Panel.background");
            }
            GradientPaint gradientPaint = new GradientPaint(n, n2, Color.white, n3, n2, color);
            ((Graphics2D)graphics).setPaint(gradientPaint);
            graphics.fillRect(n, n2, n3, n4);
        }
    }

    private void _checkHeader() {
        if (this._headerImageLabel != null && this._headerImageLabel.getIcon() == null) {
            this.remove(this._headerImageLabel);
            this._headerImageLabel = null;
        }
        if (this._headerTitle != null && (this._headerTitle.getText() == null || "".equals(this._headerTitle.getText()))) {
            this.remove(this._headerTitle);
            this._headerTitle = null;
        }
        if (this._headerDescription != null && (this._headerDescription.getText() == null || "".equals(this._headerDescription.getText()))) {
            this.remove(this._headerDescription);
            this._headerDescription = null;
        }
        this.revalidate();
        this.repaint();
    }

    private static Border _getHeaderImageBorder() {
        if (_sHeaderImageBorder == null) {
            _sHeaderImageBorder = new EmptyBorder(3, 3, 4, 3);
        }
        return _sHeaderImageBorder;
    }

    private static Border _getHeaderTitleBorder() {
        if (_sHeaderTitleBorder == null) {
            _sHeaderTitleBorder = new EmptyBorder(10, 13, 0, 3);
        }
        return _sHeaderTitleBorder;
    }

    private static Border _getHeaderDescriptionBorder() {
        if (_sHeaderDescriptionBorder == null) {
            _sHeaderDescriptionBorder = new EmptyBorder(0, 23, 10, 3);
        }
        return _sHeaderDescriptionBorder;
    }

    private static class HeaderBorder
    implements Border {
        private Insets _insets = new Insets(0, 0, 2, 0);

        private HeaderBorder() {
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            int n5 = n2 + n4 - 1;
            int n6 = n + n3 - 1;
            Color color = graphics.getColor();
            graphics.setColor(UIManager.getColor("controlShadow"));
            graphics.drawLine(n + 2, n5 - 1, n6 - 2, n5 - 1);
            graphics.setColor(Color.white);
            graphics.drawLine(n + 2, n5, n6 - 1, n5);
            graphics.drawLine(n6 - 1, n5 - 1, n6 - 1, n5 - 1);
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return this._insets;
        }

        public boolean isBorderOpaque() {
            return false;
        }
    }

    private class HeaderLayout
    implements LayoutManager2 {
        private HeaderLayout() {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = DialogHeader.this._headerTitle == null ? _EMPTY : DialogHeader.this._headerTitle.getPreferredSize();
            Dimension dimension2 = DialogHeader.this._headerDescription == null ? _EMPTY : DialogHeader.this._headerDescription.getPreferredSize();
            Dimension dimension3 = DialogHeader.this._headerImageLabel == null ? _EMPTY : DialogHeader.this._headerImageLabel.getPreferredSize();
            int n = dimension.height + dimension2.height;
            if (dimension != _EMPTY && dimension2 != _EMPTY) {
                n += 5;
            } else if (dimension != _EMPTY || dimension2 != _EMPTY) {
                n += 10;
            }
            int n2 = Math.max(dimension.width, dimension2.width) + dimension3.width;
            int n3 = Math.max(n, dimension3.height);
            return new Dimension(n2, n3);
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            int n;
            Dimension dimension;
            Dimension dimension2;
            Insets insets = container.getInsets();
            Dimension dimension3 = dimension2 = DialogHeader.this._headerTitle == null ? _EMPTY : DialogHeader.this._headerTitle.getPreferredSize();
            if (DialogHeader.this._headerTitle != null) {
                DialogHeader.this._headerTitle.setBounds(insets.left, insets.top, dimension2.width, dimension2.height);
            }
            if (DialogHeader.this._headerDescription != null) {
                dimension = DialogHeader.this._headerDescription.getPreferredSize();
                n = dimension2 == _EMPTY ? insets.top + dimension2.height + 10 : insets.top + dimension2.height + 5;
                DialogHeader.this._headerDescription.setBounds(insets.left, n, dimension.width, dimension.height);
            }
            if (DialogHeader.this._headerImageLabel != null) {
                dimension = DialogHeader.this._headerImageLabel.getPreferredSize();
                n = container.getWidth() - (insets.left + insets.right + dimension.width);
                DialogHeader.this._headerImageLabel.setBounds(n, insets.top, dimension.width, dimension.height);
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.5f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
        }
    }
}

