/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.util;

import java.text.DateFormatSymbols;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import oracle.core.ojdl.util.TimestampFormat;

public class CLFTimestampFormat
extends TimestampFormat {
    private Calendar m_calendar = new GregorianCalendar();
    private int m_year = Integer.MIN_VALUE;
    private int m_month = Integer.MIN_VALUE;
    private int m_day = Integer.MIN_VALUE;
    private long m_baseTime = 0L;
    private boolean m_hasBrackets;
    private HashMap m_months = new HashMap();

    public CLFTimestampFormat() {
        this(false, Locale.getDefault());
    }

    public CLFTimestampFormat(boolean bl) {
        this(bl, Locale.getDefault());
    }

    public CLFTimestampFormat(boolean bl, Locale locale) {
        this.m_calendar.setTimeZone(TimeZone.getTimeZone("GMT+00:00"));
        this.m_calendar.setLenient(false);
        this.m_hasBrackets = bl;
        this.initMonths(locale);
    }

    public long parse(String string, ParsePosition parsePosition) {
        return this.parse(string.toCharArray(), parsePosition);
    }

    public long parse(String string) {
        return this.parse(string.toCharArray(), new ParsePosition(0));
    }

    public long parse(char[] cArray, ParsePosition parsePosition) {
        char c;
        int n = cArray.length;
        int n2 = parsePosition.getIndex();
        int n3 = n - n2;
        if (this.m_hasBrackets && n3 < 26) {
            return Long.MIN_VALUE;
        }
        if (n3 < 24) {
            return Long.MIN_VALUE;
        }
        if (this.m_hasBrackets && cArray[n2++] != '[') {
            return Long.MIN_VALUE;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = Character.digit(cArray[n2++], 10);
        int n14 = Character.digit(cArray[n2++], 10);
        if (n13 < 0 || n14 < 0) {
            return Long.MIN_VALUE;
        }
        n6 = n13 * 10 + n14;
        if (cArray[n2++] != '/') {
            return Long.MIN_VALUE;
        }
        int n15 = n2;
        while (n2 < n3 && cArray[n2++] != '/') {
        }
        if (n2 >= n3) {
            return Long.MIN_VALUE;
        }
        n5 = this.getMonth(cArray, n15, n2);
        if (n5 < 0) {
            return Long.MIN_VALUE;
        }
        n3 = n - n2;
        if (this.m_hasBrackets && n3 < 20) {
            return Long.MIN_VALUE;
        }
        if (n3 < 19) {
            return Long.MIN_VALUE;
        }
        n13 = Character.digit(cArray[n2++], 10);
        n14 = Character.digit(cArray[n2++], 10);
        int n16 = Character.digit(cArray[n2++], 10);
        int n17 = Character.digit(cArray[n2++], 10);
        if (n13 < 0 || n14 < 0 || n16 < 0 || n17 < 0) {
            return Long.MIN_VALUE;
        }
        n4 = n13 * 1000 + n14 * 100 + n16 * 10 + n17;
        if (cArray[n2++] != ':') {
            return Long.MIN_VALUE;
        }
        n13 = Character.digit(cArray[n2++], 10);
        n14 = Character.digit(cArray[n2++], 10);
        if (n13 < 0 || n14 < 0) {
            return Long.MIN_VALUE;
        }
        n7 = n13 * 10 + n14;
        if (cArray[n2++] != ':') {
            return Long.MIN_VALUE;
        }
        n13 = Character.digit(cArray[n2++], 10);
        n14 = Character.digit(cArray[n2++], 10);
        if (n13 < 0 || n14 < 0) {
            return Long.MIN_VALUE;
        }
        n8 = n13 * 10 + n14;
        if (cArray[n2++] != ':') {
            return Long.MIN_VALUE;
        }
        n13 = Character.digit(cArray[n2++], 10);
        n14 = Character.digit(cArray[n2++], 10);
        if (n13 < 0 || n14 < 0) {
            return Long.MIN_VALUE;
        }
        n9 = n13 * 10 + n14;
        n10 = 0;
        if (cArray[n2] == '.') {
            n13 = 0;
            n14 = 0;
            n16 = 0;
            if (++n2 < n && (n13 = Character.digit(cArray[n2], 10)) >= 0) {
                if (++n2 < n && (n14 = Character.digit(cArray[n2], 10)) >= 0) {
                    if (++n2 < n && (n16 = Character.digit(cArray[n2], 10)) >= 0) {
                        ++n2;
                    } else {
                        n16 = 0;
                    }
                } else {
                    n14 = 0;
                }
            } else {
                n13 = 0;
            }
            n10 = n13 * 100 + n14 * 10 + n16;
            while (n2 < n && Character.isDigit(cArray[n2])) {
                ++n2;
            }
        }
        if (cArray[n2++] != ' ') {
            return Long.MIN_VALUE;
        }
        int n18 = 0;
        if ((c = cArray[n2++]) == '-') {
            n18 = -1;
        } else if (c == '+') {
            n18 = 1;
        } else {
            return Long.MIN_VALUE;
        }
        n13 = Character.digit(cArray[n2++], 10);
        n14 = Character.digit(cArray[n2++], 10);
        if (n13 < 0 || n14 < 0) {
            return Long.MIN_VALUE;
        }
        n11 = n13 * 10 + n14;
        if (n11 > 23) {
            return Long.MIN_VALUE;
        }
        n13 = Character.digit(cArray[n2++], 10);
        n14 = Character.digit(cArray[n2++], 10);
        if (n13 < 0 || n14 < 0) {
            return Long.MIN_VALUE;
        }
        n12 = n13 * 10 + n14;
        if (n12 > 59) {
            return Long.MIN_VALUE;
        }
        int n19 = n18 * (n11 * 60 + n12) * 60000;
        if (this.m_hasBrackets && cArray[n2++] != ']') {
            return Long.MIN_VALUE;
        }
        parsePosition.setIndex(n2);
        if (n7 > 24 || n8 > 59 || n9 > 59) {
            return Long.MIN_VALUE;
        }
        if (n4 != this.m_year || n5 != this.m_month || n6 != this.m_day) {
            this.m_calendar.clear();
            try {
                this.m_calendar.set(n4, n5, n6);
                this.m_baseTime = this.m_calendar.getTime().getTime();
            }
            catch (Exception exception) {
                return Long.MIN_VALUE;
            }
            this.m_year = n4;
            this.m_month = n5;
            this.m_day = n6;
        }
        return this.m_baseTime + (long)(((n7 * 60 + n8) * 60 + n9) * 1000) + (long)n10 - (long)n19;
    }

    private int getMonth(char[] cArray, int n, int n2) {
        String string = new String(cArray, n, n2 - n - 1).toLowerCase();
        Integer n3 = (Integer)this.m_months.get(string);
        if (n3 != null) {
            return n3;
        }
        return -1;
    }

    private void initMonths(Locale locale) {
        String[] stringArray = new DateFormatSymbols(locale).getShortMonths();
        for (int i = 0; i < 12; ++i) {
            if (i >= stringArray.length || stringArray[i] == null) continue;
            String string = stringArray[i].toLowerCase();
            this.m_months.put(string, new Integer(i));
        }
    }
}

