/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Handler;
import oracle.core.ojdl.ODLTextFormatter;
import oracle.core.ojdl.logging.HandlerFactory;
import oracle.core.ojdl.logging.HandlerFactoryException;
import oracle.core.ojdl.logging.ODLHandler;
import oracle.core.ojdl.util.TimestampFormat;

public class ODLHandlerFactory
implements HandlerFactory {
    private Properties m_properties;
    private HashMap m_nameMap;
    private static final TimestampFormat[] s_timeFormats = new TimestampFormat[]{TimestampFormat.getInstance("ISO8601"), TimestampFormat.getInstance("yyyy-MM-dd'T'HH:mm"), TimestampFormat.getInstance("yyyy-MM-dd"), TimestampFormat.getInstance("HH:mm")};
    private static final String PATH = "path";
    private static final String FORMAT = "format";
    private static final String MAXFILESZ = "maxfilesize";
    private static final String MAXLOGSZ = "maxlogsize";
    private static final String BASETIME = "baserotationtime";
    private static final String FREQUENCY = "rotationfrequency";
    private static final String ENCODING = "encoding";
    private static final String SUPPLATTRS = "supplementalattributes";
    private static final String USESCM = "usesourceclassandmethod";
    private static final String USEDEFATTRS = "usedefaultattributes";
    private static final String DELETEFILES = "deletefiles";
    private static final String KEEPOPEN = "keepopen";
    private static final List s_allProperties = Arrays.asList("path", "format", "maxfilesize", "maxlogsize", "baserotationtime", "rotationfrequency", "encoding", "supplementalattributes", "usesourceclassandmethod", "usedefaultattributes", "deletefiles", "keepopen");

    public Handler create(Properties properties) throws HandlerFactoryException {
        ODLHandler oDLHandler;
        String string;
        this.m_properties = properties;
        this.m_nameMap = new HashMap(properties.size());
        Object object = properties.propertyNames();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            String string2 = string.toLowerCase();
            if (!s_allProperties.contains(string2)) {
                throw new HandlerFactoryException("Invalid property name: " + string);
            }
            this.m_nameMap.put(string2, string);
        }
        object = this.getProperty(PATH);
        if (object == null) {
            throw new HandlerFactoryException("Required property 'path' not found.");
        }
        string = this.getProperty(FORMAT);
        if (string != null && !string.equalsIgnoreCase("ODL-Text") && !string.equalsIgnoreCase("ODL-XML")) {
            throw new HandlerFactoryException("Invalid format: " + string + ". Valid formats are 'ODL-XML'" + " and 'ODL-Text'");
        }
        long l = this.getLongProperty(MAXFILESZ, Long.MAX_VALUE);
        if (l <= 0L) {
            throw new HandlerFactoryException("Invalid maxFileSize value: " + this.getProperty(MAXFILESZ));
        }
        long l2 = this.getLongProperty(MAXLOGSZ, Long.MAX_VALUE);
        if (l2 <= 0L) {
            throw new HandlerFactoryException("Invalid maxLogSize value: " + this.getProperty(MAXLOGSZ));
        }
        if (l2 < l) {
            throw new HandlerFactoryException("Invalid configuration: maxLogSize cannot be less than maxFileSize");
        }
        long l3 = this.getTimeProperty(BASETIME, 0L);
        if (l3 == Long.MIN_VALUE) {
            throw new HandlerFactoryException("Invalid baseRotationTime value: " + this.getProperty(BASETIME));
        }
        int n = this.getFreqProperty(FREQUENCY, Integer.MAX_VALUE);
        if (n <= 0) {
            throw new HandlerFactoryException("Invalid rotationFrequency value: " + this.getProperty(FREQUENCY));
        }
        String string3 = this.getProperty(ENCODING);
        String string4 = this.getProperty(SUPPLATTRS);
        String string5 = this.getProperty(USESCM);
        String string6 = this.getProperty(USEDEFATTRS);
        String string7 = this.getProperty(DELETEFILES);
        String string8 = this.getProperty(KEEPOPEN);
        boolean bl = string != null && string.equalsIgnoreCase("ODL-Text");
        try {
            oDLHandler = !bl ? new ODLHandler((String)object, string3) : new ODLHandler(new ODLTextFormatter(), (String)object, string3);
            oDLHandler.setMaxFileSize(l);
            oDLHandler.setMaxLogSize(l2);
            oDLHandler.setBaseRotationTime(l3);
            oDLHandler.setRotationFrequency(n);
            if (string4 != null) {
                String[] stringArray = ODLHandler.parseAttrList(string4);
                oDLHandler.setSupplementalAttributes(stringArray);
            }
            if (string5 != null) {
                oDLHandler.setUseSourceClassAndMethod(string5.equalsIgnoreCase("true"));
            }
            if (string6 != null) {
                oDLHandler.setUseDefaultAttributes(string6.equalsIgnoreCase("true"));
            } else if (bl) {
                oDLHandler.setUseDefaultAttributes(false);
            }
            if (string7 != null) {
                oDLHandler.setDeleteFiles(string7.equalsIgnoreCase("true"));
            }
            if (string8 != null) {
                oDLHandler.setKeepOpen(string8.equalsIgnoreCase("true"));
            }
        }
        catch (Exception exception) {
            throw new HandlerFactoryException("Failed to create ODLHandler: " + exception, exception);
        }
        return oDLHandler;
    }

    private long getLongProperty(String string, long l) throws HandlerFactoryException {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            throw new HandlerFactoryException("Invalid value for property " + this.m_nameMap.get(string) + ": " + string2);
        }
    }

    private int getFreqProperty(String string, int n) throws HandlerFactoryException {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return n;
        }
        if (string2.equalsIgnoreCase("hourly")) {
            return 60;
        }
        if (string2.equalsIgnoreCase("daily")) {
            return 1440;
        }
        if (string2.equalsIgnoreCase("weekly")) {
            return 10080;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            throw new HandlerFactoryException("Invalid value for property " + this.m_nameMap.get(string) + ": " + string2);
        }
    }

    private long getTimeProperty(String string, long l) throws HandlerFactoryException {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return l;
        }
        long l2 = Long.MIN_VALUE;
        for (int i = 0; i < s_timeFormats.length && (l2 = s_timeFormats[i].parse(string2)) == Long.MIN_VALUE; ++i) {
        }
        return l2;
    }

    private String getProperty(String string) {
        String string2 = (String)this.m_nameMap.get(string);
        if (string2 != null) {
            return this.m_properties.getProperty(string2);
        }
        return null;
    }
}

