/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import oracle.core.ojdl.BufferedLogWriter;
import oracle.core.ojdl.BusStopLogWriter;
import oracle.core.ojdl.ExceptionHandler;
import oracle.core.ojdl.FileLogWriter;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.LogWriter;
import oracle.core.ojdl.LogWriterException;
import oracle.core.ojdl.RotationSupport;
import oracle.core.ojdl.logging.ODLFormatter;
import oracle.core.ojdl.logging.ODLHandlerException;
import oracle.core.ojdl.logging.ODLLevel;

public class ODLHandler
extends Handler {
    private static String PROP_PREFIX = "oracle.core.ojdl.logging.ODLHandler";
    private static String SUPPL_ATTRS_PROP = PROP_PREFIX + ".supplementalAttributes";
    private static String USE_SRCMET_PROP = PROP_PREFIX + ".useSourceClassAndMethod";
    private static String USE_DEF_ATTRS_PROP = PROP_PREFIX + ".useDefaultAttributes";
    private LogWriter m_logWriter;
    private ODLFormatter m_formatter;
    private Level m_autoFlushLevel = ODLLevel.NOTIFICATION;

    public ODLHandler(String string, long l, long l2, String string2) throws ODLHandlerException {
        try {
            this.m_formatter = new ODLFormatter();
            this.m_logWriter = BusStopLogWriter.create(string, l, l2, string2);
            this.setEncoding(string2);
            this.m_logWriter.setExceptionHandler(new ExceptionHandler(true));
        }
        catch (Exception exception) {
            throw new ODLHandlerException(exception);
        }
        this.initProperties();
    }

    public ODLHandler(LogFormatter logFormatter, String string, long l, long l2, String string2) throws ODLHandlerException {
        try {
            this.m_formatter = new ODLFormatter(logFormatter);
            this.m_logWriter = FileLogWriter.create(logFormatter, string, l, l2, string2);
            this.m_logWriter.setExceptionHandler(new ExceptionHandler(true));
            this.setEncoding(string2);
        }
        catch (Exception exception) {
            throw new ODLHandlerException(exception);
        }
        this.initProperties();
    }

    public ODLHandler(String string, long l, long l2) throws ODLHandlerException {
        this(string, l, l2, null);
    }

    public ODLHandler(String string, long l) throws ODLHandlerException {
        this(string, l, Long.MAX_VALUE, null);
    }

    public ODLHandler(String string) throws ODLHandlerException {
        this(string, Long.MAX_VALUE, Long.MAX_VALUE, null);
    }

    public ODLHandler(String string, String string2) throws ODLHandlerException {
        this(string, Long.MAX_VALUE, Long.MAX_VALUE, string2);
    }

    public ODLHandler(LogFormatter logFormatter, String string, String string2) throws ODLHandlerException {
        this(logFormatter, string, Long.MAX_VALUE, Long.MAX_VALUE, string2);
    }

    public void setMaxFileSize(long l) {
        ((RotationSupport)((Object)this.m_logWriter)).setMaxSegmentSize(l);
    }

    public long getMaxFileSize() {
        return ((RotationSupport)((Object)this.m_logWriter)).getMaxSegmentSize();
    }

    public void setMaxLogSize(long l) {
        ((RotationSupport)((Object)this.m_logWriter)).setMaxSize(l);
    }

    public long getMaxLogSize() {
        return ((RotationSupport)((Object)this.m_logWriter)).getMaxSize();
    }

    public void setBaseRotationTime(long l) {
        ((RotationSupport)((Object)this.m_logWriter)).setBaseRotationTime(l);
    }

    public long getBaseRotationTime() {
        return ((RotationSupport)((Object)this.m_logWriter)).getBaseRotationTime();
    }

    public void setRotationFrequency(int n) {
        ((RotationSupport)((Object)this.m_logWriter)).setRotationFrequency(n);
    }

    public int getRotationFrequency() {
        return ((RotationSupport)((Object)this.m_logWriter)).getRotationFrequency();
    }

    public void setKeepOpen(boolean bl) {
        ((RotationSupport)((Object)this.m_logWriter)).setKeepOpen(bl);
    }

    public boolean getKeepOpen() {
        return ((RotationSupport)((Object)this.m_logWriter)).getKeepOpen();
    }

    public void setDeleteFiles(boolean bl) {
        ((RotationSupport)((Object)this.m_logWriter)).setDeleteFiles(bl);
    }

    public boolean getDeleteFiles() {
        return ((RotationSupport)((Object)this.m_logWriter)).getDeleteFiles();
    }

    public void setEncoding(String string) throws UnsupportedEncodingException {
        super.setEncoding(string);
        try {
            ((BufferedLogWriter)this.m_logWriter).setEncoding(this.getEncoding());
        }
        catch (LogWriterException logWriterException) {
            throw new UnsupportedEncodingException(string);
        }
    }

    public void close() {
        if (this.m_logWriter == null) {
            return;
        }
        try {
            this.m_logWriter.close();
        }
        catch (Exception exception) {
            this.reportError("", exception, 3);
        }
        this.m_logWriter = null;
    }

    public void flush() {
        if (this.m_logWriter == null) {
            return;
        }
        try {
            this.m_logWriter.flush();
        }
        catch (Exception exception) {
            this.reportError("", exception, 2);
        }
    }

    public void publish(LogRecord logRecord) {
        if (this.m_logWriter == null || !this.isLoggable(logRecord)) {
            return;
        }
        LogMessage logMessage = this.m_formatter.toLogMessage(logRecord);
        try {
            this.m_logWriter.write(logMessage);
        }
        catch (Exception exception) {
            this.reportError("", exception, 1);
        }
        if (logRecord.getLevel().intValue() >= this.m_autoFlushLevel.intValue()) {
            this.flush();
        }
    }

    public void setSupplementalAttributes(String[] stringArray) {
        this.m_formatter.setSupplementalAttributes(stringArray);
    }

    public String[] getSupplementalAttributes() {
        return this.m_formatter.getSupplementalAttributes();
    }

    public void setUseSourceClassAndMethod(boolean bl) {
        this.m_formatter.setUseSourceClassAndMethod(bl);
    }

    public boolean getUseSourceClassAndMethod() {
        return this.m_formatter.getUseSourceClassAndMethod();
    }

    public void setUseDefaultAttributes(boolean bl) {
        this.m_formatter.setUseDefaultAttributes(bl);
    }

    public boolean getUseDefaultAttributes() {
        return this.m_formatter.getUseDefaultAttributes();
    }

    private void initProperties() {
        String string = this.getProperty(SUPPL_ATTRS_PROP);
        if (string != null) {
            this.setSupplementalAttributes(ODLHandler.parseAttrList(string));
        }
        if ((string = this.getProperty(USE_SRCMET_PROP)) != null) {
            this.setUseSourceClassAndMethod(string.equalsIgnoreCase("true"));
        }
        if ((string = this.getProperty(USE_DEF_ATTRS_PROP)) != null) {
            this.setUseDefaultAttributes(string.equalsIgnoreCase("true"));
        }
    }

    private String getProperty(String string) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            string2 = LogManager.getLogManager().getProperty(string);
        }
        return string2;
    }

    static String[] parseAttrList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken().trim());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

