/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.MessageType;
import oracle.core.ojdl.ODLTextFormatter;
import oracle.core.ojdl.XMLFormatter;
import oracle.core.ojdl.logging.MessageIdKeyResourceBundle;
import oracle.core.ojdl.logging.MessageIdResourceBundle;
import oracle.core.ojdl.logging.ODLLevel;
import oracle.dms.instrument.ExecutionContext;

public class ODLFormatter
extends Formatter {
    public static final String ODL_XML = "ODL-XML";
    public static final String ODL_TEXT = "ODL-Text";
    private LogFormatter m_logFormatter;
    private String[] m_supplAttributes = null;
    private boolean m_useDefaultAttributes = true;
    private boolean m_useSrcClassAndMethod = false;
    private WeakHashMap m_bundles = new WeakHashMap();
    private static final Object MSG_ID_KEY_BUNDLE = new Object();
    private static final Object MSG_ID_SUFFIX_BUNDLE = new Object();
    private static final Object UNMARKED_BUNDLE = new Object();
    private static final String MSG_ID_SUFFIX_MARKER = "oracle.core.ojdl.logging.MessageIdSuffixResourceBundle";
    private static final String MSG_ID_KEY_MARKER = "oracle.core.ojdl.logging.MessageIdKeyResourceBundle";
    private static final String MARKER_FIELD = "ORACLE_LOGGING_MSG_ID_KEY_BUNDLE";
    private static final String MSG_ID_SUFFIX = ".MSGID";

    public ODLFormatter() {
        this(new XMLFormatter());
    }

    public ODLFormatter(String string) {
        if (string.equalsIgnoreCase(ODL_XML)) {
            this.m_logFormatter = new XMLFormatter();
        } else if (string.equalsIgnoreCase(ODL_TEXT)) {
            this.m_logFormatter = new ODLTextFormatter();
            this.setUseDefaultAttributes(false);
        } else {
            throw new IllegalArgumentException("format: " + string);
        }
    }

    ODLFormatter(LogFormatter logFormatter) {
        this.m_logFormatter = logFormatter;
    }

    public String format(LogRecord logRecord) {
        return this.m_logFormatter.format(this.toLogMessage(logRecord));
    }

    public String getHead(Handler handler) {
        String string = this.m_logFormatter.header();
        return string != null ? string : "";
    }

    public String getTail(Handler handler) {
        String string = this.m_logFormatter.tail();
        return string != null ? string : "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LogMessage toLogMessage(LogRecord logRecord) {
        Object object;
        Class<?> clazz;
        Object object2;
        Object object3;
        String string;
        String string2;
        HashMap<String, Object> hashMap;
        String string3;
        LogMessage.InstanceId instanceId;
        LogMessage.InstanceId instanceId2;
        String string4;
        String string5;
        String string6;
        String string7;
        block43: {
            Object object4;
            String string8;
            int n;
            String string9 = logRecord.getLoggerName();
            if (string9 == null) {
                string9 = "";
            }
            if ((n = string9.indexOf(46)) >= 0) {
                string8 = string9.substring(0, n);
                int n2 = string9.indexOf(46, n + 1);
                if (n2 >= 0) {
                    string7 = string9.substring(n + 1, n2);
                    string6 = string9.substring(n2 + 1);
                } else {
                    string7 = string9.substring(n + 1);
                    string6 = null;
                }
            } else {
                string8 = null;
                string7 = string9;
                string6 = null;
            }
            string5 = null;
            string4 = null;
            instanceId2 = null;
            instanceId = null;
            string3 = null;
            hashMap = null;
            ExecutionContext executionContext = ExecutionContext.get();
            if (executionContext != null) {
                instanceId2 = executionContext.getECID();
                if (instanceId2.getUniqueId() == null) {
                    instanceId2 = null;
                }
                object4 = executionContext.getAttributeMap();
                string3 = (String)object4.get("ClientID");
                if (this.m_supplAttributes != null) {
                    for (int i = 0; i < this.m_supplAttributes.length; ++i) {
                        string2 = this.m_supplAttributes[i];
                        string = object4.get(string2);
                        if (string == null) continue;
                        if (hashMap == null) {
                            hashMap = new HashMap();
                        }
                        hashMap.put(string2, string);
                    }
                }
            }
            object4 = logRecord.getResourceBundle();
            String string10 = logRecord.getMessage();
            if (object4 != null) {
                try {
                    string2 = ((ResourceBundle)object4).getString(string10);
                    if (object4 instanceof MessageIdKeyResourceBundle) {
                        string = string10;
                        break block43;
                    }
                    if (object4 instanceof MessageIdResourceBundle) {
                        try {
                            string = ((MessageIdResourceBundle)object4).getMessageId(string10);
                        }
                        catch (Exception exception) {
                            string = null;
                        }
                        break block43;
                    }
                    object3 = this.m_bundles;
                    synchronized (object3) {
                        object2 = this.m_bundles.get(object4);
                        if (object2 == null) {
                            try {
                                ((ResourceBundle)object4).getString(MSG_ID_KEY_MARKER);
                                object2 = MSG_ID_KEY_BUNDLE;
                            }
                            catch (Exception exception) {
                                try {
                                    ((ResourceBundle)object4).getString(MSG_ID_SUFFIX_MARKER);
                                    object2 = MSG_ID_SUFFIX_BUNDLE;
                                }
                                catch (Exception exception2) {
                                    clazz = object4.getClass();
                                    try {
                                        clazz.getDeclaredField(MARKER_FIELD);
                                        object2 = MSG_ID_KEY_BUNDLE;
                                    }
                                    catch (NoSuchFieldException noSuchFieldException) {
                                        object2 = UNMARKED_BUNDLE;
                                    }
                                }
                                this.m_bundles.put(object4, object2);
                            }
                        }
                    }
                    if (object2 == MSG_ID_KEY_BUNDLE) {
                        string = string10;
                        break block43;
                    }
                    if (object2 == MSG_ID_SUFFIX_BUNDLE) {
                        object3 = string10 + MSG_ID_SUFFIX;
                        try {
                            string = ((ResourceBundle)object4).getString(string10 + MSG_ID_SUFFIX);
                        }
                        catch (Exception exception) {
                            string = null;
                        }
                        break block43;
                    }
                    string = null;
                }
                catch (Exception exception) {
                    string2 = string10;
                    string = null;
                }
            } else {
                string2 = string10;
                string = null;
            }
        }
        if ((object2 = logRecord.getParameters()) != null && ((Object[])object2).length > 0 && string2 != null && string2.indexOf("{") >= 0) {
            try {
                string2 = MessageFormat.format(string2, object2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        object3 = null;
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            object3 = this.writeStackTrace(throwable);
        }
        if (this.m_useSrcClassAndMethod) {
            object = logRecord.getSourceClassName();
            if (object != null) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, Object>();
                }
                hashMap.put("SRC_CLASS", object);
            }
            if ((clazz = logRecord.getSourceMethodName()) != null) {
                if (hashMap == null) {
                    hashMap = new HashMap();
                }
                hashMap.put("SRC_METHOD", clazz);
            }
        }
        object = new int[1];
        clazz = ODLLevel.getMsgTypeAndLevel(logRecord.getLevel(), (int[])object);
        LogMessage logMessage = new LogMessage(null, string7, string, null, (MessageType)((Object)clazz), null, (int)object[0], string6, null, string3, string5, string4, instanceId2, instanceId, string2, null, null, (String)object3);
        logMessage.setTimestamp(logRecord.getMillis());
        logMessage.setThreadId(String.valueOf(logRecord.getThreadID()));
        if (hashMap != null) {
            logMessage.setSupplAttrs(hashMap);
        }
        if (!this.m_useDefaultAttributes) {
            logMessage.setHostId(null);
            logMessage.setHostNwAddr(null);
            logMessage.setUserId(string3);
        }
        return logMessage;
    }

    public void setSupplementalAttributes(String[] stringArray) {
        this.m_supplAttributes = stringArray;
    }

    public String[] getSupplementalAttributes() {
        return this.m_supplAttributes;
    }

    public void setUseSourceClassAndMethod(boolean bl) {
        this.m_useSrcClassAndMethod = bl;
    }

    public boolean getUseSourceClassAndMethod() {
        return this.m_useSrcClassAndMethod;
    }

    public void setUseDefaultAttributes(boolean bl) {
        this.m_useDefaultAttributes = bl;
    }

    public boolean getUseDefaultAttributes() {
        return this.m_useDefaultAttributes;
    }

    private final String writeStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        return stringWriter.toString();
    }
}

