/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.statemanager.javacache;

import java.io.File;
import java.security.AccessController;
import java.util.Hashtable;
import oracle.adf.share.statemanager.Policy;
import oracle.adf.share.statemanager.StateManager;
import oracle.adf.share.statemanager.javacache.StateManagerCacheAccess;
import oracle.ias.cache.Cache;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheException;
import sun.security.action.GetPropertyAction;

public class StateManagerImpl
implements StateManager {
    public static final String ENV_CACHE_ATTRIBUTES = "oracle.adf.share.statemanager.javacache.cache_attributes";

    public void init(Hashtable hashtable) {
        if (!Cache.isReady()) {
            try {
                CacheAttributes cacheAttributes = (CacheAttributes)hashtable.get(ENV_CACHE_ATTRIBUTES);
                if (cacheAttributes == null) {
                    cacheAttributes = new CacheAttributes();
                    cacheAttributes.setDistribute(true);
                    GetPropertyAction getPropertyAction = new GetPropertyAction("java.io.tmpdir");
                    String string = AccessController.doPrivileged(getPropertyAction);
                    cacheAttributes.setDiskPath(string);
                    cacheAttributes.setLogFileName(string + File.separatorChar + "javacache.log");
                }
                Cache.init((CacheAttributes)cacheAttributes);
            }
            catch (CacheException cacheException) {
                System.out.println("WARNING:  Could not init the StateManager cache");
                cacheException.printStackTrace();
            }
        }
    }

    public Object getState(Object object, Object object2) {
        StateManagerCacheAccess stateManagerCacheAccess = null;
        try {
            stateManagerCacheAccess = new StateManagerCacheAccess(object.toString(), object2);
            Object object3 = stateManagerCacheAccess.get();
            Object var6_5 = null;
            if (stateManagerCacheAccess != null) {
                stateManagerCacheAccess.destroy();
            }
            return object3;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                if (stateManagerCacheAccess == null) break block3;
                stateManagerCacheAccess.destroy();
            }
            throw throwable;
        }
    }

    public Object putState(Object object, Object object2, Object object3) {
        return this.putState(object, object2, object3, null);
    }

    public Object putState(Object object, Object object2, Object object3, Policy policy) {
        StateManagerCacheAccess stateManagerCacheAccess = null;
        try {
            stateManagerCacheAccess = new StateManagerCacheAccess(object.toString(), object2, policy);
            Object object4 = stateManagerCacheAccess.put(object3);
            Object var8_7 = null;
            if (stateManagerCacheAccess != null) {
                stateManagerCacheAccess.destroy();
            }
            return object4;
        }
        catch (Throwable throwable) {
            block3: {
                Object var8_8 = null;
                if (stateManagerCacheAccess == null) break block3;
                stateManagerCacheAccess.destroy();
            }
            throw throwable;
        }
    }

    public Object removeState(Object object, Object object2) {
        StateManagerCacheAccess stateManagerCacheAccess = null;
        try {
            stateManagerCacheAccess = new StateManagerCacheAccess(object.toString(), object2);
            Object object3 = stateManagerCacheAccess.remove();
            Object var6_5 = null;
            if (stateManagerCacheAccess != null) {
                stateManagerCacheAccess.destroy();
            }
            return object3;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                if (stateManagerCacheAccess == null) break block3;
                stateManagerCacheAccess.destroy();
            }
            throw throwable;
        }
    }

    public void clearStates(Object object) {
        StateManagerCacheAccess stateManagerCacheAccess = null;
        try {
            stateManagerCacheAccess = new StateManagerCacheAccess(object.toString(), null);
            stateManagerCacheAccess.remove();
            Object var4_3 = null;
            if (stateManagerCacheAccess != null) {
                stateManagerCacheAccess.destroy();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (stateManagerCacheAccess != null) {
                stateManagerCacheAccess.destroy();
            }
            throw throwable;
        }
    }
}

