/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.statemanager.javacache;

import oracle.adf.share.statemanager.DefaultPolicyImpl;
import oracle.adf.share.statemanager.Policy;
import oracle.adf.share.statemanager.javacache.AttributePolicyImpl;
import oracle.adf.share.statemanager.javacache.StateManagerCacheLoader;
import oracle.adf.share.statemanager.javacache.StateManagerCacheLoaderHolder;
import oracle.ias.cache.Attributes;
import oracle.ias.cache.CacheAccess;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheLoader;
import oracle.ias.cache.InvalidArgumentException;

class StateManagerCacheAccess {
    private static String STATE_MANAGER_CACHE_REGION = "__state_manager_cache_region__";
    private final String mScopeName;
    private final Object mObjId;
    private final CacheAccess mCacheAccess;
    private final Policy mPolicy;

    StateManagerCacheAccess(String string, Object object) {
        this(string, object, null);
    }

    StateManagerCacheAccess(String string, Object object, Policy policy) {
        this.mScopeName = string;
        this.mObjId = object;
        this.mCacheAccess = this.getCacheAccess(string);
        if (policy == null) {
            try {
                policy = new AttributePolicyImpl(this.mCacheAccess.getAttributes());
            }
            catch (CacheException cacheException) {
                cacheException.printStackTrace();
                policy = new DefaultPolicyImpl();
            }
        }
        this.mPolicy = policy;
    }

    Object get() {
        try {
            if (this.mCacheAccess.isPresent(this.mObjId)) {
                Object object = this.mCacheAccess.get(this.mObjId);
                return object;
            }
            Object var3_2 = null;
            return var3_2;
        }
        catch (CacheException cacheException) {
            cacheException.printStackTrace();
            throw new RuntimeException(cacheException);
        }
    }

    Object put(Object object) {
        Attributes attributes = new Attributes();
        long l = 8;
        if (this.mPolicy.isDistributable() || this.mPolicy.isPersistent()) {
            l |= 1L;
        }
        attributes.setFlags(l);
        long l2 = this.mPolicy.getTimeToLive();
        if (l2 > 0L) {
            try {
                attributes.setTimeToLive(l2);
            }
            catch (InvalidArgumentException invalidArgumentException) {
                invalidArgumentException.printStackTrace();
                throw new RuntimeException(invalidArgumentException);
            }
        }
        try {
            if (!this.mCacheAccess.isPresent(this.mObjId)) {
                this.mCacheAccess.get(this.mObjId, (Object)new StateManagerCacheLoaderHolder(object, attributes));
            } else {
                this.mCacheAccess.replace(this.mObjId, object);
            }
            if (this.mPolicy.isDistributable() || this.mPolicy.isPersistent()) {
                this.mCacheAccess.save(this.mObjId);
            }
            Object object2 = object;
            return object2;
        }
        catch (CacheException cacheException) {
            cacheException.printStackTrace();
            throw new RuntimeException(cacheException);
        }
    }

    Object remove() {
        try {
            if (this.mObjId != null) {
                Object object = null;
                if (this.mCacheAccess.isPresent(this.mObjId)) {
                    object = this.mCacheAccess.get(this.mObjId);
                    this.mCacheAccess.destroy(this.mObjId);
                }
                Object object2 = object;
                return object2;
            }
            this.mCacheAccess.destroy();
            Object var4_3 = null;
            return var4_3;
        }
        catch (CacheException cacheException) {
            cacheException.printStackTrace();
            throw new RuntimeException(cacheException);
        }
    }

    void destroy() {
        try {
            if (this.mCacheAccess != null) {
                this.mCacheAccess.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private CacheAccess getCacheAccess(Object object) {
        CacheAccess cacheAccess;
        if (this.mCacheAccess != null) {
            return this.mCacheAccess;
        }
        Attributes attributes = new Attributes();
        attributes.setLoader((CacheLoader)new StateManagerCacheLoader());
        attributes.setFlags((long)32);
        String string = object.toString();
        string = STATE_MANAGER_CACHE_REGION + '/' + string;
        try {
            cacheAccess = CacheAccess.getAccess((String)string, (Attributes)attributes, (boolean)true);
        }
        catch (CacheException cacheException) {
            cacheException.printStackTrace();
            throw new RuntimeException(cacheException);
        }
        return cacheAccess;
    }
}

