/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.providers.jazn;

import java.lang.reflect.Constructor;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import javax.security.auth.Subject;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.authentication.ADFRolePrincipal;
import oracle.adf.share.security.authentication.ADFUserPrincipal;
import oracle.adf.share.security.authorization.ADFPermission;
import oracle.adf.share.security.authorization.PermissionActionDescriptor;
import oracle.adf.share.security.authorization.PermissionClassDescriptor;
import oracle.adf.share.security.authorization.PermissionTargetDescriptor;
import oracle.adf.share.security.authorization.PolicyStatement;
import oracle.adf.share.security.authorization.spi.PolicyInspection;
import oracle.adf.share.security.providers.jazn.JAZNContextHelper;
import oracle.adf.share.security.providers.jazn.JAZNIdentityManagementProvider;
import oracle.security.jazn.JAZNConfig;
import oracle.security.jazn.JAZNException;
import oracle.security.jazn.policy.GlobalPolicy;
import oracle.security.jazn.policy.Grantee;
import oracle.security.jazn.policy.JAZNPolicy;
import oracle.security.jazn.policy.PermissionClassDesc;
import oracle.security.jazn.policy.PermissionClassManager;
import oracle.security.jazn.policy.RealmPolicy;
import oracle.security.jazn.realm.Realm;
import oracle.security.jazn.realm.RealmManager;
import oracle.security.jazn.realm.RealmPrincipal;
import oracle.security.jazn.realm.RealmRole;
import oracle.security.jazn.realm.RealmUser;
import oracle.security.jazn.realm.RoleManager;
import oracle.security.jazn.spi.xml.XMLPrincipal;
import oracle.security.jazn.spi.xml.XMLRealmManager;
import oracle.security.jazn.spi.xml.XMLRoleManager;
import oracle.security.jazn.util.Env;
import oracle.security.jazn.util.ItemDesc;
import oracle.security.jazn.util.NVPair;

public class JAZNPolicyProvider
implements PolicyInspection {
    private JAZNContextHelper _contextHelper;
    private boolean isRealmPolicySupported;
    private static boolean _bAddPermission = false;
    private static ProtectionDomain _thisPD = null;
    private static CodeSource _thisCS = null;
    static char NAME_ACTION_SEPARATOR = (char)36;
    static String PAGE_PERMISSION_CLASS = "oracle.adf.share.security.authorization.mds.PagePermission";
    static String MDS_PERMISSION_CLASS = "oracle.adf.share.security.authorization.mds.MDSPermission";
    private JAZNConfig _primaryConfig;
    private JAZNConfig _config;
    private JAZNConfig _localConfig;
    private static Grantee _anyoneGrantee = null;

    private /* synthetic */ void $init$() {
        this.isRealmPolicySupported = true;
        this._primaryConfig = null;
        this._config = null;
        this._localConfig = null;
    }

    public JAZNPolicyProvider() {
        this(JAZNContextHelper.getInstance());
    }

    public JAZNPolicyProvider(JAZNContextHelper jAZNContextHelper) {
        this.$init$();
        this._contextHelper = jAZNContextHelper;
        this.init();
    }

    public void init() {
        this._config = this._contextHelper.getJAZNConfig();
        this._primaryConfig = this._contextHelper.getEmbeddedJAZNConfig();
        if (this._primaryConfig == null) {
            this._primaryConfig = this._config;
        }
        _thisPD = this.getClass().getProtectionDomain();
        _thisCS = _thisPD.getCodeSource();
        if (!this._primaryConfig.getProviderType().equals(Env.PROVIDER_TYPE_LDAP)) {
            this.isRealmPolicySupported = false;
        }
    }

    public void setLocalConfigPath(String string) {
        try {
            if (!this._primaryConfig.getProviderType().equals(Env.PROVIDER_TYPE_LDAP)) {
                Properties properties = new Properties();
                properties.setProperty(Env.PROP_DEFAULT_REALM, "jazn.com");
                properties.setProperty(Env.PROVIDER_TYPE, Env.PROVIDER_TYPE_XML);
                properties.setProperty(Env.PROP_LOCATION, string);
                this._localConfig = new JAZNConfig(properties);
                Realm realm = this.getJAZNRealm(this._localConfig.getDefaultRealm(), this._localConfig);
                if (realm == null) {
                    realm = ((XMLRealmManager)this._localConfig.getRealmManager()).createRealm(this._localConfig.getDefaultRealm(), "oc4jadmin", "welcome", "oc4j-administrators");
                    ((XMLRoleManager)realm.getRoleManager()).dropRole("oc4j-administrators", true);
                    realm.getUserManager().dropUser("oc4jadmin");
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refresh(boolean bl) {
        if (bl) {
            this._contextHelper.persistJAZNData(this._primaryConfig);
            if (this._localConfig != null) {
                this._contextHelper.persistJAZNData(this._localConfig);
            }
        }
    }

    Realm getJAZNRealm(String string, JAZNConfig jAZNConfig) {
        Realm realm = null;
        try {
            RealmManager realmManager = jAZNConfig.getRealmManager();
            if (realmManager != null) {
                realm = realmManager.getRealm(string);
            }
        }
        catch (JAZNException jAZNException) {
            // empty catch block
        }
        return realm;
    }

    public JAZNPolicy getGlobalPolicy() {
        return this.getGlobalPolicy(this._primaryConfig);
    }

    private JAZNPolicy getGlobalPolicy(JAZNConfig jAZNConfig) {
        GlobalPolicy globalPolicy = null;
        try {
            globalPolicy = jAZNConfig.getPolicyManager().getGlobalPolicy();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return globalPolicy;
    }

    public JAZNPolicy getRealmPolicy(Realm realm) {
        return this.getRealmPolicy(realm, this._primaryConfig);
    }

    public JAZNPolicy getRealmPolicy(Realm realm, JAZNConfig jAZNConfig) {
        RealmPolicy realmPolicy = null;
        if (!this.isRealmPolicySupported) {
            return null;
        }
        try {
            realmPolicy = jAZNConfig.getPolicyManager().getRealmPolicy(realm);
        }
        catch (Exception exception) {
            this.isRealmPolicySupported = false;
        }
        return realmPolicy;
    }

    public void addPolicyStatement(PolicyStatement policyStatement) {
        Permission permission = policyStatement.getPermission();
        if (_bAddPermission) {
            this.addPerm(permission.getName(), permission.getClass().getName(), new String[]{permission.getActions()}, permission.getName(), "ADF");
        }
        Realm realm = null;
        Principal principal = policyStatement.getPrincipal();
        PolicyStatement[] policyStatementArray = this.getPolicyStatements(principal, new Class[]{policyStatement.getPermission().getClass()});
        int n = 0;
        while (n < policyStatementArray.length) {
            Permission permission2 = policyStatementArray[n].getPermission();
            if (permission2.getName().equalsIgnoreCase(policyStatement.getPermission().getName()) && permission2.getActions().equalsIgnoreCase(policyStatement.getPermission().getActions())) {
                return;
            }
            ++n;
        }
        if (principal instanceof RealmPrincipal) {
            realm = ((RealmPrincipal)principal).getRealm();
        } else if (principal instanceof XMLPrincipal) {
            String string = ((XMLPrincipal)principal).getPrincipalRealmName();
            realm = this.getJAZNRealm(string, this._primaryConfig);
        }
        if (realm == null) {
            realm = this.getJAZNRealm(this._primaryConfig.getDefaultRealm(), this._primaryConfig);
        }
        this.grantPermission(principal, realm, permission.getClass().getName(), new String[]{permission.getName(), permission.getActions()}, this._primaryConfig);
        if (this._config != this._primaryConfig && this._contextHelper.isDualUpdate()) {
            realm = this.getJAZNRealm(realm.getName(), this._config);
            RealmRole realmRole = this._contextHelper.getRealmRole(principal.getName(), this._config);
            if (realm != null && realmRole != null) {
                this.grantPermission(principal, realm, permission.getClass().getName(), new String[]{permission.getName(), permission.getActions()}, this._config);
            }
        }
        if (this._localConfig != null) {
            try {
                Realm realm2 = this.getJAZNRealm(realm.getName(), this._localConfig);
                if (realm2 == null) {
                    realm2 = ((XMLRealmManager)this._localConfig.getRealmManager()).createRealm(realm.getFullName(), "oc4jadmin", "welcome", "oc4j-administrators");
                    ((XMLRoleManager)realm2.getRoleManager()).dropRole("oc4j-administrators", true);
                    realm2.getUserManager().dropUser("oc4jadmin");
                }
                RealmRole realmRole = this._contextHelper.getRealmRole(principal.getName(), this._localConfig);
                Object object = null;
                object = realmRole != null ? realmRole : (principal.getName().equals("anyone") ? JAZNIdentityManagementProvider.getADFRolePrincipal() : realm2.getRoleManager().createRole(principal.getName()));
                if (realm2 != null && object != null) {
                    this.grantPermission((Principal)object, realm2, permission.getClass().getName(), new String[]{permission.getName(), permission.getActions()}, this._localConfig);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void removePolicyStatement(PolicyStatement policyStatement) {
        Principal principal = policyStatement.getPrincipal();
        PolicyStatement[] policyStatementArray = this.getPolicyStatements(principal, new Class[]{policyStatement.getPermission().getClass()});
        int n = 0;
        while (n < policyStatementArray.length) {
            Permission permission = policyStatementArray[n].getPermission();
            if (permission.getName().equalsIgnoreCase(policyStatement.getPermission().getName())) {
                this.revokePerm(principal, permission, this._primaryConfig);
                Realm realm = null;
                if (principal instanceof RealmPrincipal) {
                    realm = ((RealmPrincipal)principal).getRealm();
                } else if (principal instanceof XMLPrincipal) {
                    String string = ((XMLPrincipal)principal).getPrincipalRealmName();
                    realm = this.getJAZNRealm(string, this._primaryConfig);
                }
                if (this._config != this._primaryConfig && this._contextHelper.isDualUpdate()) {
                    realm = this.getJAZNRealm(realm.getName(), this._config);
                    RealmRole realmRole = this._contextHelper.getRealmRole(principal.getName(), this._config);
                    if (realm != null && realmRole != null) {
                        this.revokePerm(policyStatement.getPrincipal(), policyStatement.getPermission(), this._config);
                    }
                }
                if (this._localConfig != null) {
                    RealmRole realmRole = this._contextHelper.getRealmRole(principal.getName(), this._localConfig);
                    Object object = null;
                    if (realmRole != null) {
                        realm = realmRole.getRealm();
                        object = realmRole;
                    } else if (realmRole == null && principal.getName().equals("anyone")) {
                        object = JAZNIdentityManagementProvider.getADFRolePrincipal();
                        realm = this.getJAZNRealm(this._primaryConfig.getDefaultRealm(), this._primaryConfig);
                    }
                    if (realm != null && object != null) {
                        this.revokePerm((Principal)object, policyStatement.getPermission(), this._localConfig);
                    }
                }
            }
            ++n;
        }
    }

    public PolicyStatement[] getPolicyStatements(Principal principal, Class[] classArray) {
        RealmRole realmRole = this._contextHelper.getRealmRole(principal.getName(), this._primaryConfig);
        Object object = null;
        Realm realm = null;
        if (realmRole != null) {
            realm = realmRole.getRealm();
            object = realmRole;
        } else if (realmRole == null && principal.getName().equals("anyone")) {
            object = JAZNIdentityManagementProvider.getADFRolePrincipal();
            realm = this.getJAZNRealm(this._primaryConfig.getDefaultRealm(), this._primaryConfig);
        }
        ArrayList arrayList = this.retrieveGrantedPermissions(realm, (Principal)object, classArray);
        PolicyStatement[] policyStatementArray = new PolicyStatement[arrayList.size()];
        int n = 0;
        while (n < arrayList.size()) {
            Permission permission = (Permission)arrayList.get(n);
            policyStatementArray[n] = new PolicyStatement(principal, permission);
            ++n;
        }
        return policyStatementArray;
    }

    public PolicyStatement[] getPolicyStatements(String string, Class clazz) {
        ArrayList<PolicyStatement> arrayList = new ArrayList<PolicyStatement>();
        Collection collection = null;
        Realm realm = this.getJAZNRealm(this._primaryConfig.getDefaultRealm(), this._primaryConfig);
        JAZNPolicy jAZNPolicy = this.getRealmPolicy(realm);
        try {
            if (jAZNPolicy == null) {
                jAZNPolicy = this.getGlobalPolicy();
                collection = ((GlobalPolicy)jAZNPolicy).getGrantees();
            } else {
                collection = ((RealmPolicy)jAZNPolicy).getGrantees();
            }
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Grantee grantee = (Grantee)iterator.next();
                ArrayList arrayList2 = this.retrieveGrantedPermissions(jAZNPolicy, grantee, new Class[]{clazz});
                Set set = grantee.getPrincipals();
                Iterator iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    Principal principal = (Principal)iterator2.next();
                    if (_anyoneGrantee == null && principal.getName().equals("anyone")) {
                        _anyoneGrantee = grantee;
                    }
                    int n = 0;
                    while (n < arrayList2.size()) {
                        Permission permission = (Permission)arrayList2.get(n);
                        if (permission.getName().equals(string)) {
                            arrayList.add(new PolicyStatement(principal, permission));
                        }
                        ++n;
                    }
                }
            }
        }
        catch (JAZNException jAZNException) {
            // empty catch block
        }
        return arrayList.toArray(new PolicyStatement[arrayList.size()]);
    }

    public PermissionClassDescriptor[] getPermissionClassDescriptors() {
        return null;
    }

    public boolean addPermissionClassDescriptor(PermissionClassDescriptor permissionClassDescriptor) {
        PermissionClassDescriptor permissionClassDescriptor2 = this.getPermissionClassDescriptor(permissionClassDescriptor.getPermissionClass());
        if (permissionClassDescriptor2 == null) {
            PermissionActionDescriptor[] permissionActionDescriptorArray = permissionClassDescriptor.getPermissionActionDescriptors();
            String[] stringArray = null;
            if (permissionActionDescriptorArray != null && permissionActionDescriptorArray.length > 0) {
                stringArray = new String[permissionActionDescriptorArray.length];
                int n = 0;
                while (n < permissionActionDescriptorArray.length) {
                    stringArray[n] = permissionActionDescriptorArray[n].getName();
                    ++n;
                }
            }
            this.addPerm(permissionClassDescriptor.getDisplayName(), permissionClassDescriptor.getPermissionClass().getName(), stringArray, permissionClassDescriptor.getDisplayName(), "ADF");
        }
        return true;
    }

    public boolean removePermissionClassDescriptor(Class clazz) {
        return false;
    }

    public PermissionClassDescriptor getPermissionClassDescriptor(Class clazz) {
        PermissionClassManager permissionClassManager = this._primaryConfig.getPermissionClassManager();
        PermissionClassDesc permissionClassDesc = permissionClassManager.getPermissionClass(clazz.getName());
        if (permissionClassDesc == null) {
            return null;
        }
        ItemDesc itemDesc = permissionClassDesc.getClassDesc();
        Collection collection = permissionClassDesc.getActionsDesc();
        Iterator iterator = collection.iterator();
        PermissionActionDescriptor[] permissionActionDescriptorArray = new PermissionActionDescriptor[collection.size()];
        int n = 0;
        while (iterator.hasNext()) {
            NVPair nVPair = (NVPair)iterator.next();
            PermissionActionDescriptor permissionActionDescriptor = new PermissionActionDescriptor(nVPair.getName(), nVPair.getValue());
            permissionActionDescriptorArray[n++] = permissionActionDescriptor;
        }
        Collection collection2 = permissionClassDesc.getTargetsDesc();
        Iterator iterator2 = collection2.iterator();
        PermissionTargetDescriptor[] permissionTargetDescriptorArray = new PermissionTargetDescriptor[collection2.size()];
        n = 0;
        while (iterator2.hasNext()) {
            NVPair nVPair = (NVPair)iterator2.next();
            PermissionTargetDescriptor permissionTargetDescriptor = new PermissionTargetDescriptor(nVPair.getName(), nVPair.getValue());
            permissionTargetDescriptorArray[n++] = permissionTargetDescriptor;
        }
        return new PermissionClassDescriptor(itemDesc.getDisplayName(), clazz, permissionActionDescriptorArray, permissionTargetDescriptorArray);
    }

    private String getGrantName(Permission permission) {
        StringBuffer stringBuffer = new StringBuffer(permission.getName());
        stringBuffer.append(NAME_ACTION_SEPARATOR).append(permission.getActions());
        return stringBuffer.toString();
    }

    public void grantPermission(Principal principal, Realm realm, String string, String[] stringArray, JAZNConfig jAZNConfig) {
        try {
            Grantee grantee = this.createGrantee(realm, principal);
            JAZNPolicy jAZNPolicy = this.getRealmPolicy(realm, jAZNConfig);
            if (jAZNPolicy == null) {
                jAZNPolicy = this.getGlobalPolicy(jAZNConfig);
            }
            Constructor<?>[] constructorArray = Class.forName(string).getConstructors();
            Object var9_9 = null;
            if (stringArray == null) {
                stringArray = new String[]{};
            } else {
                int n = 0;
                while (n < constructorArray.length) {
                    try {
                        if (stringArray.length == constructorArray[n].getParameterTypes().length) {
                            var9_9 = constructorArray[n].newInstance(stringArray);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    ++n;
                }
            }
            if (var9_9 == null) {
                System.out.println("Invalid argument ");
            } else {
                jAZNPolicy.grant(grantee, (Permission)var9_9);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private ArrayList retrieveGrantedPermissions(JAZNPolicy jAZNPolicy, Grantee grantee, Class[] classArray) {
        ArrayList<Permission> arrayList = new ArrayList<Permission>();
        try {
            int n = 0;
            while (n < classArray.length) {
                PermissionCollection permissionCollection = jAZNPolicy.getPermissions(grantee, classArray[n]);
                if (permissionCollection != null) {
                    Enumeration<Permission> enumeration = permissionCollection.elements();
                    while (enumeration.hasMoreElements()) {
                        Permission permission = enumeration.nextElement();
                        if (permission.getClass() != classArray[n]) continue;
                        arrayList.add(permission);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private ArrayList retrieveGrantedPermissions(Realm realm, Principal principal, Class[] classArray) {
        ArrayList<Permission> arrayList = new ArrayList<Permission>();
        try {
            JAZNPolicy jAZNPolicy = this.getRealmPolicy(realm);
            if (jAZNPolicy == null) {
                jAZNPolicy = this.getGlobalPolicy();
            }
            Grantee grantee = new Grantee(principal);
            int n = 0;
            while (n < classArray.length) {
                PermissionCollection permissionCollection = jAZNPolicy.getPermissions(grantee, classArray[n]);
                if (permissionCollection != null) {
                    Enumeration<Permission> enumeration = permissionCollection.elements();
                    while (enumeration.hasMoreElements()) {
                        Permission permission = enumeration.nextElement();
                        if (permission.getClass() != classArray[n]) continue;
                        arrayList.add(permission);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    private void addPerm(String string, String string2, String[] stringArray, String string3, String string4) {
        if (stringArray.equals("-null")) {
            stringArray = null;
        }
        if (string3.equals("-null")) {
            string3 = null;
        }
        int n = string2.startsWith("oracle.security.jazn") ? 1 : (string2.startsWith("java") ? 0 : (string2.startsWith("oracle") ? 2 : 3));
        ItemDesc itemDesc = new ItemDesc(string2, string4, string);
        NVPair[] nVPairArray = null;
        if (stringArray != null) {
            nVPairArray = new NVPair[stringArray.length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                nVPairArray[n2] = new NVPair(stringArray[n2], "");
                ++n2;
            }
        } else {
            nVPairArray = null;
        }
        NVPair[] nVPairArray2 = new NVPair[1];
        if (string3 != null) {
            nVPairArray2[0] = new NVPair(string3, "");
        } else {
            nVPairArray2 = null;
        }
        try {
            JAZNContextHelper.getPermissionClassManager().addPermissionClass(new PermissionClassDesc(n, itemDesc, nVPairArray2, nVPairArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void revokePerm(Principal principal, Permission permission, JAZNConfig jAZNConfig) {
        try {
            Realm realm = this.getRealm(principal, jAZNConfig);
            JAZNPolicy jAZNPolicy = this.getRealmPolicy(realm, jAZNConfig);
            if (jAZNPolicy == null) {
                jAZNPolicy = this.getGlobalPolicy(jAZNConfig);
            }
            Grantee grantee = this.createGrantee(realm, principal);
            jAZNPolicy.revoke(grantee, permission);
        }
        catch (Exception exception) {
            this._contextHelper.getADFSecurityLogger().log(Level.FINE, "Error revoke perm " + permission.getName());
        }
    }

    public boolean hasPermission(Permission permission, Principal principal) {
        if (principal == null || permission == null) {
            return false;
        }
        Realm realm = this.getRealm(principal);
        ArrayList arrayList = this.getGrantedRoles(principal, realm);
        try {
            JAZNPolicy jAZNPolicy = null;
            if (this.isRealmPolicySupported && realm != null) {
                jAZNPolicy = this.getRealmPolicy(realm);
            }
            if (jAZNPolicy == null) {
                jAZNPolicy = this.getGlobalPolicy();
            }
            int n = 0;
            while (n < arrayList.size()) {
                Grantee grantee = new Grantee((Principal)arrayList.get(n));
                if (jAZNPolicy.hasPermission(grantee, permission)) {
                    boolean bl = true;
                    return bl;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    Realm getRealm(Principal principal) {
        return this.getRealm(principal, this._primaryConfig);
    }

    Realm getRealm(Principal principal, JAZNConfig jAZNConfig) {
        if (principal == null) {
            return null;
        }
        Realm realm = null;
        String string = principal.getName();
        try {
            int n = string.indexOf(47);
            if (n != -1) {
                String string2 = string.substring(0, n);
                realm = jAZNConfig.getRealmManager().getRealm(string2);
            } else {
                realm = jAZNConfig.getRealmManager().getRealm(jAZNConfig.getDefaultRealm());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return realm;
    }

    Principal getRealmPrincipal(Realm realm, String string) {
        RealmUser realmUser = null;
        try {
            realmUser = realm.getUserManager().getUser(string);
        }
        catch (JAZNException jAZNException) {
            jAZNException.printStackTrace();
        }
        return (Principal)realmUser;
    }

    String getPrivileges(String string, String string2, Principal principal) {
        StringBuffer stringBuffer = new StringBuffer();
        Realm realm = this.getRealm(principal);
        ArrayList arrayList = this.getGrantedRoles(principal, realm);
        arrayList.add(principal);
        try {
            JAZNPolicy jAZNPolicy = this.getRealmPolicy(realm);
            if (jAZNPolicy == null) {
                jAZNPolicy = this.getGlobalPolicy();
            }
            int n = 0;
            while (n < arrayList.size()) {
                Grantee grantee = new Grantee((Principal)((RealmPrincipal)arrayList.get(n)));
                String[] stringArray = new String[]{string};
                int n2 = 0;
                int n3 = 0;
                while (n3 < stringArray.length) {
                    PermissionCollection permissionCollection = jAZNPolicy.getPermissions(grantee, Class.forName(stringArray[n3]));
                    if (permissionCollection != null) {
                        Enumeration<Permission> enumeration = permissionCollection.elements();
                        while (enumeration.hasMoreElements()) {
                            Permission permission = enumeration.nextElement();
                            if (!permission.getName().equals(string2)) continue;
                            if (n2 > 0) {
                                stringBuffer.append(",");
                            }
                            stringBuffer.append(permission.getActions());
                            ++n2;
                        }
                    }
                    ++n3;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Vector vector = ADFPermission.parseActions(stringBuffer.toString());
        String string3 = "";
        int n = 0;
        while (n < vector.size()) {
            if (n > 0 && n < vector.size()) {
                string3 = string3 + ",";
            }
            string3 = string3 + (String)vector.elementAt(n);
            ++n;
        }
        return string3;
    }

    ArrayList getGrantedRoles(Principal principal, Realm realm) {
        Subject subject = ADFContext.getCurrent().getSecurityContext().getSubject();
        if (subject != null) {
            return this.getRolesFromSubject(subject);
        }
        ArrayList<Principal> arrayList = new ArrayList<Principal>();
        arrayList.add(principal);
        if (ADFContext.getCurrent().getSecurityContext().isAnyoneEnabled()) {
            ADFUserPrincipal aDFUserPrincipal = new ADFUserPrincipal("anonymous");
            ADFRolePrincipal aDFRolePrincipal = new ADFRolePrincipal("anyone");
            aDFRolePrincipal.addUserGrantee(aDFUserPrincipal);
            arrayList.add(aDFRolePrincipal);
        }
        RealmManager realmManager = this._primaryConfig.getRealmManager();
        if (realm != null && realmManager instanceof XMLRealmManager) {
            try {
                RoleManager roleManager = realm.getRoleManager();
                Principal principal2 = this.getRealmPrincipal(realm, principal.getName());
                Set set = ((XMLRoleManager)roleManager).getGrantedRoles((RealmPrincipal)principal2, false);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    arrayList.add((Principal)iterator.next());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    Grantee createGrantee(Realm realm, Principal principal) {
        Grantee grantee = null;
        try {
            RoleManager roleManager = realm.getRoleManager();
            String string = principal.getName();
            RealmRole realmRole = roleManager.getRole(string);
            if (realmRole == null) {
                realmRole = (RealmPrincipal)this.getRealmPrincipal(realm, string);
            }
            if (realmRole != null) {
                grantee = new Grantee((Principal)realmRole);
            } else if (string.equals("anyone")) {
                if (_anyoneGrantee == null) {
                    _anyoneGrantee = grantee = new Grantee(principal);
                } else {
                    grantee = _anyoneGrantee;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return grantee;
    }

    ArrayList getRolesFromSubject(Subject subject) {
        ArrayList<Principal> arrayList = new ArrayList<Principal>();
        Iterator<Principal> iterator = subject.getPrincipals().iterator();
        while (iterator.hasNext()) {
            Principal principal = iterator.next();
            if (!(principal instanceof RealmRole)) continue;
            arrayList.add(principal);
        }
        return arrayList;
    }
}

