/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.identitymanagement;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Properties;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.identitymanagement.AttributeFilter;
import oracle.adf.share.security.identitymanagement.User;
import oracle.adf.share.security.identitymanagement.spi.IdentityManagement;

public class UserManager {
    private static final String PROVIDER_CLASS_PROPERTY = "providerClass";
    private IdentityManagement identityManagementProvider;

    private /* synthetic */ void $init$() {
        this.identityManagementProvider = null;
    }

    private static Object createObject(String string) {
        Object var1_1 = null;
        Class<?> clazz = Class.forName(string);
        var1_1 = clazz.newInstance();
        return var1_1;
    }

    private void setidentityManagementProvider(IdentityManagement identityManagement) {
        this.identityManagementProvider = identityManagement;
    }

    private void checkProviderConfiguration() throws SecurityException {
        if (this.identityManagementProvider == null) {
            throw new UnsupportedOperationException("Provider not installed.");
        }
    }

    public UserManager() {
        this.$init$();
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("test.properties"));
        }
        catch (IOException iOException) {
            System.out.println(iOException.getMessage());
        }
        String string = properties.getProperty(PROVIDER_CLASS_PROPERTY);
        if (string != null) {
            IdentityManagement identityManagement = (IdentityManagement)UserManager.createObject(string);
            this.setidentityManagementProvider(identityManagement);
        }
    }

    public UserManager(String string) {
        this.$init$();
        if (string != null) {
            IdentityManagement identityManagement = (IdentityManagement)UserManager.createObject(string);
            this.setidentityManagementProvider(identityManagement);
        }
    }

    public Principal addUser(User user, Credential credential) {
        return this.identityManagementProvider.addUser(user, credential);
    }

    public User createUser() {
        return this.identityManagementProvider.createUser();
    }

    public Principal getPrincipal(String string) {
        return string == null || string.length() == 0 ? null : this.identityManagementProvider.getUserPrincipal(string);
    }

    public User getUser(Principal principal) {
        return principal == null ? null : this.identityManagementProvider.getUser(principal);
    }

    public void modifyUser(Principal principal, User user) {
        if (principal != null && user != null) {
            this.identityManagementProvider.modifyUser(principal, user);
        }
    }

    public void deleteUser(Principal principal) {
        if (principal != null) {
            this.identityManagementProvider.deleteUser(principal);
        }
    }

    public boolean isAddUserSupported() {
        return false;
    }

    public boolean isModifyUserSupported() {
        return false;
    }

    public boolean isDeleteUserSupported() {
        return false;
    }

    public ArrayList getUserList(int n, AttributeFilter[] attributeFilterArray) {
        return this.identityManagementProvider.getUserList(n, attributeFilterArray);
    }

    public ArrayList getUserList(int n, AttributeFilter[] attributeFilterArray, Principal principal) {
        return this.identityManagementProvider.getUserList(n, attributeFilterArray, principal);
    }
}

