/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.credentialstore;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityEnv;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.spi.CredentialProvisioning;
import oracle.adf.share.security.credentialstore.spi.CredentialStorage;

class CredentialStoreContext {
    private static CredentialStoreContext _singleton;
    private static final Object __LOCK__;
    private static Hashtable _sessionCredentials;
    private Vector mProviders;

    private /* synthetic */ void $init$() {
        this.mProviders = new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CredentialStoreContext getInstance() {
        Object object = __LOCK__;
        synchronized (object) {
            if (_singleton == null) {
                CredentialStoreContext credentialStoreContext = _singleton = new CredentialStoreContext();
                return credentialStoreContext;
            }
        }
        return _singleton;
    }

    public void initialize(Properties properties) {
    }

    public CredentialStorage getDefaultCredentialStoreProvider() {
        SecurityContext securityContext = ADFContext.getCurrent().getSecurityContext();
        String string = null;
        try {
            string = (String)securityContext.getEnvironment().get("oracle.adf.security.credentialstore");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            string = SecurityEnv.CREDENTIAL_STORE_PROVIDER_DEFAULT;
        }
        return this.getCredentialStorage(string);
    }

    public CredentialProvisioning getDefaultCredentialProvisioner() {
        return (CredentialProvisioning)((Object)this.getDefaultCredentialStoreProvider());
    }

    public CredentialProvisioning getCredentialProvisioner(String string) {
        return (CredentialProvisioning)((Object)this.getCredentialStorage(string));
    }

    public CredentialStorage getCredentialStoreProvider(String string) {
        return this.getCredentialStorage(string);
    }

    public CredentialStorage getCredentialStorage(String string) {
        CredentialStorage credentialStorage = null;
        int n = 0;
        while (n < this.mProviders.size()) {
            Object e = this.mProviders.get(n);
            if (e.getClass().getName().equals(string)) {
                return (CredentialStorage)e;
            }
            ++n;
        }
        Class<?> clazz = Class.forName(string);
        credentialStorage = (CredentialStorage)clazz.newInstance();
        this.mProviders.add(credentialStorage);
        return credentialStorage;
    }

    public static void storeSessionCredential(Credential credential, String string) {
        _sessionCredentials.put(string, credential);
    }

    public static Credential fetchSessionCredential(String string) {
        return (Credential)_sessionCredentials.get(string);
    }

    CredentialStoreContext() {
        this.$init$();
    }

    static {
        __LOCK__ = new Object();
        _sessionCredentials = new Hashtable();
    }
}

