/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.credentialstore;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import oracle.adf.share.security.credentialstore.CredentialStoreEnv;
import oracle.adf.share.security.credentialstore.ProviderProperties;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class CredentialStoreConfig {
    private Hashtable _providers;
    private static String _configFilePath;
    private static URL _configFileURL;
    private static XMLDocument xmlDoc;

    private /* synthetic */ void $init$() {
        this._providers = new Hashtable();
    }

    public CredentialStoreConfig(String string) {
        this.$init$();
        _configFilePath = string;
    }

    private static synchronized URL getConfigFileURL() {
        try {
            if (_configFileURL != null) {
                URL uRL = _configFileURL;
                return uRL;
            }
            String string = CredentialStoreConfig.getConfigFilePath();
            if (string != null) {
                File file = new File(string);
                URL uRL = _configFileURL = file.toURL();
                return uRL;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static synchronized String getConfigFilePath() {
        if (_configFilePath == null || _configFilePath.length() == 0) {
            _configFilePath = CredentialStoreConfig.getConfigFileFromSystemProperty();
        }
        return _configFilePath;
    }

    void loadFromXML() {
        DOMParser dOMParser = new DOMParser();
        XMLElement xMLElement = null;
        try {
            Node node;
            Reader reader = this.createReader(CredentialStoreConfig.getConfigFileURL());
            if (reader == null) {
                return;
            }
            dOMParser.parse(reader);
            xmlDoc = dOMParser.getDocument();
            xMLElement = (XMLElement)xmlDoc.getDocument().getDocumentElement();
            NodeList nodeList = xmlDoc.getElementsByTagName("providers");
            if (nodeList != null && (node = nodeList.item(0)).getNodeName().equals("providers") && node.hasChildNodes()) {
                this.loadProviderProperties(node.getChildNodes());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Reader createReader(URL uRL) throws IOException {
        InputStream inputStream = null;
        InputStreamReader inputStreamReader = null;
        if (uRL == null) {
            return null;
        }
        try {
            inputStream = uRL.openStream();
            inputStreamReader = new InputStreamReader(inputStream);
            Object var6_4 = null;
            if (inputStreamReader != null) return inputStreamReader;
            if (inputStream == null) return inputStreamReader;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (inputStreamReader != null || inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return inputStreamReader;
        }
        catch (Exception exception) {}
        return inputStreamReader;
    }

    private static String getConfigFileFromSystemProperty() {
        String string = null;
        try {
            string = System.getProperty(CredentialStoreEnv.CREDENTIAL_STORE_CONFIG);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    void loadProviderProperties(NodeList nodeList) {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            System.out.println(" Parent:   " + node.getNodeName());
            if (node.hasChildNodes()) {
                NodeList nodeList2 = node.getChildNodes();
                ProviderProperties providerProperties = new ProviderProperties();
                providerProperties.loadProperties(node);
                String string = providerProperties.getProperty(CredentialStoreEnv.PROVIDER_TYPE);
                if (string != null) {
                    this._providers.put(string, providerProperties);
                }
            }
            ++n;
        }
    }

    void showProviders() {
        Enumeration enumeration = this._providers.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ProviderProperties providerProperties = (ProviderProperties)this._providers.get(k);
            this.showProperties(providerProperties);
            ArrayList arrayList = providerProperties.getCredentialTypeProperties();
            int n = 0;
            while (n < arrayList.size()) {
                this.showProperties((Properties)arrayList.get(n));
                ++n;
            }
        }
    }

    void showProperties(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println(string + " = " + properties.getProperty(string));
        }
    }

    private Hashtable getProviders() {
        return this._providers;
    }

    public Properties getProperties(String string) {
        ProviderProperties providerProperties = (ProviderProperties)this._providers.get(string);
        return providerProperties;
    }

    public ProviderProperties getProviderProperties() {
        return (ProviderProperties)this._providers.get(this.getProviderTypes().get(0));
    }

    ArrayList getProviderTypes() {
        Enumeration enumeration = this._providers.keys();
        ArrayList arrayList = new ArrayList();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            System.out.println(" Provider = " + k);
            arrayList.add(k);
        }
        return arrayList;
    }

    ArrayList getCredentialTypeProperties(String string) {
        ProviderProperties providerProperties = (ProviderProperties)this._providers.get(string);
        return providerProperties.getCredentialTypeProperties();
    }

    public String getProviderClassName(String string) {
        ProviderProperties providerProperties = (ProviderProperties)this.getProviders().get(string);
        return providerProperties.getClassName();
    }

    public ProviderProperties getProviderProperties(String string) {
        Enumeration enumeration = this._providers.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            ProviderProperties providerProperties = (ProviderProperties)this._providers.get(k);
            if (!providerProperties.getClassName().equals(string)) continue;
            return providerProperties;
        }
        return null;
    }

    static {
        xmlDoc = null;
    }
}

