/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.authorization;

import java.security.CodeSource;
import java.security.Principal;

public class Grantee {
    private Principal _principal;
    private CodeSource _cs;

    public Grantee() {
        this(null, null);
    }

    public Grantee(Principal principal) {
        this(principal, null);
    }

    public Grantee(Principal principal, CodeSource codeSource) {
        this._principal = principal;
        this._cs = codeSource;
    }

    protected void setPrincipal(Principal principal) {
        this._principal = principal;
    }

    protected void setCodeSource(CodeSource codeSource) {
        this._cs = codeSource;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public CodeSource getCodeSource() {
        return this._cs;
    }

    private boolean matches(Grantee grantee) {
        if (this.getCodeSource() != null) {
            if (grantee.getCodeSource() == null) {
                return false;
            }
            if (!this.getCodeSource().equals(grantee.getCodeSource())) {
                return false;
            }
        } else if (grantee.getCodeSource() != null) {
            return false;
        }
        if (this._principal != null) {
            if (grantee.getPrincipal() == null) {
                return false;
            }
            if (this._principal.equals(grantee.getPrincipal())) {
                return false;
            }
        } else if (grantee.getPrincipal() != null) {
            return false;
        }
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof Grantee) {
            Grantee grantee = (Grantee)object;
            return this.matches(grantee);
        }
        return false;
    }
}

