/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.authentication;

import java.io.IOException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import oracle.adf.share.ADFContext;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.resource.ADFSecurityMessageBundle;

public class AuthenticationServlet
extends HttpServlet {
    private static ADFLogger _adfSecLogger = ADFSecurityUtil.getADFLogger();
    private static final String PARAM_KEY_SUCCESS_URL = "success_url";
    private static final String PARAM_KEY_END_URL = "end_url";
    private static final String PARAM_KEY_LOGIN = "login";
    private static final String PARAM_KEY_LOGOUT = "logout";
    public static final String ATTR_KEY_SUCCESS_URL = "success_url";
    static final String JSSOUTIL_CLASS = "oracle.security.jazn.sso.util.JSSOUtil";
    static final int SSO_AUTH = 0;
    static final int JSSO_AUTH = 1;
    static final int COREIDSSO_AUTH = 2;
    static String[] mAuthMethods = new String[]{"SSO", "CUSTOM_AUTH", "COREIDSSO"};
    String successUrl;
    String endUrl;
    private static /* synthetic */ Class class$javax$servlet$http$HttpServletResponse;
    private static /* synthetic */ Class class$java$lang$String;

    private /* synthetic */ void $init$() {
        this.successUrl = null;
        this.endUrl = null;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.successUrl = servletConfig.getInitParameter("success_url");
        this.endUrl = servletConfig.getInitParameter(PARAM_KEY_END_URL);
        try {
            String string = "oracle.adfinternal.extapp.credential.mbean.ConnectionCredentialMgr";
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName("oracle.adfinternal.extapp.credential.mbean.ConnectionCredentialMgr", true, classLoader);
            String string2 = "registerMBean";
            Method method = clazz.getMethod("registerMBean", null);
            method.invoke(null, null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.processRequest(httpServletRequest, httpServletResponse);
    }

    private void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        _adfSecLogger.log(Level.INFO, "AuthenticationServlet processRequest...");
        Hashtable hashtable = this.collectParms(httpServletRequest);
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (hashtable.containsKey(PARAM_KEY_LOGOUT)) {
            String[] stringArray = (String[])hashtable.get(PARAM_KEY_LOGOUT);
            if (stringArray.length > 0 && (stringArray[0].equals("true") || stringArray[0].equals(PARAM_KEY_LOGOUT))) {
                this.doLogout(hashtable, httpServletResponse, httpServletRequest);
            } else {
                httpServletResponse.sendError(500, ADFSecurityMessageBundle.getString("80111"));
            }
        } else {
            Principal principal = httpServletRequest.getUserPrincipal();
            if (hashtable.containsKey(PARAM_KEY_LOGIN)) {
                String[] stringArray = (String[])hashtable.get(PARAM_KEY_LOGIN);
                if (stringArray.length > 0 && stringArray[0].equals("true")) {
                    if (principal == null) {
                        _adfSecLogger.log(Level.WARNING, "No authentication user");
                        httpServletResponse.sendError(401, ADFSecurityMessageBundle.getString("80113"));
                    }
                } else {
                    httpServletResponse.sendError(500, ADFSecurityMessageBundle.getString("80112"));
                }
            }
            _adfSecLogger.log(Level.INFO, "User principal " + principal.getName());
            String string = null;
            if (hashtable.containsKey("success_url")) {
                String[] stringArray = (String[])hashtable.get("success_url");
                string = this.getEncodeRedirectURL(httpServletRequest, httpServletResponse, stringArray[0]);
            }
            if (string == null) {
                if (httpSession != null && (this.successUrl == null || this.successUrl.length() == 0)) {
                    string = (String)httpSession.getAttribute("success_url");
                    httpSession.removeAttribute("success_url");
                } else {
                    string = this.getEncodeRedirectURL(httpServletRequest, httpServletResponse, this.successUrl);
                }
            }
            if (string == null) {
                return;
            }
            _adfSecLogger.log(Level.INFO, "Success url " + string);
            if (httpSession != null) {
                httpSession.setAttribute("adf_session_invalidate_bindingcontainer_def", (Object)"true");
            }
            try {
                SecurityContext securityContext = ADFContext.getCurrent().getSecurityContext();
                securityContext.getEnvironment().remove("jaas.permissioncheck");
                securityContext.addToEnvironment("java.naming.security.principal", principal);
            }
            catch (Exception exception) {
                _adfSecLogger.log(Level.FINE, "Error setting security context environment " + exception.getMessage());
            }
            httpServletResponse.sendRedirect(string);
        }
    }

    public Hashtable collectParms(HttpServletRequest httpServletRequest) {
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        Enumeration enumeration = httpServletRequest.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String[] stringArray = httpServletRequest.getParameterValues(string);
            hashtable.put(string, stringArray);
        }
        return hashtable;
    }

    void doLogout(Hashtable hashtable, HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) throws IOException {
        String[] stringArray = (String[])hashtable.get(PARAM_KEY_END_URL);
        String string = null;
        HttpSession httpSession = httpServletRequest.getSession(false);
        string = (stringArray == null || stringArray.length == 0) && this.endUrl != null ? this.getEncodeRedirectURL(httpServletRequest, httpServletResponse, this.endUrl) : this.getEncodeRedirectURL(httpServletRequest, httpServletResponse, stringArray[0]);
        SecurityContext securityContext = ADFContext.getCurrent().getSecurityContext();
        try {
            securityContext.getEnvironment().remove("jaas.permissioncheck");
            securityContext.getEnvironment().remove("jaas.subject");
            securityContext.getEnvironment().remove("java.naming.security.principal");
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean bl = false;
        int n = this.getSSOType(httpServletRequest);
        if (n == 1 || n == 2) {
            bl = this.doJSSOLogout(httpServletResponse, string);
        } else if (n == 0) {
            bl = this.doSSOLogout(httpServletResponse, string);
        }
        if (httpSession != null) {
            httpSession.setAttribute("adf_session_invalidate_bindingcontainer_def", (Object)"true");
            httpServletRequest.getSession().invalidate();
        }
        if ((httpSession = httpServletRequest.getSession(false)) != null) {
            Enumeration enumeration = httpSession.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                _adfSecLogger.log(Level.INFO, "---- remove session attribute: " + string2);
                httpSession.removeAttribute(string2);
            }
        }
        if (!bl) {
            if (string != null) {
                httpServletResponse.sendRedirect(string);
            } else {
                httpServletResponse.setContentType("text/html");
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                servletOutputStream.println("<html>");
                servletOutputStream.println("<head><title>ADF Security</title></head>");
                servletOutputStream.println("<body>");
                servletOutputStream.println("<h1>You have been logout</h1>");
                servletOutputStream.println("</body>");
                servletOutputStream.println("</html>");
            }
        }
    }

    int getSSOType(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getAuthType();
        if (string != null) {
            int n = 0;
            while (n < mAuthMethods.length) {
                if (string.equals(mAuthMethods[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    boolean doJSSOLogout(HttpServletResponse httpServletResponse, String string) {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName(JSSOUTIL_CLASS);
            if (clazz != null) {
                Class[] classArray;
                Method method;
                Class clazz2;
                Class[] classArray2 = new Class[2];
                Class clazz3 = class$javax$servlet$http$HttpServletResponse;
                if (clazz3 == null) {
                    clazz3 = classArray2[0] = (class$javax$servlet$http$HttpServletResponse = AuthenticationServlet.class$("javax.servlet.http.HttpServletResponse"));
                }
                if ((clazz2 = class$java$lang$String) == null) {
                    clazz2 = classArray2[1] = (class$java$lang$String = AuthenticationServlet.class$("java.lang.String"));
                }
                if ((method = clazz.getMethod(PARAM_KEY_LOGOUT, classArray = classArray2)) != null) {
                    method.invoke(null, httpServletResponse, string);
                    _adfSecLogger.log(Level.INFO, "DONE JSSO Logout");
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            _adfSecLogger.log(Level.FINE, "Error on JSSO Logout ");
        }
        return bl;
    }

    boolean doSSOLogout(HttpServletResponse httpServletResponse, String string) {
        try {
            httpServletResponse.setHeader("Osso-Return-Url", string);
            httpServletResponse.sendError(470, "Oracle SSO");
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            _adfSecLogger.log(Level.FINE, "Error on SSO Logout ");
            return false;
        }
    }

    String getEncodeRedirectURL(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) {
        StringBuffer stringBuffer = new StringBuffer(httpServletRequest.getContextPath());
        if (!string.startsWith("/")) {
            stringBuffer.append("/");
        }
        stringBuffer.append(string);
        return httpServletResponse.encodeRedirectURL(stringBuffer.toString());
    }

    public AuthenticationServlet() {
        this.$init$();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

