/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.security.AccessController;
import java.security.Permission;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.SecurityContext;

public class SecurityContextImpl
implements SecurityContext {
    private static final int ENV_SIZE = 10;
    protected Hashtable mEnv;
    protected Hashtable mNames;
    private long _timeMillis;
    private static final Object __LOCK__ = new Object();
    private static final String SECURITYCONTEXT_PRINCIPAL = "__securitycontext_principal__";
    private static final String SECURITYCONTEXT_AUTH_TIMESTAMP = "__securitycontext_auth_timestamp__";

    private /* synthetic */ void $init$() {
        this.mEnv = new Hashtable(10);
        this.mNames = new Hashtable();
        this._timeMillis = 0L;
    }

    public SecurityContextImpl() {
        this(null);
    }

    public SecurityContextImpl(Hashtable hashtable) {
        this.$init$();
        if (hashtable != null) {
            this.mEnv = (Hashtable)hashtable.clone();
        }
    }

    public Principal getUserPrincipal() {
        return (Principal)this.mEnv.get("java.naming.security.principal");
    }

    public String getUserName() {
        Principal principal = this.getUserPrincipal();
        return principal != null ? principal.getName() : null;
    }

    public boolean isAuthorizationEnabled() {
        return false;
    }

    public boolean hasPermission(Permission permission) {
        return false;
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (string == null) {
            throw new InvalidNameException("Empty name.");
        }
        if (string.equals("")) {
            return new NameList(this.mNames.keySet().iterator(), true);
        }
        return new NameList(string, true);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (string == null) {
            throw new InvalidNameException("Empty name.");
        }
        if (string.equals("")) {
            return new NameList(this.mNames.keySet().iterator(), false);
        }
        return new NameList(string, false);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public void rename(String string, String string2) throws NamingException {
        if (string == null || string.equals("") || string2 == null || string2.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        Object v = null;
        Object v2 = this.mNames.get(string);
        v = v2;
        if (v2 == null) {
            throw new NameNotFoundException(string + " not bound.");
        }
        if (this.mNames.get(string2) != null) {
            throw new NameAlreadyBoundException(string2 + " already bound.");
        }
        this.mNames.remove(string);
        this.mNames.put(string2, v);
    }

    public void rename(Name name, Name name2) throws NamingException {
        if (name == null || name2 == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.rename(name.toString(), name2.toString());
    }

    public void bind(String string, Object object) throws NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (this.mNames.get(string) != null) {
            throw new NameAlreadyBoundException(string + " already bound.");
        }
        this.mNames.put(string, object);
    }

    public void bind(Name name, Object object) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.bind(name.toString(), object);
    }

    public void rebind(String string, Object object) throws NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        this.mNames.put(string, object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.rebind(name.toString(), object);
    }

    public void destroySubcontext(String string) throws NamingException {
        this.unbind(string);
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.destroySubcontext(name.toString());
    }

    public void unbind(String string) throws NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        this.mNames.remove(string);
    }

    public void unbind(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        this.unbind(name.toString());
    }

    public Context createSubcontext(String string) throws NamingException {
        throw new OperationNotSupportedException("Subcontext not supported.");
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.createSubcontext(name.toString());
    }

    public Object lookup(String string) throws NamingException {
        return this.mNames.get(string);
    }

    public Object lookup(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.lookup(name.toString());
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookup(string);
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.lookupLink(name.toString());
    }

    public NameParser getNameParser(String string) throws NamingException {
        throw new OperationNotSupportedException("getNameParser not supported.");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (name == null) {
            throw new InvalidNameException("Empty name.");
        }
        return this.getNameParser(name.toString());
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (string == "java.naming.security.principal" && object != null) {
            this.setPrincipal(object);
            return object;
        }
        return object != null ? this.mEnv.put(string, object) : null;
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (string == null || string.equals("")) {
            throw new InvalidNameException("Empty name.");
        }
        if (this.mEnv == null) {
            return null;
        }
        if (string == "java.naming.security.principal") {
            this.mEnv.remove("jaas.subject");
            this.mEnv.remove("oracle.adf.security.authenticated");
            this._timeMillis = 0L;
        }
        return this.mEnv.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.mEnv == null) {
            throw new NamingException("Null Environment");
        }
        return this.mEnv;
    }

    public void close() throws NamingException {
        this.mEnv = null;
    }

    public String getNameInNamespace() throws NamingException {
        return null;
    }

    void setPrincipal(Object object) {
        RuntimePermission runtimePermission = new RuntimePermission("setPrincipal");
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(runtimePermission);
        }
        this.mEnv.put("oracle.adf.security.authenticated", "true");
        this.mEnv.put("java.naming.security.principal", object);
        if (this.isAuthorizationEnabled()) {
            this.initTimeStamp(true);
        }
    }

    protected void initTimeStamp(boolean bl) {
        if (this._timeMillis != 0L && !bl) {
            return;
        }
        Principal principal = this.getUserPrincipal();
        if (ADFContext.getCurrent().isHttpContext()) {
            Map map = ADFContext.getCurrent().getSessionScope();
            if (map != null) {
                Object v = map.get(SECURITYCONTEXT_PRINCIPAL);
                if (v == principal || v != null && principal != null && ((Principal)v).getName().equals(principal.getName())) {
                    return;
                }
                if (principal != null) {
                    map.put(SECURITYCONTEXT_PRINCIPAL, principal);
                    map.put(SECURITYCONTEXT_AUTH_TIMESTAMP, new Long(this._timeMillis));
                    this._timeMillis = System.currentTimeMillis();
                } else {
                    this._timeMillis = 0L;
                }
            }
        } else {
            this._timeMillis = System.currentTimeMillis();
        }
    }

    public boolean isAuthenticated() {
        return this.mEnv.get("java.naming.security.principal") != null;
    }

    public boolean isUserInRole(String string) {
        Object object;
        if (ADFContext.getCurrent().isHttpContext() && (object = ADFContext.getCurrent().getEnvironment().getRequest()) != null) {
            return ((HttpServletRequest)object).isUserInRole(string);
        }
        Subject subject = this.getSubject();
        if (subject != null) {
            Iterator<Principal> iterator = subject.getPrincipals().iterator();
            while (iterator.hasNext()) {
                Principal principal = iterator.next();
                String string2 = principal.getName();
                int n = string2.indexOf("/");
                if ((n <= 0 || !string.regionMatches(0, string2, n + 1, string.length())) && !string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public Subject getSubject() {
        Subject subject = (Subject)this.mEnv.get("jaas.subject");
        if (subject == null) {
            subject = Subject.getSubject(AccessController.getContext());
        }
        return subject;
    }

    public boolean isAnyoneEnabled() {
        return ADFSecurityUtil.isAnyoneRoleEnabled();
    }

    public boolean isReAuthenticated(long l) {
        Map map;
        if (this._timeMillis == 0L && (map = ADFContext.getCurrent().getSessionScope()) != null) {
            Long l2 = (Long)map.get(SECURITYCONTEXT_AUTH_TIMESTAMP);
            if (l2 != null) {
                this._timeMillis = l2;
            } else {
                this.initTimeStamp(true);
            }
        }
        return this._timeMillis > l;
    }

    public class NameList
    implements NamingEnumeration {
        Iterator names;
        boolean isNameClassPair;

        NameList(String string, boolean bl) {
            ArrayList<String> arrayList = new ArrayList<String>(1);
            if (SecurityContextImpl.this.mNames.get(string) != null) {
                arrayList.add(string);
            }
            this.names = arrayList.iterator();
            this.isNameClassPair = bl;
        }

        NameList(Iterator iterator, boolean bl) {
            this.names = iterator;
            this.isNameClassPair = bl;
        }

        public boolean hasMoreElements() {
            return this.names.hasNext();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String string = (String)this.names.next();
            if (this.isNameClassPair) {
                return new NameClassPair(string, SecurityContextImpl.this.mNames.get(string).getClass().getName());
            }
            return new Binding(string, SecurityContextImpl.this.mNames.get(string));
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() throws NamingException {
            this.names = null;
        }
    }
}

