/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ADFSecurityException
extends Exception {
    private Throwable m_Cause;
    private String m_ErrorMsgKey;
    private Object[] m_MsgArgs;
    private ResourceBundle mResourceBundle;
    private static String s_DefaultMsgKey = "default";
    private static ResourceBundle sDefaultResourceBundle;

    static {
        try {
            ADFSecurityException.init("oracle.adf.share.security.resource.ADFSecurityMessages");
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource bundle ADFSecurityResources file");
        }
    }

    public static void init(String string) throws MissingResourceException {
        sDefaultResourceBundle = ResourceBundle.getBundle(string);
    }

    public ADFSecurityException() {
        this(s_DefaultMsgKey);
    }

    public ADFSecurityException(String string) {
        this(null, string, null);
    }

    public ADFSecurityException(String string, Object[] objectArray) {
        this(null, string, objectArray);
    }

    public ADFSecurityException(String string, ResourceBundle resourceBundle) {
        this(null, string, resourceBundle, null);
    }

    public ADFSecurityException(Throwable throwable) {
        this(throwable, s_DefaultMsgKey, null);
    }

    public ADFSecurityException(Throwable throwable, String string, Object object, Object object2, Object object3) {
        this(throwable, string, new Object[]{object, object2, object3});
    }

    public ADFSecurityException(Throwable throwable, String string, ResourceBundle resourceBundle, Object object, Object object2, Object object3) {
        this(throwable, string, resourceBundle, new Object[]{object, object2, object3});
    }

    public ADFSecurityException(Throwable throwable, String string, Object[] objectArray) {
        this(throwable, string, null, objectArray);
    }

    public ADFSecurityException(Throwable throwable, String string, ResourceBundle resourceBundle, Object[] objectArray) {
        this.m_Cause = throwable;
        this.m_ErrorMsgKey = string;
        this.mResourceBundle = resourceBundle;
        this.m_MsgArgs = objectArray;
    }

    public String getErrorMsgKey() {
        return this.m_ErrorMsgKey;
    }

    public String getErrorMessage() {
        String string = this.getLocalErrorMessage();
        if (this.m_Cause != null) {
            string = string.concat("    \n");
            if (this.m_Cause instanceof ADFSecurityException) {
                String string2 = ((ADFSecurityException)this.m_Cause).getErrorMessage();
                if (string2 != null) {
                    string = string.concat(string2);
                }
            } else {
                String string3 = this.m_Cause.getMessage();
                if (string3 != null) {
                    string = string.concat(string3);
                }
            }
        }
        return string;
    }

    public String getLocalErrorMessage() {
        String string = "";
        if (this.m_ErrorMsgKey.equals(s_DefaultMsgKey)) {
            if (this.m_Cause == null) {
                string = this.getResourceBundle().getString(this.m_ErrorMsgKey);
            }
        } else {
            string = this.getResourceBundle().getString(this.m_ErrorMsgKey);
            if (this.m_MsgArgs != null) {
                MessageFormat messageFormat = new MessageFormat(string);
                string = messageFormat.format(this.m_MsgArgs);
            }
        }
        return string;
    }

    public void printErrorMessage() {
        System.out.println(this.getErrorMessage());
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream printStream) {
        printStream.println();
        printStream.println(" Exception: ");
        super.printStackTrace(printStream);
        if (this.m_Cause != null) {
            printStream.println("Cause: ");
            this.m_Cause.printStackTrace(printStream);
        }
        printStream.println();
    }

    public void printStackTrace(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println("Exception: ");
        super.printStackTrace(printWriter);
        if (this.m_Cause != null) {
            printWriter.println("Cause: ");
            this.m_Cause.printStackTrace(printWriter);
        }
        printWriter.println();
        printWriter.flush();
    }

    public Throwable getCause() {
        return this.m_Cause;
    }

    public String getLocalizedMessage() {
        return this.getErrorMessage();
    }

    private ResourceBundle getResourceBundle() {
        if (this.mResourceBundle != null) {
            return this.mResourceBundle;
        }
        return sDefaultResourceBundle;
    }
}

