/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.io.PrintStream;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.SensorResult;
import oracle.adf.share.perf.analysis.TreeNode;

class SensorTree {
    private TreeSet mThreads;
    private String mUrl;
    private TreeNode mUrlThread;
    private static final int INDENTATION_SPACES = 2;
    private static int sXmlIdCount = 0;
    private int mMinThreadCount;
    private int mMaxThreadCount;
    private long mTotalThreadCount;
    private long mRequestCount;

    private /* synthetic */ void $init$() {
        this.mThreads = new TreeSet(new ThreadComparator());
        this.mUrl = null;
        this.mUrlThread = null;
        this.mMinThreadCount = Integer.MAX_VALUE;
        this.mMaxThreadCount = Integer.MIN_VALUE;
        this.mTotalThreadCount = 0L;
        this.mRequestCount = 0L;
    }

    SensorTree(int n, int n2, long l, long l2) {
        this.$init$();
        this.mMinThreadCount = n;
        this.mMaxThreadCount = n2;
        this.mTotalThreadCount = l;
        this.mRequestCount = l2;
    }

    void addThread(TreeNode treeNode, boolean bl) {
        if (bl) {
            if (this.mUrlThread == null) {
                this.mUrlThread = treeNode;
            } else if (this.mUrlThread.mResult.mHit < treeNode.mResult.mHit) {
                this.mThreads.add(this.mUrlThread);
                this.mUrlThread = treeNode;
            } else {
                this.mThreads.add(treeNode);
            }
        } else {
            this.mThreads.add(treeNode);
        }
    }

    TreeNode insertToThread(TreeNode treeNode, SensorResult sensorResult) {
        int n = sensorResult.mNameIndex;
        if (this.mUrl == null && ((String)Analyzer.sSensorTypes.get(n)).equalsIgnoreCase("s") && ((String)Analyzer.sSensorNames.get(n)).endsWith("/url")) {
            this.mUrl = sensorResult.getValue();
        }
        if (!((String)Analyzer.sSensorTypes.get(n)).equalsIgnoreCase("t") && Analyzer.sTimerOnly) {
            return treeNode;
        }
        return this.add(new TreeNode(sensorResult), treeNode);
    }

    private TreeNode add(TreeNode treeNode, TreeNode treeNode2) {
        if (treeNode2 == null) {
            return treeNode;
        }
        if (treeNode.mResult.mTimeStamp < treeNode2.mResult.mTimeStamp) {
            if (treeNode.mResult.mTimeStamp + treeNode.mResult.mElapseTime >= treeNode2.mResult.mTimeStamp + treeNode2.mResult.mElapseTime) {
                this.enclose(treeNode, treeNode2);
            } else {
                treeNode.mParent = treeNode2.mParent;
                if (treeNode.mParent != null) {
                    treeNode.mParent.mChild = treeNode;
                    treeNode2.mParent = null;
                }
                treeNode.mNext = treeNode2;
                treeNode.mPrev = treeNode2.mPrev;
                if (treeNode.mPrev != null) {
                    treeNode.mPrev.mNext = treeNode;
                    treeNode.mResult.setGap(treeNode.mPrev.mResult, false);
                }
                treeNode2.mPrev = treeNode;
                treeNode2.mResult.setGap(treeNode.mResult, false);
            }
            return treeNode;
        }
        if (treeNode.mResult.mTimeStamp >= treeNode2.mResult.mTimeStamp + treeNode2.mResult.mElapseTime) {
            treeNode = this.add(treeNode, treeNode2.mNext);
            treeNode.mPrev = treeNode2;
            treeNode2.mNext = treeNode;
            treeNode.mResult.setGap(treeNode2.mResult, false);
            return treeNode2;
        }
        if (treeNode.mResult.mTimeStamp + treeNode.mResult.mElapseTime <= treeNode2.mResult.mTimeStamp + treeNode2.mResult.mElapseTime) {
            if (treeNode.mResult.mTimeStamp == treeNode2.mResult.mTimeStamp && treeNode.mResult.mTimeStamp + treeNode.mResult.mElapseTime == treeNode2.mResult.mTimeStamp + treeNode2.mResult.mElapseTime) {
                this.enclose(treeNode, treeNode2);
                return treeNode;
            }
            treeNode2.mChild = treeNode = this.add(treeNode, treeNode2.mChild);
            treeNode.mParent = treeNode2;
            treeNode.mResult.setGap(treeNode2.mResult, true);
            return treeNode2;
        }
        if (treeNode.mResult.mTimeStamp == treeNode2.mResult.mTimeStamp) {
            this.enclose(treeNode, treeNode2);
            return treeNode;
        }
        System.out.println("Warning: two sensors with the same ecid and threadid should not have following situation:");
        System.out.println(" threadId=" + treeNode2.mResult.mThreadId + " rootNameIndex=" + treeNode2.mResult.mNameIndex + " timeStamp=" + treeNode2.mResult.mTimeStamp + " elapseTime=" + treeNode2.mResult.mElapseTime + " newNodeNameIndex=" + treeNode.mResult.mNameIndex + " timeStamp=" + treeNode.mResult.mTimeStamp + " elapseTime=" + treeNode.mResult.mElapseTime);
        treeNode.mNext = treeNode2.mNext;
        if (treeNode.mNext != null) {
            treeNode.mNext.mPrev = treeNode;
            treeNode.mNext.mResult.setGap(treeNode.mResult, false);
        }
        treeNode.mPrev = treeNode2;
        treeNode2.mNext = treeNode;
        treeNode.mResult.setGap(treeNode2.mResult, false);
        return treeNode2;
    }

    private void enclose(TreeNode treeNode, TreeNode treeNode2) {
        TreeNode treeNode3 = treeNode2;
        while (treeNode3.mNext != null) {
            if (treeNode.mResult.mTimeStamp + treeNode.mResult.mElapseTime < treeNode3.mNext.mResult.mTimeStamp + treeNode3.mNext.mResult.mElapseTime) break;
            treeNode3 = treeNode3.mNext;
        }
        treeNode.mParent = treeNode2.mParent;
        if (treeNode.mParent != null) {
            treeNode.mParent.mChild = treeNode;
        }
        treeNode.mChild = treeNode2;
        treeNode2.mParent = treeNode;
        treeNode2.mResult.setGap(treeNode.mResult, true);
        treeNode.mNext = treeNode3.mNext;
        if (treeNode.mNext != null) {
            treeNode.mNext.mPrev = treeNode;
            treeNode.mNext.mResult.setGap(treeNode.mResult, false);
        }
        treeNode3.mNext = null;
        treeNode.mPrev = treeNode2.mPrev;
        if (treeNode.mPrev != null) {
            treeNode.mPrev.mNext = treeNode;
            treeNode.mResult.setGap(treeNode.mPrev.mResult, false);
        }
        treeNode2.mPrev = null;
    }

    String getURL() {
        return this.mUrl;
    }

    void setThreadGap() {
        Iterator iterator = this.mThreads.iterator();
        long l = this.mUrlThread.mResult.mTimeStamp;
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            if (treeNode.mResult.mTimeStamp >= l) continue;
            l = treeNode.mResult.mTimeStamp;
        }
        iterator = this.mThreads.iterator();
        while (iterator.hasNext()) {
            TreeNode treeNode = (TreeNode)iterator.next();
            treeNode.mResult.mGap = treeNode.mResult.mTimeStamp - l;
        }
    }

    String getSummary() {
        if (this.mUrlThread == null) {
            System.out.println("Error: don't have thread that contains url sensor.");
            return "";
        }
        String string = "";
        if (this.mUrlThread != null) {
            double d = this.mUrlThread.getDuration();
            string = "request.avg=" + SensorResult.sDblFmt.format(d);
        }
        if (this.mThreads.size() > 0) {
            if (this.mUrlThread != null) {
                string = string + " | ";
            }
            string = string + "thread.avg=" + SensorResult.sDblFmt.format((double)this.mTotalThreadCount / (double)this.mRequestCount);
            if (this.mMaxThreadCount != this.mMinThreadCount) {
                string = string + " | thread.max=" + this.mMaxThreadCount + " | thread.min=" + this.mMinThreadCount;
            }
        }
        return string;
    }

    void print(PrintStream printStream) {
        int n = 1;
        if (Analyzer.sFormatXml) {
            n = 4;
        }
        TreeNode treeNode = this.mUrlThread;
        int n2 = this.mThreads.size();
        if (n2 > 0) {
            if (Analyzer.sFormatXml) {
                double d = (double)treeNode.mResult.mGap / (double)treeNode.mResult.mHit;
                double d2 = treeNode.getDuration() - d;
                printStream.println("      <branch id=\"thread" + sXmlIdCount++ + "\">");
                printStream.println("        <branchText>(gap=" + SensorResult.prependSpace(SensorResult.sDblFmt.format(d), 8) + " | avg=" + SensorResult.prependSpace(SensorResult.sDblFmt.format(d2), 8) + ") Main Thread: </branchText>");
                n += 4;
            } else {
                printStream.println("Main Thread: ");
                ++n;
            }
        }
        this.print(printStream, treeNode, n);
        if (n2 > 0 && Analyzer.sFormatXml) {
            printStream.println("      </branch>");
        }
        Iterator iterator = this.mThreads.iterator();
        int n3 = 1;
        while (iterator.hasNext()) {
            n = 1;
            if (Analyzer.sFormatXml) {
                n = 4;
            }
            treeNode = (TreeNode)iterator.next();
            if (n2 > 0) {
                if (Analyzer.sFormatXml) {
                    double d = (double)treeNode.mResult.mGap / (double)treeNode.mResult.mHit;
                    double d3 = treeNode.getDuration() - d;
                    printStream.println("      <branch id=\"thread" + sXmlIdCount++ + "\">");
                    printStream.println("        <branchText>(gap=" + SensorResult.prependSpace(SensorResult.sDblFmt.format(d), 8) + " | avg=" + SensorResult.prependSpace(SensorResult.sDblFmt.format(d3), 8) + ") Thread pattern: " + n3 + "</branchText>");
                    n += 4;
                } else {
                    printStream.println("Thread pattern: " + n3);
                    ++n;
                }
                ++n3;
            }
            this.print(printStream, treeNode, n);
            if (n2 <= 0 || !Analyzer.sFormatXml) continue;
            printStream.println("      </branch>");
        }
    }

    void print(PrintStream printStream, TreeNode treeNode, int n) {
        byte[] byArray = new byte[2 * (n - 1)];
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = 32;
            ++n2;
        }
        String string = new String(byArray);
        if (Analyzer.sFormatXml) {
            if (treeNode.mChild != null) {
                printStream.println(string + "<branch id=\"id" + sXmlIdCount++ + "\">");
                printStream.println(string + "  <branchText>");
            } else {
                printStream.println(string + "<leaf>");
                printStream.println(string + "  <leafText>");
            }
        }
        treeNode.mResult.print(printStream, true, string);
        if (Analyzer.sFormatXml) {
            if (treeNode.mChild != null) {
                printStream.println(string + "  </branchText>");
            } else {
                printStream.println(string + "  </leafText>");
            }
        }
        if (treeNode.mChild != null) {
            this.print(printStream, treeNode.mChild, n + 1);
        }
        if (Analyzer.sFormatXml) {
            if (treeNode.mChild != null) {
                printStream.println(string + "</branch>");
            } else {
                printStream.println(string + "</leaf>");
            }
        }
        if (treeNode.mNext != null) {
            this.print(printStream, treeNode.mNext, n);
        }
    }

    class ThreadComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            TreeNode treeNode = (TreeNode)object;
            TreeNode treeNode2 = (TreeNode)object2;
            if (treeNode.mResult.mHit < treeNode2.mResult.mHit) {
                return 1;
            }
            if (treeNode.mResult.mHit == treeNode2.mResult.mHit) {
                return 1;
            }
            return -1;
        }

        ThreadComparator() {
        }
    }
}

