/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf;

import java.util.logging.Level;
import oracle.adf.share.perf.ADFPerfLog;
import oracle.adf.share.perf.ADFPerfSensor;
import oracle.adf.share.perf.PerfUtil;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;

public class StateTracker
extends ADFPerfSensor {
    public static final byte DOUBLE = 1;
    public static final byte INTEGER = 3;
    public static final byte LONG = 2;
    public static final byte OBJECT = 5;
    private byte mType;
    private String mUnit;
    private State mState;

    private /* synthetic */ void $init$() {
        this.mState = null;
    }

    private StateTracker(Level level, String string, byte by, String string2, State state) {
        super(level, string);
        this.$init$();
        this.mType = by;
        this.mUnit = string2;
        this.mState = state;
    }

    public void increment(double d) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.increment(d);
        if (this.mEnablePerfLog) {
            this.log(Double.toString(d));
        }
    }

    public void increment(int n) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.increment(n);
        if (this.mEnablePerfLog) {
            this.log(Integer.toString(n));
        }
    }

    public void increment(long l) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.increment(l);
        if (this.mEnablePerfLog) {
            this.log(Long.toString(l));
        }
    }

    public void update(double d) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(d);
        if (this.mEnablePerfLog) {
            this.log(Double.toString(d));
        }
    }

    public void update(int n) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(n);
        if (this.mEnablePerfLog) {
            this.log(Integer.toString(n));
        }
    }

    public void update(long l) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(l);
        if (this.mEnablePerfLog) {
            this.log(Long.toString(l));
        }
    }

    public void update(Object object) {
        if (!this.mEnablePerfLog && !this.mEnableDms) {
            return;
        }
        this.mState.update(object);
        if (this.mEnablePerfLog) {
            this.log(object.toString());
        }
    }

    public static StateTracker createStateTracker(Level level, String string, String string2, byte by, String string3, String string4) {
        String string5 = PerfUtil.getNounType(string);
        return StateTracker.createStateTracker(level, string, string2, string5, by, string3, string4);
    }

    public static StateTracker createStateTracker(Level level, String string, String string2, String string3, byte by, String string4, String string5) {
        string = PerfUtil.standardizeGroupName(string);
        string2 = PerfUtil.standardizeSensorName(string2);
        String string6 = string + '/' + string2 + " " + "s";
        ADFPerfSensor aDFPerfSensor = PerfUtil.getSensor(string6);
        if (aDFPerfSensor != null && aDFPerfSensor instanceof StateTracker) {
            return (StateTracker)aDFPerfSensor;
        }
        State state = null;
        if (ADFPerfLog.getLevel().intValue() <= level.intValue() || PerfUtil.getDMSSensorLevel().intValue() <= level.intValue()) {
            Noun noun = Noun.create((String)string);
            noun.setType(string3);
            state = State.create((Noun)noun, (String)string2, (byte)by, (String)string4, (String)string5);
            state.deriveMetric(511);
        }
        StateTracker stateTracker = new StateTracker(level, string6, by, string4, state);
        stateTracker = (StateTracker)PerfUtil.putSensor(string6, stateTracker);
        return stateTracker;
    }

    private void log(String string) {
        if (this.mUnit != null && this.mUnit.length() != 0) {
            string = string + this.mUnit;
        }
        this.log(System.currentTimeMillis(), string, null);
    }
}

