/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf;

import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.perf.ADFPerfConstants;
import oracle.adf.share.perf.DumpPerfLogThread;
import oracle.adf.share.perf.PerfFormatter;
import oracle.adf.share.perf.PerfLogLine;
import oracle.adf.share.perf.PerfLogRecord;
import oracle.dms.instrument.ExecutionContext;

public class ADFPerfLog {
    private static Level sLevel = null;
    private static Logger sLog = null;
    private static Logger sIdxLog = null;
    private static int sBufSize = 100;
    private static final int MAXSENSORS_PER_LINE = 12;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static LinkedHashMap sLogRecordBuffer = new LinkedHashMap(sBufSize, 0.75f, true);
    private static LinkedList sDumpBuffer = new LinkedList();
    private static Thread sThread = null;
    private static final String ADFNAME = "oracle.adf.perf";
    private static final String ADFNAME_IDX = "oracle.adf.perfIdx";
    private static /* synthetic */ Class class$oracle$adf$share$perf$DumpPerfLogThread;

    public static Level getLevel() {
        if (sLevel == null) {
            sLog = Logger.getLogger(ADFNAME);
            if (System.getProperty("oracle.adf.share.perf.handler") != null) {
                if (sLog == null) {
                    sLevel = Level.OFF;
                } else {
                    String string;
                    Logger logger = sLog;
                    while ((sLevel = logger.getLevel()) == null) {
                        if ((logger = logger.getParent()) != null) continue;
                        sLevel = Level.SEVERE;
                        break;
                    }
                    if (sLevel != null && (string = System.getProperty("oracle.adf.share.perf.bufSize")) != null) {
                        sBufSize = Integer.parseInt(string);
                    }
                    Handler[] handlerArray = sLog.getHandlers();
                    PerfFormatter perfFormatter = new PerfFormatter();
                    int n = 0;
                    while (n < handlerArray.length) {
                        handlerArray[n].setFormatter(perfFormatter);
                        ++n;
                    }
                    ADFPerfLog.createIdxLogger(sLevel, perfFormatter);
                    sIdxLog.log(sLevel, PerfFormatter.LOG_LINE_FORMAT);
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 1);
                    sIdxLog.log(sLevel, "T " + dateFormat.format(new Date(PerfFormatter.STARTTIME)) + " (" + PerfFormatter.STARTTIME + ")" + LINE_SEPARATOR);
                }
            } else {
                sLevel = Level.OFF;
            }
        }
        return sLevel;
    }

    private static void createIdxLogger(Level level, Formatter formatter) {
        sIdxLog = Logger.getLogger(ADFNAME_IDX);
        sIdxLog.setLevel(level);
        sIdxLog.setUseParentHandlers(false);
        String string = System.getProperty("oracle.adf.share.perf.path");
        FileHandler fileHandler = null;
        try {
            fileHandler = new FileHandler(string + ADFPerfConstants.FILE_SEPARATOR + "adfperf" + ".log", false);
            fileHandler.setFormatter(formatter);
            Handler[] handlerArray = sIdxLog.getHandlers();
            int n = 0;
            while (n < handlerArray.length) {
                sIdxLog.removeHandler(handlerArray[n]);
                ++n;
            }
            sIdxLog.addHandler(fileHandler);
        }
        catch (Exception exception) {
            sIdxLog = sLog;
        }
    }

    static Logger getLogger() {
        return sLog;
    }

    static Logger getIdxLogger() {
        return sIdxLog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addLogRecord(PerfLogRecord perfLogRecord, String string) {
        LinkedList linkedList = null;
        if (string == null) {
            string = ADFPerfLog.getECID();
        }
        if (string == null) {
            return;
        }
        string = ADFPerfLog.removeSeqNum(string);
        LinkedHashMap linkedHashMap = sLogRecordBuffer;
        synchronized (linkedHashMap) {
            linkedList = (LinkedList)sLogRecordBuffer.get(string);
            if (linkedList == null) {
                linkedList = new LinkedList();
                sLogRecordBuffer.put(string, linkedList);
            }
            linkedList.add(perfLogRecord);
            if (linkedList.size() >= 12) {
                linkedList = (LinkedList)sLogRecordBuffer.remove(string);
            } else {
                Iterator iterator;
                linkedList = null;
                if (sLogRecordBuffer.size() > sBufSize && (iterator = sLogRecordBuffer.keySet().iterator()).hasNext()) {
                    string = (String)iterator.next();
                    linkedList = (LinkedList)sLogRecordBuffer.remove(string);
                }
            }
            if (linkedList != null) {
                ADFPerfLog.printList(string, linkedList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushLog() {
        LinkedList linkedList = null;
        String string = ADFPerfLog.getECID();
        if (string == null) {
            return;
        }
        string = ADFPerfLog.removeSeqNum(string);
        LinkedHashMap linkedHashMap = sLogRecordBuffer;
        synchronized (linkedHashMap) {
            linkedList = (LinkedList)sLogRecordBuffer.remove(string);
            if (linkedList != null) {
                ADFPerfLog.printList(string, linkedList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printList(String string, LinkedList linkedList) {
        if (linkedList == null || linkedList.size() == 0) {
            return;
        }
        PerfLogLine perfLogLine = new PerfLogLine(string, linkedList);
        LinkedList linkedList2 = sDumpBuffer;
        synchronized (linkedList2) {
            if (sThread == null) {
                DumpPerfLogThread dumpPerfLogThread = new DumpPerfLogThread(sDumpBuffer);
                Class clazz = class$oracle$adf$share$perf$DumpPerfLogThread;
                if (clazz == null) {
                    clazz = class$oracle$adf$share$perf$DumpPerfLogThread = ADFPerfLog.class$("oracle.adf.share.perf.DumpPerfLogThread");
                }
                sThread = new Thread((Runnable)dumpPerfLogThread, clazz.getName());
                sThread.setPriority(1);
                sThread.setDaemon(true);
                sThread.start();
            }
            sDumpBuffer.add(perfLogLine);
            sDumpBuffer.notify();
        }
    }

    private static String removeSeqNum(String string) {
        int n = string.lastIndexOf(44);
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    public static String getECID() {
        String string = null;
        try {
            ExecutionContext executionContext = ExecutionContext.get();
            string = executionContext.getECIDasString();
            if (string == null) {
                executionContext.setECID(null);
                string = executionContext.getECIDasString();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return string;
    }

    public static void setECID(String string) {
        try {
            ExecutionContext executionContext = ExecutionContext.get();
            executionContext.setECID(ExecutionContext.parseECID((String)string));
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

