/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import oracle.adf.share.jndi.DocumentBackingStore;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

public class ResourceBackingStore
extends DocumentBackingStore {
    private String mResourcePath;

    public ResourceBackingStore() {
    }

    public void initialize(Hashtable hashtable, String string) throws Exception {
        super.initialize(hashtable, string);
        Object v = hashtable.get("java.naming.provider.url");
        if (v instanceof String) {
            this.mResourcePath = (String)v;
        }
    }

    public ResourceBackingStore(String string) {
        this.mResourcePath = string;
    }

    public Document readDocument(String string) throws Exception {
        XMLDocument xMLDocument;
        InputStream inputStream = this.getDocumentStream();
        if (inputStream == null) {
            throw new Exception("Unable to find resource " + this.mResourcePath);
        }
        try {
            XMLDocument xMLDocument2;
            DOMParser dOMParser = new DOMParser();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            dOMParser.parse((InputStream)bufferedInputStream);
            xMLDocument = xMLDocument2 = dOMParser.getDocument();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return xMLDocument;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean documentExists(String string) throws Exception {
        boolean bl;
        InputStream inputStream = null;
        try {
            inputStream = this.getDocumentStream();
            bl = inputStream != null;
            Object var5_4 = null;
            if (inputStream == null) return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return bl;
    }

    public Document createDocument(String string) throws Exception {
        throw new UnsupportedOperationException("ReadOnly");
    }

    public void writeDocument(Document document, String string) throws Exception {
        throw new UnsupportedOperationException("ReadOnly");
    }

    public boolean isReadOnly() {
        return true;
    }

    private InputStream getDocumentStream() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(this.mResourcePath);
        if (inputStream == null && this.mResourcePath.startsWith("/")) {
            inputStream = classLoader.getResourceAsStream(this.mResourcePath.substring(1));
        }
        return inputStream;
    }
}

