/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.jndi;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import oracle.adf.share.jndi.CredentialStoreHelper;
import oracle.adf.share.jndi.SecureRefAddr;
import oracle.adf.share.jndi.XmlRefAddr;
import oracle.adf.share.jndi.xml.AnyXmlType;
import oracle.adf.share.jndi.xml.ObjectFactory;
import oracle.adf.share.jndi.xml.PropertyType;
import oracle.adf.share.jndi.xml.RefAddrType;
import oracle.adf.share.jndi.xml.RefAddressListType;
import oracle.adf.share.jndi.xml.ReferenceFactoryType;
import oracle.adf.share.jndi.xml.ReferenceListType;
import oracle.adf.share.jndi.xml.ReferenceType;
import oracle.adf.share.jndi.xml.References;
import oracle.adf.share.jndi.xml.StringRefAddrType;
import oracle.adf.share.jndi.xml.XmlRefAddrType;
import oracle.adf.share.security.credentialstore.Credential;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class ReferenceStoreHelper {
    private ObjectFactory mJaxbFactory;
    private References mReferences;
    private Context mCtx;
    private Hashtable mEnv;
    private Map mNewCredentials;
    private Map mDeletedCredentials;
    private CredentialStoreHelper storage;
    private static /* synthetic */ Class class$java$util$Properties;

    private /* synthetic */ void $init$() {
        this.mJaxbFactory = new ObjectFactory();
        this.mReferences = null;
        this.mCtx = null;
        this.mEnv = null;
        this.storage = null;
    }

    public void init(References references, Context context, Hashtable hashtable) {
        this.mReferences = references;
        this.mCtx = context;
        this.mEnv = hashtable;
    }

    public References getReferences() {
        return this.mReferences;
    }

    public Reference findReference(String string) throws NamingException {
        ReferenceType referenceType = this.findReferenceType(string);
        if (referenceType == null) {
            return null;
        }
        Reference reference = null;
        try {
            reference = this.createReference(referenceType);
        }
        catch (Exception exception) {
            this.throwNamingException(exception);
        }
        return reference;
    }

    public boolean exists(String string) throws NamingException {
        ReferenceType referenceType = this.findReferenceType(string);
        return referenceType != null;
    }

    public Object getObjectForReference(String string) throws Exception {
        ReferenceType referenceType = this.findReferenceType(string);
        if (referenceType == null) {
            return null;
        }
        Reference reference = this.createReference(referenceType);
        javax.naming.spi.ObjectFactory objectFactory = this.getJndiObjectFactory(referenceType.getFactory());
        return objectFactory.getObjectInstance(reference, new CompositeName(string), this.mCtx, this.mEnv);
    }

    public Map getReferencesMap() throws NamingException {
        HashMap<String, Reference> hashMap = new HashMap<String, Reference>(10);
        if (this.mReferences == null) {
            return hashMap;
        }
        try {
            List list = this.mReferences.getReference();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType = (ReferenceType)iterator.next();
                String string = referenceType.getName();
                Reference reference = this.createReference(referenceType);
                hashMap.put(string, reference);
            }
        }
        catch (Exception exception) {
            this.throwNamingException(exception);
        }
        return hashMap;
    }

    public void addReference(String string, Reference reference) throws NamingException {
        ReferenceType referenceType = this.findReferenceType(string);
        if (referenceType != null) {
            throw new NamingException("Name already in use");
        }
        referenceType = this.createReferenceType(string, reference);
        this.addReferenceType(referenceType);
    }

    public void removeReference(String string) throws NamingException {
        this.removeReferenceType(string);
    }

    public void saveCredentials() throws Exception {
        if (this.mNewCredentials == null && this.mDeletedCredentials == null) {
            return;
        }
        if (this.storage == null) {
            this.storage = new CredentialStoreHelper();
        }
        String string = (String)this.mEnv.get("java.naming.security.principal");
        if (this.mNewCredentials != null) {
            Iterator iterator = this.mNewCredentials.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.storage.storeCredential(string, (String)entry.getKey(), (Credential)entry.getValue());
            }
            this.mNewCredentials.clear();
        }
        if (this.mDeletedCredentials != null) {
            Iterator iterator = this.mDeletedCredentials.keySet().iterator();
            while (iterator.hasNext()) {
                this.storage.removeCredential(string, (String)iterator.next());
            }
            this.mDeletedCredentials.clear();
        }
    }

    public void destroy() {
        this.mNewCredentials.clear();
        this.mDeletedCredentials.clear();
        this.mJaxbFactory = null;
        this.mReferences = null;
        this.mEnv = null;
        this.mNewCredentials = null;
        this.mDeletedCredentials = null;
    }

    private ReferenceType findReferenceType(String string) throws NamingException {
        if (this.mReferences == null) {
            return null;
        }
        try {
            List list = this.mReferences.getReference();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ReferenceType referenceType = (ReferenceType)iterator.next();
                if (!referenceType.getName().equals(string)) continue;
                ReferenceType referenceType2 = referenceType;
                return referenceType2;
            }
        }
        catch (Exception exception) {
            this.throwNamingException(exception);
        }
        return null;
    }

    private Reference createReference(ReferenceType referenceType) throws Exception {
        Reference reference = new Reference(referenceType.getClassName(), referenceType.getFactory().getClassName(), null);
        RefAddressListType refAddressListType = referenceType.getRefAddresses();
        Iterator iterator = refAddressListType.getStringRefAddrOrXmlRefAddrOrSecureRefAddr().iterator();
        while (iterator.hasNext()) {
            RefAddrType refAddrType = (RefAddrType)iterator.next();
            if (refAddrType instanceof XmlRefAddrType) {
                AnyXmlType anyXmlType = ((XmlRefAddrType)refAddrType).getContents();
                Iterator iterator2 = anyXmlType.getAny().iterator();
                while (iterator2.hasNext()) {
                    Node node = (Node)iterator2.next();
                    XmlRefAddr xmlRefAddr = new XmlRefAddr(refAddrType.getAddrType(), this.createDocumentFragment(node));
                    reference.add(xmlRefAddr);
                }
                continue;
            }
            if (!(refAddrType instanceof StringRefAddrType)) continue;
            reference.add(new StringRefAddr(refAddrType.getAddrType(), ((StringRefAddrType)refAddrType).getContents()));
        }
        if (referenceType.getCredentialStoreKey() != null) {
            Credential credential = this.loadCredentials(referenceType.getCredentialStoreKey());
            Iterator iterator3 = credential.getPropertyNames().iterator();
            while (iterator3.hasNext()) {
                String string = (String)iterator3.next();
                String string2 = credential.getProperty(string);
                reference.add(new SecureRefAddr(string, string2));
            }
        }
        return reference;
    }

    private void addReferenceType(ReferenceType referenceType) throws NamingException {
        if (this.mReferences == null) {
            this.mReferences = this.mJaxbFactory.createReferences();
        }
        try {
            List list = this.mReferences.getReference();
            list.add(referenceType);
        }
        catch (Exception exception) {
            this.throwNamingException(exception);
        }
    }

    private void removeReferenceType(String string) throws NamingException {
        if (this.mReferences == null) {
            return;
        }
        try {
            ReferenceType referenceType = this.findReferenceType(string);
            if (referenceType != null) {
                if (referenceType.getCredentialStoreKey() != null) {
                    this.removeCredential(referenceType.getName());
                }
                this.mReferences.getReference().remove(referenceType);
            }
        }
        catch (Exception exception) {
            this.throwNamingException(exception);
        }
    }

    private ReferenceType createReferenceType(String string, Reference reference) {
        Credential credential = new Credential();
        ReferenceListType.Reference reference2 = this.mJaxbFactory.createReferenceListTypeReference();
        reference2.setName(string);
        reference2.setClassName(reference.getClassName());
        ReferenceFactoryType referenceFactoryType = this.mJaxbFactory.createReferenceFactoryType();
        referenceFactoryType.setClassName(reference.getFactoryClassName());
        reference2.setFactory(referenceFactoryType);
        RefAddressListType refAddressListType = this.mJaxbFactory.createRefAddressListType();
        int n = 0;
        while (n < reference.size()) {
            RefAddr refAddr = reference.get(n);
            if (refAddr instanceof StringRefAddr) {
                RefAddressListType.StringRefAddr stringRefAddr = this.mJaxbFactory.createRefAddressListTypeStringRefAddr();
                stringRefAddr.setContents((String)((StringRefAddr)refAddr).getContent());
                stringRefAddr.setAddrType(((StringRefAddr)refAddr).getType());
                refAddressListType.getStringRefAddrOrXmlRefAddrOrSecureRefAddr().add(stringRefAddr);
            } else if (refAddr instanceof XmlRefAddr) {
                RefAddressListType.XmlRefAddr xmlRefAddr = this.mJaxbFactory.createRefAddressListTypeXmlRefAddr();
                xmlRefAddr.setAddrType(refAddr.getType());
                AnyXmlType anyXmlType = this.mJaxbFactory.createAnyXmlType();
                anyXmlType.getAny().add(refAddr.getContent());
                xmlRefAddr.setContents(anyXmlType);
                refAddressListType.getStringRefAddrOrXmlRefAddrOrSecureRefAddr().add(xmlRefAddr);
            } else if (refAddr instanceof SecureRefAddr) {
                SecureRefAddr secureRefAddr = (SecureRefAddr)refAddr;
                credential.put(secureRefAddr.getName(), secureRefAddr.getValue());
                RefAddressListType.SecureRefAddr secureRefAddr2 = this.mJaxbFactory.createRefAddressListTypeSecureRefAddr();
                secureRefAddr2.setAddrType(refAddr.getType());
                refAddressListType.getStringRefAddrOrXmlRefAddrOrSecureRefAddr().add(secureRefAddr2);
            }
            ++n;
        }
        if (credential.size() > 0) {
            reference2.setCredentialStoreKey(this.addCredential(string, credential));
        }
        reference2.setRefAddresses(refAddressListType);
        return reference2;
    }

    private javax.naming.spi.ObjectFactory getJndiObjectFactory(ReferenceFactoryType referenceFactoryType) throws Exception {
        String string = referenceFactoryType.getClassName();
        Class<?> clazz = Class.forName(string, true, Thread.currentThread().getContextClassLoader());
        Object obj = clazz.newInstance();
        Properties properties = null;
        Iterator iterator = referenceFactoryType.getProperty().iterator();
        while (iterator.hasNext()) {
            if (properties == null) {
                properties = new Properties();
            }
            PropertyType propertyType = (PropertyType)iterator.next();
            properties.setProperty(propertyType.getName(), propertyType.getValue());
        }
        if (properties != null) {
            try {
                Class<?> clazz2 = obj.getClass();
                Class[] classArray = new Class[1];
                Class clazz3 = class$java$util$Properties;
                if (clazz3 == null) {
                    clazz3 = class$java$util$Properties = ReferenceStoreHelper.class$("java.util.Properties");
                }
                classArray[0] = clazz3;
                Method method = clazz2.getMethod("setProperties", classArray);
                method.invoke(obj, properties);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return (javax.naming.spi.ObjectFactory)obj;
    }

    private String addCredential(String string, Credential credential) {
        if (this.mNewCredentials == null) {
            this.mNewCredentials = new HashMap(10);
        }
        this.mNewCredentials.put(string, credential);
        if (this.mDeletedCredentials != null) {
            this.mDeletedCredentials.remove(string);
        }
        return string;
    }

    private void removeCredential(String string) {
        Object v = null;
        if (this.mNewCredentials != null) {
            v = this.mNewCredentials.remove(string);
        }
        if (v == null) {
            if (this.mDeletedCredentials == null) {
                this.mDeletedCredentials = new HashMap(10);
            }
            this.mDeletedCredentials.put(string, v);
        }
    }

    private Credential loadCredentials(String string) throws Exception {
        if (this.storage == null) {
            this.storage = new CredentialStoreHelper();
        }
        String string2 = (String)this.mEnv.get("java.naming.security.principal");
        return this.storage.fetchCredential(string2, string);
    }

    private DocumentFragment createDocumentFragment(Node node) throws DOMException {
        DocumentFragment documentFragment = node.getOwnerDocument().createDocumentFragment();
        documentFragment.appendChild(node.cloneNode(true));
        return documentFragment;
    }

    private void throwNamingException(Exception exception) throws NamingException {
        NamingException namingException = new NamingException();
        namingException.setRootCause(exception);
        throw namingException;
    }

    public ReferenceStoreHelper() {
        this.$init$();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

