/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.http;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.adf.share.logging.ADFLogger;

class StateHolder
implements Map,
Serializable {
    static final long serialVersionUID = -6584403567911498126L;
    private static final ADFLogger mLogger;
    private Map mPersistentMap;
    private transient Map mTransientMap;
    private static /* synthetic */ Class class$oracle$adf$share$http$StateHolder;

    private /* synthetic */ void $init$() {
        this.mPersistentMap = new Hashtable(4);
        this.mTransientMap = new Hashtable(4);
    }

    public Object get(Object object) {
        Object v = this.mPersistentMap.get(object);
        if (v == null) {
            v = this.mTransientMap.get(object);
        }
        return v;
    }

    public Object put(Object object, Object object2) {
        Object object3 = this.get(object);
        if (object2 instanceof Serializable) {
            this.mPersistentMap.put(object, object2);
        } else {
            if (mLogger.isLoggable(ADFLogger.WARNING)) {
                mLogger.log(ADFLogger.WARNING, "StateHolder:  Transient state added to StateManager.  State may not be serialized.  State id:  " + object);
            }
            this.mTransientMap.put(object, object2);
        }
        return object3;
    }

    public Object putTransient(String string, Object object) {
        return this.mTransientMap.put(string, object);
    }

    public Object remove(Object object) {
        Object object2 = this.get(object);
        this.mPersistentMap.remove(object);
        this.mTransientMap.remove(object);
        return object2;
    }

    public Set entrySet() {
        return this.all().entrySet();
    }

    public int size() {
        return this.mPersistentMap.size() + this.mTransientMap.size();
    }

    public boolean containsKey(Object object) {
        return this.mPersistentMap.containsKey(object) || this.mTransientMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.mPersistentMap.containsValue(object) || this.mTransientMap.containsValue(object);
    }

    public Set keySet() {
        return this.all().keySet();
    }

    public Collection values() {
        return this.all().values();
    }

    public void clear() {
        this.mPersistentMap.clear();
        this.mTransientMap.clear();
    }

    public void putAll(Map map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            this.put(k, v);
        }
    }

    public boolean isEmpty() {
        return this.mPersistentMap.isEmpty() && this.mTransientMap.isEmpty();
    }

    private Map all() {
        Hashtable hashtable = new Hashtable(this.mPersistentMap.size() + this.mTransientMap.size());
        hashtable.putAll(this.mPersistentMap);
        hashtable.putAll(this.mTransientMap);
        return hashtable;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.mTransientMap = new Hashtable(4);
    }

    StateHolder() {
        this.$init$();
    }

    static {
        Class clazz = class$oracle$adf$share$http$StateHolder;
        if (clazz == null) {
            clazz = class$oracle$adf$share$http$StateHolder = StateHolder.class$("oracle.adf.share.http.StateHolder");
        }
        mLogger = ADFLogger.createADFLogger(clazz.getName());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

